/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.client.protocol.http.common;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.xmlBlaster.client.protocol.http.common.I_ObjectStream;

public class ObjectOutputStreamMicro
implements I_ObjectStream {
    private DataOutputStream out;

    public ObjectOutputStreamMicro(OutputStream outStream) throws IOException {
        this.out = new DataOutputStream(outStream);
    }

    private void writeHashtable(Hashtable map) throws IOException {
        int nmax = map.size();
        if (nmax < 1) {
            return;
        }
        this.out.writeInt(nmax);
        Enumeration keys = map.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            this.out.writeUTF(key);
            this.out.writeUTF((String)map.get(key));
        }
    }

    private void writeVector(Vector vec) throws IOException {
        int size = vec.size() / 3;
        this.out.writeInt(size);
        int i = 0;
        while (i < size) {
            Hashtable qos = (Hashtable)vec.elementAt(3 * i);
            Hashtable key = (Hashtable)vec.elementAt(3 * i + 1);
            byte[] content = (byte[])vec.elementAt(3 * i + 2);
            this.writeHashtable(qos);
            this.writeHashtable(key);
            this.out.writeInt(content.length);
            this.out.write(content);
            ++i;
        }
    }

    public void writeObject(Object obj) throws IOException {
        if (obj instanceof String) {
            this.out.writeInt(0);
            this.out.writeUTF((String)obj);
        } else if (obj instanceof Hashtable) {
            this.out.writeInt(1);
            this.writeHashtable((Hashtable)obj);
        } else if (obj instanceof Hashtable[]) {
            this.out.writeInt(2);
            Hashtable[] tables = (Hashtable[])obj;
            int size = tables.length;
            this.out.writeInt(size);
            int i = 0;
            while (i < size) {
                this.writeHashtable(tables[i]);
                ++i;
            }
        } else if (obj instanceof Vector) {
            this.out.writeInt(3);
            this.writeVector((Vector)obj);
        } else {
            throw new IOException("object of type '" + obj.getClass().getName() + "' is not supported");
        }
    }

    public static int getMessageLength(String oid, String key, String qos, byte[] content) {
        int ret = 3;
        if (oid != null) {
            ret += oid.length();
        }
        if (key != null) {
            ret += key.length();
        }
        if (qos != null) {
            ret += qos.length();
        }
        if (content != null) {
            ret += content.length;
        }
        return ret;
    }

    public static int writeMessage(OutputStream out, String oid, String key, String qos, byte[] content) throws IOException {
        byte[] buf;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (oid != null && oid.length() > 0) {
            baos.write(oid.getBytes());
        }
        baos.write(0);
        if (key != null && key.length() > 0) {
            baos.write(key.getBytes());
        }
        baos.write(0);
        if (qos != null && qos.length() > 0) {
            baos.write(qos.getBytes());
        }
        baos.write(0);
        if (content != null && content.length > 0) {
            baos.write(content);
        }
        if ((buf = baos.toByteArray()).length > 3) {
            DataOutputStream dos = new DataOutputStream(out);
            dos.write(buf);
            dos.flush();
        }
        return buf.length;
    }
}

