/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.client.protocol.http.common;

import java.io.ByteArrayInputStream;
import java.util.Hashtable;
import org.xmlBlaster.client.protocol.http.common.BufferedInputStreamMicro;
import org.xmlBlaster.client.protocol.http.common.I_Connection;
import org.xmlBlaster.client.protocol.http.common.ObjectInputStreamMicro;
import org.xmlBlaster.client.protocol.http.common.XmlBlasterAccessRawBase;

public class PersistentRequest
extends Thread {
    private String xmlBlasterServletUrl;
    private XmlBlasterAccessRawBase xmlBlasterAccess;
    private String connectReturnQos;
    private String loginName;
    private String passwd;
    private String connectQos;

    PersistentRequest(XmlBlasterAccessRawBase xmlBlasterAccess, String xmlBlasterServletUrl, String loginName, String passwd) {
        this(xmlBlasterAccess, xmlBlasterServletUrl, "<qos><securityService type='htpasswd' version='1.0'><![CDATA[<user>" + loginName + "</user>" + "<passwd>" + passwd + "</passwd>" + "]]>" + "</securityService>" + "</qos>");
    }

    PersistentRequest(XmlBlasterAccessRawBase xmlBlasterAccess, String xmlBlasterServletUrl, String connectQos) {
        this.xmlBlasterAccess = xmlBlasterAccess;
        this.xmlBlasterServletUrl = this.xmlBlasterAccess.getXmlBlasterServletUrl();
        this.connectQos = connectQos;
    }

    String getConnectReturnQos() {
        return this.connectReturnQos;
    }

    private void log(String level, String text) {
        this.xmlBlasterAccess.log("PersistentRequest", level, text);
    }

    /*
     * WARNING - void declaration
     */
    public void run() {
        try {
            try {
                String line;
                this.xmlBlasterAccess.postRequest("dummyToCreateASessionId", null, null, null, false);
                String url = this.xmlBlasterServletUrl;
                I_Connection conn = this.xmlBlasterAccess.createConnection(url);
                this.xmlBlasterAccess.writeCookie(conn);
                conn.setDoInput(true);
                conn.setPostMethod();
                conn.setUseCaches(false);
                XmlBlasterAccessRawBase.writeRequest(conn, "connect", null, this.connectQos, null);
                this.log("DEBUG", "POST, sending '" + url + "' ...");
                this.log("DEBUG", "Creating now a persistent connection to '" + url + "'");
                conn.connect();
                this.xmlBlasterAccess.readCookie(conn);
                BufferedInputStreamMicro dataInput = new BufferedInputStreamMicro(conn.getInputStream());
                while ((line = dataInput.readLine()) != null) {
                    void var4_5;
                    this.log("DEBUG", "Receiving Base64: <" + (String)var4_5 + "> with length " + var4_5.length());
                    if (var4_5 == null || var4_5.length() < 1 || var4_5.indexOf("--End") != -1) continue;
                    byte[] serial = this.xmlBlasterAccess.decodeBase64(var4_5.getBytes());
                    this.log("DEBUG", "Parsing now: <" + new String(serial) + "> with length " + serial.length);
                    if (serial.length < 1) continue;
                    ByteArrayInputStream in = new ByteArrayInputStream(serial);
                    ObjectInputStreamMicro ois = new ObjectInputStreamMicro(in);
                    String method = (String)ois.readObject();
                    this.log("DEBUG", "Received method '" + method + "'");
                    if ("ping".equals(method)) {
                        String qos = (String)ois.readObject();
                        this.log("DEBUG", "Received ping '" + qos + "'");
                        if (qos.indexOf("loginSucceeded") != -1) {
                            this.connectReturnQos = "<qos/>";
                            this.xmlBlasterAccess.isConnected(true);
                            this.xmlBlasterAccess.postRequest("pong", null, null, null, false);
                            continue;
                        }
                        if (!this.xmlBlasterAccess.isConnected()) continue;
                        this.xmlBlasterAccess.postRequest("pong", null, null, null, false);
                        continue;
                    }
                    if ("update".equals(method)) {
                        String cbSessionId = (String)ois.readObject();
                        Hashtable qosMap = (Hashtable)ois.readObject();
                        Hashtable keyMap = (Hashtable)ois.readObject();
                        String contentBase64 = (String)ois.readObject();
                        byte[] content = this.xmlBlasterAccess.decodeBase64(contentBase64.getBytes());
                        this.log("DEBUG", "Received update keyOid='" + keyMap.get("/key/@oid") + "' stateId=" + qosMap.get("/qos/state/@id"));
                        this.xmlBlasterAccess.update(cbSessionId, keyMap, content, qosMap);
                        continue;
                    }
                    if ("exception".equals(method)) {
                        String err = (String)ois.readObject();
                        this.log("ERROR", "Received exception: " + err);
                        continue;
                    }
                    this.log("ERROR", "Ignoring response for methodName=" + method);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.log("ERROR", "Can't handle exception: " + e.toString());
                Object var15_16 = null;
                this.xmlBlasterAccess.isConnected(false);
            }
            Object var15_15 = null;
            this.xmlBlasterAccess.isConnected(false);
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            this.xmlBlasterAccess.isConnected(false);
            throw throwable;
        }
    }
}

