/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.client.protocol.http.common;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.xmlBlaster.client.protocol.http.common.BufferedInputStreamMicro;
import org.xmlBlaster.client.protocol.http.common.I_CallbackRaw;
import org.xmlBlaster.client.protocol.http.common.I_Connection;
import org.xmlBlaster.client.protocol.http.common.I_Log;
import org.xmlBlaster.client.protocol.http.common.I_XmlBlasterAccessRaw;
import org.xmlBlaster.client.protocol.http.common.Msg;
import org.xmlBlaster.client.protocol.http.common.ObjectInputStreamMicro;
import org.xmlBlaster.client.protocol.http.common.ObjectOutputStreamMicro;
import org.xmlBlaster.client.protocol.http.common.PersistentRequest;

public abstract class XmlBlasterAccessRawBase
implements I_XmlBlasterAccessRaw {
    protected String xmlBlasterServletUrl;
    private PersistentRequest persistentHttpConnection;
    private I_CallbackRaw callback;
    public static final boolean ONEWAY = true;
    private boolean isConnected = false;
    protected Hashtable properties = new Hashtable();
    protected I_Log logListener;
    protected String logLevels = "ERROR,WARN,INFO";
    private Hashtable cookie;

    public XmlBlasterAccessRawBase(Hashtable properties) {
        this.properties = properties;
        this.xmlBlasterServletUrl = (String)this.properties.get("xmlBlaster/servletUrl");
        if (this.properties.get("xmlBlaster/logLevels") != null) {
            this.logLevels = (String)this.properties.get("xmlBlaster/logLevels");
        }
        this.log("DEBUG", "constructor - " + this.xmlBlasterServletUrl);
    }

    public synchronized void setLogListener(I_Log logListener) {
        this.logListener = logListener;
    }

    public Hashtable getHtmlProperties() {
        return this.properties;
    }

    protected void log(String level, String text) {
        this.log("XmlBlasterAccess", level, text);
    }

    public synchronized void log(String location, String level, String text) {
        if (this.logListener != null) {
            this.logListener.log(location, level, text);
        }
        if (this.logLevels.indexOf(level) != -1) {
            System.out.println(location + " [" + level + "]: " + text);
        }
    }

    public String getXmlBlasterServletUrl() {
        return this.xmlBlasterServletUrl;
    }

    public void isConnected(boolean isConnected) {
        this.isConnected = isConnected;
        this.log("INFO", "isConnected(" + isConnected + ")");
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    private String startPersistentHttpConnection() throws Exception {
        this.persistentHttpConnection.start();
        this.log("DEBUG", "Waiting for connect() to establish ...");
        int num = 100;
        int i = 0;
        while (i < num) {
            if (this.isConnected) break;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                this.log("WARN", e.toString());
            }
            ++i;
        }
        if (i >= num) {
            this.log("ERROR", "Can't login to xmlBlaster, timed out.");
            throw new Exception("Can't login to xmlBlaster, timed out.");
        }
        this.log("INFO", "Successfully connected to xmlBlaster");
        return this.persistentHttpConnection.getConnectReturnQos();
    }

    public String connect(String qos, I_CallbackRaw callback) throws Exception {
        this.callback = callback;
        if (qos == null) {
            String loginName = (String)this.properties.get("xmlBlaster/loginName");
            String passwd = (String)this.properties.get("xmlBlaster/passwd");
            if (loginName != null && passwd != null) {
                this.log("INFO", "Using loginName = " + loginName + " as configured in your HTML page to connect to xmlBlaster");
                this.persistentHttpConnection = new PersistentRequest(this, this.xmlBlasterServletUrl, loginName, passwd);
            } else {
                qos = "<qos/>";
            }
        }
        if (qos != null) {
            this.persistentHttpConnection = new PersistentRequest(this, this.xmlBlasterServletUrl, qos);
        }
        return this.startPersistentHttpConnection();
    }

    public String sendXmlScript(String xmlRequest) throws Exception {
        this.log("DEBUG", "xmlScript(xmlRequest=" + xmlRequest + ")");
        return (String)this.postRequest("xmlScript", xmlRequest, null, null, false);
    }

    public Hashtable subscribe(String xmlKey, String qos) throws Exception {
        this.log("DEBUG", "subscribe(key=" + xmlKey + ")");
        return (Hashtable)this.postRequest("subscribe", xmlKey, qos, null, false);
    }

    public Msg[] get(String xmlKey, String qos) throws Exception {
        this.log("DEBUG", "get(key=" + xmlKey + ")");
        Vector list = (Vector)this.postRequest("get", xmlKey, qos, null, false);
        Msg[] msgs = new Msg[list.size() / 3];
        int i = 0;
        while (i < list.size() / 3) {
            this.log("DEBUG", "Synchronous get is not implented");
            Hashtable qosRet = (Hashtable)list.elementAt(i * 3);
            Hashtable keyRet = (Hashtable)list.elementAt(i * 3 + 1);
            byte[] content = (byte[])list.elementAt(i * 3 + 2);
            msgs[i] = new Msg(keyRet, content, qosRet);
            ++i;
        }
        return msgs;
    }

    public Hashtable[] unSubscribe(String xmlKey, String qos) throws Exception {
        this.log("DEBUG", "unSubscribe(key=" + xmlKey + ")");
        return (Hashtable[])this.postRequest("unSubscribe", xmlKey, qos, null, false);
    }

    public Hashtable publish(String xmlKey, byte[] content, String qos) throws Exception {
        this.log("DEBUG", "publish(key=" + xmlKey + ")");
        return (Hashtable)this.postRequest("publish", xmlKey, qos, content, false);
    }

    public Hashtable[] erase(String xmlKey, String qos) throws Exception {
        this.log("DEBUG", "erase(key=" + xmlKey + ")");
        return (Hashtable[])this.postRequest("erase", xmlKey, qos, null, false);
    }

    public void disconnect(String qos) {
        this.log("DEBUG", "disconnect()");
        try {
            this.postRequest("disconnect", null, qos, null, false);
            this.log("INFO", "Successfully disconnected from xmlBlaster");
        }
        catch (Exception e) {
            this.log("WARN", "Ignoring unexpected exception during disconnect: " + e.toString());
        }
    }

    static void writeRequest(I_Connection conn, String actionType, String key, String qos, byte[] content) throws IOException {
        conn.setRequestProperty("ActionType", actionType);
        conn.setRequestProperty("BinaryProtocol", "true");
        int length = ObjectOutputStreamMicro.getMessageLength(null, key, qos, content);
        conn.setRequestProperty("Data-Length", "" + length);
        ObjectOutputStreamMicro.writeMessage(conn.getOutputStream(), null, key, qos, content);
    }

    /*
     * WARNING - void declaration
     */
    Object postRequest(String actionType, String key, String qos, byte[] content, boolean oneway) throws Exception {
        String request = "ActionType=" + actionType;
        try {
            String line;
            boolean doPost = true;
            String url = this.xmlBlasterServletUrl;
            I_Connection conn = this.createConnection(url);
            this.writeCookie(conn);
            this.log("DEBUG", "doPost=" + doPost + ", sending '" + url + "' with request '" + request + "' ...");
            if (doPost) {
                conn.setDoOutput(true);
                conn.setPostMethod();
                conn.setDoInput(true);
                conn.setUseCaches(false);
                XmlBlasterAccessRawBase.writeRequest(conn, actionType, key, qos, content);
            }
            conn.connect();
            this.readCookie(conn);
            if (oneway) {
                return "";
            }
            BufferedInputStreamMicro dataInput = new BufferedInputStreamMicro(conn.getInputStream());
            Object returnObject = null;
            StringBuffer ret = new StringBuffer(1024);
            while ((line = dataInput.readLine()) != null) {
                Hashtable[] returnQos;
                void var11_15;
                this.log("DEBUG", "Return value for '" + request + "' = '" + (String)var11_15 + "'");
                if (var11_15 == null || var11_15.length() < 1) continue;
                byte[] serial = this.decodeBase64(var11_15.getBytes());
                this.log("DEBUG", "Parsing now: <" + new String(serial) + ">");
                ByteArrayInputStream bais = new ByteArrayInputStream(serial);
                ObjectInputStreamMicro ois = new ObjectInputStreamMicro(bais);
                String method = (String)ois.readObject();
                if ("publish".equals(method)) {
                    returnObject = returnQos = (Hashtable[])ois.readObject();
                    continue;
                }
                if ("get".equals(method)) {
                    returnObject = returnQos = (Vector)ois.readObject();
                    continue;
                }
                if ("subscribe".equals(method)) {
                    returnObject = returnQos = (Hashtable)ois.readObject();
                    continue;
                }
                if ("unSubscribe".equals(method)) {
                    returnObject = returnQos = (Hashtable[])ois.readObject();
                    continue;
                }
                if ("erase".equals(method)) {
                    returnObject = returnQos = (Hashtable[])ois.readObject();
                    continue;
                }
                if ("xmlScript".equals(method)) {
                    returnObject = (String)ois.readObject();
                    continue;
                }
                if ("disconnect".equals(method)) {
                    returnObject = ois.readObject();
                    continue;
                }
                if ("exception".equals(method)) {
                    String err = (String)ois.readObject();
                    this.log("INFO", "Caught XmlBlasterException: " + err);
                    throw new Exception(err);
                }
                if ("dummyToCreateASessionId".equals(method)) {
                    returnObject = (String)ois.readObject();
                    continue;
                }
                if ("pong".equals(method)) {
                    returnObject = (String)ois.readObject();
                    continue;
                }
                this.log("ERROR", "Unknown method=" + method);
                returnObject = var11_15;
            }
            return returnObject;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            this.log("ERROR", "request(" + request + ") failed: " + e.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
            this.log("ERROR", "request(" + request + ") failed: " + e.toString());
        }
        return "";
    }

    public String update(String cbSessionId, Hashtable updateKey, byte[] content, Hashtable updateQos) throws Exception {
        if (this.callback == null) {
            String text = "Receiving unexpected update message '" + updateKey.get("/key/@oid") + "', no callback handle available";
            this.log("WARN", "XmlBlasterAccessRaw: " + text);
            throw new Exception(text);
        }
        this.log("DEBUG", "Receiving update message '" + updateKey.get("/key/@oid") + "' state=" + updateQos.get("/qos/state/@id"));
        return this.callback.update(cbSessionId, updateKey, content, updateQos);
    }

    protected Hashtable extractCookies(String cookieTxt) {
        Hashtable<String, String> ret = new Hashtable<String, String>();
        int ch = 59;
        Vector<String> token = new Vector<String>();
        cookieTxt = cookieTxt.trim();
        while (true) {
            int pos;
            if ((pos = cookieTxt.indexOf(ch)) < 0) {
                if (cookieTxt.length() <= 0) break;
                token.addElement(cookieTxt);
                break;
            }
            token.addElement(cookieTxt.substring(0, pos));
            cookieTxt = cookieTxt.substring(pos + 1).trim();
        }
        int i = 0;
        while (i < token.size()) {
            String prop = (String)token.elementAt(i);
            int pos = prop.indexOf("=");
            if (pos >= 0) {
                String key = prop.substring(0, pos);
                String val = prop.substring(pos + 1);
                this.log("DEBUG", " extractCookies: (key='" + key + "', val='" + val + "')");
                ret.put(key, val);
            }
            ++i;
        }
        return ret;
    }

    public void readCookie(I_Connection conn) {
        this.log("DEBUG", " readCookie: Cookie         : " + conn.getHeaderField("Cookie"));
        this.log("DEBUG", " readCookie: Set-Cookie     : " + conn.getHeaderField("Set-Cookie"));
        String setCookie = conn.getHeaderField("Set-Cookie");
        if (setCookie != null) {
            this.cookie = this.extractCookies(setCookie);
        }
    }

    public void writeCookie(I_Connection conn) {
        this.log("DEBUG", "writeCookie: original cookie: " + this.cookie);
        if (this.cookie == null) {
            conn.setRequestProperty("cookie", "");
        } else {
            conn.setRequestProperty("cookie", "JSESSIONID=" + (String)this.cookie.get("JSESSIONID"));
        }
        conn.setRequestProperty("Cache-Control", "no-cache");
        conn.setRequestProperty("Pragma", "no-cache");
        conn.setRequestProperty("Connection", "keep-alive");
    }

    public abstract byte[] encodeBase64(byte[] var1);

    public abstract byte[] decodeBase64(byte[] var1);

    public abstract I_Connection createConnection(String var1) throws Exception;
}

