/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.client.protocol.local;

import org.jutils.log.LogChannel;
import org.xmlBlaster.client.protocol.I_CallbackExtended;
import org.xmlBlaster.client.protocol.I_CallbackServer;
import org.xmlBlaster.engine.Global;
import org.xmlBlaster.protocol.local.I_LocalCallback;
import org.xmlBlaster.util.MsgUnitRaw;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.plugin.PluginInfo;
import org.xmlBlaster.util.qos.address.CallbackAddress;

public class LocalCallbackImpl
implements I_CallbackServer,
I_LocalCallback {
    private String ME = "LocalCallbackImpl";
    private org.xmlBlaster.util.Global glob;
    private LogChannel log;
    private I_CallbackExtended cbClient;
    private String callbackId;
    private Global engineGlob;

    public String getType() {
        return this.getCbProtocol();
    }

    public String getVersion() {
        return "1.0";
    }

    public void init(org.xmlBlaster.util.Global glob, PluginInfo pluginInfo) {
    }

    public final synchronized void initialize(org.xmlBlaster.util.Global glob, String loginName, CallbackAddress callbackAddress, I_CallbackExtended cbClient) throws XmlBlasterException {
        this.glob = glob == null ? org.xmlBlaster.util.Global.instance() : glob;
        this.log = this.glob.getLog("local");
        this.ME = "LocalCallbackImpl-" + loginName;
        this.callbackId = "LOCAL:" + this.hashCode();
        this.cbClient = cbClient;
        this.engineGlob = (Global)glob.getObjectEntry("ServerNodeScope");
        if (this.engineGlob == null) {
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME + ".init", "could not retreive the ServerNodeScope. Am I really on the server side ?");
        }
        this.engineGlob.addObjectEntry(this.callbackId, this);
    }

    public final String getCbProtocol() {
        return "LOCAL";
    }

    public String getCbAddress() throws XmlBlasterException {
        return this.callbackId;
    }

    public synchronized void shutdown() {
        this.engineGlob.removeObjectEntry(this.callbackId);
    }

    public String[] update(String cbSessionId, MsgUnitRaw[] msgUnitArr) throws XmlBlasterException {
        if (msgUnitArr == null) {
            throw new XmlBlasterException(this.ME, "Received update of null message");
        }
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering update(" + cbSessionId + ") of " + msgUnitArr.length + " messages");
        }
        return this.cbClient.update(cbSessionId, msgUnitArr);
    }

    public void updateOneway(String cbSessionId, MsgUnitRaw[] msgUnitArr) throws XmlBlasterException {
        if (msgUnitArr == null) {
            return;
        }
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering updateOneway(" + cbSessionId + ") of " + msgUnitArr.length + " messages");
        }
        try {
            this.cbClient.updateOneway(cbSessionId, msgUnitArr);
        }
        catch (Throwable e) {
            this.log.error(this.ME, "Caught exception which can't be delivered to xmlBlaster because of 'oneway' mode: " + e.toString());
        }
    }

    public String ping(String str) {
        return "<qos><state id='OK'/></qos>";
    }
}

