/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.client.protocol.local;

import org.jutils.log.LogChannel;
import org.xmlBlaster.client.protocol.I_XmlBlasterConnection;
import org.xmlBlaster.client.qos.ConnectReturnQos;
import org.xmlBlaster.engine.Global;
import org.xmlBlaster.protocol.I_Authenticate;
import org.xmlBlaster.protocol.I_XmlBlaster;
import org.xmlBlaster.util.MsgUnitRaw;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.plugin.PluginInfo;
import org.xmlBlaster.util.qos.address.Address;

public class LocalConnection
implements I_XmlBlasterConnection {
    private String ME = "LocalConnection";
    private org.xmlBlaster.util.Global glob;
    private LogChannel log;
    private String sessionId;
    protected ConnectReturnQos connectReturnQos;
    protected Address clientAddress;
    private I_Authenticate authenticate;
    private I_XmlBlaster xmlBlasterImpl;

    public String getType() {
        return this.getProtocol();
    }

    public String getVersion() {
        return "1.0";
    }

    public void init(org.xmlBlaster.util.Global glob_, PluginInfo pluginInfo) throws XmlBlasterException {
        this.glob = glob_ == null ? org.xmlBlaster.util.Global.instance() : glob_;
        this.log = this.glob.getLog("local");
        Global engineGlob = (Global)this.glob.getObjectEntry("ServerNodeScope");
        if (engineGlob == null) {
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME + ".init", "could not retreive the ServerNodeScope. Am I really on the server side ?");
        }
        try {
            this.authenticate = engineGlob.getAuthenticate();
            if (this.authenticate == null) {
                throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME + ".init", "authenticate object is null");
            }
            this.xmlBlasterImpl = this.authenticate.getXmlBlaster();
            if (this.xmlBlasterImpl == null) {
                throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME + ".init", "xmlBlasterImpl object is null");
            }
        }
        catch (XmlBlasterException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME + ".init", "init. Could'nt initialize the driver.", ex);
        }
        this.log.info(this.ME, "Created '" + this.getProtocol() + "' protocol plugin to connect to xmlBlaster server");
    }

    public final String getProtocol() {
        return "LOCAL";
    }

    public void connectLowlevel(Address address) throws XmlBlasterException {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Entering connectLowlevel(" + address.getRawAddress() + ")");
        }
    }

    public void resetConnection() {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "LocalCLient is initialized, no connection available");
        }
        this.sessionId = null;
    }

    public String connect(String connectQos) throws XmlBlasterException {
        if (connectQos == null) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_CONFIGURATION, this.ME, "Please specify a valid ConnectQoS");
        }
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering login");
        }
        if (this.isLoggedIn()) {
            this.log.warn(this.ME, "You are already logged in, no relogin possible.");
            return "";
        }
        String retQos_literal = this.authenticate.connect(connectQos);
        this.connectReturnQos = new ConnectReturnQos(this.glob, retQos_literal);
        this.sessionId = this.connectReturnQos.getSecretSessionId();
        if (this.log.TRACE) {
            this.log.trace(this.ME, "connect(" + this.connectReturnQos.getData().getAddress().getType() + ")" + this.connectReturnQos.getSessionName().toString());
        }
        return retQos_literal;
    }

    public void setConnectReturnQos(ConnectReturnQos connectReturnQos) {
        this.sessionId = connectReturnQos.getSecretSessionId();
        this.ME = "LocalConnection-" + connectReturnQos.getSessionName().toString();
    }

    public boolean disconnect(String disconnectQos) {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering logout");
        }
        if (!this.isLoggedIn()) {
            this.log.warn(this.ME, "You are not logged in, no logout possible.");
        }
        try {
            this.authenticate.disconnect(this.sessionId, disconnectQos);
        }
        catch (XmlBlasterException e) {
            this.log.error(this.ME, e.getMessage());
        }
        if (this.log.TRACE) {
            this.log.trace(this.ME, "disconnect() done");
        }
        return true;
    }

    public void shutdown() throws XmlBlasterException {
    }

    public boolean isLoggedIn() {
        return this.xmlBlasterImpl != null && this.sessionId != null;
    }

    public final String subscribe(String xmlKey_literal, String qos_literal) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering subscribe(id=" + this.sessionId + ")");
        }
        return this.xmlBlasterImpl.subscribe(this.sessionId, xmlKey_literal, qos_literal);
    }

    public final String[] unSubscribe(String xmlKey_literal, String qos_literal) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering unsubscribe(): id=" + this.sessionId);
        }
        return this.xmlBlasterImpl.unSubscribe(this.sessionId, xmlKey_literal, qos_literal);
    }

    public final String publish(MsgUnitRaw msgUnit) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering publish(): id=" + this.sessionId);
        }
        return this.xmlBlasterImpl.publish(this.sessionId, msgUnit);
    }

    public final String[] publishArr(MsgUnitRaw[] msgUnitArr) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering publishArr: id=" + this.sessionId);
        }
        if (msgUnitArr == null) {
            this.log.error(this.ME + ".InvalidArguments", "The argument of method publishArr() are invalid");
            throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME, "The argument of method publishArr() are invalid");
        }
        return this.xmlBlasterImpl.publishArr(this.sessionId, msgUnitArr);
    }

    public final void publishOneway(MsgUnitRaw[] msgUnitArr) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering publishOneway: id=" + this.sessionId);
        }
        if (msgUnitArr == null) {
            this.log.error(this.ME + ".InvalidArguments", "The argument of method publishOneway() are invalid");
            throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME, "The argument of method publishOneway() are invalid");
        }
        this.xmlBlasterImpl.publishOneway(this.sessionId, msgUnitArr);
    }

    public final String[] erase(String xmlKey_literal, String qos_literal) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering erase() id=" + this.sessionId);
        }
        return this.xmlBlasterImpl.erase(this.sessionId, xmlKey_literal, qos_literal);
    }

    public final MsgUnitRaw[] get(String xmlKey_literal, String qos_literal) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering get() xmlKey=" + xmlKey_literal.trim() + ") ...");
        }
        return this.xmlBlasterImpl.get(this.sessionId, xmlKey_literal, qos_literal);
    }

    public String ping(String str) throws XmlBlasterException {
        return "";
    }

    public String toXml() throws XmlBlasterException {
        return this.toXml("");
    }

    public String toXml(String extraOffset) throws XmlBlasterException {
        if (!this.isLoggedIn()) {
            return "<noConnection />";
        }
        return "<LocalConnection/>";
    }

    public static String usage() {
        String text = "\n";
        text = text + "LocalConnection 'LOCAL' options:\n";
        text = text + "   -plugin/local/debug\n";
        text = text + "                       true switches on detailed LOCAL debugging [false].\n";
        text = text + "\n";
        return text;
    }
}

