/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.client.protocol.rmi;

import java.net.MalformedURLException;
import java.rmi.AlreadyBoundException;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.ExportException;
import java.rmi.server.UnicastRemoteObject;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.protocol.I_CallbackExtended;
import org.xmlBlaster.client.protocol.I_CallbackServer;
import org.xmlBlaster.protocol.rmi.I_XmlBlasterCallback;
import org.xmlBlaster.protocol.rmi.RmiUrl;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnitRaw;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.plugin.PluginInfo;
import org.xmlBlaster.util.qos.address.CallbackAddress;

public class RmiCallbackServer
extends UnicastRemoteObject
implements I_XmlBlasterCallback,
I_CallbackServer {
    private String ME;
    private Global glob;
    private LogChannel log;
    private I_CallbackExtended client;
    private String loginName;
    private String callbackRmiServerBindName = null;
    public static final int DEFAULT_REGISTRY_PORT = 1099;
    private RmiUrl rmiUrl;
    private CallbackAddress callbackAddress;

    public String getType() {
        return this.getCbProtocol();
    }

    public String getVersion() {
        return "1.0";
    }

    public void init(Global glob, PluginInfo pluginInfo) {
    }

    public void initialize(Global glob, String name, CallbackAddress callbackAddress, I_CallbackExtended client) throws XmlBlasterException {
        this.ME = "RmiCallbackServer-" + name;
        this.glob = glob;
        this.log = glob.getLog("rmi");
        this.client = client;
        this.loginName = name;
        this.callbackAddress = callbackAddress;
        this.createCallbackServer(this);
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Success, created RMI callback server for " + this.loginName);
        }
    }

    public void createCallbackServer(I_XmlBlasterCallback callbackRmiServer) throws XmlBlasterException {
        this.bindToRegistry(callbackRmiServer);
    }

    private void bindToRegistry(I_XmlBlasterCallback callbackRmiServer) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "bindToRegistry() ...");
        }
        this.rmiUrl = new RmiUrl(this.glob, this.callbackAddress);
        try {
            if (this.rmiUrl.getRegistryPort() > 0) {
                try {
                    LocateRegistry.createRegistry(this.rmiUrl.getRegistryPort());
                    this.log.info(this.ME, "Started RMI registry on port " + this.rmiUrl.getRegistryPort());
                }
                catch (ExportException e) {
                    try {
                        LocateRegistry.getRegistry(this.rmiUrl.getHostname(), this.rmiUrl.getRegistryPort());
                        this.log.info(this.ME, "Another rmiregistry is running on port 1099 we will use this one. You could change the port with e.g. '-dispatch/callback/plugin/rmi/registryPort 1122' to run your own rmiregistry.");
                    }
                    catch (RemoteException e2) {
                        String text = "Port 1099 is already in use, but does not seem to be a rmiregistry. Please can change the port with e.g. -dispatch/callback/plugin/rmi/registryPort 1122 : " + e.toString();
                        this.log.error(this.ME, text);
                        throw new XmlBlasterException(this.ME, text);
                    }
                }
            }
            this.callbackRmiServerBindName = this.rmiUrl.getUrl() + "I_XmlBlasterCallback/" + this.loginName;
            try {
                Naming.bind(this.callbackRmiServerBindName, callbackRmiServer);
                this.log.info(this.ME, "Bound RMI callback server to registry with name '" + this.callbackRmiServerBindName + "'");
                this.callbackAddress.setRawAddress(this.callbackRmiServerBindName);
            }
            catch (AlreadyBoundException e) {
                try {
                    Naming.rebind(this.callbackRmiServerBindName, callbackRmiServer);
                    this.log.warn(this.ME, "Removed another entry while binding authentication RMI callback server to registry with name '" + this.callbackRmiServerBindName + "'");
                }
                catch (Exception e2) {
                    this.log.error(this.ME + ".RmiRegistryFailed", "RMI registry of '" + this.callbackRmiServerBindName + "' failed: " + e2.toString());
                    throw new XmlBlasterException(this.ME + ".RmiRegistryFailed", "RMI registry of '" + this.callbackRmiServerBindName + "' failed: " + e2.toString());
                }
            }
        }
        catch (MalformedURLException e) {
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION, this.ME, "Could not initialize RMI registry", e);
        }
        catch (RemoteException e) {
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION, this.ME, "Could not initialize RMI registry", e);
        }
    }

    public final String getCbProtocol() {
        return "RMI";
    }

    public String getCbAddress() throws XmlBlasterException {
        return this.callbackRmiServerBindName;
    }

    public void shutdown() {
        try {
            if (this.callbackRmiServerBindName != null) {
                Naming.unbind(this.callbackRmiServerBindName);
            }
            UnicastRemoteObject.unexportObject(this, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.log.info(this.ME, "The RMI callback server is shutdown.");
    }

    public String[] update(String cbSessionId, MsgUnitRaw[] msgUnitArr) throws RemoteException, XmlBlasterException {
        if (msgUnitArr == null) {
            throw new XmlBlasterException(this.ME, "Received update of null message");
        }
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering update(" + cbSessionId + ") of " + msgUnitArr.length + " messages");
        }
        return this.client.update(cbSessionId, msgUnitArr);
    }

    public void updateOneway(String cbSessionId, MsgUnitRaw[] msgUnitArr) throws RemoteException {
        if (msgUnitArr == null) {
            return;
        }
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering updateOneway(" + cbSessionId + ") of " + msgUnitArr.length + " messages");
        }
        try {
            this.client.updateOneway(cbSessionId, msgUnitArr);
        }
        catch (Throwable e) {
            this.log.error(this.ME, "Caught exception which can't be delivered to xmlBlaster because of 'oneway' mode: " + e.toString());
        }
    }

    public String ping(String qos) throws RemoteException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering ping(" + qos + ") ...");
        }
        return "<qos><state id='OK'/></qos>";
    }
}

