/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.client.protocol.rmi;

import java.applet.Applet;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.protocol.I_XmlBlasterConnection;
import org.xmlBlaster.client.qos.ConnectReturnQos;
import org.xmlBlaster.protocol.rmi.I_AuthServer;
import org.xmlBlaster.protocol.rmi.I_XmlBlaster;
import org.xmlBlaster.protocol.rmi.RmiUrl;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnitRaw;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.XmlBlasterSecurityManager;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.plugin.PluginInfo;
import org.xmlBlaster.util.qos.address.Address;

public class RmiConnection
implements I_XmlBlasterConnection {
    private String ME = "RmiConnection";
    private Global glob;
    private LogChannel log;
    private I_AuthServer authServer = null;
    private I_XmlBlaster blasterServer = null;
    private String sessionId = null;
    protected Address clientAddress;
    private RmiUrl rmiUrl;
    public static final int DEFAULT_REGISTRY_PORT = 1099;
    private boolean verbose = true;

    public RmiConnection() {
    }

    public RmiConnection(Global glob) throws XmlBlasterException {
        this.init(glob, null);
    }

    public RmiConnection(Global glob, Applet ap) throws XmlBlasterException {
        this.init(glob, null);
    }

    public String getType() {
        return this.getProtocol();
    }

    public String getVersion() {
        return "1.0";
    }

    public void init(Global glob, PluginInfo pluginInfo) throws XmlBlasterException {
        this.glob = glob == null ? Global.instance() : glob;
        this.log = this.glob.getLog("rmi");
        XmlBlasterSecurityManager.createSecurityManager(this.glob);
        this.log.info(this.ME, "Created '" + this.getProtocol() + "' protocol plugin to connect to xmlBlaster server");
    }

    public void connectLowlevel(Address address) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "connectLowlevel() ...");
        }
        if (this.authServer != null) {
            return;
        }
        this.clientAddress = address;
        this.rmiUrl = new RmiUrl(this.glob, this.clientAddress);
        String authServerUrl = this.rmiUrl.getUrl() + "I_AuthServer";
        String addr = this.clientAddress.getEnv("AuthServerUrl", authServerUrl).getValue();
        Remote rem = this.lookup(addr);
        if (!(rem instanceof I_AuthServer)) {
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION_ADDRESS, this.ME, "No connect to '" + addr + "' possible, class needs to implement interface I_AuthServer.");
        }
        this.authServer = (I_AuthServer)rem;
        this.clientAddress.setRawAddress(addr);
        this.log.info(this.ME, "Accessed xmlBlaster authentication reference with '" + addr + "'");
        String xmlBlasterUrl = this.rmiUrl.getUrl() + "I_XmlBlaster";
        addr = this.clientAddress.getEnv("XmlBlasterUrl", xmlBlasterUrl).getValue();
        rem = this.lookup(addr);
        if (!(rem instanceof I_XmlBlaster)) {
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION_ADDRESS, this.ME, "No connect to '" + addr + "' possible, class needs to implement interface I_XmlBlaster.");
        }
        this.blasterServer = (I_XmlBlaster)rem;
        this.log.info(this.ME, "Accessed xmlBlaster server reference with '" + addr + "'");
    }

    private Remote lookup(String addr) throws XmlBlasterException {
        try {
            try {
                Remote remote = Naming.lookup(addr);
                Object var7_4 = null;
                this.verbose = false;
                return remote;
            }
            catch (RemoteException e) {
                if (this.verbose) {
                    this.log.warn(this.ME, "Can't access address ='" + addr + "', no rmi registry running");
                }
                throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "Can't access address ='" + addr + "', no rmi registry running");
            }
            catch (NotBoundException e) {
                if (this.verbose) {
                    this.log.warn(this.ME, "The given address ='" + addr + "' is not bound to rmi registry: " + e.toString());
                }
                throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "The given address '" + addr + "' is not bound to rmi registry: " + e.toString());
            }
            catch (MalformedURLException e) {
                this.log.error(this.ME, "The given address ='" + addr + "' is invalid: " + e.toString());
                throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION_ADDRESS, this.ME, "The given address '" + addr + "' is invalid: " + e.toString());
            }
            catch (Throwable e) {
                this.log.error(this.ME, "The given address ='" + addr + "' is invalid : " + e.toString());
                throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION_ADDRESS, this.ME, "The given address '" + addr + "' is invalid : " + e.toString());
            }
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            this.verbose = false;
            throw throwable;
        }
    }

    public void resetConnection() {
        this.authServer = null;
        this.blasterServer = null;
        this.sessionId = null;
    }

    private I_XmlBlaster getXmlBlaster() throws XmlBlasterException {
        if (this.blasterServer == null) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "No RMI connection available.");
            }
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "The RMI xmlBlaster handle is null, no connection available");
        }
        return this.blasterServer;
    }

    public final String getProtocol() {
        return "RMI";
    }

    public String connect(String connectQos) throws XmlBlasterException {
        if (connectQos == null) {
            throw new XmlBlasterException(this.ME + ".connect()", "Please specify a valid QoS");
        }
        if (this.log.CALL) {
            this.log.call(this.ME, "connect() ...");
        }
        if (this.sessionId != null) {
            this.log.warn(this.ME, "You are already logged in.");
            return "";
        }
        this.connectLowlevel(this.clientAddress);
        try {
            return this.authServer.connect(connectQos);
        }
        catch (RemoteException e) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Login failed");
            }
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "Login failed");
        }
    }

    public void setConnectReturnQos(ConnectReturnQos connectReturnQos) {
        this.sessionId = connectReturnQos.getSecretSessionId();
        this.ME = "RmiConnection-" + connectReturnQos.getSessionName().toString();
    }

    public boolean disconnect(String disconnectQos) {
        if (this.log.CALL) {
            this.log.call(this.ME, "logout() ...");
        }
        try {
            if (this.authServer != null) {
                this.authServer.disconnect(this.sessionId, disconnectQos == null ? "" : disconnectQos);
            }
            this.shutdown();
            this.resetConnection();
            return true;
        }
        catch (XmlBlasterException e) {
            this.log.warn(this.ME, "XmlBlasterException: " + e.getMessage());
        }
        catch (RemoteException e) {
            this.log.warn(this.ME, e.toString());
            e.printStackTrace();
        }
        try {
            this.shutdown();
        }
        catch (XmlBlasterException ex) {
            this.log.error(this.ME, "disconnect: could not shutdown properly. " + ex.getMessage());
        }
        this.resetConnection();
        return false;
    }

    public void shutdown() throws XmlBlasterException {
    }

    public boolean isLoggedIn() {
        return this.blasterServer != null;
    }

    public final String subscribe(String xmlKey, String qos) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "subscribe() ...");
        }
        try {
            return this.getXmlBlaster().subscribe(this.sessionId, xmlKey, qos);
        }
        catch (XmlBlasterException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "subscribe", e);
        }
    }

    public final String[] unSubscribe(String xmlKey, String qos) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "unSubscribe() ...");
        }
        try {
            return this.getXmlBlaster().unSubscribe(this.sessionId, xmlKey, qos);
        }
        catch (XmlBlasterException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "unSubscribe", e);
        }
    }

    public final String publish(MsgUnitRaw msgUnit) throws XmlBlasterException {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Publishing ...");
        }
        try {
            return this.getXmlBlaster().publish(this.sessionId, msgUnit);
        }
        catch (XmlBlasterException e) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "XmlBlasterException: " + e.getMessage());
            }
            throw e;
        }
        catch (Exception e) {
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "publish", e);
        }
    }

    public String[] publishArr(MsgUnitRaw[] msgUnitArr) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "publishArr() ...");
        }
        try {
            return this.getXmlBlaster().publishArr(this.sessionId, msgUnitArr);
        }
        catch (XmlBlasterException e) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "XmlBlasterException: " + e.getMessage());
            }
            throw e;
        }
        catch (Exception e) {
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "publishArr", e);
        }
    }

    public void publishOneway(MsgUnitRaw[] msgUnitArr) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "publishOneway(), RMI does not support oneway, we switch to publishArr() ...");
        }
        this.publishArr(msgUnitArr);
    }

    public final String[] erase(String xmlKey, String qos) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "erase() ...");
        }
        try {
            return this.getXmlBlaster().erase(this.sessionId, xmlKey, qos);
        }
        catch (XmlBlasterException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "erase", e);
        }
    }

    public final MsgUnitRaw[] get(String xmlKey, String qos) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "get() ...");
        }
        try {
            return this.getXmlBlaster().get(this.sessionId, xmlKey, qos);
        }
        catch (XmlBlasterException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "get", e);
        }
    }

    public String ping(String str) throws XmlBlasterException {
        try {
            return this.getXmlBlaster().ping(str);
        }
        catch (Exception e) {
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "ping", e);
        }
    }

    public static String usage() {
        String text = "\n";
        text = text + "RmiConnection 'RMI' options:\n";
        text = text + "   -dispatch/connection/plugin/rmi/registryPort\n";
        text = text + "                       Specify a port number where rmiregistry of the xmlBlaster server listens.\n";
        text = text + "                       Default is port 1099, the port 0 switches this feature off.\n";
        text = text + "   -dispatch/connection/plugin/rmi/hostname\n";
        text = text + "                       Specify a hostname where rmiregistry of the xmlBlaster server runs.\n";
        text = text + "                       Default is the localhost.\n";
        text = text + "   -dispatch/callback/plugin/rmi/registryPort\n";
        text = text + "                       Specify a port number where rmiregistry for the callback server listens.\n";
        text = text + "                       Default is port 1099, the port 0 switches this feature off.\n";
        text = text + "   -dispatch/callback/plugin/rmi/hostname\n";
        text = text + "                       Specify a hostname where rmiregistry for the callback server runs.\n";
        text = text + "                       Default is the localhost (useful for multi homed hosts).\n";
        text = text + "\n";
        return text;
    }
}

