/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.client.protocol.socket;

import java.io.IOException;
import java.net.Socket;
import java.util.Iterator;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.protocol.I_CallbackExtended;
import org.xmlBlaster.client.protocol.I_CallbackServer;
import org.xmlBlaster.client.protocol.socket.SocketConnection;
import org.xmlBlaster.client.protocol.socket.WorkerThread;
import org.xmlBlaster.protocol.socket.Executor;
import org.xmlBlaster.protocol.socket.Parser;
import org.xmlBlaster.protocol.socket.SocketUrl;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.plugin.PluginInfo;
import org.xmlBlaster.util.qos.address.CallbackAddress;

public class SocketCallbackImpl
extends Executor
implements Runnable,
I_CallbackServer {
    private String ME = "SocketCallbackImpl";
    private Global glob;
    private LogChannel log;
    private SocketConnection sockCon;
    private SocketUrl socketUrl;
    private CallbackAddress callbackAddress;
    boolean running = false;

    public String getType() {
        return this.getCbProtocol();
    }

    public String getVersion() {
        return "1.0";
    }

    public void init(Global glob, PluginInfo pluginInfo) {
    }

    public final synchronized void initialize(Global glob, String loginName, CallbackAddress callbackAddress, I_CallbackExtended cbClient) throws XmlBlasterException {
        this.glob = glob == null ? Global.instance() : glob;
        this.log = this.glob.getLog("socket");
        this.ME = "SocketCallbackImpl-" + loginName;
        this.callbackAddress = callbackAddress;
        this.setLoginName(loginName);
        this.setCbClient(cbClient);
        if (!this.running) {
            this.sockCon = (SocketConnection)glob.getObjectEntry("org.xmlBlaster.client.protocol.socket.SocketConnection");
            if (this.sockCon == null) {
                throw new XmlBlasterException(glob, ErrorCode.INTERNAL_NOTIMPLEMENTED, this.ME, "Sorry, creation of SOCKET callback handler is not possible if client connection is not of type 'SOCKET'");
            }
            this.sockCon.registerCbReceiver(this);
            Socket sock = null;
            try {
                sock = this.sockCon.getSocket();
            }
            catch (XmlBlasterException e) {
                this.log.trace(this.ME, "There is no client socket connection which i could use: " + e.getMessage());
                return;
            }
            try {
                super.initialize(this.sockCon.getGlobal(), this.callbackAddress, sock, null);
            }
            catch (IOException e) {
                throw new XmlBlasterException(glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "Creation of SOCKET callback handler failed", e);
            }
            this.socketUrl = this.sockCon.getLocalSocketUrl();
            this.callbackAddress.setRawAddress(this.socketUrl.getUrl());
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Callback uri=" + this.socketUrl.getUrl());
            }
            this.running = true;
            Thread t = new Thread((Runnable)this, "XmlBlaster.SOCKET.callback-" + this.sockCon.getLoginName());
            t.setDaemon(true);
            int threadPrio = this.callbackAddress.getEnv("threadPrio", 5).getValue();
            try {
                t.setPriority(threadPrio);
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "-dispatch/callback/plugin/socket/threadPrio = " + threadPrio);
                }
            }
            catch (IllegalArgumentException e) {
                this.log.warn(this.ME, "Your -dispatch/callback/plugin/socket/threadPrio " + threadPrio + " is out of range, we continue with default setting " + 5);
            }
            t.start();
        }
    }

    public final String getCbProtocol() {
        return "SOCKET";
    }

    public String getCbAddress() throws XmlBlasterException {
        if (this.socketUrl == null) {
            return "";
        }
        return this.socketUrl.getUrl();
    }

    public void run() {
        this.log.info(this.ME, "Started callback receiver plugin on '" + this.socketUrl.getUrl() + "'");
        boolean multiThreaded = this.callbackAddress.getEnv("multiThreaded", true).getValue();
        if (this.log.TRACE) {
            this.log.trace(this.ME, "SOCKET multiThreaded=" + multiThreaded);
        }
        while (this.running) {
            Parser receiver = new Parser(this.glob);
            try {
                receiver.parse(this.iStream);
                if (this.log.DUMP) {
                    this.log.dump(this.ME, "Receiving message >" + Parser.toLiteral(receiver.createRawMsg()) + "<\n" + receiver.dump());
                }
                if (receiver.isInvoke() && multiThreaded) {
                    WorkerThread t = new WorkerThread(this.glob, this, receiver);
                    t.setPriority(this.callbackAddress.getEnv("invokerThreadPrio", 5).getValue());
                    t.start();
                    continue;
                }
                this.receive(receiver);
            }
            catch (XmlBlasterException e) {
                this.log.warn(this.ME, e.toString());
            }
            catch (Throwable e) {
                if (!this.running) continue;
                if (e instanceof IOException) {
                    this.log.warn(this.ME, "Closing connection to server: " + e.toString());
                } else {
                    this.log.error(this.ME, "Closing connection to server: " + e.toString());
                }
                try {
                    this.sockCon.shutdown();
                }
                catch (XmlBlasterException ex) {
                    this.log.error(this.ME, "run() could not shutdown correctly. " + ex.getMessage());
                }
            }
        }
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Terminating socket callback thread");
        }
    }

    final SocketConnection getSocketConnection() {
        return this.sockCon;
    }

    public synchronized void shutdown() {
        this.setCbClient(null);
    }

    public synchronized void shutdownSocket() {
        this.running = false;
        if (this.iStream != null) {
            try {
                this.iStream.close();
                this.iStream = null;
            }
            catch (IOException e) {
                this.log.warn(this.ME, e.toString());
            }
        }
        try {
            if (this.responseListenerMap.size() > 0) {
                Iterator iterator = this.responseListenerMap.keySet().iterator();
                StringBuffer buf = new StringBuffer(256);
                while (iterator.hasNext()) {
                    if (buf.length() > 0) {
                        buf.append(", ");
                    }
                    String key = (String)iterator.next();
                    buf.append(key);
                }
                this.log.warn(this.ME, "There are " + this.responseListenerMap.size() + " messages pending without a response, request IDs are " + buf.toString());
                this.responseListenerMap.clear();
            }
            Object var5_5 = null;
            this.freePendingThreads();
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.freePendingThreads();
            throw throwable;
        }
    }
}

