/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.client.protocol.socket;

import java.applet.Applet;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.net.UnknownHostException;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.protocol.I_CallbackExtended;
import org.xmlBlaster.client.protocol.I_CallbackServer;
import org.xmlBlaster.client.protocol.I_XmlBlasterConnection;
import org.xmlBlaster.client.protocol.socket.SocketCallbackImpl;
import org.xmlBlaster.client.qos.ConnectReturnQos;
import org.xmlBlaster.engine.qos.EraseQosServer;
import org.xmlBlaster.engine.qos.GetQosServer;
import org.xmlBlaster.engine.xml2java.XmlKey;
import org.xmlBlaster.protocol.socket.ExecutorBase;
import org.xmlBlaster.protocol.socket.Parser;
import org.xmlBlaster.protocol.socket.SocketUrl;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnitRaw;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.def.MethodName;
import org.xmlBlaster.util.plugin.PluginInfo;
import org.xmlBlaster.util.qos.address.Address;
import org.xmlBlaster.util.qos.address.CallbackAddress;

public class SocketConnection
implements I_XmlBlasterConnection,
ExecutorBase {
    private String ME = "SocketConnection";
    private Global glob;
    private LogChannel log;
    private SocketUrl socketUrl;
    private SocketUrl localSocketUrl;
    protected Socket sock;
    protected InputStream iStream;
    protected OutputStream oStream;
    protected SocketCallbackImpl cbReceiver;
    protected String sessionId;
    protected String loginName = "dummyLoginName";
    protected Address clientAddress;
    private I_CallbackExtended cbClient;

    public SocketConnection() {
    }

    public SocketConnection(Global glob) throws XmlBlasterException {
        this.init(glob, null);
    }

    public SocketConnection(Global glob, Applet ap) throws XmlBlasterException {
        this.init(glob, null);
    }

    public String getLoginName() {
        return this.loginName;
    }

    public String getType() {
        return this.getProtocol();
    }

    public String getVersion() {
        return "1.0";
    }

    public void init(Global glob, PluginInfo pluginInfo) throws XmlBlasterException {
        this.glob = glob == null ? Global.instance() : glob;
        this.log = this.glob.getLog("socket");
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering init()");
        }
        this.glob.addObjectEntry("org.xmlBlaster.client.protocol.socket.SocketConnection", this);
    }

    public Socket getSocket() throws XmlBlasterException {
        if (this.sock == null) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "No socket connection available.");
            }
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "No plain SOCKET connection available.");
        }
        return this.sock;
    }

    final Global getGlobal() {
        return this.glob;
    }

    public void connectLowlevel(Address address) throws XmlBlasterException {
        if (this.isConnected()) {
            return;
        }
        this.clientAddress = address;
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering connectLowlevel(), connection with raw socket to server ...");
        }
        this.socketUrl = new SocketUrl(this.glob, this.clientAddress);
        if (this.socketUrl.getPort() < 1) {
            String str = "Option dispatch/connection/plugin/socket/port set to " + this.socketUrl.getPort() + ", socket client not started";
            this.log.info(this.ME, str);
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION_ADDRESS, this.ME, str);
        }
        this.localSocketUrl = new SocketUrl(this.glob, this.clientAddress, true, -1);
        try {
            if (this.localSocketUrl.getPort() > -1) {
                this.sock = new Socket(this.socketUrl.getInetAddress(), this.socketUrl.getPort(), this.localSocketUrl.getInetAddress(), this.localSocketUrl.getPort());
                this.log.info(this.ME, "Created SOCKET client connected to '" + this.socketUrl.getUrl() + "', your configured local parameters are localHostname=" + this.localSocketUrl.getHostname() + " on localPort=" + this.localSocketUrl.getPort());
            } else {
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Trying socket connection to " + this.socketUrl.getUrl() + " ...");
                }
                this.sock = new Socket(this.socketUrl.getInetAddress(), this.socketUrl.getPort());
                this.clientAddress.setPluginProperty("localPort", "" + this.sock.getLocalPort());
                this.clientAddress.setPluginProperty("localHostname", this.sock.getLocalAddress().getHostAddress());
                this.localSocketUrl = new SocketUrl(this.glob, this.sock.getLocalAddress().getHostAddress(), this.sock.getLocalPort());
                this.log.info(this.ME, "Created SOCKET client connected to '" + this.socketUrl.getUrl() + "', callback address is '" + this.localSocketUrl.getUrl() + "'");
            }
            this.oStream = this.sock.getOutputStream();
            this.iStream = this.sock.getInputStream();
            if (this.cbReceiver != null) {
                CallbackAddress cba = new CallbackAddress(this.glob);
                this.cbReceiver.initialize(this.glob, this.getLoginName(), cba, this.cbClient);
            }
        }
        catch (XmlBlasterException e) {
            throw e;
        }
        catch (UnknownHostException e) {
            String str = "XmlBlaster server host is unknown, '-dispatch/connection/plugin/socket/hostname=<ip>': " + e.toString();
            if (this.log.TRACE) {
                this.log.trace(this.ME + ".constructor", str);
            }
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "XmlBlaster server is unknown, '-dispatch/connection/plugin/socket/hostname=<ip>'", e);
        }
        catch (IOException e) {
            String str = "Connection to xmlBlaster server failed local=" + this.localSocketUrl + " remote=" + this.socketUrl + ": " + e.toString();
            if (this.log.TRACE) {
                this.log.trace(this.ME + ".constructor", str);
            }
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, str);
        }
        catch (Throwable e) {
            if (!(e instanceof IOException) && !(e instanceof ConnectException)) {
                e.printStackTrace();
            }
            String str = "Socket client connection to '" + this.socketUrl.getUrl() + "' failed, try options '-dispatch/connection/plugin/socket/hostname <ip> -dispatch/connection/plugin/socket/port <port>' and check if the xmlBlaster server has loaded the socket driver in xmlBlaster.properties";
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME, str, e);
        }
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Created '" + this.getProtocol() + "' protocol plugin and connect to xmlBlaster server");
        }
    }

    public void resetConnection() {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "SocketClient is re-initialized, no connection available");
        }
        try {
            this.shutdown();
        }
        catch (XmlBlasterException ex) {
            this.log.error(this.ME, "disconnect. Could not shutdown properly. " + ex.getMessage());
        }
    }

    public SocketUrl getLocalSocketUrl() {
        if (this.localSocketUrl == null) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Can't determine client address, no socket connection available");
            }
            return null;
        }
        return this.localSocketUrl;
    }

    public void setConnectReturnQos(ConnectReturnQos connectReturnQos) {
        this.sessionId = connectReturnQos.getSecretSessionId();
        this.loginName = connectReturnQos.getSessionName().getLoginName();
        this.ME = "SocketConnection-" + this.loginName;
    }

    public String connect(String connectQos) throws XmlBlasterException {
        if (connectQos == null) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME + ".connect()", "Please specify a valid QoS");
        }
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering connect");
        }
        if (this.isConnected() && this.isLoggedIn()) {
            this.log.warn(this.ME, "You are already logged in, no relogin possible.");
            return "";
        }
        this.connectLowlevel(this.clientAddress);
        if (this.getCbReceiver() == null) {
            this.log.info(this.ME, "Creating default callback server type=" + this.getType());
            I_CallbackServer server = this.glob.getCbServerPluginManager().getPlugin(this.getType(), this.getVersion());
            CallbackAddress cba = new CallbackAddress(this.glob);
            server.initialize(this.glob, this.getLoginName(), cba, this.cbClient);
        }
        try {
            Parser parser = new Parser(this.glob, 73, MethodName.CONNECT, this.sessionId);
            parser.addQos(connectQos);
            return (String)this.getCbReceiver().execute(parser, true);
        }
        catch (XmlBlasterException e) {
            throw e;
        }
        catch (Throwable e) {
            if (!(e instanceof IOException) && !(e instanceof ConnectException)) {
                e.printStackTrace();
            }
            if (this.log.TRACE) {
                this.log.trace(this.ME + ".connect", e.toString());
            }
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "login failed", e);
        }
    }

    public final String getProtocol() {
        return "SOCKET";
    }

    public boolean disconnect(String qos) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering logout/disconnect: id=" + this.sessionId);
        }
        if (!this.isLoggedIn()) {
            this.log.warn(this.ME, "You are not logged in, no logout possible.");
            return false;
        }
        try {
            Parser parser = new Parser(this.glob, 73, MethodName.DISCONNECT, this.sessionId);
            parser.addQos(qos == null ? "" : qos);
            this.getCbReceiver().running = false;
            this.getCbReceiver().execute(parser, false);
            this.shutdown();
            this.sessionId = null;
            return true;
        }
        catch (XmlBlasterException e) {
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "disconnect", e);
        }
        catch (IOException e1) {
            if (this.log.TRACE) {
                this.log.trace(this.ME + ".disconnect", "IO exception: " + e1.toString());
            }
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "disconnect", e1);
        }
    }

    public void shutdown() throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering shutdown of callback server");
        }
        if (this.cbReceiver != null) {
            this.cbClient = this.cbReceiver.getCbClient();
            this.cbReceiver.shutdownSocket();
        }
        try {
            if (this.iStream != null) {
                this.iStream.close();
                this.iStream = null;
            }
        }
        catch (IOException e) {
            this.log.warn(this.ME + ".shutdown", e.toString());
        }
        try {
            if (this.oStream != null) {
                this.oStream.close();
                this.oStream = null;
            }
        }
        catch (IOException e) {
            this.log.warn(this.ME + ".shutdown", e.toString());
        }
        try {
            if (this.sock != null) {
                this.sock.close();
                this.sock = null;
            }
        }
        catch (IOException e) {
            this.log.warn(this.ME + ".shutdown", e.toString());
        }
    }

    public final boolean isLoggedIn() {
        return this.sessionId != null;
    }

    public final boolean isConnected() {
        return this.sock != null;
    }

    final void registerCbReceiver(SocketCallbackImpl cbReceiver) {
        this.cbReceiver = cbReceiver;
        if (this.cbReceiver != null) {
            this.cbClient = this.cbReceiver.getCbClient();
        }
    }

    private final SocketCallbackImpl getCbReceiver() throws XmlBlasterException {
        return this.cbReceiver;
    }

    public final String subscribe(String xmlKey_literal, String qos_literal) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering subscribe(id=" + this.sessionId + ")");
        }
        try {
            Parser parser = new Parser(this.glob, 73, MethodName.SUBSCRIBE, this.sessionId);
            parser.addKeyAndQos(xmlKey_literal, qos_literal);
            Object response = this.getCbReceiver().execute(parser, true);
            return (String)response;
        }
        catch (IOException e1) {
            if (this.log.TRACE) {
                this.log.trace(this.ME + ".subscribe", "IO exception: " + e1.toString());
            }
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, MethodName.SUBSCRIBE.toString(), e1);
        }
    }

    public final String[] unSubscribe(String xmlKey_literal, String qos_literal) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering unSubscribe(): id=" + this.sessionId);
        }
        if (this.log.DUMP) {
            this.log.dump(this.ME, "Entering unSubscribe(): id=" + this.sessionId + " key='" + xmlKey_literal + "' qos='" + qos_literal + "'");
        }
        try {
            Parser parser = new Parser(this.glob, 73, MethodName.UNSUBSCRIBE, this.sessionId);
            parser.addKeyAndQos(xmlKey_literal, qos_literal);
            Object response = this.getCbReceiver().execute(parser, true);
            return (String[])response;
        }
        catch (IOException e1) {
            if (this.log.TRACE) {
                this.log.trace(this.ME + ".unSubscribe", "IO exception: " + e1.toString());
            }
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, MethodName.UNSUBSCRIBE.toString(), e1);
        }
    }

    public final String publish(MsgUnitRaw msgUnit) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering publish(): id=" + this.sessionId);
        }
        try {
            Parser parser = new Parser(this.glob, 73, MethodName.PUBLISH, this.sessionId);
            parser.addMessage(msgUnit);
            Object response = this.getCbReceiver().execute(parser, true);
            String[] arr = (String[])response;
            return arr[0];
        }
        catch (IOException e1) {
            if (this.log.TRACE) {
                this.log.trace(this.ME + ".publish", "IO exception: " + e1.toString());
            }
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, MethodName.PUBLISH.toString(), e1);
        }
    }

    public final String[] publishArr(MsgUnitRaw[] msgUnitArr) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering publishArr: id=" + this.sessionId);
        }
        if (msgUnitArr == null) {
            if (this.log.TRACE) {
                this.log.trace(this.ME + ".InvalidArguments", "The argument of method publishArr() are invalid");
            }
            throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME + ".InvalidArguments", "The argument of method publishArr() are invalid");
        }
        try {
            Parser parser = new Parser(this.glob, 73, MethodName.PUBLISH, this.sessionId);
            parser.addMessage(msgUnitArr);
            Object response = this.getCbReceiver().execute(parser, true);
            return (String[])response;
        }
        catch (IOException e1) {
            if (this.log.TRACE) {
                this.log.trace(this.ME + ".publishArr", "IO exception: " + e1.toString());
            }
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "publishArr", e1);
        }
    }

    public final void publishOneway(MsgUnitRaw[] msgUnitArr) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering publishOneway: id=" + this.sessionId);
        }
        if (msgUnitArr == null) {
            if (this.log.TRACE) {
                this.log.trace(this.ME + ".InvalidArguments", "The argument of method publishOneway() are invalid");
            }
            return;
        }
        try {
            Parser parser = new Parser(this.glob, 73, MethodName.PUBLISH_ONEWAY, this.sessionId);
            parser.addMessage(msgUnitArr);
            this.getCbReceiver().execute(parser, false);
        }
        catch (Throwable e) {
            if (this.log.TRACE) {
                this.log.trace(this.ME + ".publishOneway", "Sending of oneway message failed: " + e.toString());
            }
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, MethodName.PUBLISH_ONEWAY.toString(), e);
        }
    }

    public final String[] erase(XmlKey xmlKey, EraseQosServer eraseQoS) throws XmlBlasterException {
        String xmlKey_literal = xmlKey.toXml();
        String eraseQoS_literal = eraseQoS.toXml();
        return this.erase(xmlKey_literal, eraseQoS_literal);
    }

    public final String[] erase(String xmlKey_literal, String qos_literal) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering erase() id=" + this.sessionId);
        }
        try {
            Parser parser = new Parser(this.glob, 73, MethodName.ERASE, this.sessionId);
            parser.addKeyAndQos(xmlKey_literal, qos_literal);
            Object response = this.getCbReceiver().execute(parser, true);
            return (String[])response;
        }
        catch (IOException e1) {
            if (this.log.TRACE) {
                this.log.trace(this.ME + ".erase", "IO exception: " + e1.toString());
            }
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, MethodName.ERASE.toString(), e1);
        }
    }

    public final MsgUnitRaw[] get(XmlKey xmlKey, GetQosServer getQoS) throws XmlBlasterException {
        String xmlKey_literal = xmlKey.toXml();
        String getQoS_literal = getQoS.toXml();
        return this.get(xmlKey_literal, getQoS_literal);
    }

    public final MsgUnitRaw[] get(String xmlKey_literal, String qos_literal) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering get() xmlKey=\n" + xmlKey_literal + ") ...");
        }
        try {
            Parser parser = new Parser(this.glob, 73, MethodName.GET, this.sessionId);
            parser.addKeyAndQos(xmlKey_literal, qos_literal);
            Object response = this.getCbReceiver().execute(parser, true);
            return (MsgUnitRaw[])response;
        }
        catch (IOException e1) {
            if (this.log.TRACE) {
                this.log.trace(this.ME + ".get", "IO exception: " + e1.toString());
            }
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, MethodName.GET.toString(), e1);
        }
    }

    public String ping(String qos) throws XmlBlasterException {
        if (this.getCbReceiver() == null) {
            return "<qos><state id='OK'/></qos>";
        }
        try {
            Parser parser = new Parser(this.glob, 73, MethodName.PING, null);
            parser.addQos("");
            Object response = this.getCbReceiver().execute(parser, true);
            return (String)response;
        }
        catch (IOException e1) {
            if (this.log.TRACE) {
                this.log.trace(this.ME + ".ping", "IO exception: " + e1.toString());
            }
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, MethodName.PING.toString(), e1);
        }
    }

    public String toXml() throws XmlBlasterException {
        return this.toXml("");
    }

    public String toXml(String extraOffset) throws XmlBlasterException {
        if (this.sock == null) {
            return "<noConnection />";
        }
        return "<connected/>";
    }

    public static String usage() {
        String text = "\n";
        text = text + "SocketConnection 'SOCKET' options:\n";
        text = text + "   -dispatch/connection/plugin/socket/port\n";
        text = text + "                       Specify a port number where xmlBlaster SOCKET server listens.\n";
        text = text + "                       Default is port 7607, the port 0 switches this feature off.\n";
        text = text + "   -dispatch/connection/plugin/socket/hostname\n";
        text = text + "                       Specify a hostname where the xmlBlaster web server runs.\n";
        text = text + "                       Default is the localhost.\n";
        text = text + "   -dispatch/connection/plugin/socket/localPort\n";
        text = text + "                       You can specify our client side port as well (usually you shouldn't)\n";
        text = text + "                       Default is that the port is chosen by the operating system.\n";
        text = text + "   -dispatch/connection/plugin/socket/localHostname\n";
        text = text + "                       Specify the hostname who we are. Makes sense for multi homed computers.\n";
        text = text + "                       Defaults to our hostname.\n";
        text = text + "   -dispatch/callback/plugin/socket/responseTimeout\n";
        text = text + "                       How long to wait for a method invocation to return.\n";
        text = text + "                       Defaults to one minute.\n";
        text = text + "   -dispatch/callback/plugin/socket/threadPrio\n";
        text = text + "                       The priority 1=min - 10=max of the callback listener thread [5].\n";
        text = text + "   -dispatch/callback/plugin/socket/multiThreaded\n";
        text = text + "                       Use seperate threads per update() on client side [true].\n";
        text = text + "   -dump[socket]       true switches on detailed SOCKET debugging [false].\n";
        text = text + "\n";
        return text;
    }
}

