/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.client.protocol.socket;

import java.io.IOException;
import java.net.SocketException;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.protocol.socket.SocketCallbackImpl;
import org.xmlBlaster.protocol.socket.Parser;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;

public class WorkerThread
extends Thread {
    private final String ME;
    private final Global glob;
    private final LogChannel log;
    private final Parser parser;
    private final SocketCallbackImpl cbHandler;

    public WorkerThread(Global glob, SocketCallbackImpl cbHandler, Parser receiver) {
        super("protocol.socket.workerThread.forCallbackMessages");
        this.glob = glob;
        this.log = glob.getLog("socket");
        this.cbHandler = cbHandler;
        this.ME = "WorkerThread-" + cbHandler.getSocketConnection().getLoginName();
        this.parser = receiver;
    }

    public void run() {
        try {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Starting worker thread, invoking client code with received message");
            }
            this.cbHandler.receive(this.parser);
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Worker thread done");
            }
        }
        catch (XmlBlasterException e) {
            this.log.error(this.ME, e.toString());
        }
        catch (Throwable e) {
            if (!(e instanceof IOException)) {
                e.printStackTrace();
            }
            if (e instanceof SocketException) {
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Shutting down because of: " + e.toString());
                }
            } else {
                this.log.error(this.ME, "Shutting down because of: " + e.toString());
            }
            try {
                this.cbHandler.getSocketConnection().shutdown();
            }
            catch (XmlBlasterException ex) {
                this.log.error(this.ME, "run() could not shutdown correctly. " + ex.getMessage());
            }
        }
    }
}

