/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.client.protocol.xmlrpc;

import java.io.IOException;
import java.net.BindException;
import org.apache.xmlrpc.WebServer;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.protocol.I_CallbackExtended;
import org.xmlBlaster.client.protocol.I_CallbackServer;
import org.xmlBlaster.client.protocol.xmlrpc.XmlRpcCallbackImpl;
import org.xmlBlaster.protocol.xmlrpc.XmlRpcUrl;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.plugin.PluginInfo;
import org.xmlBlaster.util.qos.address.CallbackAddress;

public class XmlRpcCallbackServer
implements I_CallbackServer {
    private String ME = "XmlRpcCallbackServer";
    private Global glob = null;
    private LogChannel log = null;
    private I_CallbackExtended client;
    private String loginName;
    private XmlRpcUrl xmlRpcUrlCallback;
    public static final int DEFAULT_CALLBACK_PORT = 8081;
    public CallbackAddress callbackAddress;
    private WebServer webServer = null;

    public String getType() {
        return this.getCbProtocol();
    }

    public String getVersion() {
        return "1.0";
    }

    public void init(Global glob, PluginInfo pluginInfo) {
    }

    public void initialize(Global glob, String name, CallbackAddress callbackAddress, I_CallbackExtended client) throws XmlBlasterException {
        this.ME = "XmlRpcCallbackServer-" + name;
        this.glob = glob;
        this.log = glob.getLog("xmlrpc");
        this.callbackAddress = callbackAddress;
        this.client = client;
        this.loginName = name;
        this.createCallbackServer();
        this.log.info(this.ME, "Success, created XMLRPC callback server for " + this.loginName);
    }

    public void createCallbackServer() throws XmlBlasterException {
        block12: {
            if (this.log.CALL) {
                this.log.call(this.ME, "createCallbackServer() ...");
            }
            this.xmlRpcUrlCallback = new XmlRpcUrl(this.glob, this.callbackAddress, false, 8081);
            try {
                if (this.xmlRpcUrlCallback.getPort() > 0) {
                    int numTries = 20;
                    int ii = 0;
                    while (ii < numTries) {
                        try {
                            this.webServer = new WebServer(this.xmlRpcUrlCallback.getPort(), this.xmlRpcUrlCallback.getInetAddress());
                            break;
                        }
                        catch (BindException e) {
                            this.log.warn(this.ME, "Port " + this.xmlRpcUrlCallback.getPort() + " for XMLRPC callback server is in use already, trying with port " + (this.xmlRpcUrlCallback.getPort() + 1) + ": " + e.toString());
                            this.xmlRpcUrlCallback.setPort(this.xmlRpcUrlCallback.getPort() + 1);
                        }
                        catch (IOException e) {
                            if (e.getMessage().indexOf("Cannot assign requested address") != -1) {
                                if (this.log.TRACE) {
                                    this.log.warn(this.ME, "Host " + this.xmlRpcUrlCallback.getHostname() + " for XMLRPC callback server is invalid: " + e.toString());
                                }
                                throw new XmlBlasterException(this.glob, ErrorCode.USER_CONFIGURATION, this.ME, "Local host IP '" + this.xmlRpcUrlCallback.getHostname() + "' for XMLRPC callback server is invalid: " + e.toString());
                            }
                            this.log.warn(this.ME, "Port " + this.xmlRpcUrlCallback.getPort() + " for XMLRPC callback server is in use already, trying with port " + (this.xmlRpcUrlCallback.getPort() + 1) + ": " + e.toString());
                            this.xmlRpcUrlCallback.setPort(this.xmlRpcUrlCallback.getPort() + 1);
                        }
                        if (ii == numTries - 1) {
                            this.log.error(this.ME, "Can't find free port " + this.xmlRpcUrlCallback.getPort() + " for XMLRPC callback server, please use '-dispatch/callback/plugin/xmlrpc/port <port>' to specify a free one.");
                        }
                        ++ii;
                    }
                    this.webServer.addHandler("$default", new XmlRpcCallbackImpl(this));
                    this.callbackAddress.setRawAddress(this.xmlRpcUrlCallback.getUrl());
                    this.ME = "XmlRpcCallbackServer-" + this.xmlRpcUrlCallback.getUrl();
                    break block12;
                }
                this.log.info(this.ME, "XmlRpc callback http server not created, because of -dispatch/callback/plugin/xmlrpc/port is 0");
            }
            catch (XmlBlasterException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new XmlBlasterException(this.glob, ErrorCode.USER_CONFIGURATION, this.ME, "Could not initialize XMLRPC callback server on '" + this.xmlRpcUrlCallback.getUrl() + "': " + e.toString());
            }
        }
    }

    public String getCbProtocol() {
        return "XMLRPC";
    }

    public String getCbAddress() throws XmlBlasterException {
        return this.xmlRpcUrlCallback.getUrl();
    }

    public void shutdown() {
        if (this.webServer != null) {
            try {
                this.webServer.removeHandler("$default");
                this.webServer.shutdown();
            }
            catch (Throwable e) {
                this.log.warn(this.ME, "Problems during shutdown of XMLRPC callback web server: " + e.toString());
                return;
            }
        }
        this.log.info(this.ME, "The XMLRPC callback server is shutdown.");
    }

    public String update(String cbSessionId, String updateKey, byte[] content, String updateQos) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering update(): sessionId: " + cbSessionId);
        }
        return this.client.update(cbSessionId, updateKey, content, updateQos);
    }

    public void updateOneway(String cbSessionId, String updateKey, byte[] content, String updateQos) {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering updateOneway(): sessionId: " + cbSessionId);
        }
        try {
            this.client.updateOneway(cbSessionId, updateKey, content, updateQos);
        }
        catch (Throwable e) {
            this.log.error(this.ME, "Caught exception which can't be delivered to xmlBlaster because of 'oneway' mode: " + e.toString());
        }
    }

    public String ping(String str) {
        return "<qos><state id='OK'/></qos>";
    }
}

