/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.client.protocol.xmlrpc;

import java.applet.Applet;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Vector;
import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;
import org.jutils.log.LogChannel;
import org.jutils.text.StringHelper;
import org.xmlBlaster.client.protocol.I_XmlBlasterConnection;
import org.xmlBlaster.client.qos.ConnectReturnQos;
import org.xmlBlaster.engine.qos.EraseQosServer;
import org.xmlBlaster.engine.qos.GetQosServer;
import org.xmlBlaster.engine.xml2java.XmlKey;
import org.xmlBlaster.protocol.xmlrpc.XmlRpcUrl;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnitRaw;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.plugin.PluginInfo;
import org.xmlBlaster.util.protocol.ProtoConverter;
import org.xmlBlaster.util.qos.address.Address;

public class XmlRpcConnection
implements I_XmlBlasterConnection {
    private String ME = "XmlRpcConnection";
    private Global glob;
    private LogChannel log;
    private XmlRpcUrl xmlRpcUrl;
    private XmlRpcClient xmlRpcClient;
    private String sessionId;
    protected ConnectReturnQos connectReturnQos;
    protected Address clientAddress;

    public XmlRpcConnection() {
    }

    public XmlRpcConnection(Global glob) throws XmlBlasterException {
        this.init(glob, null);
    }

    public XmlRpcConnection(Global glob, Applet ap) throws XmlBlasterException {
        this.init(glob, null);
    }

    public String getType() {
        return this.getProtocol();
    }

    public String getVersion() {
        return "1.0";
    }

    public void init(Global glob, PluginInfo pluginInfo) throws XmlBlasterException {
        this.glob = glob == null ? Global.instance() : glob;
        this.log = this.glob.getLog("xmlrpc");
        this.log.info(this.ME, "Created '" + this.getProtocol() + "' protocol plugin to connect to xmlBlaster server");
    }

    public final String getProtocol() {
        return "XMLRPC";
    }

    public void connectLowlevel(Address address) throws XmlBlasterException {
        if (this.xmlRpcClient != null) {
            return;
        }
        this.clientAddress = address;
        this.xmlRpcUrl = new XmlRpcUrl(this.glob, this.clientAddress);
        try {
            if (this.clientAddress.getEnv("debug", false).getValue()) {
                XmlRpc.setDebug(true);
            }
            this.xmlRpcClient = new XmlRpcClient(this.xmlRpcUrl.getUrl());
            this.log.info(this.ME, "Created XmlRpc client to " + this.xmlRpcUrl.getUrl());
        }
        catch (MalformedURLException e) {
            this.log.error(this.ME + ".constructor", "Malformed URL: " + e.toString());
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION_ADDRESS, "Malformed URL for XmlRpc connection", e.toString());
        }
        catch (IOException e1) {
            this.log.error(this.ME + ".constructor", "IO Exception: " + e1.toString());
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "IO Exception", e1);
        }
    }

    public void resetConnection() {
        this.log.trace(this.ME, "XmlRpcCLient is initialized, no connection available");
        this.xmlRpcClient = null;
        this.sessionId = null;
    }

    private XmlRpcClient getXmlRpcClient() throws XmlBlasterException {
        if (this.xmlRpcClient == null) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "No XMLRPC connection available.");
            }
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "The XMLRPC xmlBlaster handle is null, no connection available");
        }
        return this.xmlRpcClient;
    }

    public String connect(String connectQos) throws XmlBlasterException {
        if (connectQos == null) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_CONFIGURATION, this.ME, "Please specify a valid ConnectQoS");
        }
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering login");
        }
        if (this.isLoggedIn()) {
            this.log.warn(this.ME, "You are already logged in, no relogin possible.");
            return "";
        }
        try {
            this.connectLowlevel(this.clientAddress);
            String qosOrig = connectQos;
            String qosStripped = StringHelper.replaceAll(qosOrig, "<![CDATA[", "");
            connectQos = StringHelper.replaceAll(qosStripped, "]]>", "");
            if (!connectQos.equals(qosOrig)) {
                this.log.trace(this.ME, "Stripped CDATA tags surrounding security credentials, XMLRPC does not like it (Helma does not escape ']]>'). This shouldn't be a problem as long as your credentials doesn't contain '<'");
            }
            Vector<String> args = new Vector<String>();
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Executing authenticate.connect() via XmlRpc");
            }
            args.addElement(connectQos);
            return (String)this.getXmlRpcClient().execute("authenticate.connect", args);
        }
        catch (ClassCastException e) {
            this.log.error(this.ME + ".login", "return value not a valid String: " + e.toString());
            throw XmlBlasterException.convert(this.glob, this.ME, "return value not a valid String, Class Cast Exception", e);
        }
        catch (IOException e) {
            if (this.log.TRACE) {
                this.log.trace(this.ME + ".login", "Login to xmlBlaster failed: " + e.toString());
            }
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "Login failed", e);
        }
        catch (XmlRpcException e) {
            throw XmlRpcConnection.extractXmlBlasterException(this.glob, e);
        }
    }

    public void setConnectReturnQos(ConnectReturnQos connectReturnQos) {
        this.sessionId = connectReturnQos.getSecretSessionId();
        this.ME = "XmlRpcConnection-" + connectReturnQos.getSessionName().toString();
    }

    public boolean disconnect(String disconnectQos) {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering logout");
        }
        if (!this.isLoggedIn()) {
            this.log.warn(this.ME, "You are not logged in, no logout possible.");
        }
        try {
            if (this.xmlRpcClient != null) {
                Vector<String> args = new Vector<String>();
                args.addElement(this.sessionId);
                args.addElement(disconnectQos == null ? " " : disconnectQos);
                this.xmlRpcClient.execute("authenticate.disconnect", args);
            }
            try {
                this.shutdown();
            }
            catch (XmlBlasterException ex) {
                this.log.error(this.ME, "disconnect() could not shutdown properly. " + ex.getMessage());
            }
            this.resetConnection();
            return true;
        }
        catch (IOException e1) {
            this.log.warn(this.ME + ".logout", "IO exception: " + e1.toString());
        }
        catch (XmlRpcException e) {
            this.log.warn(this.ME + ".logout", "xml-rpc exception: " + XmlRpcConnection.extractXmlBlasterException(this.glob, e).toString());
        }
        try {
            this.shutdown();
        }
        catch (XmlBlasterException ex) {
            this.log.error(this.ME, "disconnect() could not shutdown properly. " + ex.getMessage());
        }
        this.resetConnection();
        return false;
    }

    public void shutdown() throws XmlBlasterException {
    }

    public boolean isLoggedIn() {
        return this.xmlRpcClient != null && this.sessionId != null;
    }

    public final String subscribe(String xmlKey_literal, String qos_literal) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering subscribe(id=" + this.sessionId + ")");
        }
        try {
            Vector<String> args = new Vector<String>();
            args.addElement(this.sessionId);
            args.addElement(xmlKey_literal);
            args.addElement(qos_literal);
            return (String)this.getXmlRpcClient().execute("xmlBlaster.subscribe", args);
        }
        catch (ClassCastException e) {
            this.log.error(this.ME + ".subscribe", "return value not a valid String: " + e.toString());
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME + ".subscribe", "return value not a valid String, Class Cast Exception", e);
        }
        catch (IOException e1) {
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "subscribe", e1);
        }
        catch (XmlRpcException e) {
            throw XmlRpcConnection.extractXmlBlasterException(this.glob, e);
        }
    }

    public final String[] unSubscribe(String xmlKey_literal, String qos_literal) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering unsubscribe(): id=" + this.sessionId);
        }
        try {
            Vector<String> args = new Vector<String>();
            args.addElement(this.sessionId);
            args.addElement(xmlKey_literal);
            args.addElement(qos_literal);
            Vector vec = (Vector)this.getXmlRpcClient().execute("xmlBlaster.unSubscribe", args);
            return ProtoConverter.vector2StringArray(vec);
        }
        catch (IOException e1) {
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "unSubscribe", e1);
        }
        catch (XmlRpcException e) {
            throw XmlRpcConnection.extractXmlBlasterException(this.glob, e);
        }
    }

    public final String publish(MsgUnitRaw msgUnit) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering publish(): id=" + this.sessionId);
        }
        try {
            Vector<Object> args = new Vector<Object>();
            args.addElement(this.sessionId);
            args.addElement(msgUnit.getKey());
            args.addElement(msgUnit.getContent());
            args.addElement(msgUnit.getQos());
            return (String)this.getXmlRpcClient().execute("xmlBlaster.publish", args);
        }
        catch (ClassCastException e) {
            this.log.error(this.ME + ".publish", "not a valid MsgUnitRaw: " + e.toString());
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME + ".publish", "Not a valid MsgUnitRaw", e);
        }
        catch (IOException e1) {
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "publish", e1);
        }
        catch (XmlRpcException e) {
            throw XmlRpcConnection.extractXmlBlasterException(this.glob, e);
        }
    }

    public final String[] publishArr(MsgUnitRaw[] msgUnitArr) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering publishArr: id=" + this.sessionId);
        }
        if (msgUnitArr == null) {
            this.log.error(this.ME + ".InvalidArguments", "The argument of method publishArr() are invalid");
            throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME, "The argument of method publishArr() are invalid");
        }
        try {
            Vector msgUnitArrWrap = ProtoConverter.messageUnitArray2Vector(msgUnitArr);
            Vector<Object> args = new Vector<Object>();
            args.addElement(this.sessionId);
            args.addElement(msgUnitArrWrap);
            Vector returnVectorWrap = (Vector)this.getXmlRpcClient().execute("xmlBlaster.publishArr", args);
            return ProtoConverter.vector2StringArray(returnVectorWrap);
        }
        catch (ClassCastException e) {
            this.log.error(this.ME + ".publishArr", "not a valid String[]: " + e.toString());
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME + ".publishArr", "Not a valid String[]", e);
        }
        catch (IOException e) {
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "publishArr", e);
        }
        catch (XmlRpcException e) {
            throw XmlRpcConnection.extractXmlBlasterException(this.glob, e);
        }
    }

    public final void publishOneway(MsgUnitRaw[] msgUnitArr) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering publishOneway: id=" + this.sessionId);
        }
        if (msgUnitArr == null) {
            this.log.error(this.ME + ".InvalidArguments", "The argument of method publishOneway() are invalid");
            throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME, "The argument of method publishOneway() are invalid");
        }
        try {
            Vector msgUnitArrWrap = ProtoConverter.messageUnitArray2Vector(msgUnitArr);
            Vector<Object> args = new Vector<Object>();
            args.addElement(this.sessionId);
            args.addElement(msgUnitArrWrap);
            this.getXmlRpcClient().execute("xmlBlaster.publishOneway", args);
        }
        catch (ClassCastException e) {
            this.log.error(this.ME + ".publishOneway", e.toString());
            e.printStackTrace();
            throw XmlBlasterException.convert(this.glob, this.ME, "publishOneway Class Cast Exception", e);
        }
        catch (IOException e) {
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "publishOneway", e);
        }
        catch (XmlRpcException e) {
            throw XmlRpcConnection.extractXmlBlasterException(this.glob, e);
        }
    }

    public final String[] erase(XmlKey xmlKey, EraseQosServer eraseQoS) throws XmlBlasterException {
        String xmlKey_literal = xmlKey.toXml();
        String eraseQoS_literal = eraseQoS.toXml();
        return this.erase(xmlKey_literal, eraseQoS_literal);
    }

    public final String[] erase(String xmlKey_literal, String qos_literal) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering erase() id=" + this.sessionId);
        }
        try {
            Vector<String> args = new Vector<String>();
            args.addElement(this.sessionId);
            args.addElement(xmlKey_literal);
            args.addElement(qos_literal);
            Vector vec = (Vector)this.getXmlRpcClient().execute("xmlBlaster.erase", args);
            return ProtoConverter.vector2StringArray(vec);
        }
        catch (ClassCastException e) {
            this.log.error(this.ME + ".erase", "not a valid Vector: " + e.toString());
            throw XmlBlasterException.convert(this.glob, this.ME, "erase Class Cast Exception", e);
        }
        catch (IOException e1) {
            this.log.error(this.ME + ".erase", "IO exception: " + e1.toString() + " sessionId=" + this.sessionId);
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "erase", e1);
        }
        catch (XmlRpcException e) {
            throw XmlRpcConnection.extractXmlBlasterException(this.glob, e);
        }
    }

    public final MsgUnitRaw[] get(XmlKey xmlKey, GetQosServer getQoS) throws XmlBlasterException {
        String xmlKey_literal = xmlKey.toXml();
        String getQoS_literal = getQoS.toXml();
        return this.get(xmlKey_literal, getQoS_literal);
    }

    public final MsgUnitRaw[] get(String xmlKey_literal, String qos_literal) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering get() xmlKey=\n" + xmlKey_literal + ") ...");
        }
        try {
            Vector<String> args = new Vector<String>();
            args.addElement(this.sessionId);
            args.addElement(xmlKey_literal);
            args.addElement(qos_literal);
            Vector retVector = (Vector)this.getXmlRpcClient().execute("xmlBlaster.get", args);
            return ProtoConverter.vector2MsgUnitRawArray(retVector);
        }
        catch (ClassCastException e) {
            this.log.error(this.ME + ".get", "not a valid Vector: " + e.toString());
            throw XmlBlasterException.convert(this.glob, this.ME, "get Class Cast Exception", e);
        }
        catch (IOException e1) {
            this.log.error(this.ME + ".get", "IO exception: " + e1.toString());
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "get", e1);
        }
        catch (XmlRpcException e) {
            throw XmlRpcConnection.extractXmlBlasterException(this.glob, e);
        }
    }

    public static XmlBlasterException extractXmlBlasterException(Global glob, XmlRpcException e) {
        XmlBlasterException ex = XmlBlasterException.parseToString(glob, e.toString());
        ex.isServerSide(true);
        return ex;
    }

    public String ping(String str) throws XmlBlasterException {
        try {
            Vector<String> args = new Vector<String>();
            args.addElement("");
            return (String)this.getXmlRpcClient().execute("xmlBlaster.ping", args);
        }
        catch (ClassCastException e) {
            this.log.error(this.ME + ".ping", e.toString());
            e.printStackTrace();
            throw XmlBlasterException.convert(this.glob, this.ME, "ping Class Cast Exception", e);
        }
        catch (IOException e) {
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "ping", e);
        }
        catch (XmlRpcException e) {
            throw XmlRpcConnection.extractXmlBlasterException(this.glob, e);
        }
    }

    public String toXml() throws XmlBlasterException {
        return this.toXml("");
    }

    public String toXml(String extraOffset) throws XmlBlasterException {
        if (!this.isLoggedIn()) {
            return "<noConnection />";
        }
        try {
            Vector<String> args = new Vector<String>();
            args.addElement(extraOffset);
            return (String)this.xmlRpcClient.execute("xmlBlaster.toXml", args);
        }
        catch (ClassCastException e) {
            this.log.error(this.ME + ".toXml", "not a valid Vector: " + e.toString());
            throw XmlBlasterException.convert(this.glob, this.ME, "toXml Class Cast Exception", e);
        }
        catch (IOException e) {
            this.log.error(this.ME + ".toXml", "IO exception: " + e.toString());
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "toXml", e);
        }
        catch (XmlRpcException e) {
            throw XmlRpcConnection.extractXmlBlasterException(this.glob, e);
        }
    }

    public static String usage() {
        String text = "\n";
        text = text + "XmlRpcConnection 'XMLRPC' options:\n";
        text = text + "   -dispatch/connection/plugin/xmlrpc/port\n";
        text = text + "                       Specify a port number where xmlBlaster XMLRPC web server listens.\n";
        text = text + "                       Default is port 8080, the port 0 switches this feature off.\n";
        text = text + "   -dispatch/connection/plugin/xmlrpc/hostname\n";
        text = text + "                       Specify a hostname where the xmlBlaster web server runs.\n";
        text = text + "                       Default is the localhost.\n";
        text = text + "   -dispatch/callback/plugin/xmlrpc/port\n";
        text = text + "                       Specify a port number for the callback web server to listen.\n";
        text = text + "                       Default is port 8081, the port 0 switches this feature off.\n";
        text = text + "   -dispatch/callback/plugin/xmlrpc/hostname\n";
        text = text + "                       Specify a hostname where the callback web server shall run.\n";
        text = text + "                       Default is the localhost (useful for multi homed hosts).\n";
        text = text + "   -plugin/xmlrpc/debug\n";
        text = text + "                       true switches on detailed XMLRPC debugging [false].\n";
        text = text + "\n";
        return text;
    }

    public static void main(String[] args) {
    }
}

