/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.client.qos;

import org.xmlBlaster.authentication.plugins.I_ClientPlugin;
import org.xmlBlaster.authentication.plugins.I_SecurityQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.SessionName;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.qos.ClientProperty;
import org.xmlBlaster.util.qos.ConnectQosData;
import org.xmlBlaster.util.qos.SessionQos;
import org.xmlBlaster.util.qos.address.Address;
import org.xmlBlaster.util.qos.address.AddressBase;
import org.xmlBlaster.util.qos.address.CallbackAddress;
import org.xmlBlaster.util.qos.storage.CbQueueProperty;
import org.xmlBlaster.util.qos.storage.ClientQueueProperty;

public final class ConnectQos {
    private String ME = "ConnectQos";
    private final Global glob;
    private final ConnectQosData connectQosData;

    public ConnectQos(Global glob) {
        this.glob = glob == null ? Global.instance() : glob;
        this.connectQosData = new ConnectQosData(this.glob);
    }

    public ConnectQos(Global glob, String userId, String passwd) throws XmlBlasterException {
        this.glob = glob == null ? Global.instance() : glob;
        this.connectQosData = new ConnectQosData(this.glob, this.glob.getConnectQosFactory(), null, null);
        this.connectQosData.loadClientPlugin(null, null, userId, passwd);
    }

    public ConnectQos(Global glob, ConnectQosData connectQosData) {
        this.glob = glob == null ? Global.instance() : glob;
        this.connectQosData = connectQosData;
    }

    public ConnectQosData getData() {
        return this.connectQosData;
    }

    public SessionQos getSessionQos() {
        return this.connectQosData.getSessionQos();
    }

    public void setSessionName(SessionName sessionName) {
        this.getSessionQos().setSessionName(sessionName);
    }

    public SessionName getSessionName() {
        return this.getSessionQos().getSessionName();
    }

    public void setSessionTimeout(long timeout) {
        this.getSessionQos().setSessionTimeout(timeout);
    }

    public void setSecretSessionId(String id) {
        this.connectQosData.getSessionQos().setSecretSessionId(id);
    }

    public void setMaxSessions(int max) {
        this.connectQosData.getSessionQos().setMaxSessions(max);
    }

    public void clearSessions(boolean clear) {
        this.connectQosData.getSessionQos().clearSessions(clear);
    }

    public final boolean clearSessions() {
        return this.connectQosData.getSessionQos().clearSessions();
    }

    public void setUserId(String loginName) throws XmlBlasterException {
        this.connectQosData.setUserId(loginName);
    }

    public String getUserId() {
        return this.connectQosData.getUserId();
    }

    public I_ClientPlugin loadClientPlugin(String type, String version, String userId, String credential) throws XmlBlasterException {
        return this.connectQosData.loadClientPlugin(type, version, userId, credential);
    }

    public I_ClientPlugin getClientPlugin() {
        return this.getClientPlugin();
    }

    public I_SecurityQos getSecurityQos() {
        return this.connectQosData.getSecurityQos();
    }

    public void setPtpAllowed(boolean ptpAllowed) {
        this.connectQosData.setPtpAllowed(ptpAllowed);
    }

    public boolean isPtpAllowed() {
        return this.connectQosData.isPtpAllowed();
    }

    public void setDuplicateUpdates(boolean duplicateUpdates) {
        this.connectQosData.setDuplicateUpdates(duplicateUpdates);
    }

    public boolean duplicateUpdates() {
        return this.connectQosData.duplicateUpdates();
    }

    public ClientQueueProperty getClientQueueProperty() {
        return this.connectQosData.getClientQueueProperty();
    }

    public void addClientQueueProperty(ClientQueueProperty clientQueueProperty) {
        this.connectQosData.addClientQueueProperty(clientQueueProperty);
    }

    public void setAddress(Address address) {
        this.connectQosData.setAddress(address);
    }

    public Address getAddress() {
        return this.connectQosData.getAddress();
    }

    public AddressBase[] getAddresses() {
        return this.connectQosData.getAddresses();
    }

    public void addCallbackAddress(CallbackAddress callback) {
        this.connectQosData.addCallbackAddress(callback);
    }

    public void setSessionCbQueueProperty(CbQueueProperty prop) {
        this.connectQosData.setSessionCbQueueProperty(prop);
    }

    public CbQueueProperty getSessionCbQueueProperty() {
        return this.connectQosData.getSessionCbQueueProperty();
    }

    public int size() {
        return this.connectQosData.size();
    }

    public String toString() {
        return this.toXml();
    }

    public String toXml() {
        return this.connectQosData.toXml();
    }

    public void addClientProperty(String key, Object value) {
        this.connectQosData.addClientProperty(key, value);
    }

    public ClientProperty getClientProperty(String key) {
        return this.connectQosData.getClientProperty(key);
    }

    public void setPersistent(boolean persistent) {
        this.connectQosData.setPersistent(persistent);
    }

    public boolean getPersistent() {
        return this.connectQosData.getPersistentProp().getValue();
    }

    public String usage() {
        String text = "\n";
        text = text + "Control my security settings\n";
        text = text + "   -security.plugin.type    The security plugin to use [simple]\n";
        text = text + "   -security.plugin.version The version of the plugin [1.0]\n";
        text = text + "\n";
        text = text + this.getSessionQos().usage();
        return text;
    }

    public void setSubjectQueueProperty(CbQueueProperty subjectQueueProperty) {
        this.connectQosData.setSubjectQueueProperty(subjectQueueProperty);
    }

    public CbQueueProperty getSubjectQueueProperty() {
        return this.connectQosData.getSubjectQueueProperty();
    }

    public static void main(String[] args) throws XmlBlasterException {
        Global glob = new Global(args);
        ConnectQos qos = new ConnectQos(new Global(args), "joe/2", "secret");
        System.out.println(qos.toXml());
        qos = new ConnectQos(null);
        System.out.println("Minimal:" + qos.toXml());
    }
}

