/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.client.qos;

import org.xmlBlaster.engine.mime.Query;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.def.MethodName;
import org.xmlBlaster.util.qos.AccessFilterQos;
import org.xmlBlaster.util.qos.ClientProperty;
import org.xmlBlaster.util.qos.HistoryQos;
import org.xmlBlaster.util.qos.QueryQosData;
import org.xmlBlaster.util.qos.QuerySpecQos;

public final class GetQos {
    private String ME = "GetQos";
    private final Global glob;
    private final QueryQosData queryQosData;

    public GetQos(Global glob) {
        this(glob, null);
    }

    public GetQos(Global glob, QueryQosData queryQosData) {
        this.glob = glob == null ? Global.instance() : glob;
        this.queryQosData = queryQosData == null ? new QueryQosData(this.glob, this.glob.getQueryQosFactory(), MethodName.GET) : queryQosData;
        this.queryQosData.setMethod(MethodName.GET);
    }

    public QueryQosData getData() {
        return this.queryQosData;
    }

    public void setWantContent(boolean content) {
        this.queryQosData.setWantContent(content);
    }

    public void addAccessFilter(AccessFilterQos filter) {
        this.queryQosData.addAccessFilter(filter);
    }

    public void addQuerySpec(QuerySpecQos querySpec) {
        this.queryQosData.addQuerySpec(querySpec);
    }

    public void setHistoryQos(HistoryQos historyQos) {
        this.queryQosData.setHistoryQos(historyQos);
    }

    public void addClientProperty(String key, Object value) {
        this.queryQosData.addClientProperty(key, value);
    }

    public ClientProperty getClientProperty(String key) {
        return this.queryQosData.getClientProperty(key);
    }

    public String toString() {
        return this.queryQosData.toXml();
    }

    public String toXml() {
        return this.queryQosData.toXml();
    }

    public static void main(String[] args) {
        Global glob = new Global(args);
        try {
            GetQos qos = new GetQos(glob);
            qos.setWantContent(false);
            qos.addAccessFilter(new AccessFilterQos(glob, "ContentLenFilter", "1.0", new Query(glob, "800")));
            qos.addAccessFilter(new AccessFilterQos(glob, "ContentLenFilter", "3.2", new Query(glob, "a<10")));
            System.out.println(qos.toXml());
        }
        catch (Throwable e) {
            System.out.println("Test failed: " + e.toString());
        }
    }
}

