/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.client.qos;

import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.SessionName;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.MethodName;
import org.xmlBlaster.util.def.PriorityEnum;
import org.xmlBlaster.util.qos.ClientProperty;
import org.xmlBlaster.util.qos.MsgQosData;
import org.xmlBlaster.util.qos.TopicProperty;
import org.xmlBlaster.util.qos.address.Destination;

public final class PublishQos {
    private String ME = "PublishQos";
    private final Global glob;
    private final MsgQosData msgQosData;

    public PublishQos(Global glob) {
        this.glob = glob == null ? Global.instance() : glob;
        this.msgQosData = new MsgQosData(this.glob, this.glob.getMsgQosFactory(), MethodName.PUBLISH);
        this.msgQosData.setMethod(MethodName.PUBLISH);
    }

    public PublishQos(Global glob, Destination destination) {
        this(glob);
        this.addDestination(destination);
    }

    public PublishQos(Global glob, boolean persistent) {
        this(glob);
        this.setPersistent(persistent);
    }

    public MsgQosData getData() {
        return this.msgQosData;
    }

    public void setSubscribable(boolean isSubscribable) {
        this.msgQosData.setSubscribable(isSubscribable);
    }

    public PriorityEnum getPriority() {
        return this.msgQosData.getPriority();
    }

    public void setPriority(PriorityEnum priority) {
        this.msgQosData.setPriority(priority);
    }

    public void setForceUpdate(boolean force) {
        this.msgQosData.setForceUpdate(force);
    }

    public void setReadonly(boolean readonly) {
        this.msgQosData.setReadonly(readonly);
    }

    public void setVolatile(boolean volatileFlag) {
        this.msgQosData.setVolatile(volatileFlag);
    }

    public boolean isVolatile() {
        return this.msgQosData.isVolatile();
    }

    public void setPersistent(boolean persistent) {
        this.msgQosData.setPersistent(persistent);
    }

    public void setLifeTime(long lifeTime) {
        this.msgQosData.setLifeTime(lifeTime);
    }

    public void setForceDestroy(boolean forceDestroy) {
        this.msgQosData.setForceDestroy(forceDestroy);
    }

    public void addDestination(Destination destination) {
        this.msgQosData.addDestination(destination);
    }

    public SessionName getSender() {
        return this.msgQosData.getSender();
    }

    public void setSender(SessionName sender) {
        this.msgQosData.setSender(sender);
    }

    public void setState(String state) {
        this.msgQosData.setState(state);
    }

    public String getState() {
        return this.msgQosData.getState();
    }

    public void setStateInfo(String stateInfo) {
        this.msgQosData.setStateInfo(stateInfo);
    }

    public String getStateInfo() {
        return this.msgQosData.getStateInfo();
    }

    public void setTopicProperty(TopicProperty topicProperty) {
        this.msgQosData.setTopicProperty(topicProperty);
    }

    public void addClientProperty(String key, Object value) {
        this.msgQosData.addClientProperty(key, value);
    }

    public void addClientProperty(String key, boolean value) {
        this.msgQosData.addClientProperty(key, value);
    }

    public void addClientProperty(String key, int value) {
        this.msgQosData.addClientProperty(key, value);
    }

    public void addClientProperty(String key, byte value) {
        this.msgQosData.addClientProperty(key, value);
    }

    public void addClientProperty(String key, long value) {
        this.msgQosData.addClientProperty(key, value);
    }

    public void addClientProperty(String key, short value) {
        this.msgQosData.addClientProperty(key, value);
    }

    public void addClientProperty(String key, double value) {
        this.msgQosData.addClientProperty(key, value);
    }

    public void addClientProperty(String key, float value) {
        this.msgQosData.addClientProperty(key, value);
    }

    public ClientProperty getClientProperty(String key) {
        return this.msgQosData.getClientProperty(key);
    }

    public String toString() {
        return this.toXml();
    }

    public String toXml() {
        return this.msgQosData.toXml();
    }

    public static void main(String[] args) throws XmlBlasterException {
        Global glob = new Global(args);
        PublishQos qos = new PublishQos(new Global(args), new Destination(new SessionName(glob, "joe")));
        qos.addDestination(new Destination(new SessionName(glob, "Tim")));
        qos.setPriority(PriorityEnum.HIGH_PRIORITY);
        qos.setPersistent(true);
        qos.setForceUpdate(true);
        qos.setReadonly(true);
        qos.setLifeTime(60000L);
        System.out.println(qos.toXml());
        qos = new PublishQos(null);
        System.out.println("Minimal '" + qos.toXml() + "'");
    }
}

