/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.client.qos;

import org.xmlBlaster.engine.mime.Query;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.def.MethodName;
import org.xmlBlaster.util.qos.AccessFilterQos;
import org.xmlBlaster.util.qos.ClientProperty;
import org.xmlBlaster.util.qos.HistoryQos;
import org.xmlBlaster.util.qos.QueryQosData;
import org.xmlBlaster.util.qos.QuerySpecQos;

public final class SubscribeQos {
    private String ME = "SubscribeQos";
    private final Global glob;
    private final QueryQosData queryQosData;

    public SubscribeQos(Global glob) {
        this(glob, null);
    }

    public SubscribeQos(Global glob, QueryQosData queryQosData) {
        this.glob = glob == null ? Global.instance() : glob;
        this.queryQosData = queryQosData == null ? new QueryQosData(this.glob, this.glob.getQueryQosFactory(), MethodName.SUBSCRIBE) : queryQosData;
        this.queryQosData.setMethod(MethodName.SUBSCRIBE);
    }

    public QueryQosData getData() {
        return this.queryQosData;
    }

    public void setSubscriptionId(String subId) {
        this.queryQosData.setSubscriptionId(subId);
    }

    public void setMultiSubscribe(boolean multiSubscribe) {
        this.queryQosData.setMultiSubscribe(multiSubscribe);
    }

    public void setWantInitialUpdate(boolean initialUpdate) {
        this.queryQosData.setWantInitialUpdate(initialUpdate);
    }

    public void setWantLocal(boolean local) {
        this.queryQosData.setWantLocal(local);
    }

    public void setWantContent(boolean content) {
        this.queryQosData.setWantContent(content);
    }

    public void setWantNotify(boolean notify) {
        this.queryQosData.setWantNotify(notify);
    }

    public void addAccessFilter(AccessFilterQos filter) {
        this.queryQosData.addAccessFilter(filter);
    }

    public void addQuerySpec(QuerySpecQos querySpec) {
        this.queryQosData.addQuerySpec(querySpec);
    }

    public void setHistoryQos(HistoryQos historyQos) {
        this.queryQosData.setHistoryQos(historyQos);
    }

    public void addClientProperty(String key, Object value) {
        this.queryQosData.addClientProperty(key, value);
    }

    public ClientProperty getClientProperty(String key) {
        return this.queryQosData.getClientProperty(key);
    }

    public void setPersistent(boolean persistent) {
        this.queryQosData.setPersistent(persistent);
    }

    public boolean getPersistent() {
        return this.queryQosData.getPersistentProp().getValue();
    }

    public String toString() {
        return this.queryQosData.toXml();
    }

    public String toXml() {
        return this.queryQosData.toXml();
    }

    public static void main(String[] args) {
        Global glob = new Global(args);
        try {
            SubscribeQos qos = new SubscribeQos(glob);
            qos.setWantContent(false);
            qos.addAccessFilter(new AccessFilterQos(glob, "ContentLenFilter", "1.0", new Query(glob, "800")));
            qos.addAccessFilter(new AccessFilterQos(glob, "ContentLenFilter", "3.2", new Query(glob, "a<10")));
            System.out.println(qos.toXml());
        }
        catch (Throwable e) {
            System.out.println("Test failed: " + e.toString());
        }
    }
}

