/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.client.queuemsg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.key.EraseKey;
import org.xmlBlaster.client.key.UnSubscribeKey;
import org.xmlBlaster.client.qos.DisconnectQos;
import org.xmlBlaster.client.qos.EraseQos;
import org.xmlBlaster.client.qos.UnSubscribeQos;
import org.xmlBlaster.client.queuemsg.MsgQueueConnectEntry;
import org.xmlBlaster.client.queuemsg.MsgQueueDisconnectEntry;
import org.xmlBlaster.client.queuemsg.MsgQueueEraseEntry;
import org.xmlBlaster.client.queuemsg.MsgQueuePublishEntry;
import org.xmlBlaster.client.queuemsg.MsgQueueSubscribeEntry;
import org.xmlBlaster.client.queuemsg.MsgQueueUnSubscribeEntry;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.Timestamp;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.def.MethodName;
import org.xmlBlaster.util.def.PriorityEnum;
import org.xmlBlaster.util.key.MsgKeyData;
import org.xmlBlaster.util.qos.ConnectQosData;
import org.xmlBlaster.util.qos.MsgQosData;
import org.xmlBlaster.util.queue.I_Entry;
import org.xmlBlaster.util.queue.I_EntryFactory;
import org.xmlBlaster.util.queue.StorageId;
import org.xmlBlaster.util.queuemsg.DummyEntry;

public class ClientEntryFactory
implements I_EntryFactory {
    private static final String ME = "ClientEntryFactory";
    private Global glob = null;
    private LogChannel log = null;

    public byte[] toBlob(I_Entry entry) throws XmlBlasterException {
        try {
            Object obj = entry.getEmbeddedObject();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream objStream = new ObjectOutputStream(baos);
            objStream.writeObject(obj);
            return baos.toByteArray();
        }
        catch (IOException ex) {
            this.log.error(ME, "toBlob: " + ex.getMessage());
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, ME, "toBlob()", ex);
        }
    }

    public I_Entry createEntry(int priority, long timestamp, String type, boolean persistent, long sizeInBytes, InputStream is, StorageId storageId) throws XmlBlasterException {
        MethodName methodName = MethodName.toMethodName(type);
        try {
            ObjectInputStream objStream = new ObjectInputStream(is);
            Object[] obj = (Object[])objStream.readObject();
            if (methodName == MethodName.PUBLISH_ONEWAY || methodName == MethodName.PUBLISH) {
                if (obj.length != 3) {
                    throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, ME, "Expected 3 entries in serialized object '" + type + "' but got " + obj.length + " for priority=" + priority + " timestamp=" + timestamp + ". Could be a version incompatibility.");
                }
                String qos = (String)obj[0];
                String key = (String)obj[1];
                byte[] content = (byte[])obj[2];
                MsgQosData msgQosData = this.glob.getMsgQosFactory().readObject(qos);
                MsgKeyData msgKeyData = this.glob.getMsgKeyFactory().readObject(key);
                MsgUnit msgUnit = new MsgUnit(msgKeyData, content, msgQosData);
                return new MsgQueuePublishEntry(this.glob, methodName, PriorityEnum.toPriorityEnum(priority), storageId, new Timestamp(timestamp), sizeInBytes, msgUnit);
            }
            if (methodName == MethodName.SUBSCRIBE) {
                if (obj.length != 2) {
                    throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, ME, "Expected 2 entries in serialized object '" + type + "' but got " + obj.length + " for priority=" + priority + " timestamp=" + timestamp + ". Could be a version incompatibility.");
                }
                String qos = (String)obj[0];
                String key = (String)obj[1];
                return new MsgQueueSubscribeEntry(this.glob, PriorityEnum.toPriorityEnum(priority), storageId, new Timestamp(timestamp), sizeInBytes, this.glob.getQueryKeyFactory().readObject(key), this.glob.getQueryQosFactory().readObject(qos));
            }
            if (methodName == MethodName.UNSUBSCRIBE) {
                if (obj.length != 2) {
                    throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, ME, "Expected 2 entries in serialized object '" + type + "' but got " + obj.length + " for priority=" + priority + " timestamp=" + timestamp + ". Could be a version incompatibility.");
                }
                String qos = (String)obj[0];
                String key = (String)obj[1];
                return new MsgQueueUnSubscribeEntry(this.glob, PriorityEnum.toPriorityEnum(priority), storageId, new Timestamp(timestamp), sizeInBytes, new UnSubscribeKey(this.glob, this.glob.getQueryKeyFactory().readObject(key)), new UnSubscribeQos(this.glob, this.glob.getQueryQosFactory().readObject(qos)));
            }
            if (methodName == MethodName.ERASE) {
                if (obj.length != 2) {
                    throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, ME, "Expected 2 entries in serialized object '" + type + "' but got " + obj.length + " for priority=" + priority + " timestamp=" + timestamp + ". Could be a version incompatibility.");
                }
                String qos = (String)obj[0];
                String key = (String)obj[1];
                return new MsgQueueEraseEntry(this.glob, PriorityEnum.toPriorityEnum(priority), storageId, new Timestamp(timestamp), sizeInBytes, new EraseKey(this.glob, this.glob.getQueryKeyFactory().readObject(key)), new EraseQos(this.glob, this.glob.getQueryQosFactory().readObject(qos)));
            }
            if (methodName == MethodName.GET) {
                throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_NOTIMPLEMENTED, ME, "Object '" + type + "' not implemented, you can't use synchronous GET requests in queues.");
            }
            if (methodName == MethodName.CONNECT) {
                if (obj.length != 1) {
                    throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, ME, "Expected 1 entries in serialized object '" + type + "' but got " + obj.length + " for priority=" + priority + " timestamp=" + timestamp + ". Could be a version incompatibility.");
                }
                String qos = (String)obj[0];
                ConnectQosData connectQosData = this.glob.getConnectQosFactory().readObject(qos);
                return new MsgQueueConnectEntry(this.glob, PriorityEnum.toPriorityEnum(priority), storageId, new Timestamp(timestamp), sizeInBytes, connectQosData);
            }
            if (methodName == MethodName.DISCONNECT) {
                if (obj.length != 1) {
                    throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, ME, "Expected 1 entries in serialized object '" + type + "' but got " + obj.length + " for priority=" + priority + " timestamp=" + timestamp + ". Could be a version incompatibility.");
                }
                String qos = (String)obj[0];
                DisconnectQos disconnectQos = new DisconnectQos(this.glob, this.glob.getDisconnectQosFactory().readObject(qos));
                return new MsgQueueDisconnectEntry(this.glob, PriorityEnum.toPriorityEnum(priority), storageId, new Timestamp(timestamp), sizeInBytes, disconnectQos);
            }
            if (methodName == MethodName.DUMMY) {
                byte[] bytes = (byte[])obj[0];
                DummyEntry entry = new DummyEntry(this.glob, PriorityEnum.toPriorityEnum(priority), new Timestamp(timestamp), storageId, bytes, persistent);
                return entry;
            }
        }
        catch (Exception ex) {
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, ME, "createEntry-" + methodName, ex);
        }
        throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_NOTIMPLEMENTED, ME, "Object '" + type + "' not implemented");
    }

    public void initialize(Global glob) {
        this.glob = glob;
        this.log = glob.getLog("queue");
        this.log.info(ME, "successfully initialized");
    }

    public void setProperties(Object userData) {
    }

    public Object getProperties() {
        return null;
    }
}

