/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.client.queuemsg;

import org.xmlBlaster.client.key.EraseKey;
import org.xmlBlaster.client.qos.EraseQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.SessionName;
import org.xmlBlaster.util.Timestamp;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.MethodName;
import org.xmlBlaster.util.def.PriorityEnum;
import org.xmlBlaster.util.queue.StorageId;
import org.xmlBlaster.util.queuemsg.MsgQueueEntry;

public final class MsgQueueEraseEntry
extends MsgQueueEntry {
    private static final String ME = "EraseQueueEntry";
    private final EraseQos eraseQos;
    private final EraseKey eraseKey;
    private SessionName receiver;
    private final long immutableSizeInBytes;

    public MsgQueueEraseEntry(Global glob, StorageId storageId, EraseKey eraseKey, EraseQos eraseQos) throws XmlBlasterException {
        super(glob, MethodName.ERASE, PriorityEnum.MIN_PRIORITY, storageId, eraseQos.getData().isPersistent());
        this.eraseQos = eraseQos;
        this.eraseKey = eraseKey;
        this.immutableSizeInBytes = 567 + this.eraseQos.getData().size() + this.eraseKey.getData().size();
    }

    public MsgQueueEraseEntry(Global glob, PriorityEnum priority, StorageId storageId, Timestamp timestamp, long sizeInBytes, EraseKey eraseKey, EraseQos eraseQos) {
        super(glob, MethodName.ERASE.toString(), priority, timestamp, storageId, eraseQos == null ? false : eraseQos.getData().isPersistent());
        this.eraseQos = eraseQos == null ? new EraseQos(glob) : eraseQos;
        this.eraseKey = eraseKey;
        this.immutableSizeInBytes = sizeInBytes;
    }

    public boolean isExpired() {
        return false;
    }

    public boolean isDestroyed() {
        return false;
    }

    public EraseQos getEraseQos() {
        return this.eraseQos;
    }

    public EraseKey getEraseKey() {
        return this.eraseKey;
    }

    public SessionName getSender() {
        return null;
    }

    public void setReceiver(SessionName receiver) {
        this.receiver = receiver;
    }

    public SessionName getReceiver() {
        return this.receiver;
    }

    public String getKeyOid() {
        return null;
    }

    public Timestamp getRcvTimestamp() {
        return null;
    }

    public Object getEmbeddedObject() {
        Object[] obj = new Object[]{this.eraseQos.toXml(), this.eraseKey.toXml()};
        return obj;
    }

    public long getSizeInBytes() {
        return this.immutableSizeInBytes;
    }

    public boolean isInternal() {
        return true;
    }

    public Object clone() {
        MsgQueueEraseEntry entry = null;
        entry = (MsgQueueEraseEntry)super.clone();
        return entry;
    }
}

