/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.client.queuemsg;

import java.util.ArrayList;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.SessionName;
import org.xmlBlaster.util.Timestamp;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.MethodName;
import org.xmlBlaster.util.def.PriorityEnum;
import org.xmlBlaster.util.key.MsgKeyData;
import org.xmlBlaster.util.qos.MsgQosData;
import org.xmlBlaster.util.queue.StorageId;
import org.xmlBlaster.util.queuemsg.MsgQueueEntry;

public final class MsgQueuePublishEntry
extends MsgQueueEntry {
    private static final String ME = "PublishQueueEntry";
    private final MsgQosData msgQosData;
    private SessionName receiver;
    private MsgUnit msgUnit;
    private final long immutableSizeInBytes;

    public MsgQueuePublishEntry(Global glob, MsgUnit msgUnit, StorageId storageId) throws XmlBlasterException {
        this(glob, msgUnit, storageId, false);
    }

    public MsgQueuePublishEntry(Global glob, MsgUnit msgUnit, StorageId storageId, boolean oneway) throws XmlBlasterException {
        super(glob, oneway ? MethodName.PUBLISH_ONEWAY : MethodName.PUBLISH, ((MsgQosData)msgUnit.getQosData()).getPriority(), storageId, ((MsgQosData)msgUnit.getQosData()).isPersistent());
        if (msgUnit == null) {
            glob.getLog("dispatch").error(ME, "Invalid constructor parameter");
            Thread.currentThread();
            Thread.dumpStack();
            throw new IllegalArgumentException("PublishQueueEntry: Invalid constructor parameter");
        }
        if (this.log.CALL) {
            this.log.call(ME, "Created: " + this.getUniqueId());
        }
        this.msgUnit = msgUnit;
        this.msgQosData = (MsgQosData)msgUnit.getQosData();
        this.immutableSizeInBytes = 660L + this.msgUnit.size();
    }

    public MsgQueuePublishEntry(Global glob, MethodName entryType, PriorityEnum priority, StorageId storageId, Timestamp publishEntryTimestamp, long sizeInBytes, MsgUnit msgUnit) {
        super(glob, entryType.toString(), ((MsgQosData)msgUnit.getQosData()).getPriority(), publishEntryTimestamp, storageId, ((MsgQosData)msgUnit.getQosData()).isPersistent());
        if (msgUnit == null) {
            glob.getLog("queue").error(ME, "Invalid constructor parameter");
            Thread.currentThread();
            Thread.dumpStack();
            throw new IllegalArgumentException("PublishQueueEntry: Invalid constructor parameter");
        }
        this.msgUnit = msgUnit;
        this.msgQosData = (MsgQosData)msgUnit.getQosData();
        this.immutableSizeInBytes = sizeInBytes;
        if (this.log.CALL) {
            this.log.call(ME, "Created from persistence: " + this.getUniqueId());
        }
    }

    public boolean isExpired() {
        return this.msgQosData.isExpired();
    }

    public boolean isDestroyed() {
        return false;
    }

    public MsgUnit getMsgUnit() {
        return this.msgUnit;
    }

    public long getSizeInBytes() {
        return this.immutableSizeInBytes;
    }

    public boolean isInternal() {
        return this.getMsgKeyData().isInternal() || this.getMsgKeyData().isPluginInternal();
    }

    public SessionName getSender() {
        return this.msgQosData.getSender();
    }

    public void setReceiver(SessionName receiver) {
        this.receiver = receiver;
    }

    public SessionName getReceiver() {
        ArrayList list;
        if (this.receiver == null && (list = this.msgQosData.getDestinations()) != null && list.size() > 0) {
            this.receiver = (SessionName)list.get(0);
            if (list.size() > 1) {
                this.log.warn(ME, "Ignoring other receivers with getReceiver()");
            }
        }
        return this.receiver;
    }

    public MsgKeyData getMsgKeyData() {
        return (MsgKeyData)this.getMsgUnit().getKeyData();
    }

    public String getKeyOid() {
        return this.getMsgKeyData().getOid();
    }

    public Object getEmbeddedObject() {
        Object[] obj = new Object[]{this.msgUnit.getQosData().toXml(), this.msgUnit.getKeyData().toXml(), this.msgUnit.getContent()};
        return obj;
    }

    public Object clone() {
        MsgQueuePublishEntry entry = null;
        entry = (MsgQueuePublishEntry)super.clone();
        return entry;
    }
}

