/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.client.reader;

import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.GetKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.GetQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;

public class GetMessage {
    private static final String ME = "GetMessage";
    private final Global glob;
    private final LogChannel log;
    private I_XmlBlasterAccess xmlBlasterConnection;

    public GetMessage(Global glob) {
        this.glob = glob;
        this.log = glob.getLog(null);
    }

    public void get() throws Exception {
        String queryType;
        String xmlKey;
        String oidString = this.glob.getProperty().get("oid", (String)null);
        String xpathString = this.glob.getProperty().get("xpath", (String)null);
        if (oidString == null && xpathString == null) {
            this.usage();
            this.log.error(ME, "Specify -oid <message-oid> or -xpath <query>");
            System.exit(1);
        }
        if (oidString != null) {
            xmlKey = oidString;
            queryType = "EXACT";
        } else {
            xmlKey = xpathString;
            queryType = "XPATH";
        }
        try {
            this.xmlBlasterConnection = this.glob.getXmlBlasterAccess();
            ConnectQos qos = new ConnectQos(this.glob);
            this.xmlBlasterConnection.connect(qos, null);
        }
        catch (Exception e) {
            this.log.error(ME, e.toString());
            e.printStackTrace();
        }
        GetKey xmlKeyWr = new GetKey(this.glob, xmlKey, queryType);
        GetQos xmlQos = new GetQos(this.glob);
        MsgUnit[] msgs = this.xmlBlasterConnection.get(xmlKeyWr.toXml(), xmlQos.toXml());
        this.log.info(ME, "Got " + msgs.length + " messages for '" + xmlKey + "'");
        int ii = 0;
        while (ii < msgs.length) {
            System.out.println("\n" + msgs[ii].toXml());
            ++ii;
        }
        this.xmlBlasterConnection.disconnect(null);
    }

    private void usage() {
        this.log.plain(ME, "----------------------------------------------------------");
        this.log.plain(ME, "java org.xmlBlaster.client.reader.GetMessage <options>");
        this.log.plain(ME, "----------------------------------------------------------");
        this.log.plain(ME, "Options:");
        this.log.plain(ME, "   -?                  Print this message.");
        this.log.plain(ME, "");
        this.log.plain(ME, "   -oid <XmlKeyOid>    The unique oid of the message");
        this.log.plain(ME, "   -xpath <XPATH>      The XPATH query");
        this.log.plain(ME, "----------------------------------------------------------");
        this.log.plain(ME, "Example:");
        this.log.plain(ME, "java org.xmlBlaster.client.reader.GetMessage -oid mySpecialMessage");
        this.log.plain(ME, "");
        this.log.plain(ME, "java org.xmlBlaster.client.reader.GetMessage -oid __cmd:?freeMem");
        this.log.plain(ME, "");
        this.log.plain(ME, "java org.xmlBlaster.client.reader.GetMessage -xpath //key/CAR");
        this.log.plain(ME, "----------------------------------------------------------");
        this.log.plain(ME, "");
    }

    public static void main(String[] args) {
        GetMessage getter;
        Global glob = new Global();
        if (glob.init(args) != 0) {
            getter = new GetMessage(glob);
            getter.usage();
            System.exit(0);
        }
        try {
            getter = new GetMessage(glob);
            getter.get();
        }
        catch (XmlBlasterException e) {
            System.out.println("ERROR: " + e.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.out.println("ERROR: " + e.toString());
        }
    }
}

