/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.client.reader;

import org.jutils.JUtilsException;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.SubscribeKey;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.SubscribeQos;
import org.xmlBlaster.client.qos.SubscribeReturnQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;

public class SubscribeMessage
implements I_Callback {
    private static final String ME = "SubscribeMessage";
    private final Global glob;
    private final LogChannel log;
    private I_XmlBlasterAccess xmlBlasterConnection;
    private String subscriptionHandle;

    public SubscribeMessage(Global glob) throws JUtilsException {
        String queryType;
        String xmlKey;
        this.glob = glob;
        this.log = glob.getLog("client");
        String oidString = glob.getProperty().get("oid", (String)null);
        String xpathString = glob.getProperty().get("xpath", (String)null);
        if (oidString == null && xpathString == null) {
            SubscribeMessage.usage();
            this.log.error(ME, "Specify the message oid or a xpath query");
            System.exit(1);
        }
        if (oidString != null) {
            xmlKey = oidString;
            queryType = "EXACT";
        } else {
            xmlKey = xpathString;
            queryType = "XPATH";
        }
        this.setUp();
        this.subscriptionHandle = this.subscribe(xmlKey, queryType);
        try {
            Thread.currentThread();
            Thread.sleep(10000000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.log.warn(ME, "Bye, time is over.");
    }

    public SubscribeMessage(Global glob, String xmlKey, String queryType) {
        this.glob = glob;
        this.log = glob.getLog("client");
        this.setUp();
        this.subscriptionHandle = this.subscribe(xmlKey, queryType);
    }

    private void setUp() {
        try {
            this.xmlBlasterConnection = this.glob.getXmlBlasterAccess();
            ConnectQos qos = new ConnectQos(this.glob);
            this.xmlBlasterConnection.connect(qos, this);
        }
        catch (Exception e) {
            this.log.error(ME, e.toString());
            e.printStackTrace();
        }
    }

    private void tearDown() {
        this.unSubscribe(this.subscriptionHandle);
        this.xmlBlasterConnection.disconnect(null);
    }

    private String subscribe(String xmlKey, String queryType) {
        try {
            SubscribeKey xmlKeyWr = new SubscribeKey(this.glob, xmlKey, queryType);
            SubscribeQos xmlQos = new SubscribeQos(this.glob);
            SubscribeReturnQos ret = this.xmlBlasterConnection.subscribe(xmlKeyWr.toXml(), xmlQos.toXml());
            String subscriptionId = ret.getSubscriptionId();
            this.log.info(ME, "Subscribed to [" + xmlKey + "] " + queryType + ", subscriptionId=" + subscriptionId);
            return subscriptionId;
        }
        catch (XmlBlasterException e) {
            this.log.error(ME, "XmlBlasterException:\n" + e.getMessage());
            System.exit(1);
            return null;
        }
    }

    private void unSubscribe(String subscriptionId) {
        if (subscriptionId == null || subscriptionId.length() < 1) {
            return;
        }
        try {
            SubscribeKey xmlKey = new SubscribeKey(this.glob, subscriptionId);
            SubscribeQos xmlQos = new SubscribeQos(this.glob);
            this.xmlBlasterConnection.unSubscribe(xmlKey.toXml(), xmlQos.toXml());
            if (this.log.TRACE) {
                this.log.trace(ME, "Unsubscribed from " + subscriptionId + " (GML and XML Packages)");
            }
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "unSubscribe(" + subscriptionId + ") failed: XmlBlasterException: " + e.getMessage());
        }
    }

    public String update(String loginName, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        System.out.println("");
        System.out.println("============= START " + updateKey.getOid() + " =======================");
        this.log.info(ME, "Receiving update of a message ...");
        System.out.println("<xmlBlaster>");
        System.out.println(updateKey.toXml());
        System.out.println("");
        System.out.println("<content>");
        System.out.println(new String(content));
        System.out.println("</content>");
        System.out.println(updateQos.toXml());
        System.out.println("</xmlBlaster>");
        System.out.println("============= END " + updateKey.getOid() + " =========================");
        System.out.println("");
        return "<qos><state id='OK'/></qos>";
    }

    private static void usage() {
        System.out.println(Global.instance().usage());
        System.out.println("----------------------------------------------------------");
        System.out.println("java org.xmlBlaster.client.reader.SubscribeMessage <options>");
        System.out.println("----------------------------------------------------------");
        System.out.println("Options:");
        System.out.println("   -?                  Print this message.");
        System.out.println("");
        System.out.println("   -oid <XmlKeyOid>    The unique oid of the message");
        System.out.println("   -xpath <XPATH>      The XPATH query");
        System.out.println("----------------------------------------------------------");
        System.out.println("Example:");
        System.out.println("java org.xmlBlaster.client.reader.SubscribeMessage -oid mySpecialMessage");
        System.out.println("");
        System.out.println("java org.xmlBlaster.client.reader.SubscribeMessage -xpath //key/CAR");
        System.out.println("----------------------------------------------------------");
        System.out.println("");
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            SubscribeMessage.usage();
            System.exit(1);
        }
        try {
            SubscribeMessage publishFile = new SubscribeMessage(glob);
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.err.println("SubscribeMessage: " + e.toString());
        }
    }
}

