/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.client.script;

import java.io.IOException;
import java.io.OutputStream;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;

public class StreamCallback
implements I_Callback {
    private final String ME = "StreamCallback";
    private Global global;
    private LogChannel log;
    private OutputStream out;
    private String offset = "";

    public StreamCallback(Global global, OutputStream out, String offset) {
        this.global = global;
        this.log = this.global.getLog("script");
        this.out = out;
        if (offset != null) {
            this.offset = offset;
        }
    }

    protected void writeContent(byte[] content, StringBuffer buf) {
        buf.append(this.offset).append("   ").append("<content>");
        buf.append("<![CDATA\u00a0[").append(new String(content)).append("]]>");
        buf.append("</content>");
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) throws XmlBlasterException {
        if (this.out == null) {
            return "OK";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("\n<!-- ___________________________________ update ________________________________ -->");
        buf.append("\n").append(this.offset).append("<update>\n");
        buf.append(this.offset).append("<sessionId>").append(cbSessionId).append("</sessionId>");
        buf.append(updateKey.toXml(this.offset + "  ")).append("\n");
        this.writeContent(content, buf);
        buf.append(updateQos.toXml(this.offset + "  ")).append("\n");
        buf.append(this.offset).append("</update>\n");
        OutputStream outputStream = this.out;
        synchronized (outputStream) {
            try {
                this.out.write(buf.toString().getBytes());
            }
            catch (IOException ex) {
                throw new XmlBlasterException(updateKey.getGlobal(), ErrorCode.USER_CLIENTCODE, "StreamCallback.update");
            }
        }
        return "OK";
    }
}

