/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.client.script;

import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.jutils.log.LogChannel;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.ConnectReturnQos;
import org.xmlBlaster.client.qos.DisconnectQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.PublishReturnQos;
import org.xmlBlaster.client.qos.SubscribeReturnQos;
import org.xmlBlaster.client.qos.UnSubscribeReturnQos;
import org.xmlBlaster.client.script.StreamCallback;
import org.xmlBlaster.util.EncodableData;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.SaxHandlerBase;
import org.xmlBlaster.util.StopParseException;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.qos.ConnectQosData;
import org.xmlBlaster.util.qos.ConnectQosSaxFactory;
import org.xmlBlaster.util.qos.DisconnectQosData;
import org.xmlBlaster.util.qos.DisconnectQosSaxFactory;

public class XmlScriptInterpreter
extends SaxHandlerBase {
    private final String ME = "XmlScriptInterpreter";
    private final LogChannel log;
    private I_XmlBlasterAccess access;
    private HashSet commandsToFire = new HashSet();
    private StringBuffer qos = new StringBuffer();
    private StringBuffer key = new StringBuffer();
    private StringBuffer content = new StringBuffer();
    private EncodableData contentData;
    private int inQos;
    private int inKey;
    private int inContent;
    private String link;
    private HashMap attachments;
    private ArrayList messageList;
    private StringBuffer response;
    private final Global glob;
    private I_Callback callback;
    private OutputStream out;
    private String currentCommand;
    private ConnectQosSaxFactory connectQosFactory;
    private DisconnectQosSaxFactory disconnectQosFactory;

    public XmlScriptInterpreter(Global glob, I_XmlBlasterAccess access, I_Callback callback, HashMap attachments, OutputStream out) {
        this.setUseLexicalHandler(true);
        this.glob = glob;
        this.log = glob.getLog("script");
        this.commandsToFire.add("get");
        this.commandsToFire.add("connect");
        this.commandsToFire.add("subscribe");
        this.commandsToFire.add("unSubscribe");
        this.commandsToFire.add("publish");
        this.commandsToFire.add("publishArr");
        this.commandsToFire.add("erase");
        this.commandsToFire.add("disconnect");
        this.access = access;
        this.callback = callback;
        this.attachments = attachments;
        this.out = out;
        this.connectQosFactory = new ConnectQosSaxFactory(this.glob);
        this.disconnectQosFactory = new DisconnectQosSaxFactory(this.glob);
    }

    public XmlScriptInterpreter(Global glob, I_XmlBlasterAccess access, OutputStream cbStream, OutputStream responseStream, HashMap attachments) {
        this(glob, access, new StreamCallback(glob, cbStream, "  "), attachments, responseStream);
    }

    public XmlScriptInterpreter(Global glob, OutputStream out) {
        this(glob, glob.getXmlBlasterAccess(), out, out, null);
    }

    protected String writeElementStart(String qName, Attributes attr) {
        StringBuffer buf = new StringBuffer("<");
        buf.append(qName);
        int nmax = attr.getLength();
        int i = 0;
        while (i < nmax) {
            String name = attr.getQName(i);
            String value = attr.getValue(i);
            buf.append(' ');
            buf.append(name);
            buf.append("='");
            buf.append(value);
            buf.append('\'');
            ++i;
        }
        buf.append('>');
        return buf.toString();
    }

    public synchronized void parse(Reader in) throws XmlBlasterException {
        this.inQos = 0;
        this.inKey = 0;
        this.inContent = 0;
        try {
            this.out.flush();
        }
        catch (IOException ex) {
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, "XmlScriptInterpreter.parse: could not flush the output stream: original message: '" + ex.getMessage() + "'");
        }
        this.init(new InputSource(in));
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inQos > 0) {
            this.qos.append(ch, start, length);
        } else if (this.inKey > 0) {
            this.key.append(ch, start, length);
        } else if (this.inContent > 0) {
            this.content.append(ch, start, length);
        } else {
            super.characters(ch, start, length);
        }
    }

    private void incrementInElementCounters(String qName) {
        if ("qos".equals(qName) && this.inQos > 0) {
            ++this.inQos;
        } else if ("key".equals(qName) && this.inKey > 0) {
            ++this.inKey;
        } else if ("content".equals(qName) && this.inContent > 0) {
            ++this.inContent;
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
        this.checkNestedTags();
        if (this.inQos > 0) {
            this.qos.append(this.writeElementStart(qName, atts));
            this.incrementInElementCounters(qName);
            return;
        }
        if (this.inKey > 0) {
            this.key.append(this.writeElementStart(qName, atts));
            this.incrementInElementCounters(qName);
            return;
        }
        if (this.inContent > 0) {
            this.content.append(this.writeElementStart(qName, atts));
            this.incrementInElementCounters(qName);
            return;
        }
        if (this.commandsToFire.contains(qName)) {
            this.character = new StringBuffer();
            this.character.append(this.writeElementStart(qName, atts));
            this.currentCommand = qName;
            if ("publishArr".equals(qName)) {
                this.messageList = new ArrayList();
            }
            return;
        }
        if ("key".equals(qName)) {
            ++this.inKey;
            this.key = new StringBuffer();
            this.key.append(this.writeElementStart(qName, atts));
            return;
        }
        if ("qos".equals(qName)) {
            ++this.inQos;
            this.qos = new StringBuffer();
            this.qos.append(this.writeElementStart(qName, atts));
            return;
        }
        if ("content".equals(qName)) {
            ++this.inContent;
            this.link = null;
            this.content = new StringBuffer();
            String type = atts.getValue("type");
            String encoding = atts.getValue("encoding");
            this.contentData = new EncodableData(this.glob, "content", null, type, encoding);
            String tmp = atts.getValue("link");
            if (tmp != null && tmp.length() > 0) {
                this.link = tmp;
            }
            return;
        }
        if ("wait".equals(qName)) {
            String tmp = atts.getValue("delay");
            if (tmp != null) {
                try {
                    long delay = Long.parseLong(tmp);
                    Thread.sleep(delay);
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            return;
        }
        if ("xmlBlaster".equals(qName)) {
            String id = atts.getValue("id");
            this.response = new StringBuffer("<xmlBlasterResponse");
            if (id != null) {
                this.response.append(" id='").append(id).append("'");
            }
            this.response.append(">\n");
            return;
        }
    }

    private void appendEndOfElement(StringBuffer buf, String qName) {
        buf.append("</");
        buf.append(qName);
        buf.append('>');
    }

    private void fireCommand(String qName) throws XmlBlasterException {
        if ("connect".equals(qName)) {
            if (this.log.TRACE) {
                this.log.trace("XmlScriptInterpreter", "appendEndOfElement connect: " + this.qos.toString());
            }
            String ret = null;
            if (this.qos.length() < 1) {
                ConnectQos connectQos = new ConnectQos(this.glob);
                ret = this.access.connect(connectQos, this.callback).toXml();
            } else {
                ConnectQosData data = this.connectQosFactory.readObject(this.qos.toString());
                ConnectReturnQos tmp = this.access.connect(new ConnectQos(this.glob, data), this.callback);
                ret = tmp != null ? tmp.toXml("  ") : "";
            }
            this.response.append("\n<!-- __________________________________  connect ________________________________ -->");
            this.response.append("\n<connect>");
            this.response.append(ret);
            this.response.append("\n</connect>\n");
            this.flushResponse();
            return;
        }
        if ("disconnect".equals(qName)) {
            if (this.log.TRACE) {
                this.log.trace("XmlScriptInterpreter", "appendEndOfElement disconnect: " + this.qos.toString());
            }
            if (this.qos.length() < 1) {
                this.qos.append("<qos />");
            }
            DisconnectQosData disconnectQosData = this.disconnectQosFactory.readObject(this.qos.toString());
            boolean ret = this.access.disconnect(new DisconnectQos(this.glob, disconnectQosData));
            this.response.append("\n<!-- __________________________________  disconnect _____________________________ -->");
            this.response.append("\n<disconnect>").append(ret).append("</disconnect>\n");
            this.flushResponse();
            return;
        }
        if ("publish".equals(qName)) {
            if (this.qos.length() < 1) {
                this.qos.append("<qos />");
            }
            if (this.key.length() < 1) {
                this.key.append("<key />");
            }
            MsgUnit msgUnit = this.buildMsgUnit();
            if (this.log.TRACE) {
                this.log.trace("XmlScriptInterpreter", "appendEndOfElement publish: " + msgUnit.toXml());
            }
            PublishReturnQos ret = this.access.publish(msgUnit);
            this.response.append("\n<!-- __________________________________  publish ________________________________ -->");
            this.response.append("\n<publish>");
            if (ret != null) {
                this.response.append(ret.toXml("  "));
            }
            this.response.append("\n</publish>\n");
            this.flushResponse();
            return;
        }
        if ("publishArr".equals(qName)) {
            if (this.qos.length() < 1) {
                this.qos.append("<qos />");
            }
            if (this.key.length() < 1) {
                this.key.append("<key />");
            }
            int size = this.messageList.size();
            MsgUnit[] msgs = new MsgUnit[size];
            int i = 0;
            while (i < size) {
                if (this.log.TRACE) {
                    this.log.trace("XmlScriptInterpreter", "appendEndOfElement publishArr: " + msgs[i].toXml());
                }
                msgs[i] = (MsgUnit)this.messageList.get(i);
                ++i;
            }
            PublishReturnQos[] ret = this.access.publishArr(msgs);
            this.response.append("\n<!-- __________________________________  publishArr _____________________________ -->");
            this.response.append("\n<publishArr>");
            if (ret != null) {
                int i2 = 0;
                while (i2 < ret.length) {
                    this.response.append("\n  <message>");
                    this.response.append(ret[i2].toXml("    "));
                    this.response.append("\n  </message>\n");
                    ++i2;
                }
            }
            this.response.append("\n</publishArr>\n");
            this.flushResponse();
            return;
        }
        if ("subscribe".equals(qName)) {
            if (this.log.TRACE) {
                this.log.trace("XmlScriptInterpreter", "appendEndOfElement subscribe: " + this.key.toString() + " " + this.qos.toString());
            }
            if (this.qos.length() < 1) {
                this.qos.append("<qos />");
            }
            if (this.key.length() < 1) {
                this.key.append("<key />");
            }
            SubscribeReturnQos ret = this.access.subscribe(this.key.toString(), this.qos.toString());
            this.response.append("\n<!-- __________________________________  subscribe ______________________________ -->");
            this.response.append("\n<subscribe>");
            if (ret != null) {
                this.response.append(ret.toXml("    "));
            }
            this.response.append("\n</subscribe>\n");
            this.flushResponse();
            return;
        }
        if ("unSubscribe".equals(qName)) {
            if (this.log.TRACE) {
                this.log.trace("XmlScriptInterpreter", "appendEndOfElement unSubscribe: " + this.key.toString() + " " + this.qos.toString());
            }
            if (this.qos.length() < 1) {
                this.qos.append("<qos />");
            }
            if (this.key.length() < 1) {
                this.key.append("<key />");
            }
            UnSubscribeReturnQos[] ret = this.access.unSubscribe(this.key.toString(), this.qos.toString());
            this.response.append("\n<!-- __________________________________  unSubscribe ____________________________ -->");
            this.response.append("\n<unSubscribe>");
            if (ret != null) {
                int i = 0;
                while (i < ret.length) {
                    this.response.append(ret[i].toXml("  "));
                    ++i;
                }
            }
            this.response.append("\n</unSubscribe>\n");
            this.flushResponse();
            return;
        }
        if ("erase".equals(qName)) {
            if (this.log.TRACE) {
                this.log.trace("XmlScriptInterpreter", "appendEndOfElement erase: " + this.key.toString() + " " + this.qos.toString());
            }
            if (this.qos.length() < 1) {
                this.qos.append("<qos />");
            }
            if (this.key.length() < 1) {
                this.key.append("<key />");
            }
            EraseReturnQos[] ret = this.access.erase(this.key.toString(), this.qos.toString());
            this.response.append("\n<!-- __________________________________  erase __________________________________ -->");
            this.response.append("\n<erase>");
            if (ret != null) {
                int i = 0;
                while (i < ret.length) {
                    this.response.append(ret[i].toXml("  "));
                    ++i;
                }
            }
            this.response.append("\n</erase>\n");
            this.flushResponse();
            return;
        }
        if ("get".equals(qName)) {
            if (this.log.TRACE) {
                this.log.trace("XmlScriptInterpreter", "appendEndOfElement get: " + this.key.toString() + " " + this.qos.toString());
            }
            if (this.qos.length() < 1) {
                this.qos.append("<qos />");
            }
            if (this.key.length() < 1) {
                this.key.append("<key />");
            }
            MsgUnit[] ret = this.access.get(this.key.toString(), this.qos.toString());
            this.response.append("\n<!-- __________________________________  get ____________________________________ -->");
            this.response.append("\n<get>");
            if (ret != null) {
                int i = 0;
                while (i < ret.length) {
                    this.response.append("\n  <message>");
                    this.response.append(ret[i].toXml("    "));
                    this.response.append("\n  </message>");
                    ++i;
                }
            }
            this.response.append("\n</get>\n");
            this.flushResponse();
            return;
        }
        if ("qos".equals(qName)) {
            --this.inQos;
        }
        if ("key".equals(qName)) {
            --this.inKey;
        }
        if ("content".equals(qName)) {
            --this.inContent;
        }
    }

    private void flushResponse() throws XmlBlasterException {
        try {
            try {
                if (this.out != null) {
                    OutputStream outputStream = this.out;
                    synchronized (outputStream) {
                        this.out.write(this.response.toString().getBytes());
                    }
                }
                Object var4_4 = null;
                this.response = new StringBuffer();
            }
            catch (IOException ex) {
                this.log.error("XmlScriptInterpreter", "flushResponse exception occured " + ex.getMessage());
                throw XmlBlasterException.convert(this.glob, "XmlScriptInterpreter", ErrorCode.INTERNAL_UNKNOWN.toString(), ex);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.response = new StringBuffer();
            throw throwable;
        }
    }

    private MsgUnit buildMsgUnit() throws XmlBlasterException {
        byte[] currentContent = null;
        if (this.link == null) {
            currentContent = this.contentData.getBlobValue();
        } else if (this.attachments != null && this.attachments.containsKey(this.link)) {
            Object obj = this.attachments.get(this.link);
            if (obj instanceof String) {
                this.contentData.setValueRaw((String)obj);
                currentContent = this.contentData.getBlobValue();
            } else {
                currentContent = (byte[])obj;
            }
        } else {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, "XmlScriptInterpreter", "buildMsgUnit: the attachment '" + this.link + "' was not found");
        }
        MsgUnit msgUnit = new MsgUnit(this.key.toString(), currentContent, this.qos.toString());
        return msgUnit;
    }

    private void checkNestedTags() {
        int sum = 0;
        if (this.inContent > 0) {
            ++sum;
        }
        if (this.inKey > 0) {
            ++sum;
        }
        if (this.inQos > 0) {
            ++sum;
        }
        if (sum > 1) {
            Thread.dumpStack();
            this.log.error("XmlScriptInterpreter", "check: there is an internal error!! Mismatch with the nested tags ...");
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        try {
            this.checkNestedTags();
            if (this.inQos > 0) {
                this.appendEndOfElement(this.qos, qName);
                if ("qos".equals(qName) && this.inQos > 0) {
                    --this.inQos;
                }
                return;
            }
            if (this.inKey > 0) {
                this.appendEndOfElement(this.key, qName);
                if ("key".equals(qName) && this.inKey > 0) {
                    --this.inKey;
                }
                return;
            }
            if ("content".equals(qName)) {
                if (this.inContent > 0) {
                    --this.inContent;
                }
                if (this.inContent > 0) {
                    this.appendEndOfElement(this.content, qName);
                }
                this.contentData.setValueRaw(this.content.toString());
                return;
            }
            if ("xmlBlaster".equals(qName)) {
                this.response = new StringBuffer("\n</xmlBlasterResponse>\n");
                this.flushResponse();
            }
            if ("message".equals(qName)) {
                try {
                    this.messageList.add(this.buildMsgUnit());
                }
                catch (XmlBlasterException e) {
                    this.log.error("XmlScriptInterpreter", "endElement '" + qName + "' exception occurred when trying to build message unit: " + e.getMessage());
                }
                return;
            }
            if (this.inContent > 0) {
                this.appendEndOfElement(this.content, qName);
            }
            if (this.commandsToFire.contains(qName)) {
                this.appendEndOfElement(this.character, qName);
                this.fireCommand(qName);
                return;
            }
        }
        catch (XmlBlasterException e) {
            if (this.log.TRACE) {
                this.log.trace("XmlScriptInterpreter", "endElement exception occured " + e.getMessage());
            }
            throw new StopParseException(e);
        }
    }

    public void startCDATA() {
        if (this.log.CALL) {
            this.log.call("XmlScriptInterpreter", "startCDATA");
        }
        if (this.inQos > 0) {
            this.qos.append("<![CDATA[");
        } else if (this.inKey > 0) {
            this.key.append("<![CDATA[");
        } else if (this.inContent > 0) {
            this.content.append("<![CDATA[");
        } else {
            this.character.append("<![CDATA[");
        }
    }

    public void endCDATA() {
        if (this.log.CALL) {
            String txt = "";
            if (this.qos != null) {
                this.qos.toString();
            }
            this.log.call("XmlScriptInterpreter", "endCDATA: " + txt);
        }
        if (this.inQos > 0) {
            this.qos.append("]]>");
        } else if (this.inKey > 0) {
            this.key.append("]]>");
        } else if (this.inContent > 0) {
            this.content.append("]]>");
        } else {
            this.character.append("]]>");
        }
    }

    public static void main(String[] args) {
        String request = "<xmlBlaster>\n  <connect>    <securityPlugin type='aaa' version='bbb'>\n      <user>michele</user>\n      <passwd><![CDATA[secret    ]]></passwd>\n    </securityPlugin>\n  </connect>\n  <publish>\n    <key>xxxx</key>\n    <content xlink='sss'/>\n    <qos></qos>\n  </publish>\n  <subscribe/>\n  <disconnect/>\n</xmlBlaster>";
        try {
            Global glob = new Global();
            String[] tmp = new String[args.length - 2];
            int i = 0;
            while (i < tmp.length) {
                tmp[i] = args[i + 2];
                ++i;
            }
            glob.init(tmp);
            FileOutputStream out = new FileOutputStream(args[1]);
            XmlScriptInterpreter interpreter = new XmlScriptInterpreter(glob, out);
            FileReader in = new FileReader(args[0]);
            interpreter.parse(in);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

