/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine;

import org.jutils.log.LogChannel;
import org.xmlBlaster.engine.Global;
import org.xmlBlaster.engine.runlevel.I_RunlevelListener;
import org.xmlBlaster.engine.runlevel.RunlevelManager;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.SessionName;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.def.MethodName;

public final class AvailabilityChecker
implements I_RunlevelListener {
    private String ME = "AvailabilityChecker";
    private final Global glob;
    private final LogChannel log;
    private RunlevelManager runlevelManager;
    private boolean startup = true;

    public AvailabilityChecker(Global glob) {
        this.glob = glob;
        this.log = glob.getLog("core");
        this.runlevelManager = glob.getRunlevelManager();
        this.runlevelManager.addRunlevelListener(this);
    }

    public void shutdown() {
        this.glob.getRunlevelManager().removeRunlevelListener(this);
    }

    public String getStatus(String qos) {
        if (this.runlevelManager.getCurrentRunlevel() > 6) {
            return "OK";
        }
        return RunlevelManager.toRunlevelStr(this.runlevelManager.getCurrentRunlevel());
    }

    public void checkServerIsReady(SessionName sessionName, MsgUnit msgUnit, MethodName action) throws XmlBlasterException {
        boolean isInternalUser;
        if (this.runlevelManager.getCurrentRunlevel() > 6) {
            return;
        }
        boolean bl = isInternalUser = sessionName != null && sessionName.isInternalLoginName();
        if (isInternalUser) {
            return;
        }
        if (!this.startup && action == MethodName.DISCONNECT && this.runlevelManager.getCurrentRunlevel() >= 3) {
            return;
        }
        if (this.startup && this.runlevelManager.getCurrentRunlevel() < 3) {
            return;
        }
        String post = sessionName != null ? " from '" + sessionName.getAbsoluteName() + "'" : "";
        String str = "The server is in run level " + RunlevelManager.toRunlevelStr(this.runlevelManager.getCurrentRunlevel()) + " and not ready for " + action.toString() + post;
        if (this.log.TRACE) {
            this.log.trace(this.ME, str);
        }
        throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION_SERVERDENY, this.ME, str);
    }

    public XmlBlasterException checkException(MethodName action, Throwable origEx) {
        if (this.runlevelManager.getCurrentRunlevel() <= 6) {
            XmlBlasterException e;
            if (origEx instanceof XmlBlasterException && (e = (XmlBlasterException)origEx).isCommunication()) {
                return e;
            }
            this.log.warn(this.ME, "DEBUG ONLY: The server is in run level " + RunlevelManager.toRunlevelStr(this.runlevelManager.getCurrentRunlevel()) + " and not ready for " + action.toString() + "(): " + origEx.toString());
            return new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION_SERVERDENY, this.ME, "The server is in run level " + RunlevelManager.toRunlevelStr(this.runlevelManager.getCurrentRunlevel()) + " and not ready for " + action.toString() + "()", origEx);
        }
        if (origEx instanceof XmlBlasterException) {
            XmlBlasterException e = (XmlBlasterException)origEx;
            if (e.isInternal()) {
                this.log.error(this.ME, action.toString() + "() failed: " + e.getMessage());
            }
            return e;
        }
        this.log.error(this.ME, "Internal problem in " + action.toString() + "(): " + origEx.getMessage());
        ErrorCode code = ErrorCode.INTERNAL_UNKNOWN;
        if (action == MethodName.PUBLISH) {
            code = ErrorCode.INTERNAL_PUBLISH;
        } else if (action == MethodName.PUBLISH_ARR) {
            code = ErrorCode.INTERNAL_PUBLISH_ARR;
        } else if (action == MethodName.SUBSCRIBE) {
            code = ErrorCode.INTERNAL_SUBSCRIBE;
        } else if (action == MethodName.UNSUBSCRIBE) {
            code = ErrorCode.INTERNAL_UNSUBSCRIBE;
        } else if (action == MethodName.ERASE) {
            code = ErrorCode.INTERNAL_ERASE;
        }
        origEx.printStackTrace();
        return XmlBlasterException.convert(this.glob, code, this.ME, action.toString(), origEx);
    }

    public String getName() {
        return this.ME;
    }

    public void runlevelChange(int from, int to, boolean force) throws XmlBlasterException {
        this.startup = to > from;
    }
}

