/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.jutils.log.LogChannel;
import org.xmlBlaster.authentication.Authenticate;
import org.xmlBlaster.authentication.ClientEvent;
import org.xmlBlaster.authentication.I_ClientListener;
import org.xmlBlaster.authentication.SessionInfo;
import org.xmlBlaster.engine.Global;
import org.xmlBlaster.engine.I_SubscriptionListener;
import org.xmlBlaster.engine.RequestBroker;
import org.xmlBlaster.engine.SubscriptionEvent;
import org.xmlBlaster.engine.SubscriptionInfo;
import org.xmlBlaster.engine.TopicHandler;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.key.KeyData;

public class ClientSubscriptions
implements I_ClientListener,
I_SubscriptionListener {
    private final String ME;
    private final Global glob;
    private final RequestBroker requestBroker;
    private final LogChannel log;
    private final Map clientSubscriptionMap = Collections.synchronizedMap(new HashMap());
    private final Set querySubscribeRequestsSet = Collections.synchronizedSet(new HashSet());

    ClientSubscriptions(Global glob, RequestBroker requestBroker, Authenticate authenticate) throws XmlBlasterException {
        this.glob = glob;
        this.requestBroker = requestBroker;
        this.ME = "ClientSubscriptions" + this.glob.getLogPrefixDashed();
        this.log = requestBroker.getGlobal().getLog("core");
        requestBroker.addSubscriptionListener(this);
        authenticate.addClientListener(this);
    }

    public Set getQuerySubscribeRequestsSet() {
        return this.querySubscribeRequestsSet;
    }

    public SubscriptionInfo getSubscription(SessionInfo sessionInfo, String subscriptionInfoUniqueKey) throws XmlBlasterException {
        Map subMap;
        Map map = this.clientSubscriptionMap;
        synchronized (map) {
            Object obj = this.clientSubscriptionMap.get(sessionInfo.getSessionName().getRelativeName());
            if (obj == null) {
                SubscriptionInfo subscriptionInfo = null;
                return subscriptionInfo;
            }
            subMap = (Map)obj;
        }
        SubscriptionInfo subs = (SubscriptionInfo)subMap.get(subscriptionInfoUniqueKey);
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Looking for subscriptionId=" + subscriptionInfoUniqueKey + " found " + subs);
        }
        return subs;
    }

    public SubscriptionInfo getSubscription(String subscriptionInfoUniqueKey) {
        Map map = this.clientSubscriptionMap;
        synchronized (map) {
            Iterator iterator = this.clientSubscriptionMap.values().iterator();
            while (iterator.hasNext()) {
                Map subMap;
                Map map2 = subMap = (Map)iterator.next();
                synchronized (map2) {
                    Object obj = subMap.get(subscriptionInfoUniqueKey);
                    if (obj != null) {
                        SubscriptionInfo subscriptionInfo = (SubscriptionInfo)obj;
                        return subscriptionInfo;
                    }
                }
            }
        }
        if (this.log.TRACE) {
            this.log.trace(this.ME, "subscriptionId=" + subscriptionInfoUniqueKey + " not found");
        }
        return null;
    }

    public int getNumSubscriptions() {
        int num = 0;
        Map map = this.clientSubscriptionMap;
        synchronized (map) {
            Iterator iterator = this.clientSubscriptionMap.values().iterator();
            while (iterator.hasNext()) {
                Map subMap;
                Map map2 = subMap = (Map)iterator.next();
                synchronized (map2) {
                    num += subMap.size();
                }
            }
        }
        return num;
    }

    public String getSubscriptionList() {
        StringBuffer sb = new StringBuffer(this.getNumSubscriptions() * 20);
        Map map = this.clientSubscriptionMap;
        synchronized (map) {
            Iterator iterator = this.clientSubscriptionMap.values().iterator();
            while (iterator.hasNext()) {
                Map subMap;
                Map map2 = subMap = (Map)iterator.next();
                synchronized (map2) {
                    Iterator iterator2 = subMap.values().iterator();
                    while (iterator2.hasNext()) {
                        SubscriptionInfo sub = (SubscriptionInfo)iterator2.next();
                        if (sb.length() > 0) {
                            sb.append(",");
                        }
                        sb.append(sub.getSubscriptionId());
                    }
                }
            }
        }
        return sb.toString();
    }

    public SubscriptionInfo[] getSubscriptions(SessionInfo sessionInfo) {
        Map map = this.clientSubscriptionMap;
        synchronized (map) {
            Object obj = this.clientSubscriptionMap.get(sessionInfo.getSessionName().getRelativeName());
            if (obj == null) {
                SubscriptionInfo[] subscriptionInfoArray = new SubscriptionInfo[]{};
                return subscriptionInfoArray;
            }
            Collection c = ((Map)obj).values();
            SubscriptionInfo[] subscriptionInfoArray = c.toArray(new SubscriptionInfo[c.size()]);
            return subscriptionInfoArray;
        }
    }

    public Vector getSubscriptionByOid(SessionInfo sessionInfo, String keyOid, boolean exactOnly) throws XmlBlasterException {
        Map subMap;
        if (keyOid == null || sessionInfo == null) {
            return null;
        }
        Map map = this.clientSubscriptionMap;
        synchronized (map) {
            Object obj = this.clientSubscriptionMap.get(sessionInfo.getSessionName().getRelativeName());
            if (obj == null) {
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Session '" + sessionInfo.getId() + "' is unknown, there was no subscription of this session yet. Oid '" + keyOid + "' is not existing");
                }
                Vector vector = null;
                return vector;
            }
            subMap = (Map)obj;
        }
        Vector<SubscriptionInfo> vec = null;
        Map map2 = subMap;
        synchronized (map2) {
            Iterator iterator = subMap.values().iterator();
            while (iterator.hasNext()) {
                SubscriptionInfo sub = (SubscriptionInfo)iterator.next();
                if (exactOnly && sub.getKeyData().isQuery()) {
                    if (!this.log.TRACE) continue;
                    this.log.trace(this.ME, "Ignoring subscription " + sub.getSubscriptionId() + " for session '" + sessionInfo.getId() + "' for message '" + keyOid + "'");
                    continue;
                }
                if (!keyOid.equals(sub.getKeyOid())) continue;
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Found subscription " + sub.getSubscriptionId() + " for session '" + sessionInfo.getId() + "' for message '" + keyOid + "'");
                }
                if (vec == null) {
                    vec = new Vector<SubscriptionInfo>();
                }
                vec.addElement(sub);
            }
        }
        return vec;
    }

    public Vector getSubscriptionByOid(String keyOid, boolean exactOnly) throws XmlBlasterException {
        Vector<SubscriptionInfo> vec = null;
        Map map = this.clientSubscriptionMap;
        synchronized (map) {
            Iterator iterator = this.clientSubscriptionMap.values().iterator();
            while (iterator.hasNext()) {
                Map subMap;
                Map map2 = subMap = (Map)iterator.next();
                synchronized (map2) {
                    Iterator iterator2 = subMap.values().iterator();
                    while (iterator2.hasNext()) {
                        SubscriptionInfo sub = (SubscriptionInfo)iterator2.next();
                        if (exactOnly && sub.getKeyData().isQuery()) {
                            if (!this.log.TRACE) continue;
                            this.log.trace(this.ME, "Ignoring subscription " + sub.getSubscriptionId() + " for message '" + keyOid + "'");
                            continue;
                        }
                        if (!keyOid.equals(sub.getKeyOid())) continue;
                        if (this.log.TRACE) {
                            this.log.trace(this.ME, "Found subscription " + sub.getSubscriptionId() + " for message '" + keyOid + "'");
                        }
                        if (vec == null) {
                            vec = new Vector<SubscriptionInfo>();
                        }
                        vec.addElement(sub);
                    }
                }
            }
        }
        return vec;
    }

    public void sessionAdded(ClientEvent e) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Login event for client " + e.getSessionInfo().toString() + ", nothing to do");
        }
    }

    public void sessionPreRemoved(ClientEvent e) throws XmlBlasterException {
    }

    public void sessionRemoved(ClientEvent e) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "START-logout()");
        }
        SessionInfo sessionInfo = e.getSessionInfo();
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Logout event for client " + sessionInfo.toString() + ", removing entries");
        }
        try {
            this.removeFromClientSubscriptionMap(sessionInfo, null);
        }
        catch (XmlBlasterException e1) {
            // empty catch block
        }
        try {
            this.removeFromQuerySubscribeRequestsSet(sessionInfo, null);
        }
        catch (XmlBlasterException xmlBlasterException) {
            // empty catch block
        }
    }

    public void subjectAdded(ClientEvent e) throws XmlBlasterException {
        this.log.warn(this.ME, "Ignoring SubjectInfo added event for client " + e.getSubjectInfo().toString());
    }

    public void subjectRemoved(ClientEvent e) throws XmlBlasterException {
        this.log.warn(this.ME, "Ignoring SubjectInfo removed event for client " + e.getSubjectInfo().toString());
    }

    public void messageErase(TopicHandler topicHandler) throws XmlBlasterException {
        String uniqueKey = topicHandler.getUniqueKey();
        if (topicHandler.hasExactSubscribers()) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Erase event for oid=" + uniqueKey + "', we do nothing here as subscription reservation remains even on deleted messages");
            }
            return;
        }
        Vector vec = this.getSubscriptionByOid(uniqueKey, false);
        if (vec == null) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Erase event for oid=" + uniqueKey + "', we do nothing as no subscribes are found");
            }
            return;
        }
        int ii = 0;
        while (ii < vec.size()) {
            SubscriptionInfo sub = (SubscriptionInfo)vec.elementAt(ii);
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Erase event for oid=" + uniqueKey + "', removing subId=" + sub.getSubscriptionId() + " ...");
            }
            this.subscriptionRemove(new SubscriptionEvent(sub));
            ++ii;
        }
    }

    public void subscriptionAdd(SubscriptionEvent e) throws XmlBlasterException {
        Object obj;
        SubscriptionInfo subscriptionInfo = e.getSubscriptionInfo();
        if (subscriptionInfo.getSubscribeCounter() > 1) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Ignoring multisubscribe instance " + subscriptionInfo.getSubscribeCounter());
            }
            return;
        }
        SessionInfo sessionInfo = subscriptionInfo.getSessionInfo();
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Subscription add event for client " + sessionInfo.getId());
        }
        KeyData keyData = subscriptionInfo.getKeyData();
        String uniqueKey = sessionInfo.getSessionName().getRelativeName();
        Map map = this.clientSubscriptionMap;
        synchronized (map) {
            Map<String, SubscriptionInfo> subMap;
            obj = this.clientSubscriptionMap.get(uniqueKey);
            if (obj == null) {
                subMap = Collections.synchronizedMap(new HashMap());
                this.clientSubscriptionMap.put(uniqueKey, subMap);
            } else {
                subMap = (Map<String, SubscriptionInfo>)obj;
            }
            subMap.put(subscriptionInfo.getSubscriptionId(), subscriptionInfo);
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Adding subscriptionId=" + subscriptionInfo.getSubscriptionId() + " to subMap of client " + sessionInfo.getId());
            }
        }
        if (keyData.isQuery()) {
            obj = null;
            Set set = this.querySubscribeRequestsSet;
            synchronized (set) {
                this.querySubscribeRequestsSet.add(subscriptionInfo);
            }
        }
    }

    public void subscriptionRemove(SubscriptionEvent e) throws XmlBlasterException {
        SubscriptionInfo subscriptionInfo = e.getSubscriptionInfo();
        if (subscriptionInfo.getSubscribeCounter() > 1) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Ignoring multisubscribe instance " + subscriptionInfo.getSubscribeCounter());
            }
            return;
        }
        String subscriptionInfoUniqueKey = subscriptionInfo.getSubscriptionId();
        SessionInfo sessionInfo = subscriptionInfo.getSessionInfo();
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Subscription remove event for client " + sessionInfo.toString() + " for subscriptionId=" + subscriptionInfoUniqueKey);
        }
        try {
            this.removeFromClientSubscriptionMap(sessionInfo, subscriptionInfoUniqueKey);
        }
        catch (XmlBlasterException e1) {
            this.log.error(this.ME + ".subscriptionRemove", "removeFromClientSubscriptionMap: " + e1.toString());
        }
        try {
            this.removeFromQuerySubscribeRequestsSet(sessionInfo, subscriptionInfoUniqueKey);
        }
        catch (XmlBlasterException e2) {
            this.log.error(this.ME + ".subscriptionRemove", "removeFromQuerySubscribeRequestsSet: " + e2.toString());
        }
        subscriptionInfo.shutdown();
    }

    private void removeFromClientSubscriptionMap(SessionInfo sessionInfo, String subscriptionInfoUniqueKey) throws XmlBlasterException {
        Object obj;
        String uniqueKey = sessionInfo.getSessionName().getRelativeName();
        Map map = this.clientSubscriptionMap;
        synchronized (map) {
            if (subscriptionInfoUniqueKey == null) {
                obj = this.clientSubscriptionMap.remove(uniqueKey);
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Removing client " + sessionInfo.toString() + " from clientSubscriptionMap ...");
                }
            } else {
                obj = this.clientSubscriptionMap.get(uniqueKey);
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Removing subscription " + subscriptionInfoUniqueKey + " from client " + sessionInfo.toString() + " from clientSubscriptionMap, subscriptionInfoUniqueKey=" + subscriptionInfoUniqueKey + " ...");
                }
            }
        }
        if (obj == null) {
            if (this.log.TRACE) {
                this.log.trace(this.ME + ".ClientDoesntExist", "Sorry, can't remove client subscription for " + sessionInfo.toString() + ", client never subscribed something");
            }
            return;
        }
        Map subMap = (Map)obj;
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Subscription=" + subscriptionInfoUniqueKey + " client=" + sessionInfo.toString() + " subMap.size=" + subMap.size());
        }
        if (subscriptionInfoUniqueKey == null) {
            Map map2 = subMap;
            synchronized (map2) {
                Iterator iterator = subMap.values().iterator();
                while (iterator.hasNext()) {
                    SubscriptionInfo sub = (SubscriptionInfo)iterator.next();
                    if (sub.getKeyData().isQuery()) {
                        if (!this.log.TRACE) continue;
                        this.log.trace(this.ME, "Ignoring subscription " + sub.getSubscriptionId() + " from TopicHandler '" + sub.getKeyOid() + "'");
                        continue;
                    }
                    if (this.log.TRACE) {
                        this.log.trace(this.ME, "Removing subscription " + sub.getSubscriptionId() + " from TopicHandler '" + sub.getKeyOid() + "'");
                    }
                    sub.removeSubscribe();
                }
            }
            subMap.clear();
            subMap = null;
        } else {
            SubscriptionInfo sub = null;
            Map map3 = subMap;
            synchronized (map3) {
                sub = (SubscriptionInfo)subMap.remove(subscriptionInfoUniqueKey);
            }
            if (sub == null) {
                this.log.error(this.ME + ".Internal", "Sorry, can't remove client subscriptionId=" + subscriptionInfoUniqueKey + " for " + sessionInfo.toString() + ", not found, subMap size=" + subMap.size());
                this.log.plain(this.ME, this.toXml());
                Thread.dumpStack();
                return;
            }
            sub.removeSubscribe();
        }
    }

    private void removeFromQuerySubscribeRequestsSet(SessionInfo sessionInfo, String subscriptionInfoUniqueKey) throws XmlBlasterException {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "removing client " + sessionInfo.toString() + " subscriptionInfoUniqueKey=" + subscriptionInfoUniqueKey + " from querySubscribeRequestsSet with size=" + this.querySubscribeRequestsSet.size() + " ...");
        }
        String uniqueKey = sessionInfo.getSessionName().getRelativeName();
        Vector<SubscriptionInfo> vec = new Vector<SubscriptionInfo>(this.querySubscribeRequestsSet.size());
        Set set = this.querySubscribeRequestsSet;
        synchronized (set) {
            Iterator iterator = this.querySubscribeRequestsSet.iterator();
            while (iterator.hasNext()) {
                SubscriptionInfo sub = (SubscriptionInfo)iterator.next();
                if ((!sub.getSessionInfo().getSessionName().getRelativeName().equals(uniqueKey) || subscriptionInfoUniqueKey != null) && subscriptionInfoUniqueKey != sub.getSubscriptionId()) continue;
                vec.addElement(sub);
            }
            int ii = 0;
            while (ii < vec.size()) {
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Removing subscription " + ((SubscriptionInfo)vec.elementAt(ii)).getSubscriptionId() + " from querySubscribeRequestsSet");
                }
                this.querySubscribeRequestsSet.remove(vec.elementAt(ii));
                ++ii;
            }
        }
        vec = null;
    }

    public final String toXml() throws XmlBlasterException {
        return this.toXml(null);
    }

    public final String toXml(String extraOffset) throws XmlBlasterException {
        StringBuffer sb = new StringBuffer(10000);
        if (extraOffset == null) {
            extraOffset = "";
        }
        String offset = "\n " + extraOffset;
        sb.append(offset).append("<ClientSubscriptions>");
        sb.append(offset).append(" <ExactSubscriptions>");
        Map map = this.clientSubscriptionMap;
        synchronized (map) {
            Iterator iterator = this.clientSubscriptionMap.values().iterator();
            while (iterator.hasNext()) {
                Map subMap;
                Map map2 = subMap = (Map)iterator.next();
                synchronized (map2) {
                    Iterator iterator2 = subMap.values().iterator();
                    while (iterator2.hasNext()) {
                        SubscriptionInfo sub = (SubscriptionInfo)iterator2.next();
                        if (!sub.getKeyData().isExact()) continue;
                        sb.append(sub.toXmlSmall(extraOffset + " " + " "));
                    }
                }
            }
        }
        sb.append(offset).append(" </ExactSubscriptions>");
        sb.append(offset).append(" <XPathSubscriptions>");
        Set set = this.querySubscribeRequestsSet;
        synchronized (set) {
            Iterator iterator = this.querySubscribeRequestsSet.iterator();
            while (iterator.hasNext()) {
                SubscriptionInfo sub = (SubscriptionInfo)iterator.next();
                sb.append(offset).append(sub.toXml(extraOffset + " " + " "));
            }
        }
        sb.append(offset + " </XPathSubscriptions>");
        sb.append(offset + "</ClientSubscriptions>");
        return sb.toString();
    }
}

