/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine;

import java.util.Properties;
import org.jutils.init.Property;
import org.jutils.runtime.ThreadLister;
import org.jutils.time.TimeHelper;
import org.xmlBlaster.authentication.SessionInfo;
import org.xmlBlaster.engine.RequestBroker;
import org.xmlBlaster.engine.SubjectEntryShuffler;
import org.xmlBlaster.engine.admin.CommandManager;
import org.xmlBlaster.engine.admin.extern.MomClientGateway;
import org.xmlBlaster.engine.cluster.ClusterManager;
import org.xmlBlaster.engine.dispatch.CbDispatchConnectionsHandler;
import org.xmlBlaster.engine.distributor.plugins.MsgDistributorPluginManager;
import org.xmlBlaster.engine.msgstore.StoragePluginManager;
import org.xmlBlaster.engine.persistence.MsgFileDumper;
import org.xmlBlaster.engine.queuemsg.ServerEntryFactory;
import org.xmlBlaster.engine.runlevel.I_RunlevelListener;
import org.xmlBlaster.engine.runlevel.PluginHolder;
import org.xmlBlaster.engine.runlevel.PluginHolderSaxFactory;
import org.xmlBlaster.engine.runlevel.RunlevelManager;
import org.xmlBlaster.engine.xml2java.XmlKey;
import org.xmlBlaster.protocol.CbProtocolManager;
import org.xmlBlaster.protocol.I_Authenticate;
import org.xmlBlaster.util.Timeout;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.admin.extern.JmxWrapper;
import org.xmlBlaster.util.cluster.NodeId;
import org.xmlBlaster.util.context.ContextNode;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.dispatch.DispatchConnectionsHandler;
import org.xmlBlaster.util.dispatch.DispatchManager;
import org.xmlBlaster.util.queue.I_EntryFactory;

public final class Global
extends org.xmlBlaster.util.Global
implements I_RunlevelListener {
    private RunlevelManager runlevelManager;
    private JmxWrapper jmxWrapper;
    private I_Authenticate authenticate;
    private RequestBroker requestBroker;
    private NodeId nodeId;
    private ClusterManager clusterManager;
    private Timeout sessionTimer;
    private Timeout topicTimer;
    private Timeout telnetSessionTimer;
    private boolean useCluster = true;
    private boolean firstUseCluster = true;
    private CbProtocolManager cbProtocolManager;
    private StoragePluginManager topicStorePluginManager;
    private CommandManager commandManager;
    private boolean useAdminManager = true;
    private boolean firstUseAdminManager = true;
    private MomClientGateway momClientGateway = null;
    private MsgFileDumper msgFileDumper;
    private PluginHolder pluginHolder;
    private MsgDistributorPluginManager msgDistributorPluginManager;
    private SubjectEntryShuffler subjectEntryShuffler;
    static /* synthetic */ Class class$org$xmlBlaster$engine$msgstore$StoragePluginManager;
    static /* synthetic */ Class class$org$xmlBlaster$engine$distributor$plugins$MsgDistributorPluginManager;
    static /* synthetic */ Class class$org$xmlBlaster$engine$SubjectEntryShuffler;

    public void finalize() {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Entering finalize");
        }
        this.shutdown();
    }

    public void shutdown() {
        super.shutdown();
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Destroying engine.Global handle");
        }
        try {
            this.unregisterJmx();
        }
        catch (XmlBlasterException e) {
            this.log.warn(this.ME, "Ignoring exception during JMX unregister: " + e.getMessage());
        }
        if (this.sessionTimer != null) {
            this.sessionTimer.shutdown();
            this.sessionTimer = null;
        }
        if (this.topicTimer != null) {
            this.topicTimer.shutdown();
            this.topicTimer = null;
        }
        this.removeTelnetSessionTimer();
    }

    public Global() {
        this(null, true);
    }

    public Global(String[] args) {
        this.init(args);
        this.addObjectEntry("ServerNodeScope", this);
    }

    public Global(Properties p, boolean loadPropFile) {
        super(Property.propsToArgs(p), loadPropFile, false);
        this.initThis();
        this.addObjectEntry("ServerNodeScope", this);
    }

    public int init(String[] args) {
        int ret = super.init(args);
        this.initThis();
        return ret;
    }

    private void initThis() {
        String myId = this.getProperty().get("cluster.node.id", (String)null);
        if (myId == null && this.getBootstrapAddress().getRawAddress() != null && this.getBootstrapAddress().getRawAddress().length() > 0) {
            myId = org.xmlBlaster.util.Global.getStrippedString(this.getBootstrapAddress().getRawAddress());
        }
        if (myId == null && this.getBootstrapAddress().getBootstrapPort() > 0) {
            myId = org.xmlBlaster.util.Global.getStrippedString(this.getBootstrapAddress().getBootstrapHostname() + ":" + this.getBootstrapAddress().getBootstrapPort());
        }
        if (myId == null) {
            if (this.useCluster()) {
                this.log.error(this.ME, "Can't determine server instance name, try to add '-cluster.node.id <aUniqueId>' on startup.");
                System.exit(1);
            } else {
                myId = "xmlBlaster";
            }
        }
        if (myId != null) {
            this.setId(myId);
        }
        this.getRunlevelManager().addRunlevelListener(this);
        this.log.info(this.ME, "Setting xmlBlaster instance name (-cluster.node.id) to '" + this.getId() + "'");
    }

    public boolean isServerSide() {
        return true;
    }

    public final NodeId getNodeId() {
        return this.nodeId;
    }

    public final String getId() {
        if (this.getNodeId() == null) {
            return null;
        }
        return this.getNodeId().getId();
    }

    public final void setId(String id) {
        super.setId(id);
        this.nodeId = new NodeId(id);
        this.contextNode = new ContextNode(this, "node", this.getStrippedId(), null);
    }

    public final RunlevelManager getRunlevelManager() {
        if (this.runlevelManager == null) {
            Global global = this;
            synchronized (global) {
                if (this.runlevelManager == null) {
                    this.runlevelManager = new RunlevelManager(this);
                }
            }
        }
        return this.runlevelManager;
    }

    public final ClusterManager getClusterManager() throws XmlBlasterException {
        if (this.clusterManager == null) {
            if (!this.useCluster()) {
                return null;
            }
            this.log.error(this.ME, "Internal problem: please intialize ClusterManager first");
            Thread.dumpStack();
            throw new XmlBlasterException(this, ErrorCode.INTERNAL_ILLEGALARGUMENT, this.ME, "Internal problem: please intialize ClusterManager first - Please ask on mailing list for support");
        }
        return this.clusterManager;
    }

    public final boolean useCluster() {
        if (this.firstUseCluster) {
            this.useCluster = this.getProperty().get("cluster", this.useCluster);
            this.firstUseCluster = false;
        }
        return this.useCluster;
    }

    public final String getLogPrefix() {
        if (this.useCluster()) {
            return "/node/" + this.getId();
        }
        return "";
    }

    public final String getLogPrefixDashed(String post) {
        String prae = this.getLogPrefix();
        return prae.length() < 1 ? "-" + post : "-/node/" + this.getId() + "/" + post;
    }

    public final String getLogPrefixDashed() {
        String prae = this.getLogPrefix();
        if (prae.length() > 0) {
            return "-" + prae;
        }
        return "";
    }

    public final ClusterManager getClusterManager(SessionInfo sessionInfo) throws XmlBlasterException {
        if (this.clusterManager == null) {
            if (!this.useCluster()) {
                return null;
            }
            Global global = this;
            synchronized (global) {
                if (this.clusterManager == null) {
                    this.clusterManager = new ClusterManager(this, sessionInfo);
                    this.ME = "Global" + this.getLogPrefixDashed();
                }
            }
        }
        return this.clusterManager;
    }

    public final CbProtocolManager getCbProtocolManager() throws XmlBlasterException {
        if (this.cbProtocolManager == null) {
            Global global = this;
            synchronized (global) {
                if (this.cbProtocolManager == null) {
                    this.cbProtocolManager = new CbProtocolManager(this);
                }
            }
        }
        return this.cbProtocolManager;
    }

    public final StoragePluginManager getStoragePluginManager() {
        if (this.topicStorePluginManager == null) {
            Class clazz = class$org$xmlBlaster$engine$msgstore$StoragePluginManager == null ? (class$org$xmlBlaster$engine$msgstore$StoragePluginManager = Global.class$("org.xmlBlaster.engine.msgstore.StoragePluginManager")) : class$org$xmlBlaster$engine$msgstore$StoragePluginManager;
            synchronized (clazz) {
                if (this.topicStorePluginManager == null) {
                    this.topicStorePluginManager = new StoragePluginManager(this);
                }
            }
        }
        return this.topicStorePluginManager;
    }

    public final MsgFileDumper getMsgFileDumper() throws XmlBlasterException {
        if (this.msgFileDumper == null) {
            Global global = this;
            synchronized (global) {
                if (this.msgFileDumper == null) {
                    this.msgFileDumper = new MsgFileDumper();
                    this.msgFileDumper.init(this);
                }
            }
        }
        return this.msgFileDumper;
    }

    public final Timeout getSessionTimer() {
        if (this.sessionTimer == null) {
            Global global = this;
            synchronized (global) {
                if (this.sessionTimer == null) {
                    this.sessionTimer = new Timeout("XmlBlaster.SessionTimer");
                }
            }
        }
        return this.sessionTimer;
    }

    public final Timeout getTopicTimer() {
        if (this.topicTimer == null) {
            Global global = this;
            synchronized (global) {
                if (this.topicTimer == null) {
                    this.topicTimer = new Timeout("XmlBlaster.TopicTimer");
                }
            }
        }
        return this.topicTimer;
    }

    public final Timeout getTelnetSessionTimer() {
        if (this.telnetSessionTimer == null) {
            Global global = this;
            synchronized (global) {
                if (this.telnetSessionTimer == null) {
                    this.telnetSessionTimer = new Timeout("XmlBlaster.TelnetSessionTimer");
                }
            }
        }
        return this.telnetSessionTimer;
    }

    public final boolean hasTelnetSessionTimer() {
        return this.telnetSessionTimer != null;
    }

    public final void removeTelnetSessionTimer() {
        if (this.telnetSessionTimer != null) {
            Global global = this;
            synchronized (global) {
                if (this.telnetSessionTimer != null) {
                    this.telnetSessionTimer.shutdown();
                    this.telnetSessionTimer = null;
                }
            }
        }
    }

    public I_EntryFactory getEntryFactory() {
        if (this.entryFactory != null) {
            return this.entryFactory;
        }
        Global global = this;
        synchronized (global) {
            this.entryFactory = new ServerEntryFactory();
            this.entryFactory.initialize(this);
            I_EntryFactory i_EntryFactory = this.entryFactory;
            return i_EntryFactory;
        }
    }

    public JmxWrapper getJmxWrapper() throws XmlBlasterException {
        if (this.jmxWrapper == null) {
            Global global = this;
            synchronized (global) {
                boolean activateJmx;
                if (this.jmxWrapper == null && (activateJmx = this.getProperty().get("xmlBlaster.activateJmx", false))) {
                    this.jmxWrapper = new JmxWrapper(this);
                }
            }
        }
        return this.jmxWrapper;
    }

    public synchronized void unregisterJmx() throws XmlBlasterException {
        if (this.jmxWrapper != null) {
            this.jmxWrapper.unRegister(this.getStrippedId());
            this.jmxWrapper = null;
        }
    }

    public final CommandManager getCommandManager() throws XmlBlasterException {
        if (this.commandManager == null) {
            if (!this.useAdminManager()) {
                return null;
            }
            this.log.error(this.ME, "Internal problem: please intialize CommandManager first");
            Thread.dumpStack();
            throw new XmlBlasterException(this, ErrorCode.INTERNAL_UNKNOWN, this.ME, "please intialize CommandManager first - Please ask on mailing list for support");
        }
        return this.commandManager;
    }

    public final boolean useAdminManager() {
        if (this.firstUseAdminManager) {
            this.useAdminManager = this.getProperty().get("admin", this.useAdminManager);
            this.firstUseAdminManager = false;
        }
        return this.useAdminManager;
    }

    public final CommandManager getCommandManager(SessionInfo sessionInfo) throws XmlBlasterException {
        if (this.commandManager == null) {
            if (!this.useAdminManager()) {
                return null;
            }
            Global global = this;
            synchronized (global) {
                if (this.commandManager == null) {
                    this.commandManager = new CommandManager(this, sessionInfo);
                }
            }
        }
        return this.commandManager;
    }

    public final MomClientGateway getMomClientGateway() {
        return this.momClientGateway;
    }

    public final boolean supportAdministrative() {
        return this.momClientGateway != null;
    }

    public final void registerMomClientGateway(MomClientGateway momClientGateway) {
        this.momClientGateway = momClientGateway;
    }

    public final boolean isAdministrationCommand(XmlKey xmlKey) throws XmlBlasterException {
        if (this.momClientGateway == null) {
            return false;
        }
        if (xmlKey == null) {
            this.log.error(this.ME, "Illegal null argument in isAdministrationCommand()");
            Thread.dumpStack();
            return false;
        }
        return xmlKey.isAdministrative();
    }

    public DispatchConnectionsHandler createDispatchConnectionsHandler(DispatchManager dispatchManager) throws XmlBlasterException {
        return new CbDispatchConnectionsHandler(this, dispatchManager);
    }

    public void setAuthenticate(I_Authenticate auth) {
        this.authenticate = auth;
        this.addObjectEntry("/xmlBlaster/I_Authenticate", this.authenticate);
    }

    public I_Authenticate getAuthenticate() {
        return this.authenticate;
    }

    public final MsgDistributorPluginManager getMsgDistributorPluginManager() {
        if (this.msgDistributorPluginManager == null) {
            Class clazz = class$org$xmlBlaster$engine$distributor$plugins$MsgDistributorPluginManager == null ? (class$org$xmlBlaster$engine$distributor$plugins$MsgDistributorPluginManager = Global.class$("org.xmlBlaster.engine.distributor.plugins.MsgDistributorPluginManager")) : class$org$xmlBlaster$engine$distributor$plugins$MsgDistributorPluginManager;
            synchronized (clazz) {
                if (this.msgDistributorPluginManager == null) {
                    this.msgDistributorPluginManager = new MsgDistributorPluginManager(this);
                }
            }
        }
        return this.msgDistributorPluginManager;
    }

    public void setRequestBroker(RequestBroker requestBroker) {
        this.requestBroker = requestBroker;
    }

    public RequestBroker getRequestBroker() {
        return this.requestBroker;
    }

    public String getName() {
        return this.ME;
    }

    public void runlevelChange(int from, int to, boolean force) throws XmlBlasterException {
        if (to == from) {
            return;
        }
        if (to > from) {
            if (to == 3) {
                this.getHttpServer();
            }
            if (to == 6) {
                // empty if block
            }
            if (to == 9) {
                // empty if block
            }
        } else if (to < from) {
            if (to == 6) {
                // empty if block
            }
            if (to == 3) {
                // empty if block
            }
            if (to <= 0) {
                this.shutdownHttpServer();
                this.shutdown();
            }
        }
    }

    public boolean isEmbedded() {
        return this.getProperty().get("xmlBlaster.isEmbedded", false);
    }

    public String getDump() throws XmlBlasterException {
        StringBuffer sb = new StringBuffer(10000);
        String offset = "\n";
        sb.append(offset).append("<xmlBlaster id='").append(this.getId()).append("'");
        sb.append(" version='").append(this.getVersion()).append("' counter='").append(org.xmlBlaster.util.Global.counter).append("'");
        sb.append("\n   ");
        sb.append(" buildTimestamp='").append(this.getBuildTimestamp()).append("'");
        sb.append(" buildJavaVendor='").append(this.getBuildJavaVendor()).append("'");
        sb.append(" buildJavaVersion='").append(this.getBuildJavaVersion()).append("'");
        sb.append("\n   ");
        sb.append(" java.vendor='").append(System.getProperty("java.vendor")).append("'");
        sb.append(" java.version='").append(System.getProperty("java.version")).append("'");
        sb.append("\n   ");
        sb.append(" os.name='").append(System.getProperty("os.name")).append("'");
        sb.append(" os.version='").append(System.getProperty("os.version")).append("'");
        sb.append("\n   ");
        sb.append(" freeMemory='").append(Runtime.getRuntime().freeMemory()).append("'");
        sb.append(" totalMemory='").append(Runtime.getRuntime().totalMemory()).append("'");
        sb.append("\n   ");
        sb.append(" dumpTimestamp='").append(TimeHelper.getDateTimeDump(0L)).append("'");
        sb.append(">");
        sb.append(this.getProperty().toXml());
        sb.append(offset).append(" <ThreadDump><![CDATA[");
        sb.append(ThreadLister.listAllThreads());
        sb.append(offset).append(" ]]></ThreadDump>");
        if (this.getAuthenticate() != null) {
            sb.append(this.getAuthenticate().toXml());
            if (this.getAuthenticate().getXmlBlaster() != null) {
                sb.append(this.getAuthenticate().getXmlBlaster().toXml());
            }
        }
        sb.append(offset).append("</xmlBlaster>");
        return sb.toString();
    }

    public boolean isServer() {
        return true;
    }

    public PluginHolder getPluginHolder() throws XmlBlasterException {
        if (this.pluginHolder != null) {
            return this.pluginHolder;
        }
        Global global = this;
        synchronized (global) {
            if (this.pluginHolder == null) {
                PluginHolderSaxFactory factory = new PluginHolderSaxFactory(this);
                this.pluginHolder = factory.readConfigFile();
            }
            PluginHolder pluginHolder = this.pluginHolder;
            return pluginHolder;
        }
    }

    public SubjectEntryShuffler getSubjectInfoShuffler() {
        if (this.subjectEntryShuffler != null) {
            return this.subjectEntryShuffler;
        }
        Class clazz = class$org$xmlBlaster$engine$SubjectEntryShuffler == null ? (class$org$xmlBlaster$engine$SubjectEntryShuffler = Global.class$("org.xmlBlaster.engine.SubjectEntryShuffler")) : class$org$xmlBlaster$engine$SubjectEntryShuffler;
        synchronized (clazz) {
            if (this.subjectEntryShuffler == null) {
                this.subjectEntryShuffler = new SubjectEntryShuffler(this);
            }
            SubjectEntryShuffler subjectEntryShuffler = this.subjectEntryShuffler;
            return subjectEntryShuffler;
        }
    }

    public String usage() {
        StringBuffer sb = new StringBuffer(512);
        sb.append(org.xmlBlaster.util.Global.logUsage());
        sb.append("\n");
        sb.append("  There are fine grained logging possibilities like:\n");
        sb.append("   -trace[corba]       Switch on trace mode only for IOR driver.\n");
        sb.append("   -call[cluster]      Show method calls in the cluster module.\n");
        sb.append("   -trace[mime]        Trace code in mime based filter plugins.\n");
        sb.append("    Supported is [core], [auth], [dispatch], [mime], [corba], [xmlrpc] [admin]\n");
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

