/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine;

import java.util.ArrayList;
import org.jutils.log.LogChannel;
import org.xmlBlaster.authentication.SessionInfo;
import org.xmlBlaster.client.qos.DisconnectQos;
import org.xmlBlaster.engine.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.dispatch.DispatchManager;
import org.xmlBlaster.util.error.I_MsgErrorHandler;
import org.xmlBlaster.util.error.I_MsgErrorInfo;
import org.xmlBlaster.util.qos.storage.QueuePropertyBase;
import org.xmlBlaster.util.queue.I_Entry;
import org.xmlBlaster.util.queue.I_Queue;
import org.xmlBlaster.util.queuemsg.MsgQueueEntry;

public final class MsgErrorHandler
implements I_MsgErrorHandler {
    private final String ME;
    private final long MAX_BYTES = 1000000L;
    private final Global glob;
    private final LogChannel log;
    private SessionInfo sessionInfo;

    public MsgErrorHandler(Global glob, SessionInfo sessionInfo) {
        this.ME = "MsgErrorHandler-" + (sessionInfo == null ? "" : sessionInfo.getId());
        this.glob = glob;
        this.log = glob.getLog("core");
        this.sessionInfo = sessionInfo;
    }

    public void handleError(I_MsgErrorInfo msgErrorInfo) {
        long size;
        if (msgErrorInfo == null) {
            return;
        }
        XmlBlasterException xmlBlasterException = msgErrorInfo.getXmlBlasterException();
        ErrorCode errorCode = xmlBlasterException.getErrorCode();
        String message = xmlBlasterException.getMessage();
        I_Entry[] msgQueueEntries = msgErrorInfo.getMsgQueueEntries();
        DispatchManager dispatchManager = this.sessionInfo == null ? null : this.sessionInfo.getDispatchManager();
        I_Queue msgQueue = msgErrorInfo.getQueue();
        if (this.log.CALL) {
            this.log.call(this.ME, "Error handling started: " + msgErrorInfo.toString());
        }
        if (msgQueueEntries != null && msgQueueEntries.length > 0) {
            this.glob.getRequestBroker().deadMessage((MsgQueueEntry[])msgQueueEntries, msgQueue, message);
            if (msgQueue != null) {
                try {
                    if (this.log.TRACE) {
                        this.log.trace(this.ME, "Removing " + msgQueueEntries.length + " dead messages from queue");
                    }
                    long removed = 0L;
                    boolean[] tmp = msgQueue.removeRandom(msgQueueEntries);
                    int i = 0;
                    while (i < tmp.length) {
                        if (tmp[i]) {
                            ++removed;
                        }
                        ++i;
                    }
                    if (removed != (long)msgQueueEntries.length) {
                        this.log.warn(this.ME, "Expected to remove " + msgQueueEntries.length + " messages from queue but where only " + removed + ": " + message);
                    }
                }
                catch (XmlBlasterException e) {
                    this.log.warn(this.ME, "Can't remove " + msgQueueEntries.length + " messages from queue: " + e.getMessage() + ". Original cause was: " + message);
                }
            }
        }
        if (xmlBlasterException.isUser()) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Error handlig for exception " + errorCode.toString() + " done");
            }
            return;
        }
        long l = size = msgQueue == null ? 0L : msgQueue.getNumOfEntries();
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Flushing " + size + " remaining message from queue");
        }
        if (size > 0L) {
            try {
                QueuePropertyBase queueProperty = (QueuePropertyBase)msgQueue.getProperties();
                if (queueProperty == null || queueProperty.onFailureDeadMessage()) {
                    while (msgQueue.getNumOfEntries() > 0L) {
                        ArrayList list = msgQueue.peek(-1, 1000000L);
                        I_Entry[] msgArr = list.toArray(new MsgQueueEntry[list.size()]);
                        if (msgArr.length > 0) {
                            this.glob.getRequestBroker().deadMessage((MsgQueueEntry[])msgArr, null, message);
                        }
                        if (msgArr.length <= 0) continue;
                        msgQueue.removeRandom(msgArr);
                    }
                } else {
                    this.log.error(this.ME, "PANIC: Only onFailure='deadMessage' is implemented, " + msgQueue.getNumOfEntries() + " messages are lost: " + message);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.log.error(this.ME, "PANIC: givingUpDelivery failed, " + size + " messages are lost: " + message + ": " + e.toString());
            }
        }
        if (dispatchManager == null || dispatchManager.isDead()) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Doing error handling for dead connection state ...");
            }
            if (dispatchManager != null) {
                dispatchManager.shutdown();
            }
            if (this.sessionInfo != null && this.sessionInfo.getConnectQos().getSessionCbQueueProperty().getCallbackAddresses().length > 0) {
                try {
                    this.log.warn(this.ME, "Callback server is lost, killing login session of client " + (msgQueue == null ? "unknown" : msgQueue.getStorageId().toString()) + ": " + message);
                    try {
                        DisconnectQos disconnectQos = new DisconnectQos(this.glob);
                        disconnectQos.deleteSubjectQueue(false);
                        this.glob.getAuthenticate().disconnect(this.sessionInfo.getSecretSessionId(), disconnectQos.toXml());
                    }
                    catch (Throwable e) {
                        this.log.error(this.ME, "PANIC: givingUpDelivery error handling failed, " + size + " messages are lost: " + message + ": " + e.toString());
                    }
                }
                catch (Throwable e) {
                    this.log.error(this.ME, "PANIC: givingUpDelivery error handling failed, " + size + " messages are lost: " + message + ": " + e.toString());
                }
            }
        }
    }

    public void handleErrorSync(I_MsgErrorInfo msgErrorInfo) throws XmlBlasterException {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Unexpected sync error handling invocation, we try our best");
        }
        this.handleError(msgErrorInfo);
    }

    public void shutdown() {
    }
}

