/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine;

import org.jutils.log.LogChannel;
import org.xmlBlaster.engine.Global;
import org.xmlBlaster.engine.TopicHandler;
import org.xmlBlaster.engine.msgstore.I_ChangeCallback;
import org.xmlBlaster.engine.msgstore.I_Map;
import org.xmlBlaster.engine.msgstore.I_MapEntry;
import org.xmlBlaster.util.I_Timeout;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.Timeout;
import org.xmlBlaster.util.Timestamp;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.def.PriorityEnum;
import org.xmlBlaster.util.key.MsgKeyData;
import org.xmlBlaster.util.qos.MsgQosData;
import org.xmlBlaster.util.queue.StorageId;

public final class MsgUnitWrapper
implements I_MapEntry,
I_Timeout,
I_ChangeCallback {
    private static final transient String ME = "MsgUnitWrapper-";
    private final transient Global glob;
    private final transient LogChannel log;
    private transient int historyReferenceCounter;
    private transient int referenceCounter;
    private final transient long uniqueId;
    private final transient String uniqueIdStr;
    private final transient StorageId storageId;
    private transient I_Map ownerCache;
    private final transient String embeddedType;
    private transient boolean wantReturnObj;
    private transient Object returnObj;
    private transient Timeout destroyTimer;
    private transient Timestamp timerKey = null;
    private static final int UNDEF = -1;
    private static final int ALIVE = 0;
    private static final int PRE_EXPIRED = 4;
    private static final int EXPIRED = 1;
    private static final int DESTROYED = 2;
    private static final int PRE_DESTROYED = 3;
    private transient int state = -1;
    private MsgUnit msgUnit;
    private final long immutableSizeInBytes;
    private boolean stored = false;
    private transient boolean swapped = false;
    private transient Timestamp sortTimestamp;

    public MsgUnitWrapper(Global glob, MsgUnit msgUnit, StorageId storageId) throws XmlBlasterException {
        this(glob, msgUnit, null, storageId, 0, 0, null, -1L);
    }

    public MsgUnitWrapper(Global glob, MsgUnit msgUnit, I_Map ownerCache, int referenceCounter, int historyReferenceCounter, long sizeInBytes) throws XmlBlasterException {
        this(glob, msgUnit, ownerCache, ownerCache.getStorageId(), referenceCounter, historyReferenceCounter, null, sizeInBytes);
    }

    public MsgUnitWrapper(Global glob, MsgUnit msgUnit, StorageId storageId, int referenceCounter, int historyReferenceCounter, long sizeInBytes) throws XmlBlasterException {
        this(glob, msgUnit, null, storageId, referenceCounter, historyReferenceCounter, null, sizeInBytes);
    }

    public MsgUnitWrapper(Global glob, MsgUnit msgUnit, I_Map ownerCache, StorageId storageId, int referenceCounter, int historyReferenceCounter, String embeddedType, long sizeInBytes) throws XmlBlasterException {
        this.glob = glob;
        this.log = glob.getLog("core");
        if (msgUnit == null) {
            throw new XmlBlasterException(glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, "MsgUnitWrapper", "Invalid constructor parameter msgUnit==null");
        }
        this.msgUnit = msgUnit;
        this.ownerCache = ownerCache;
        this.storageId = storageId != null ? storageId : (this.ownerCache != null ? this.ownerCache.getStorageId() : null);
        this.referenceCounter = referenceCounter;
        this.historyReferenceCounter = historyReferenceCounter;
        String string = this.embeddedType = embeddedType == null ? "MSG_XML" : embeddedType;
        if (this.getMsgQosData().getRcvTimestamp() == null) {
            throw new XmlBlasterException(glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, "MsgUnitWrapper", "Missing timestamp, try to create publish QoS with PublishQosServer.java");
        }
        this.uniqueId = this.getMsgQosData().getRcvTimestamp().getTimestamp();
        this.uniqueIdStr = "" + this.uniqueId;
        this.destroyTimer = this.glob.getMessageTimer();
        long l = this.immutableSizeInBytes = sizeInBytes >= 0L ? sizeInBytes : 3200L + this.msgUnit.size();
        if (this.log.TRACE) {
            this.log.trace(ME + this.getLogId(), "Created new MsgUnitWrapper instance '" + this + "' " + (this.ownerCache == null ? " from persistence store" : ""));
        }
        this.toAlive();
        if (this.historyReferenceCounter > this.referenceCounter) {
            this.log.error(ME + this.getLogId(), "PANIC: historyReferenceCounter=" + this.historyReferenceCounter + " is bigger than referenceCounter=" + this.referenceCounter + this.toXml());
        }
    }

    public void finalize() {
        if (this.destroyTimer != null && this.timerKey != null) {
            this.destroyTimer.removeTimeoutListener(this.timerKey);
        }
    }

    public boolean isSwapped() {
        return this.swapped;
    }

    public void isSwapped(boolean swapped) {
        this.swapped = swapped;
    }

    private I_Map getOwnerCache() throws XmlBlasterException {
        if (this.ownerCache == null) {
            if (this.log.TRACE) {
                this.log.trace(ME + this.getLogId(), "Creating ownerCache from topicHandler");
            }
            this.ownerCache = this.getTopicHandler().getMsgUnitCache();
        }
        return this.ownerCache;
    }

    public TopicHandler getTopicHandler() throws XmlBlasterException {
        TopicHandler topicHandler = this.glob.getRequestBroker().getMessageHandlerFromOid(this.getKeyOid());
        if (topicHandler == null) {
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, ME + this.getLogId(), "getTopicHandler() - storage lookup of topic '" + this.getKeyOid() + "' failed");
        }
        return topicHandler;
    }

    public boolean incrementReferenceCounter(int count, StorageId storageId) throws XmlBlasterException {
        I_Map cache;
        I_Map i_Map = cache = this.getOwnerCache();
        synchronized (i_Map) {
            if (this.isSwapped()) {
                if (this.log.TRACE) {
                    this.log.trace(ME + this.getLogId(), "incrementReferenceCounter: unexpected swapped message");
                }
                boolean bl = false;
                return bl;
            }
            boolean isHistoryReference = storageId != null && storageId.getPrefix().equals("history");
            String string = this.uniqueIdStr;
            synchronized (string) {
                if (isHistoryReference) {
                    this.historyReferenceCounter += count;
                }
                this.referenceCounter += count;
            }
            if (this.log.TRACE && !this.isInternal()) {
                this.log.trace(ME + this.getLogId(), "Reference count changed from " + (this.referenceCounter - count) + " to " + this.referenceCounter + ", new historyEntries=" + this.historyReferenceCounter + " this='" + this + "' storageId='" + storageId + "'");
            }
            if ((long)this.referenceCounter > 0L) {
                I_MapEntry ret;
                if (count != 0 && this.getTopicHandler().isInMsgStore(this) && (ret = cache.change(this, null)) != this) {
                    this.log.error(ME + this.getLogId(), "Expected to be identical in change(): old=" + this + " new=" + ret);
                }
            } else if (!this.isDestroyed()) {
                this.state = 3;
            }
        }
        return this.state == 3;
    }

    void setReferenceCounter(int count) {
        String string = this.uniqueIdStr;
        synchronized (string) {
            this.referenceCounter += count;
        }
        if (this.log.TRACE && !this.isInternal()) {
            this.log.trace(ME + this.getLogId(), "Reference count changed from " + (this.referenceCounter - count) + " to " + this.referenceCounter + ", this='" + this + "'");
        }
        if ((long)this.referenceCounter <= 0L) {
            this.toDestroyed();
        }
    }

    public I_MapEntry changeEntry(I_MapEntry entry) throws XmlBlasterException {
        if (this.log.TRACE) {
            this.log.trace(ME + this.getLogId(), "Entring changeEntry(), referecenceCounter=" + this.referenceCounter + ", historyReferenceCounter=" + this.historyReferenceCounter);
        }
        return this;
    }

    public int getReferenceCounter() {
        return this.referenceCounter;
    }

    public int getHistoryReferenceCounter() {
        return this.historyReferenceCounter;
    }

    public int getPriority() {
        return PriorityEnum.NORM_PRIORITY.getInt();
    }

    public MsgQosData getMsgQosData() {
        return (MsgQosData)this.msgUnit.getQosData();
    }

    public boolean isPersistent() {
        return this.getMsgQosData().isPersistent();
    }

    public MsgKeyData getMsgKeyData() {
        return (MsgKeyData)this.msgUnit.getKeyData();
    }

    public MsgUnit getMsgUnit() {
        return this.msgUnit;
    }

    public final String getKeyOid() {
        return this.getMsgKeyData().getOid();
    }

    public String getContentMime() {
        return this.getMsgKeyData().getContentMime();
    }

    public String getContentMimeExtended() {
        return this.getMsgKeyData().getContentMimeExtended();
    }

    public String getDomain() {
        return this.getMsgKeyData().getDomain();
    }

    public void setMsgUnit(MsgUnit msg) {
        this.msgUnit = msg;
    }

    public long getSizeInBytes() {
        return this.immutableSizeInBytes;
    }

    public long getUniqueId() {
        return this.uniqueId;
    }

    public String getUniqueIdStr() {
        return this.uniqueIdStr;
    }

    public final String getLogId() {
        return this.getKeyOid() + "/" + this.getMsgQosData().getRcvTimestamp();
    }

    public final boolean isInternal() {
        return this.getMsgKeyData().isInternal();
    }

    public String getEmbeddedType() {
        return this.embeddedType;
    }

    public Object getEmbeddedObject() {
        if (this.embeddedType.equals("MSG_SER")) {
            Object[] obj = new Object[]{this.msgUnit, new Integer(this.referenceCounter), new Integer(this.historyReferenceCounter)};
            return obj;
        }
        Object[] obj = new Object[]{this.msgUnit.getQosData().toXml(), this.msgUnit.getKeyData().toXml(), this.msgUnit.getContent(), new Integer(this.referenceCounter), new Integer(this.historyReferenceCounter)};
        return obj;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public final String toXml() {
        return this.toXml(null);
    }

    public String toXml(String extraOffset) {
        StringBuffer sb = new StringBuffer(1024);
        if (extraOffset == null) {
            extraOffset = "";
        }
        String offset = "\n " + extraOffset;
        int maxContentDumpSize = 80;
        sb.append(offset).append("<MsgUnitWrapper id='").append(this.getLogId());
        sb.append("' referenceCount='").append(this.getReferenceCounter());
        sb.append("' state='").append(this.getStateStr()).append("'>");
        sb.append(this.msgUnit.toXml(" " + extraOffset, maxContentDumpSize));
        sb.append(offset).append("</MsgUnitWrapper>");
        return sb.toString();
    }

    public void added(StorageId storageId) {
        this.glob.getLog("core").error(ME + this.getLogId(), "added(" + storageId.getId() + ") invocation not expected");
    }

    public void removed(StorageId storageId) {
        this.glob.getLog("core").error(ME + this.getLogId(), "removed(" + storageId.getId() + ") invocation not expected");
    }

    public boolean isAlive() {
        return this.state == 0;
    }

    private void toAlive() {
        MsgUnitWrapper msgUnitWrapper = this;
        synchronized (msgUnitWrapper) {
            long lifeTime;
            if (this.isAlive()) {
                return;
            }
            this.state = 0;
            if (this.timerKey != null) {
                this.destroyTimer.removeTimeoutListener(this.timerKey);
                this.timerKey = null;
                this.glob.getLog("core").error(ME + this.getLogId(), "Unexpected expiry timer in state " + this.getStateStr());
            }
            if ((lifeTime = this.getMsgQosData().getLifeTime()) > -1L) {
                long timeout = this.getMsgQosData().getRemainingLife();
                if (timeout <= 0L) {
                    this.state = 4;
                    timeout = 0L;
                }
                this.timerKey = this.destroyTimer.addTimeoutListener(this, timeout, null);
            }
        }
    }

    public boolean isExpired() {
        return this.state == 1 || this.state == 4;
    }

    private void toExpired() throws XmlBlasterException {
        MsgUnitWrapper msgUnitWrapper = this;
        synchronized (msgUnitWrapper) {
            if (this.timerKey != null) {
                this.destroyTimer.removeTimeoutListener(this.timerKey);
                this.timerKey = null;
            }
            if (this.state == 1) {
                return;
            }
            this.state = 1;
            if ((long)this.referenceCounter <= 0L) {
                this.toDestroyed();
                return;
            }
        }
        TopicHandler topicHandler = this.glob.getRequestBroker().getMessageHandlerFromOid(this.getKeyOid());
        if (topicHandler != null) {
            topicHandler.entryExpired(this);
        }
    }

    public boolean isDestroyed() {
        return this.state == 2 || this.state == 3;
    }

    public void toDestroyed() {
        MsgUnitWrapper msgUnitWrapper = this;
        synchronized (msgUnitWrapper) {
            if (this.timerKey != null) {
                this.destroyTimer.removeTimeoutListener(this.timerKey);
                this.timerKey = null;
            }
            if (this.state == 2) {
                return;
            }
            this.state = 2;
        }
        TopicHandler topicHandler = this.glob.getRequestBroker().getMessageHandlerFromOid(this.getKeyOid());
        if (topicHandler != null) {
            topicHandler.entryDestroyed(this);
        }
    }

    public final void timeout(Object userData) {
        MsgUnitWrapper msgUnitWrapper = this;
        synchronized (msgUnitWrapper) {
            if (this.timerKey != null) {
                this.destroyTimer.removeTimeoutListener(this.timerKey);
                this.timerKey = null;
            }
            if (this.getMsgQosData().isForceDestroy()) {
                this.toDestroyed();
            } else {
                try {
                    this.toExpired();
                }
                catch (XmlBlasterException e) {
                    this.glob.getLog("core").error(ME + this.getLogId(), "Unexpected exception from toExpired() which we can't handle: " + e.getMessage());
                }
            }
        }
    }

    public String getStateStr() {
        if (this.isAlive()) {
            return "ALIVE";
        }
        if (this.isExpired()) {
            return "EXPIRED";
        }
        if (this.isDestroyed()) {
            return "DESTROYED";
        }
        return "UNDEF";
    }

    public final void setStored(boolean stored) {
        this.stored = stored;
    }

    public final boolean isStored() {
        return this.stored;
    }

    public void setWantReturnObj(boolean wantReturnObj) {
        this.wantReturnObj = wantReturnObj;
    }

    public boolean getWantReturnObj() {
        return this.wantReturnObj;
    }

    public Object getReturnObj() {
        return this.returnObj;
    }

    public void setReturnObj(Object returnObj) {
        this.returnObj = returnObj;
    }

    public final Timestamp getSortTimestamp() {
        return this.sortTimestamp;
    }

    public final void setSortTimestamp(Timestamp timestamp) {
        this.sortTimestamp = timestamp;
    }

    public static void main(String[] args) {
    }
}

