/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.jutils.JUtilsException;
import org.jutils.io.FileUtil;
import org.jutils.log.LogChannel;
import org.xmlBlaster.authentication.Authenticate;
import org.xmlBlaster.authentication.ClientEvent;
import org.xmlBlaster.authentication.I_ClientListener;
import org.xmlBlaster.authentication.SessionInfo;
import org.xmlBlaster.client.key.PublishKey;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.client.qos.PublishReturnQos;
import org.xmlBlaster.client.qos.SubscribeReturnQos;
import org.xmlBlaster.client.qos.UnSubscribeReturnQos;
import org.xmlBlaster.engine.BigXmlKeyDOM;
import org.xmlBlaster.engine.ClientSubscriptions;
import org.xmlBlaster.engine.Global;
import org.xmlBlaster.engine.I_SubscriptionListener;
import org.xmlBlaster.engine.MsgUnitWrapper;
import org.xmlBlaster.engine.RequestBrokerMBean;
import org.xmlBlaster.engine.SubscriptionEvent;
import org.xmlBlaster.engine.SubscriptionInfo;
import org.xmlBlaster.engine.TopicHandler;
import org.xmlBlaster.engine.admin.CommandManager;
import org.xmlBlaster.engine.mime.AccessPluginManager;
import org.xmlBlaster.engine.mime.I_AccessFilter;
import org.xmlBlaster.engine.mime.I_PublishFilter;
import org.xmlBlaster.engine.mime.PublishPluginManager;
import org.xmlBlaster.engine.msgstore.I_Map;
import org.xmlBlaster.engine.msgstore.I_MapEntry;
import org.xmlBlaster.engine.persistence.PersistencePluginManager;
import org.xmlBlaster.engine.qos.EraseQosServer;
import org.xmlBlaster.engine.qos.GetQosServer;
import org.xmlBlaster.engine.qos.GetReturnQosServer;
import org.xmlBlaster.engine.qos.PublishQosServer;
import org.xmlBlaster.engine.qos.SubscribeQosServer;
import org.xmlBlaster.engine.qos.UnSubscribeQosServer;
import org.xmlBlaster.engine.queuemsg.MsgQueueHistoryEntry;
import org.xmlBlaster.engine.queuemsg.MsgQueueUpdateEntry;
import org.xmlBlaster.engine.queuemsg.ReferenceEntry;
import org.xmlBlaster.engine.queuemsg.TopicEntry;
import org.xmlBlaster.engine.runlevel.I_RunlevelListener;
import org.xmlBlaster.engine.xml2java.XmlKey;
import org.xmlBlaster.protocol.jdbc.NamedConnectionPool;
import org.xmlBlaster.protocol.jdbc.XmlDBAdapter;
import org.xmlBlaster.util.I_Timeout;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.SessionName;
import org.xmlBlaster.util.Timeout;
import org.xmlBlaster.util.Timestamp;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.admin.extern.JmxWrapper;
import org.xmlBlaster.util.cluster.RouteInfo;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.def.MethodName;
import org.xmlBlaster.util.key.KeyData;
import org.xmlBlaster.util.key.MsgKeyData;
import org.xmlBlaster.util.key.QueryKeyData;
import org.xmlBlaster.util.qos.AccessFilterQos;
import org.xmlBlaster.util.qos.MsgQosData;
import org.xmlBlaster.util.qos.QueryQosData;
import org.xmlBlaster.util.qos.StatusQosData;
import org.xmlBlaster.util.qos.TopicProperty;
import org.xmlBlaster.util.qos.address.Destination;
import org.xmlBlaster.util.qos.storage.HistoryQueueProperty;
import org.xmlBlaster.util.qos.storage.TopicStoreProperty;
import org.xmlBlaster.util.queue.I_Queue;
import org.xmlBlaster.util.queue.StorageId;
import org.xmlBlaster.util.queuemsg.MsgQueueEntry;

public final class RequestBroker
implements I_ClientListener,
RequestBrokerMBean,
I_RunlevelListener {
    private String ME = "RequestBroker";
    private final Global glob;
    private final LogChannel log;
    public static long publishedMessages = 0L;
    public static long getMessages = 0L;
    private PersistencePluginManager pluginManager = null;
    private Authenticate authenticate = null;
    private final Map messageContainerMap = new HashMap();
    private I_Map topicStore;
    private final SessionInfo unsecureSessionInfo;
    private final SessionName myselfLoginName;
    public static final String internalLoginNamePrefix = "__RequestBroker_internal";
    private final ClientSubscriptions clientSubscriptions;
    private final Set subscriptionListenerSet = Collections.synchronizedSet(new HashSet());
    private final Set messageEraseListenerSet = Collections.synchronizedSet(new HashSet());
    private BigXmlKeyDOM bigXmlKeyDOM = null;
    private boolean useOldStylePersistence;
    private boolean publishLoginEvent = true;
    private MsgKeyData xmlKeyLoginEvent = null;
    private PublishQos publishQosForEvents;
    private PublishQosServer publishQosLoginEvent;
    private boolean publishUserList = true;
    private MsgKeyData xmlKeyUserListEvent = null;
    private boolean publishLogoutEvent = true;
    private MsgKeyData xmlKeyLogoutEvent = null;
    private PublishQosServer publishQosLogoutEvent;
    private AccessPluginManager accessPluginManager = null;
    private PublishPluginManager publishPluginManager = null;
    private boolean useCluster = false;
    private long uptime;
    private long numUpdates = 0L;
    private int maxSessions;
    private static final int UNDEF = -1;
    private static final int ALIVE = 0;
    private int state = -1;

    public RequestBroker(Authenticate authenticate) throws XmlBlasterException {
        this.authenticate = authenticate;
        this.glob = this.authenticate.getGlobal();
        this.log = this.glob.getLog("core");
        this.glob.setRequestBroker(this);
        this.uptime = System.currentTimeMillis();
        this.useOldStylePersistence = this.glob.getProperty().get("useOldStylePersistence", false);
        if (this.useOldStylePersistence) {
            this.log.warn(this.ME, "Old style fielstorage is switched on which is deprecated (-useOldStylePersistence true).");
        }
        this.glob.getRunlevelManager().addRunlevelListener(this);
        this.myselfLoginName = new SessionName((org.xmlBlaster.util.Global)this.glob, this.glob.getNodeId(), "__RequestBroker_internal[" + this.glob.getId() + "]");
        this.initHelperQos();
        ConnectQos connectQos = new ConnectQos(this.glob);
        connectQos.setSessionName(this.myselfLoginName);
        connectQos.getSessionQos().setSessionTimeout(0L);
        this.unsecureSessionInfo = authenticate.unsecureCreateSession(connectQos);
        try {
            CommandManager manager = this.glob.getCommandManager(this.unsecureSessionInfo);
        }
        catch (XmlBlasterException e) {
            this.log.error(this.ME, e.toString());
        }
        this.useCluster = this.glob.useCluster();
        if (this.useCluster) {
            this.glob.getClusterManager(this.unsecureSessionInfo);
            this.ME = "RequestBroker" + this.glob.getLogPrefixDashed();
        }
        this.accessPluginManager = new AccessPluginManager(this.glob);
        this.publishPluginManager = new PublishPluginManager(this.glob);
        this.pluginManager = new PersistencePluginManager(this.glob);
        this.clientSubscriptions = new ClientSubscriptions(this.glob, this, authenticate);
        this.bigXmlKeyDOM = new BigXmlKeyDOM(this, authenticate);
        authenticate.addClientListener(this);
        try {
            JmxWrapper wr = this.glob.getJmxWrapper();
            if (wr != null) {
                this.log.info(this.ME, "Registering the RequestBroker into the jmx server");
                wr.register(this, "requestBroker");
            }
        }
        catch (XmlBlasterException e) {
            this.log.warn(this.ME, "Loading of JMX support failed: " + e.getMessage());
        }
        this.state = 0;
    }

    Authenticate getAuthenticate() {
        return this.authenticate;
    }

    private void initHelperQos() throws XmlBlasterException {
        PublishKey publishKey;
        PublishQos publishQos = new PublishQos(this.glob);
        publishQos.setLifeTime(-1L);
        publishQos.setForceUpdate(true);
        TopicProperty topicProperty = new TopicProperty(this.glob);
        HistoryQueueProperty historyQueueProperty = new HistoryQueueProperty(this.glob, this.glob.getId());
        historyQueueProperty.setMaxEntriesCache(2L);
        historyQueueProperty.setMaxEntries(2L);
        topicProperty.setHistoryQueueProperty(historyQueueProperty);
        publishQos.setTopicProperty(topicProperty);
        this.publishQosForEvents = publishQos;
        this.publishLoginEvent = this.glob.getProperty().get("loginEvent", true);
        if (this.publishLoginEvent) {
            publishKey = new PublishKey(this.glob, "__sys__Login", "text/plain");
            this.xmlKeyLoginEvent = publishKey.getData();
            this.publishQosLoginEvent = new PublishQosServer(this.glob, publishQos.getData().toXml(), false);
        }
        this.publishLogoutEvent = this.glob.getProperty().get("logoutEvent", true);
        if (this.publishLogoutEvent) {
            publishKey = new PublishKey(this.glob, "__sys__Logout", "text/plain");
            this.xmlKeyLogoutEvent = publishKey.getData();
            this.publishQosLogoutEvent = new PublishQosServer(this.glob, publishQos.getData().toXml(), false);
        }
        this.publishUserList = this.glob.getProperty().get("userListEvent", true);
        if (this.publishUserList) {
            publishKey = new PublishKey(this.glob, "__sys__UserList", "text/plain");
            publishKey.setClientTags("<__sys__internal/>");
            this.xmlKeyUserListEvent = publishKey.getData();
        }
    }

    public String getName() {
        return this.ME;
    }

    BigXmlKeyDOM getBigXmlKeyDOM() {
        return this.bigXmlKeyDOM;
    }

    public ClientSubscriptions getClientSubscriptions() {
        return this.clientSubscriptions;
    }

    public void runlevelChange(int from, int to, boolean force) throws XmlBlasterException {
        if (to == from) {
            return;
        }
        if (to > from && to == 2) {
            this.startupTopicStore();
        }
        if (to >= from || to == 0) {
            // empty if block
        }
    }

    public final Global getGlobal() {
        return this.glob;
    }

    public final LogChannel getLog() {
        return this.log;
    }

    I_Map getTopicStore() {
        return this.topicStore;
    }

    private void startupTopicStore() throws XmlBlasterException {
        boolean useTopicStore;
        boolean wipeOutJdbcDB;
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering startupTopicStore(), looking for persisted topics");
        }
        if (wipeOutJdbcDB = this.glob.getProperty().get("wipeOutJdbcDB", false)) {
            this.glob.setWipeOutDB(wipeOutJdbcDB);
        }
        if (!(useTopicStore = this.glob.getProperty().get("useTopicStore", true))) {
            this.log.warn(this.ME, "Persistent and recoverable topics are switched off with '-useTopicStore false', topics are handled RAM based only.");
            return;
        }
        RequestBroker requestBroker = this;
        synchronized (requestBroker) {
            TopicStoreProperty topicStoreProperty = new TopicStoreProperty(this.glob, this.glob.getStrippedId());
            if (this.topicStore == null) {
                String type = topicStoreProperty.getType();
                String version = topicStoreProperty.getVersion();
                StorageId topicStoreId = new StorageId("topicStore", this.glob.getStrippedId());
                this.topicStore = this.glob.getStoragePluginManager().getPlugin(type, version, topicStoreId, topicStoreProperty);
                this.log.info(this.ME, "Activated storage '" + this.topicStore.getStorageId() + "' for persistent topics, found " + this.topicStore.getNumOfEntries() + " topics to recover.");
                I_MapEntry[] mapEntryArr = this.topicStore.getAll();
                boolean fromPersistenceStore = true;
                int i = 0;
                while (i < mapEntryArr.length) {
                    TopicEntry topicEntry = (TopicEntry)mapEntryArr[i];
                    PublishQosServer publishQosServer = new PublishQosServer(this.glob, (MsgQosData)topicEntry.getMsgUnit().getQosData(), fromPersistenceStore);
                    publishQosServer.setTopicEntry(topicEntry);
                    try {
                        this.publish(this.unsecureSessionInfo, topicEntry.getMsgUnit(), publishQosServer);
                    }
                    catch (XmlBlasterException e) {
                        this.log.error(this.ME, "Restoring topic '" + topicEntry.getMsgUnit().getKeyOid() + "' from persistency failed: " + e.getMessage());
                    }
                    ++i;
                }
            } else {
                this.log.info(this.ME, "Reconfiguring topics store.");
                this.topicStore.setProperties(topicStoreProperty);
            }
        }
    }

    public final AccessPluginManager getAccessPluginManager() {
        return this.accessPluginManager;
    }

    public final PublishPluginManager getPublishPluginManager() {
        return this.publishPluginManager;
    }

    final SessionInfo getInternalSessionInfo() {
        return this.unsecureSessionInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] deadMessage(MsgQueueEntry[] entries, I_Queue queue, String reason) {
        int ii;
        if (this.log.CALL) {
            this.log.call(this.ME, "Publishing " + entries.length + " dead messages.");
        }
        if (entries == null) {
            this.log.error(this.ME, "deadMessage() with null argument");
            Thread.dumpStack();
            return new String[0];
        }
        try {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Publishing " + entries.length + " volatile dead messages");
            }
            String[] retArr = new String[entries.length];
            PublishQos pubQos = new PublishQos(this.glob);
            pubQos.setVolatile(true);
            int ii2 = 0;
            while (true) {
                block22: {
                    block25: {
                        MsgQueueEntry entry;
                        block24: {
                            if (ii2 >= entries.length) {
                                return retArr;
                            }
                            entry = entries[ii2];
                            if (entry != null) break block24;
                            this.log.error(this.ME, "Didn't expect null element in MsgQueueEntry[], ignoring it");
                            break block22;
                        }
                        MsgUnit origMsgUnit = null;
                        if (!(entry instanceof ReferenceEntry)) break block25;
                        ReferenceEntry referenceEntry = (ReferenceEntry)entry;
                        if (referenceEntry.isDestroyed()) {
                            if (this.log.TRACE) {
                                this.log.trace(this.ME, "Ignoring dead message for destroyed callback queue entry " + referenceEntry.getLogId());
                            }
                            break block22;
                        } else {
                            origMsgUnit = ((ReferenceEntry)entry).getMsgUnit();
                            try {
                                if (entry.getKeyOid().equals("__sys__deadMessage")) {
                                    this.log.error(this.ME, "PANIC: Recursive dead message is lost, no recovery possible - dumping to file not yet coded: " + origMsgUnit.toXml() + ": " + (reason != null ? ": " + reason : ""));
                                    retArr[ii2] = entry.getKeyOid();
                                    Thread.dumpStack();
                                    break block22;
                                }
                                if (origMsgUnit.getQosData().getClientProperties().get("__isErrorHandled") != null) {
                                    this.log.warn(this.ME, "Recursive message '" + entry.getLogId() + "' is error handled already (sent as dead letter), we ignore it.");
                                    retArr[ii2] = entry.getKeyOid();
                                    break block22;
                                }
                                origMsgUnit.getQosData().addClientProperty("__isErrorHandled", true);
                                this.log.warn(this.ME, "Generating dead message '" + entry.getLogId() + "'" + " from publisher=" + entry.getSender() + " because delivery with queue '" + (queue == null ? "null" : queue.getStorageId().toString()) + "' failed" + (reason != null ? ": " + reason : ""));
                                PublishKey publishKey = new PublishKey((org.xmlBlaster.util.Global)this.glob, "__sys__deadMessage");
                                publishKey.setClientTags("<oid>" + entry.getKeyOid() + "</oid>");
                                pubQos.addClientProperty("__key", origMsgUnit.getKey());
                                pubQos.addClientProperty("__qos", origMsgUnit.getQos());
                                pubQos.addClientProperty("__oid", origMsgUnit.getKeyOid());
                                pubQos.addClientProperty("__rcvTimestamp", origMsgUnit.getQosData().getRcvTimestamp());
                                MsgUnit msgUnit = new MsgUnit(origMsgUnit, publishKey.getData(), null, pubQos.getData());
                                retArr[ii2] = this.publish(this.unsecureSessionInfo, msgUnit);
                            }
                            catch (Throwable e) {
                                this.log.error(this.ME, "PANIC: " + entry.getKeyOid() + " dead letter is lost, no recovery possible - dumping to file not yet coded: " + e.toString() + "\n" + origMsgUnit.toXml());
                                e.printStackTrace();
                                retArr[ii2] = entry.getKeyOid();
                            }
                        }
                        break block22;
                    }
                    this.log.error(this.ME, "PANIC: Internal error in deadMessage data type");
                    retArr[ii2] = "PANIC";
                }
                ++ii2;
            }
        }
        catch (Throwable e) {
            this.log.error(this.ME, "PANIC: " + entries.length + " dead letters are lost, no recovery possible:" + e.getMessage());
            ii = 0;
        }
        while (true) {
            block23: {
                if (ii >= entries.length) {
                    return new String[0];
                }
                MsgQueueEntry entry = entries[ii];
                try {
                    if (entry == null) break block23;
                    if (entry instanceof MsgQueueHistoryEntry) {
                        this.log.warn(this.ME, "History entry is lost: " + entry.toXml());
                        break block23;
                    }
                    if (entry instanceof MsgQueueUpdateEntry) {
                        ReferenceEntry referenceEntry = (ReferenceEntry)entry;
                        if (referenceEntry.isDestroyed()) {
                            if (this.log.TRACE) {
                                this.log.trace(this.ME, "Ignoring detroyed callback message " + entry.getLogId());
                            }
                            break block23;
                        }
                        this.log.warn(this.ME, "Callback of message failed unrecoverably: " + entry.toXml());
                        break block23;
                    }
                    this.log.error(this.ME, "PANIC: Unrecoverable lost message " + entry.toXml());
                }
                catch (Throwable th) {
                    this.log.error(this.ME, "PANIC: Unrecoverable lost message " + entry.toXml() + ": " + th.getMessage());
                }
            }
            ++ii;
        }
    }

    public void setClientAttributes(String clientName, String xmlAttr_literal, String qos_literal) throws XmlBlasterException {
        this.log.warn(this.ME, "setting client attributes is not yet supported: " + xmlAttr_literal);
    }

    String subscribe(SessionInfo sessionInfo, QueryKeyData xmlKey, SubscribeQosServer subscribeQos) throws XmlBlasterException {
        if (!sessionInfo.hasCallback()) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_SUBSCRIBE_NOCALLBACK, this.ME, "You can't subscribe to '" + xmlKey.getOid() + "' without having a callback server");
        }
        try {
            Vector vec;
            if (this.log.CALL) {
                this.log.call(this.ME, "Entering subscribe(oid='" + xmlKey.getOid() + "', queryType='" + xmlKey.getQueryType() + "', query='" + xmlKey.getQueryString() + "', domain='" + xmlKey.getDomain() + "') from client '" + sessionInfo.getLoginName() + "' ...");
            }
            String returnOid = "";
            if (!subscribeQos.getMultiSubscribe() && (vec = this.clientSubscriptions.getSubscriptionByOid(sessionInfo, xmlKey.getOid(), false)) != null && vec.size() > 0) {
                this.log.warn(this.ME, "Ignoring duplicate subscription '" + xmlKey.getOid() + "' as you have set multiSubscribe to false");
                StatusQosData qos = new StatusQosData(this.glob, MethodName.SUBSCRIBE);
                SubscriptionInfo i = (SubscriptionInfo)vec.elementAt(0);
                qos.setState("WARNING");
                qos.setSubscriptionId(i.getSubscriptionId());
                return qos.toXml();
            }
            SubscriptionInfo subsQuery = null;
            if (xmlKey.isQuery()) {
                subsQuery = new SubscriptionInfo(this.glob, sessionInfo, xmlKey, subscribeQos);
                returnOid = subsQuery.getSubscriptionId();
                this.fireSubscribeEvent(subsQuery);
            }
            KeyData[] keyDataArr = this.queryMatchingKeys(sessionInfo, xmlKey, subscribeQos.getData());
            int jj = 0;
            while (jj < keyDataArr.length) {
                Vector vec2;
                KeyData xmlKeyExact = keyDataArr[jj];
                if (xmlKeyExact == null && xmlKey.isExact()) {
                    xmlKeyExact = xmlKey;
                }
                SubscriptionInfo subs = null;
                if (!sessionInfo.getConnectQos().duplicateUpdates() && (vec2 = this.clientSubscriptions.getSubscriptionByOid(sessionInfo, xmlKeyExact.getOid(), true)) != null) {
                    if (vec2.size() > 0) {
                        subs = (SubscriptionInfo)vec2.firstElement();
                        if (this.log.TRACE) {
                            this.log.trace(this.ME, "Session '" + sessionInfo.getId() + "', message '" + xmlKeyExact.getOid() + "' is subscribed " + vec2.size() + " times with duplicateUpdates==false");
                        }
                    }
                    if (vec2.size() > 1) {
                        this.log.error(this.ME, "Internal problem for session '" + sessionInfo.getId() + "', message '" + xmlKeyExact.getOid() + "' is subscribed " + vec2.size() + " times but duplicateUpdates==false!");
                    }
                }
                if (subs == null) {
                    if (subsQuery != null) {
                        subs = new SubscriptionInfo(this.glob, sessionInfo, subsQuery, xmlKeyExact);
                        subsQuery.addSubscription(subs);
                    } else {
                        subs = new SubscriptionInfo(this.glob, sessionInfo, xmlKeyExact, subscribeQos);
                    }
                }
                this.subscribeToOid(subs, false);
                if (returnOid.equals("")) {
                    returnOid = subs.getSubscriptionId();
                }
                ++jj;
            }
            StatusQosData qos = null;
            if (this.useCluster) {
                try {
                    subscribeQos.setSubscriptionId(returnOid);
                    SubscribeReturnQos ret = this.glob.getClusterManager().forwardSubscribe(sessionInfo, xmlKey, subscribeQos);
                    if (ret != null) {
                        qos = ret.getData();
                    }
                }
                catch (XmlBlasterException e) {
                    if (e.getErrorCode() == ErrorCode.RESOURCE_CONFIGURATION_PLUGINFAILED) {
                        this.useCluster = false;
                    }
                    e.printStackTrace();
                    throw e;
                }
            }
            if (qos == null || qos.getSubscriptionId() == null || qos.getSubscriptionId().length() < 1) {
                if (qos == null) {
                    qos = new StatusQosData(this.glob, MethodName.SUBSCRIBE);
                }
                qos.setSubscriptionId(returnOid);
            }
            if (this.log.CALL) {
                this.log.call(this.ME, "Leaving subscribe(oid='" + xmlKey.getOid() + "', queryType='" + xmlKey.getQueryType() + "', query='" + xmlKey.getQueryString() + "', domain='" + xmlKey.getDomain() + "') from client '" + sessionInfo.getLoginName() + "' -> subscriptionId='" + qos.getSubscriptionId() + "'");
            }
            return qos.toXml();
        }
        catch (XmlBlasterException e) {
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw XmlBlasterException.convert(this.glob, this.ME, ErrorCode.INTERNAL_SUBSCRIBE.toString(), e);
        }
    }

    public MsgUnit[] get(SessionInfo sessionInfo, QueryKeyData xmlKey, GetQosServer getQos) throws XmlBlasterException {
        try {
            if (this.log.CALL) {
                this.log.call(this.ME, "Entering get(oid='" + xmlKey.getOid() + "', queryType='" + xmlKey.getQueryType() + "', query='" + xmlKey.getQueryString() + "') ...");
            }
            if ("__refresh".equals(xmlKey.getOid())) {
                return new MsgUnit[0];
            }
            if (xmlKey.isAdministrative()) {
                if (!this.glob.supportAdministrative()) {
                    throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_ADMIN_UNAVAILABLE, this.ME, "Sorry administrative get() is not available, try to configure xmlBlaster.");
                }
                MsgUnit[] raw = this.glob.getMomClientGateway().getCommand(sessionInfo, xmlKey, getQos.getData());
                if (getQos.getWantContent()) {
                    return raw;
                }
                MsgUnit[] msgUnitArr = new MsgUnit[raw.length];
                int i = 0;
                while (i < raw.length) {
                    msgUnitArr[i] = new MsgUnit(raw[i], null, new byte[0], null);
                    ++i;
                }
                return msgUnitArr;
            }
            if ("__sys__jdbc".equals(xmlKey.getOid())) {
                XmlDBAdapter adap = new XmlDBAdapter(this.glob, xmlKey.getQueryString().getBytes(), (NamedConnectionPool)this.glob.getObjectEntry("NamedConnectionPool-" + this.glob.getId()));
                return adap.query();
            }
            KeyData[] keyDataArr = this.queryMatchingKeys(sessionInfo, xmlKey, getQos.getData());
            ArrayList<MsgUnit> msgUnitList = new ArrayList<MsgUnit>(keyDataArr.length);
            if (this.useCluster) {
                try {
                    MsgUnit[] tmp = this.glob.getClusterManager().forwardGet(sessionInfo, xmlKey, getQos);
                    if (tmp != null && tmp.length > 0) {
                        this.log.info(this.ME, "get() access of " + tmp.length + " messages from cluster master");
                        int jj = 0;
                        while (jj < tmp.length) {
                            msgUnitList.add(tmp[jj]);
                            ++jj;
                        }
                    }
                }
                catch (XmlBlasterException e) {
                    if (e.getErrorCode() == ErrorCode.RESOURCE_CONFIGURATION_PLUGINFAILED) {
                        this.useCluster = false;
                    }
                    e.printStackTrace();
                    throw e;
                }
            }
            int ii = 0;
            while (ii < keyDataArr.length) {
                block37: {
                    TopicHandler topicHandler;
                    KeyData xmlKeyExact = keyDataArr[ii];
                    if (xmlKeyExact == null && xmlKey.isExact()) {
                        xmlKeyExact = xmlKey;
                    }
                    if ((topicHandler = this.getMessageHandlerFromOid(xmlKeyExact.getOid())) == null) {
                        block36: {
                            if (this.useCluster) {
                                try {
                                    MsgUnit[] tmp = this.glob.getClusterManager().forwardGet(sessionInfo, xmlKey, getQos);
                                    if (tmp == null || tmp.length <= 0) break block36;
                                    this.log.info(this.ME, "get() access of " + tmp.length + " messages from cluster master");
                                    int jj = 0;
                                    while (jj < tmp.length) {
                                        msgUnitList.add(tmp[jj]);
                                        ++jj;
                                    }
                                    break block37;
                                }
                                catch (XmlBlasterException e) {
                                    if (e.getErrorCode() == ErrorCode.RESOURCE_CONFIGURATION_PLUGINFAILED) {
                                        this.useCluster = false;
                                    }
                                    e.printStackTrace();
                                    throw e;
                                }
                            }
                        }
                        this.log.warn(this.ME, "get(): The key '" + xmlKeyExact.getOid() + "' is not available.");
                    } else if (topicHandler.isAlive()) {
                        int numEntries = getQos.getHistoryQos().getNumEntries();
                        MsgUnitWrapper[] msgUnitWrapperArr = topicHandler.getMsgUnitWrapperArr(numEntries, getQos.getHistoryQos().getNewestFirst());
                        int kk = 0;
                        while (kk < msgUnitWrapperArr.length) {
                            MsgUnitWrapper msgUnitWrapper = msgUnitWrapperArr[kk];
                            if (msgUnitWrapper != null) {
                                MsgUnit mm;
                                AccessFilterQos[] filterQos = getQos.getAccessFilterArr();
                                if (filterQos != null) {
                                    if (this.log.TRACE) {
                                        this.log.trace(this.ME, "Checking " + filterQos.length + " filters");
                                    }
                                    int jj = 0;
                                    while (jj < filterQos.length) {
                                        I_AccessFilter filter = this.getAccessPluginManager().getAccessFilter(filterQos[jj].getType(), filterQos[jj].getVersion(), xmlKey.getContentMime(), xmlKey.getContentMimeExtended());
                                        if (this.log.TRACE) {
                                            this.log.trace(this.ME, "get(" + xmlKeyExact.getOid() + ") filter=" + filter + " qos=" + getQos.toXml());
                                        }
                                        if (filter == null || filter.match(sessionInfo, msgUnitWrapper.getMsgUnit(), filterQos[jj].getQuery())) {
                                            ++jj;
                                            continue;
                                        }
                                        break;
                                    }
                                } else if (msgUnitWrapper != null && !msgUnitWrapper.isExpired() && (mm = msgUnitWrapper.getMsgUnit()) != null) {
                                    GetReturnQosServer retQos = new GetReturnQosServer(this.glob, msgUnitWrapper.getMsgQosData(), "OK");
                                    byte[] cont = getQos.getWantContent() ? mm.getContent() : new byte[]{};
                                    mm = new MsgUnit(mm, null, cont, retQos.getData());
                                    msgUnitList.add(mm);
                                }
                            }
                            ++kk;
                        }
                    }
                }
                ++ii;
            }
            MsgUnit[] msgUnitArr = msgUnitList.toArray(new MsgUnit[msgUnitList.size()]);
            getMessages += (long)msgUnitArr.length;
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Returning for get() " + msgUnitArr.length + " messages");
            }
            return msgUnitArr;
        }
        catch (XmlBlasterException e) {
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw XmlBlasterException.convert(this.glob, this.ME, ErrorCode.INTERNAL_GET.toString(), e);
        }
    }

    public void updateInternalUserList() throws XmlBlasterException {
        if (this.publishUserList && this.state == 0) {
            PublishQosServer publishQosUserListEvent = new PublishQosServer(this.glob, this.publishQosForEvents.getData().toXml(), false);
            MsgUnit msgUnit = new MsgUnit(this.xmlKeyUserListEvent, this.authenticate.getSubjectList().getBytes(), publishQosUserListEvent.getData());
            this.publish(this.unsecureSessionInfo, msgUnit);
            publishQosUserListEvent.getData().setTopicProperty(null);
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Refreshed internal state for '" + this.xmlKeyUserListEvent.getOid() + "'");
            }
        }
    }

    private KeyData[] queryMatchingKeys(SessionInfo sessionInfo, QueryKeyData queryKeyData, QueryQosData qos) throws XmlBlasterException {
        String clientName = sessionInfo.toString();
        if (queryKeyData.isQuery()) {
            ArrayList oidList = this.bigXmlKeyDOM.parseKeyOid(sessionInfo, queryKeyData.getQueryString(), qos);
            ArrayList<MsgKeyData> strippedList = new ArrayList<MsgKeyData>();
            int i = 0;
            while (i < oidList.size()) {
                MsgKeyData keyData;
                TopicHandler topicHandler = this.getMessageHandlerFromOid((String)oidList.get(i));
                if (topicHandler != null && (keyData = topicHandler.getMsgKeyData()) != null) {
                    strippedList.add(keyData);
                }
                ++i;
            }
            return strippedList.toArray(new KeyData[strippedList.size()]);
        }
        if (queryKeyData.isExact()) {
            TopicHandler topicHandler;
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Access Client " + clientName + " with EXACT oid='" + queryKeyData.getOid() + "'");
            }
            if ((topicHandler = this.getMessageHandlerFromOid(queryKeyData.getOid())) == null || topicHandler.getMsgKeyData() == null) {
                return new KeyData[]{null};
            }
            return new KeyData[]{queryKeyData};
        }
        if (queryKeyData.isDomain()) {
            String domain = queryKeyData.getDomain();
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Access Client " + clientName + " with DOMAIN domain='" + domain + "'");
            }
            if (domain == null) {
                this.log.warn(this.ME, "The DOMAIN query has a domain=null, no topics found");
                return new KeyData[0];
            }
            TopicHandler[] topics = this.getTopicHandlerArr();
            ArrayList<MsgKeyData> strippedList = new ArrayList<MsgKeyData>();
            int i = 0;
            while (i < topics.length) {
                TopicHandler topicHandler = topics[i];
                if (topicHandler.getMsgKeyData() != null && domain.equals(topicHandler.getMsgKeyData().getDomain())) {
                    strippedList.add(topicHandler.getMsgKeyData());
                }
                ++i;
            }
            return strippedList.toArray(new KeyData[strippedList.size()]);
        }
        this.log.warn(this.ME + ".UnsupportedQueryType", "Sorry, can't access, query syntax is unknown: " + queryKeyData.getQueryType());
        throw new XmlBlasterException(this.glob, ErrorCode.USER_QUERY_TYPE_INVALID, this.ME, "Sorry, can't access, query syntax is unknown: " + queryKeyData.getQueryType());
    }

    private TopicHandler[] queryMatchingTopics(SessionInfo sessionInfo, QueryKeyData queryKeyData, QueryQosData qos) throws XmlBlasterException {
        String clientName = sessionInfo.toString();
        if (queryKeyData.isQuery()) {
            ArrayList oidList = this.bigXmlKeyDOM.parseKeyOid(sessionInfo, queryKeyData.getQueryString(), qos);
            ArrayList<TopicHandler> strippedList = new ArrayList<TopicHandler>();
            int i = 0;
            while (i < oidList.size()) {
                TopicHandler topicHandler = this.getMessageHandlerFromOid((String)oidList.get(i));
                if (topicHandler != null) {
                    strippedList.add(topicHandler);
                }
                ++i;
            }
            return strippedList.toArray(new TopicHandler[strippedList.size()]);
        }
        if (queryKeyData.isExact()) {
            TopicHandler topicHandler;
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Access Client " + clientName + " with EXACT oid='" + queryKeyData.getOid() + "'");
            }
            if ((topicHandler = this.getMessageHandlerFromOid(queryKeyData.getOid())) == null) {
                return new TopicHandler[]{null};
            }
            return new TopicHandler[]{topicHandler};
        }
        if (queryKeyData.isDomain()) {
            String domain = queryKeyData.getDomain();
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Access Client " + clientName + " with DOMAIN domain='" + domain + "'");
            }
            if (domain == null) {
                this.log.warn(this.ME, "The DOMAIN query has a domain=null, no topics found");
                return new TopicHandler[0];
            }
            TopicHandler[] topics = this.getTopicHandlerArr();
            ArrayList<TopicHandler> strippedList = new ArrayList<TopicHandler>();
            int i = 0;
            while (i < topics.length) {
                TopicHandler topicHandler = topics[i];
                if (domain.equals(topicHandler.getMsgKeyData().getDomain())) {
                    strippedList.add(topicHandler);
                }
                ++i;
            }
            return strippedList.toArray(new TopicHandler[strippedList.size()]);
        }
        this.log.warn(this.ME + ".UnsupportedQueryType", "Sorry, can't access, query syntax is unknown: " + queryKeyData.getQueryType());
        throw new XmlBlasterException(this.glob, ErrorCode.USER_QUERY_TYPE_INVALID, this.ME, "Sorry, can't access, query syntax is unknown: " + queryKeyData.getQueryType());
    }

    public final TopicHandler getMessageHandlerFromOid(String oid) {
        Map map = this.messageContainerMap;
        synchronized (map) {
            Object obj = this.messageContainerMap.get(oid);
            if (obj == null) {
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "getMessageHandlerFromOid(): key oid " + oid + " is unknown, topicHandler == null");
                }
                TopicHandler topicHandler = null;
                return topicHandler;
            }
            TopicHandler topicHandler = (TopicHandler)obj;
            return topicHandler;
        }
    }

    public final TopicHandler[] getTopicHandlerArr() {
        Map map = this.messageContainerMap;
        synchronized (map) {
            TopicHandler[] topicHandlerArray = this.messageContainerMap.values().toArray(new TopicHandler[this.messageContainerMap.size()]);
            return topicHandlerArray;
        }
    }

    public final int addPersistentTopicHandler(TopicEntry topicEntry) throws XmlBlasterException {
        if (this.topicStore != null) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Persisting topicEntry");
            }
            return this.topicStore.put(topicEntry);
        }
        return 0;
    }

    public final int removePersistentTopicHandler(TopicEntry topicEntry) throws XmlBlasterException {
        if (this.topicStore != null) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Removing persisting topicEntry");
            }
            return this.topicStore.remove(topicEntry);
        }
        return 0;
    }

    public final TopicHandler addTopicHandler(TopicHandler topicHandler) {
        Map map = this.messageContainerMap;
        synchronized (map) {
            TopicHandler topicHandler2 = this.messageContainerMap.put(topicHandler.getUniqueKey(), topicHandler);
            return topicHandler2;
        }
    }

    void messageErase(TopicHandler topicHandler) throws XmlBlasterException {
        if (topicHandler.hasExactSubscribers()) {
            this.log.warn(this.ME, "Erase event occured for oid=" + topicHandler.getUniqueKey() + ", " + topicHandler.numSubscribers() + " subscribers exist ...");
        }
        String uniqueKey = topicHandler.getUniqueKey();
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Erase event occured for oid=" + uniqueKey + ", removing message from my map ...");
        }
        Map map = this.messageContainerMap;
        synchronized (map) {
            Object obj = this.messageContainerMap.remove(uniqueKey);
            if (obj == null) {
                this.log.warn(this.ME + ".NotRemoved", "Sorry, can't remove message unit, because it didn't exist: " + uniqueKey);
                throw new XmlBlasterException(this.glob, ErrorCode.USER_OID_UNKNOWN, this.ME, "Sorry, can't remove message unit, because oid=" + uniqueKey + " doesn't exist");
            }
        }
    }

    private void subscribeToOid(SubscriptionInfo subs, boolean calleeIsXPathMatchCheck) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering subscribeToOid(subId=" + subs.getSubscriptionId() + ", oid=" + subs.getKeyData().getOid() + ", queryType=" + subs.getKeyData().getQueryType() + ") ...");
        }
        String uniqueKey = subs.getKeyData().getOid();
        TopicHandler topicHandler = null;
        Map map = this.messageContainerMap;
        synchronized (map) {
            Object obj = this.messageContainerMap.get(uniqueKey);
            topicHandler = obj == null ? new TopicHandler(this, uniqueKey) : (TopicHandler)obj;
        }
        subs.incrSubscribeCounter();
        this.fireSubscribeEvent(subs);
        topicHandler.addSubscriber(subs, calleeIsXPathMatchCheck);
    }

    String[] unSubscribe(SessionInfo sessionInfo, QueryKeyData xmlKey, UnSubscribeQosServer unSubscribeQos) throws XmlBlasterException {
        try {
            int ii;
            if (this.log.CALL) {
                this.log.call(this.ME, "Entering unSubscribe(oid='" + xmlKey.getOid() + "', queryType='" + xmlKey.getQueryType() + "', query='" + xmlKey.getQueryString() + "', domain='" + xmlKey.getDomain() + "') ...");
            }
            if (this.useCluster) {
                try {
                    UnSubscribeReturnQos[] ret = this.glob.getClusterManager().forwardUnSubscribe(sessionInfo, xmlKey, unSubscribeQos);
                    if (ret != null) {
                        this.log.info(this.ME, "unSubscribe of '" + xmlKey.getNiceString() + "' matched " + ret.length + " entries in remote cluster");
                    }
                }
                catch (XmlBlasterException e) {
                    if (e.getErrorCode() == ErrorCode.RESOURCE_CONFIGURATION_PLUGINFAILED) {
                        this.log.warn(this.ME, "unSubscribe of '" + xmlKey.getNiceString() + "' entries in remote cluster: " + e.getMessage());
                        this.useCluster = false;
                    }
                    this.log.warn(this.ME, "unSubscribe of '" + xmlKey.getNiceString() + "' in remote cluster: " + e.getMessage());
                    e.printStackTrace();
                    throw e;
                }
            }
            HashSet<String> subscriptionIdSet = new HashSet<String>();
            String id = xmlKey.getOid();
            if (SubscriptionInfo.isSubscribeId(id)) {
                SubscriptionInfo subs = this.clientSubscriptions.getSubscription(sessionInfo, xmlKey.getOid());
                if (subs != null) {
                    Vector childs = subs.getChildrenSubscriptions();
                    if (childs != null) {
                        if (this.log.TRACE) {
                            this.log.trace(this.ME, "unSubscribe() Traversing " + childs.size() + " childs");
                        }
                        ii = 0;
                        while (ii < childs.size()) {
                            SubscriptionInfo so = (SubscriptionInfo)childs.elementAt(ii);
                            this.fireUnSubscribeEvent(so);
                            subscriptionIdSet.add(so.getSubscriptionId());
                            so = null;
                            ++ii;
                        }
                    }
                    this.fireUnSubscribeEvent(subs);
                    subscriptionIdSet.add(subs.getSubscriptionId());
                    subs = null;
                } else {
                    this.log.warn(this.ME, "UnSubscribe of " + xmlKey.getOid() + " failed");
                    if (this.log.DUMP) {
                        this.log.dump(this.ME, this.toXml());
                    }
                }
            } else {
                String suppliedXmlKey = xmlKey.getOid();
                TopicHandler[] topicHandlerArr = this.queryMatchingTopics(sessionInfo, xmlKey, unSubscribeQos.getData());
                ii = 0;
                while (ii < topicHandlerArr.length) {
                    TopicHandler topicHandler = topicHandlerArr[ii];
                    if (topicHandler == null) {
                        this.log.warn(this.ME, "UnSubscribe on unknown topic [" + xmlKey.getOid() + "] is ignored");
                    } else {
                        Vector subs = topicHandler.findSubscriber(sessionInfo);
                        int jj = 0;
                        while (subs != null && jj < subs.size()) {
                            SubscriptionInfo sub = (SubscriptionInfo)subs.elementAt(jj);
                            if (sub != null) {
                                this.fireUnSubscribeEvent(sub);
                                subscriptionIdSet.add(sub.getSubscriptionId());
                            } else {
                                this.log.warn(this.ME, "UnSubscribe of " + topicHandler.getId() + " failed");
                            }
                            ++jj;
                        }
                    }
                    ++ii;
                }
                if (topicHandlerArr.length < 1) {
                    this.log.error(this.ME + ".OidUnknown2", "Can't access subscription, unSubscribe failed, your supplied key oid '" + suppliedXmlKey + "' is invalid");
                    throw new XmlBlasterException(this.glob, ErrorCode.USER_OID_UNKNOWN, this.ME, "Can't access subscription, unSubscribe failed, your supplied key oid '" + suppliedXmlKey + "' is invalid");
                }
            }
            String[] oidArr = new String[subscriptionIdSet.size()];
            StatusQosData qos = new StatusQosData(this.glob, MethodName.UNSUBSCRIBE);
            qos.setState("OK");
            Iterator it = subscriptionIdSet.iterator();
            int ii2 = 0;
            while (it.hasNext()) {
                qos.setSubscriptionId((String)it.next());
                oidArr[ii2++] = qos.toXml();
            }
            return oidArr;
        }
        catch (XmlBlasterException e) {
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw XmlBlasterException.convert(this.glob, this.ME, ErrorCode.INTERNAL_UNSUBSCRIBE.toString(), e);
        }
    }

    public final String update(SessionInfo sessionInfo, UpdateKey updateKey, byte[] content, MsgQosData msgQosData) throws XmlBlasterException {
        if (msgQosData.isErased()) {
            EraseQosServer qos;
            QueryKeyData key = this.glob.getQueryKeyFactory().readObject(updateKey.toXml());
            String[] ret = this.erase(sessionInfo, key, qos = new EraseQosServer((org.xmlBlaster.util.Global)this.glob, "<qos/>"), true);
            if (ret != null && ret.length > 0) {
                return ret[0];
            }
            return "<qos/>";
        }
        PublishQosServer qos = new PublishQosServer(this.glob, msgQosData);
        MsgUnit msgUnit = new MsgUnit(updateKey.getData(), content, qos.getData());
        return this.publish(sessionInfo, msgUnit, true);
    }

    private String[] publish(SessionInfo sessionInfo, MsgUnit[] msgUnitArr) throws XmlBlasterException {
        String[] retArr = new String[msgUnitArr.length];
        int ii = 0;
        while (ii < msgUnitArr.length) {
            retArr[ii] = this.publish(sessionInfo, msgUnitArr[ii]);
            ++ii;
        }
        return retArr;
    }

    public final String publish(SessionInfo sessionInfo, MsgUnit msgUnit) throws XmlBlasterException {
        return this.publish(sessionInfo, msgUnit, false);
    }

    private final String publish(SessionInfo sessionInfo, MsgUnit msgUnit, boolean isClusterUpdate) throws XmlBlasterException {
        PublishQosServer publishQosServer = new PublishQosServer(this.glob, msgUnit.getQosData());
        publishQosServer.setClusterUpdate(isClusterUpdate);
        return this.publish(sessionInfo, msgUnit, publishQosServer);
    }

    /*
     * Unable to fully structure code
     */
    private final String publish(SessionInfo sessionInfo, MsgUnit msgUnit, PublishQosServer publishQos) throws XmlBlasterException {
        try {
            block35: {
                if (msgUnit == null) {
                    this.log.error(this.ME + ".InvalidArguments", "The arguments of method publish() are invalid (null)");
                    throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME, "The arguments of method publish() are invalid (null)");
                }
                msgKeyData = (MsgKeyData)msgUnit.getKeyData();
                if (this.log.CALL) {
                    this.log.call(this.ME, "Entering " + (publishQos.isClusterUpdate() != false ? "cluster update message " : "") + "publish(oid='" + msgKeyData.getOid() + "', contentMime='" + msgKeyData.getContentMime() + "', contentMimeExtended='" + msgKeyData.getContentMimeExtended() + "' domain='" + msgKeyData.getDomain() + "' from client '" + sessionInfo.getId() + "' ...");
                }
                if (this.log.DUMP) {
                    this.log.dump(this.ME, "Receiving " + (publishQos.isClusterUpdate() != false ? "cluster update " : "") + " message in publish()\n" + msgUnit.toXml("", 80) + "\n" + publishQos.toXml() + "\nfrom\n" + sessionInfo.toXml());
                }
                publishReturnQos = null;
                if (!publishQos.isFromPersistenceStore()) {
                    if (publishQos.getSender() == null) {
                        publishQos.setSender(sessionInfo.getSessionName());
                    }
                    if (!this.myselfLoginName.getLoginName().equals(sessionInfo.getSessionName().getLoginName())) {
                        hopCount = publishQos.count(this.glob.getNodeId());
                        if (hopCount > 0) {
                            text = "Warning, message oid='" + msgKeyData.getOid() + "' passed my node id='" + this.glob.getId() + "' " + hopCount + " times before, we have a circular routing problem " + " mySelf=" + this.myselfLoginName.getAbsoluteName() + " sessionName=" + sessionInfo.getSessionName().getAbsoluteName();
                            if (publishQos.isPtp() && publishQos.getDestinationArr().length > 0) {
                                text = text + ", does the destination cluster node '" + publishQos.getDestinationArr()[0].getDestination() + "' exist?";
                            }
                            this.log.warn(this.ME, text);
                            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CLUSTER_CIRCULARLOOP, this.ME, text + " Your QoS:" + publishQos.toXml(""));
                        }
                        stratum = -1;
                        publishQos.addRouteInfo(new RouteInfo(this.glob.getNodeId(), stratum, publishQos.getRcvTimestamp()));
                    }
                }
                ++RequestBroker.publishedMessages;
                if (msgKeyData.isAdministrative()) {
                    if (!this.glob.supportAdministrative()) {
                        throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_ADMIN_UNAVAILABLE, this.ME, "Sorry administrative publish() is not available, try to configure xmlBlaster.");
                    }
                    return this.glob.getMomClientGateway().setCommand(sessionInfo, msgKeyData, msgUnit, publishQos, publishQos.isClusterUpdate());
                }
                if (this.getPublishPluginManager().hasPlugins() && !publishQos.isClusterUpdate() && (mimePlugins = this.getPublishPluginManager().findMimePlugins(msgKeyData.getContentMime(), msgKeyData.getContentMimeExtended())) != null) {
                    iterator = mimePlugins.values().iterator();
                    while (iterator.hasNext()) {
                        plugin = (I_PublishFilter)iterator.next();
                        if (this.log.TRACE) {
                            this.log.trace(this.ME, "Message " + msgKeyData.getOid() + " is forwarded to publish plugin");
                        }
                        if ((ret = plugin.intercept(sessionInfo.getSubjectInfo(), msgUnit)) == null || ret.length() == 0 || ret.equals("OK")) continue;
                        if (this.log.TRACE) {
                            this.log.trace(this.ME, "Message " + msgKeyData.getOid() + " is rejected by PublishPlugin");
                        }
                        return "<qos><state id='" + ret + "'/></qos>";
                    }
                }
                if (!this.useCluster || publishQos.isClusterUpdate()) break block35;
                if (!this.glob.getClusterManager().isReady()) ** GOTO lbl69
                if (publishQos.isPtp()) {
                    destinationArr = publishQos.getDestinationArr();
                    ii = 0;
                    while (ii < destinationArr.length) {
                        if (this.log.TRACE) {
                            this.log.trace(this.ME, "Working on PtP message for destination [" + destinationArr[ii].getDestination() + "]");
                        }
                        if ((publishReturnQos = this.forwardPtpPublish(sessionInfo, msgUnit, publishQos.isClusterUpdate(), destinationArr[ii])) != null) {
                            publishQos.removeDestination(destinationArr[ii]);
                        }
                        ++ii;
                    }
                    if (publishQos.getNumDestinations() == 0) {
                        return publishReturnQos.toXml();
                    }
                } else {
                    try {
                        ret = this.glob.getClusterManager().forwardPublish(sessionInfo, msgUnit);
                        if (ret != null) {
                            publishReturnQos = ret.getPublishReturnQos();
                            if (!ret.getNodeDomainInfo().getDirtyRead()) {
                                if (this.log.TRACE) {
                                    this.log.trace(this.ME, "Message " + msgKeyData.getOid() + " forwarded to master " + ret.getNodeDomainInfo().getId() + ", dirtyRead==false nothing more to do");
                                }
                                return publishReturnQos.toXml();
                            }
                        }
                        break block35;
                    }
                    catch (XmlBlasterException e) {
                        if (e.getErrorCode() == ErrorCode.RESOURCE_CONFIGURATION_PLUGINFAILED) {
                            this.useCluster = false;
                            break block35;
                        }
                        e.printStackTrace();
                        throw e;
                    }
lbl69:
                    // 1 sources

                    if (!publishQos.isFromPersistenceStore()) {
                        this.log.warn(this.ME, "Cluster manager is not ready, handling message '" + msgKeyData.getOid() + "' locally");
                    }
                }
            }
            topicHandler = null;
            var7_18 = this.messageContainerMap;
            synchronized (var7_18) {
                obj = this.messageContainerMap.get(msgKeyData.getOid());
                topicHandler = obj == null ? new TopicHandler(this, sessionInfo, msgUnit.getKeyOid()) : (TopicHandler)obj;
            }
            publishReturnQos = topicHandler.publish(sessionInfo, msgUnit, publishQos);
            if (publishReturnQos == null) {
                qos = new StatusQosData(this.glob, MethodName.PUBLISH);
                qos.setKeyOid(msgKeyData.getOid());
                qos.setState("OK");
                publishReturnQos = new PublishReturnQos((org.xmlBlaster.util.Global)this.glob, qos);
                publishReturnQos.getData().setRcvTimestamp(publishQos.getRcvTimestamp());
                this.log.error(this.ME, "Internal: did not excpect to build a PublishReturnQos, but message '" + msgKeyData.getOid() + "' is processed correctly");
                Thread.dumpStack();
            }
            return publishReturnQos.toXml();
        }
        catch (XmlBlasterException e) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Throwing exception in publish: " + e.toXml());
            }
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw XmlBlasterException.convert(this.glob, this.ME, ErrorCode.INTERNAL_PUBLISH.toString() + " " + sessionInfo.getId(), e);
        }
    }

    public PublishReturnQos forwardPtpPublish(SessionInfo sessionInfo, MsgUnit msgUnit, boolean isClusterUpdate, Destination destination) throws XmlBlasterException {
        if (this.useCluster && !isClusterUpdate) {
            try {
                return this.glob.getClusterManager().forwardPtpPublish(sessionInfo, msgUnit, destination);
            }
            catch (XmlBlasterException e) {
                e.printStackTrace();
                throw e;
            }
        }
        return null;
    }

    public void eraseVolatile(SessionInfo sessionInfo, TopicHandler topicHandler) throws XmlBlasterException {
        block4: {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Published message is marked as volatile, erasing it");
            }
            if (sessionInfo == null) {
                sessionInfo = this.unsecureSessionInfo;
            }
            try {
                topicHandler.fireMessageEraseEvent(sessionInfo, null);
            }
            catch (XmlBlasterException e) {
                if (!this.log.TRACE) break block4;
                this.log.error(this.ME, "Unexpected exception: " + e.toString());
            }
        }
    }

    final void checkExistingSubscriptions(SessionInfo sessionInfo, TopicHandler topicHandler, PublishQosServer xmlQoS) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "checkExistingSubscriptions(" + topicHandler.getUniqueKey() + "), should happen only once for each topic.");
        }
        if (topicHandler.hasDomTree()) {
            XmlKey keyDom = topicHandler.getXmlKey();
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Checking existing query subscriptions if they match with this new one");
            }
            Set set = this.clientSubscriptions.getQuerySubscribeRequestsSet();
            Vector<SubscriptionInfo> matchingSubsVec = new Vector<SubscriptionInfo>();
            Set set2 = set;
            synchronized (set2) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    SubscriptionInfo existingQuerySubscription = (SubscriptionInfo)iterator.next();
                    KeyData queryXmlKey = existingQuerySubscription.getKeyData();
                    if (!queryXmlKey.isXPath()) {
                        this.log.warn(this.ME, "Only XPath queries are supported, ignoring subscription.");
                        continue;
                    }
                    String xpath = ((QueryKeyData)queryXmlKey).getQueryString();
                    if (!keyDom.match(xpath)) continue;
                    SubscriptionInfo subs = new SubscriptionInfo(this.glob, existingQuerySubscription.getSessionInfo(), existingQuerySubscription, keyDom.getKeyData());
                    existingQuerySubscription.addSubscription(subs);
                    matchingSubsVec.addElement(subs);
                }
            }
            int ii = 0;
            while (ii < matchingSubsVec.size()) {
                this.subscribeToOid((SubscriptionInfo)matchingSubsVec.elementAt(ii), true);
                ++ii;
            }
            keyDom.cleanupMatch();
        }
    }

    String[] erase(SessionInfo sessionInfo, QueryKeyData xmlKey, EraseQosServer eraseQos) throws XmlBlasterException {
        return this.erase(sessionInfo, xmlKey, eraseQos, false);
    }

    private String[] erase(SessionInfo sessionInfo, QueryKeyData xmlKey, EraseQosServer eraseQos, boolean isClusterUpdate) throws XmlBlasterException {
        try {
            if (this.log.CALL) {
                this.log.call(this.ME, "Entering " + (isClusterUpdate ? "cluster update message " : "") + "erase(oid='" + xmlKey.getOid() + "', queryType='" + xmlKey.getQueryType() + "', query='" + xmlKey.getQueryString() + "') client '" + sessionInfo.getLoginName() + "' ...");
            }
            TopicHandler[] topicHandlerArr = this.queryMatchingTopics(sessionInfo, xmlKey, eraseQos.getData());
            HashSet<String> oidSet = new HashSet<String>(topicHandlerArr.length);
            EraseReturnQos[] clusterRetArr = null;
            int ii = 0;
            while (ii < topicHandlerArr.length) {
                block17: {
                    TopicHandler topicHandler = topicHandlerArr[ii];
                    if (this.useCluster && !isClusterUpdate) {
                        try {
                            clusterRetArr = this.glob.getClusterManager().forwardErase(sessionInfo, xmlKey, eraseQos);
                        }
                        catch (XmlBlasterException e) {
                            if (e.getErrorCode() == ErrorCode.RESOURCE_CONFIGURATION_PLUGINFAILED) {
                                this.useCluster = false;
                            }
                            e.printStackTrace();
                            throw e;
                        }
                    }
                    if (topicHandler == null) {
                        if (clusterRetArr != null && clusterRetArr.length > 0) {
                            this.log.info(this.ME, "Erase for topic [" + xmlKey.getOid() + "] successfully forwarded to cluster master");
                            oidSet.add(xmlKey.getOid());
                        } else {
                            this.log.warn(this.ME, "Erase on unknown topic [" + xmlKey.getOid() + "] is ignored");
                        }
                    } else {
                        if (this.log.TRACE) {
                            this.log.trace(this.ME, "erase oid='" + topicHandler.getUniqueKey() + "' of total " + topicHandlerArr.length + " ...");
                        }
                        oidSet.add(topicHandler.getUniqueKey());
                        try {
                            topicHandler.fireMessageEraseEvent(sessionInfo, eraseQos);
                        }
                        catch (XmlBlasterException e) {
                            if (!this.log.TRACE) break block17;
                            this.log.error(this.ME, "Unexpected exception: " + e.toString());
                        }
                    }
                }
                ++ii;
            }
            String[] oidArr = new String[oidSet.size()];
            StatusQosData qos = new StatusQosData(this.glob, MethodName.ERASE);
            qos.setState("OK");
            Iterator it = oidSet.iterator();
            int ii2 = 0;
            while (it.hasNext()) {
                qos.setKeyOid((String)it.next());
                oidArr[ii2++] = qos.toXml();
            }
            return oidArr;
        }
        catch (XmlBlasterException e) {
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw XmlBlasterException.convert(this.glob, this.ME, ErrorCode.INTERNAL_ERASE.toString(), e);
        }
    }

    public void sessionAdded(ClientEvent e) throws XmlBlasterException {
        SessionInfo sessionInfo = e.getSessionInfo();
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Login event for client " + sessionInfo.toString());
        }
        if (this.publishLoginEvent) {
            this.publishQosLoginEvent.clearRoutes();
            MsgUnit msgUnit = new MsgUnit(this.xmlKeyLoginEvent, sessionInfo.getLoginName().getBytes(), this.publishQosLoginEvent.getData());
            this.publish(this.unsecureSessionInfo, msgUnit);
            this.publishQosLoginEvent.getData().setTopicProperty(null);
        }
        if (this.log.TRACE) {
            this.log.trace(this.ME, " client added:" + sessionInfo.getLoginName());
        }
    }

    public void sessionRemoved(ClientEvent e) throws XmlBlasterException {
        SessionInfo sessionInfo = e.getSessionInfo();
        if (this.publishLogoutEvent) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Logout event for client " + sessionInfo.toString());
            }
            this.publishQosLogoutEvent.clearRoutes();
            MsgUnit msgUnit = new MsgUnit(this.xmlKeyLogoutEvent, sessionInfo.getLoginName().getBytes(), this.publishQosLogoutEvent.getData());
            this.publish(this.unsecureSessionInfo, msgUnit);
            this.publishQosLogoutEvent.getData().setTopicProperty(null);
        }
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Client session '" + sessionInfo.getId() + "' removed");
        }
    }

    public void sessionPreRemoved(ClientEvent e) throws XmlBlasterException {
    }

    public void subjectAdded(ClientEvent e) throws XmlBlasterException {
        this.log.warn(this.ME, "Ignoring SubjectInfo added event for client " + e.getSubjectInfo().toString());
    }

    public void subjectRemoved(ClientEvent e) throws XmlBlasterException {
        this.log.warn(this.ME, "Ignoring SubjectInfo removed event for client " + e.getSubjectInfo().toString());
    }

    public void addSubscriptionListener(I_SubscriptionListener l) {
        if (l == null) {
            return;
        }
        Set set = this.subscriptionListenerSet;
        synchronized (set) {
            this.subscriptionListenerSet.add(l);
        }
    }

    public void removeSubscriptionListener(I_SubscriptionListener l) {
        if (l == null) {
            return;
        }
        Set set = this.subscriptionListenerSet;
        synchronized (set) {
            this.subscriptionListenerSet.remove(l);
        }
    }

    final void fireUnSubscribeEvent(SubscriptionInfo subscriptionInfo) throws XmlBlasterException {
        this.fireSubscriptionEvent(subscriptionInfo, false);
        subscriptionInfo.decrSubscribeCounter();
    }

    final void fireSubscribeEvent(SubscriptionInfo subscriptionInfo) throws XmlBlasterException {
        this.fireSubscriptionEvent(subscriptionInfo, true);
    }

    private final void fireSubscriptionEvent(SubscriptionInfo subscriptionInfo, boolean subscribe) throws XmlBlasterException {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Going to fire fireSubscriptionEvent(" + subscribe + ") ...");
        }
        Set set = this.subscriptionListenerSet;
        synchronized (set) {
            if (this.subscriptionListenerSet.size() == 0) {
                return;
            }
            SubscriptionEvent event = new SubscriptionEvent(subscriptionInfo);
            Iterator iterator = this.subscriptionListenerSet.iterator();
            while (iterator.hasNext()) {
                I_SubscriptionListener subli = (I_SubscriptionListener)iterator.next();
                if (subscribe) {
                    subli.subscriptionAdd(event);
                    continue;
                }
                subli.subscriptionRemove(event);
            }
            event = null;
        }
    }

    public final String toXml() throws XmlBlasterException {
        return this.toXml(null);
    }

    public final String toXml(String extraOffset) throws XmlBlasterException {
        StringBuffer sb = new StringBuffer(10000);
        if (extraOffset == null) {
            extraOffset = "";
        }
        String offset = "\n " + extraOffset;
        TopicHandler[] topicHandlerArr = this.getTopicHandlerArr();
        sb.append(offset).append("<RequestBroker>");
        if (this.topicStore != null) {
            sb.append(this.topicStore.toXml(extraOffset + " "));
        }
        int ii = 0;
        while (ii < topicHandlerArr.length) {
            sb.append(topicHandlerArr[ii].toXml(extraOffset + " "));
            ++ii;
        }
        sb.append(this.bigXmlKeyDOM.toXml(extraOffset + " ", true));
        sb.append(this.clientSubscriptions.toXml(extraOffset + " "));
        if (this.useCluster) {
            sb.append(this.glob.getClusterManager().toXml(extraOffset + " "));
        }
        sb.append(offset).append("</RequestBroker>");
        return sb.toString();
    }

    public int getNumNodes() {
        if (!this.glob.useCluster()) {
            return 1;
        }
        try {
            return this.glob.getClusterManager().getNumNodes();
        }
        catch (XmlBlasterException e) {
            return 1;
        }
    }

    public String getNodeList() {
        if (!this.glob.useCluster()) {
            return this.glob.getId();
        }
        try {
            return this.glob.getClusterManager().getNodeList();
        }
        catch (XmlBlasterException e) {
            return this.glob.getId();
        }
    }

    public String getNodeId() {
        return this.glob.getId();
    }

    public String getVersion() {
        return this.glob.getVersion();
    }

    public String getBuildTimestamp() {
        return this.glob.getBuildTimestamp();
    }

    public String getBuildJavaVendor() {
        return this.glob.getBuildJavaVendor();
    }

    public String getBuildJavaVersion() {
        return this.glob.getBuildJavaVersion();
    }

    public String getDump() throws XmlBlasterException {
        return this.glob.getDump();
    }

    public void setDump(String fn) throws XmlBlasterException {
        try {
            FileUtil.writeFile(fn, this.getDump());
            this.log.info(this.ME, "Dumped internal state to " + fn);
        }
        catch (JUtilsException e) {
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_FILEIO, e.id, e.getMessage());
        }
    }

    public String getRunlevel() {
        return "" + this.glob.getRunlevelManager().getCurrentRunlevel();
    }

    public void setRunlevel(String levelStr) throws XmlBlasterException {
        this.glob.getRunlevelManager().changeRunlevel(levelStr, true);
    }

    public long getUptime() {
        return (System.currentTimeMillis() - this.uptime) / 1000L;
    }

    public long getFreeMem() {
        return Runtime.getRuntime().freeMemory();
    }

    public long getTotalMem() {
        return Runtime.getRuntime().totalMemory();
    }

    public long getUsedMem() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    public String getGc() {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Garbage collector is activated");
        }
        System.gc();
        return "OK";
    }

    public void setGc(String dummy) {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Garbage collector is activated");
        }
        System.gc();
    }

    public String getExit() throws XmlBlasterException {
        return "OK";
    }

    public void setExit(String exitValue) throws XmlBlasterException {
        int val = 0;
        try {
            val = Integer.parseInt(exitValue.trim());
        }
        catch (NumberFormatException e) {
            this.log.error(this.ME, "Invalid exit value=" + exitValue + ", expected an integer");
        }
        final int exitVal = val;
        if (this.glob.isEmbedded()) {
            this.log.warn(this.ME, "Ignoring exit(" + exitVal + ") request in embeded mode ('xmlBlaster.isEmbeded' is set true).");
            return;
        }
        final long exitSleep = this.glob.getProperty().get("xmlBlaster.exit.delay", 2000L);
        Timeout exitTimeout = new Timeout("XmlBlaster ExitTimer");
        Timestamp timeoutHandle = exitTimeout.addTimeoutListener(new I_Timeout(){

            public void timeout(Object userData) {
                RequestBroker.this.log.info(RequestBroker.this.ME, "Administrative exit(" + exitVal + ") after exit-timeout of " + exitSleep + " millis.");
                try {
                    int errors = RequestBroker.this.glob.getRunlevelManager().changeRunlevel(0, true);
                }
                catch (Throwable e) {
                    RequestBroker.this.log.warn(RequestBroker.this.ME, "Administrative exit(" + exitVal + ") problems: " + e.toString());
                }
                System.exit(exitVal);
            }
        }, exitSleep, null);
        this.log.info(this.ME, "Administrative exit request, scheduled exit in " + exitSleep + " millis with exit value=" + exitVal + ".");
    }

    public String getHostname() {
        return this.glob.getBootstrapAddress().getBootstrapHostname();
    }

    public int getPort() {
        return this.glob.getBootstrapAddress().getBootstrapPort();
    }

    public int getNumClients() {
        return this.authenticate.getNumSubjects();
    }

    public int getMaxClients() {
        return this.authenticate.getMaxSubjects();
    }

    public String getClientList() {
        return this.authenticate.getSubjectList();
    }

    public int getNumSysprop() {
        return ((Hashtable)this.glob.getProperty().getProperties()).size();
    }

    public String getSyspropList() {
        Properties props = this.glob.getProperty().getProperties();
        StringBuffer sb = new StringBuffer(((Hashtable)props).size() * 30);
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append((String)e.nextElement());
        }
        return sb.toString();
    }

    public int getNumTopics() {
        Map map = this.messageContainerMap;
        synchronized (map) {
            int n = this.messageContainerMap.size();
            return n;
        }
    }

    public String getTopicList() {
        TopicHandler[] topicHandlerArr = this.getTopicHandlerArr();
        StringBuffer sb = new StringBuffer(topicHandlerArr.length * 60);
        int ii = 0;
        while (ii < topicHandlerArr.length) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(topicHandlerArr[ii].getUniqueKey());
            ++ii;
        }
        return sb.toString();
    }

    public int getNumSubscriptions() {
        return this.getClientSubscriptions().getNumSubscriptions();
    }

    public String getSubscriptionList() {
        return this.getClientSubscriptions().getSubscriptionList();
    }
}

