/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine;

import java.util.HashMap;
import org.jutils.log.LogChannel;
import org.xmlBlaster.authentication.ClientEvent;
import org.xmlBlaster.authentication.SessionInfo;
import org.xmlBlaster.engine.Global;
import org.xmlBlaster.engine.I_SessionPersistencePlugin;
import org.xmlBlaster.engine.SubscriptionEvent;
import org.xmlBlaster.engine.SubscriptionInfo;
import org.xmlBlaster.engine.msgstore.I_Map;
import org.xmlBlaster.engine.msgstore.I_MapEntry;
import org.xmlBlaster.engine.qos.ConnectQosServer;
import org.xmlBlaster.engine.qos.ConnectReturnQosServer;
import org.xmlBlaster.engine.queuemsg.SessionEntry;
import org.xmlBlaster.engine.queuemsg.SubscribeEntry;
import org.xmlBlaster.util.SessionName;
import org.xmlBlaster.util.Timestamp;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.key.KeyData;
import org.xmlBlaster.util.key.QueryKeyData;
import org.xmlBlaster.util.key.QueryKeySaxFactory;
import org.xmlBlaster.util.plugin.PluginInfo;
import org.xmlBlaster.util.qos.ClientProperty;
import org.xmlBlaster.util.qos.ConnectQosData;
import org.xmlBlaster.util.qos.ConnectQosSaxFactory;
import org.xmlBlaster.util.qos.QueryQosData;
import org.xmlBlaster.util.qos.QueryQosSaxFactory;
import org.xmlBlaster.util.qos.storage.SessionStoreProperty;
import org.xmlBlaster.util.qos.storage.SubscribeStoreProperty;
import org.xmlBlaster.util.queue.StorageId;

public class SessionPersistencePlugin
implements I_SessionPersistencePlugin {
    private static final String ME = "SessionPersistencePlugin";
    private static final String ORIGINAL_INITIAL_UPDATES = "__originalInitialUpdates";
    private PluginInfo info;
    private Global global;
    private LogChannel log;
    private boolean isOK;
    private I_Map sessionStore;
    private I_Map subscribeStore;
    private StorageId sessionStorageId;
    private StorageId subscribeStorageId;
    private ConnectQosSaxFactory connectQosFactory;
    private QueryQosSaxFactory queryQosFactory;
    private QueryKeySaxFactory queryKeyFactory;
    private Object sync = new Object();

    private HashMap recoverSessions() throws XmlBlasterException {
        I_MapEntry[] entries = this.sessionStore.getAll();
        HashMap<String, String> sessionIds = new HashMap<String, String>();
        int i = 0;
        while (i < entries.length) {
            if (entries[i] instanceof SessionEntry) {
                SessionEntry entry = (SessionEntry)entries[i];
                ConnectQosData data = this.connectQosFactory.readObject(entry.getQos());
                ConnectQosServer qos = new ConnectQosServer((org.xmlBlaster.util.Global)this.global, data);
                qos.isFromPersistenceRecovery(true);
                qos.setPersistenceUniqueId(entry.getUniqueId());
                SessionName sessionName = data.getSessionName();
                String sessionId = data.getSessionQos().getSecretSessionId();
                sessionIds.put(sessionName.getAbsoluteName(), sessionId);
                if (this.log.TRACE) {
                    this.log.trace(ME, "recoverSessions: store in map session='" + sessionName.getAbsoluteName() + "' has secret sessionId='" + sessionId + "' and persistenceUniqueId=" + entry.getUniqueId());
                }
                ConnectReturnQosServer ret = this.global.getAuthenticate().connect(qos);
                if (this.log.DUMP) {
                    this.log.dump(ME, "recoverSessions: return of connect: returnConnectQos='" + ret.toXml() + "'");
                }
            } else {
                throw new XmlBlasterException(this.global, ErrorCode.INTERNAL_ILLEGALARGUMENT, "SessionPersistencePlugin.recoverSessions: the entry in the storage should be of type 'SessionEntry' but is of type'" + entries[i].getClass().getName() + "'");
            }
            ++i;
        }
        return sessionIds;
    }

    private void recoverSubscriptions(HashMap sessionIds) throws XmlBlasterException {
        I_MapEntry[] entries = this.subscribeStore.getAll();
        int i = 0;
        while (i < entries.length) {
            String sessionId;
            QueryQosData qosData;
            SubscribeEntry entry;
            if (entries[i] instanceof SubscribeEntry) {
                SessionName sessionName;
                entry = (SubscribeEntry)entries[i];
                String qos = entry.getQos();
                qosData = this.queryQosFactory.readObject(qos);
                boolean initialUpdates = qosData.getInitialUpdateProp().getValue();
                if (initialUpdates) {
                    qosData.getClientProperties().put(ORIGINAL_INITIAL_UPDATES, new ClientProperty(this.global, ORIGINAL_INITIAL_UPDATES, "boolean", null, "true"));
                }
                if ((sessionId = (String)sessionIds.get((sessionName = new SessionName(this.global, entry.getSessionName())).getAbsoluteName())) == null) {
                    throw new XmlBlasterException(this.global, ErrorCode.INTERNAL_NULLPOINTER, "SessionPersistencePlugin.recoverSubscriptions", "The secret sessionId was not found for session='" + sessionName.getAbsoluteName() + "'");
                }
            } else {
                throw new XmlBlasterException(this.global, ErrorCode.INTERNAL_ILLEGALARGUMENT, "SessionPersistencePlugin.recoverSubscriptions: the entry in the storage should be of type 'SubscribeEntry'but is of type'" + entries[i].getClass().getName() + "'");
            }
            this.global.getAuthenticate().getXmlBlaster().subscribe(sessionId, entry.getKey(), qosData.toXml());
            ++i;
        }
    }

    private void removeAssociatedSubscriptions(SessionInfo sessionInfo) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(ME, "removeAssociatedSubscriptions for session '" + sessionInfo.getId() + "'");
        }
        XmlBlasterException e = null;
        SubscriptionInfo[] subs = this.global.getRequestBroker().getClientSubscriptions().getSubscriptions(sessionInfo);
        int i = 0;
        while (i < subs.length) {
            try {
                if (this.log.CALL) {
                    this.log.call(ME, "removeAssociatedSubscriptions for session '" + sessionInfo.getId() + "' subscription '" + subs[i].getId() + "'");
                }
                this.subscriptionRemove(new SubscriptionEvent(subs[i]));
            }
            catch (XmlBlasterException ex) {
                if (e == null) {
                    e = ex;
                }
                this.log.error(ME, "removeAssociatedSubscriptions: exception occured for session '" + sessionInfo.getId() + "' and subscriptions '" + subs[i].getId() + "' : ex: " + ex.getMessage());
            }
            ++i;
        }
        if (e != null) {
            throw e;
        }
    }

    public void init(org.xmlBlaster.util.Global glob, PluginInfo pluginInfo) throws XmlBlasterException {
        Object object = this.sync;
        synchronized (object) {
            if (this.isOK) {
                return;
            }
            this.info = pluginInfo;
            this.global = (Global)glob;
            this.log = this.global.getLog("subscription");
            if (this.log.CALL) {
                this.log.call(ME, "init");
            }
            this.connectQosFactory = new ConnectQosSaxFactory(this.global);
            this.queryQosFactory = new QueryQosSaxFactory(this.global);
            this.queryKeyFactory = new QueryKeySaxFactory(this.global);
            SessionStoreProperty sessionProp = new SessionStoreProperty(this.global, this.global.getStrippedId());
            if (sessionProp.getMaxEntries() > 0L) {
                String type = sessionProp.getType();
                String version = sessionProp.getVersion();
                this.sessionStorageId = new StorageId("session", this.global.getStrippedId() + "/" + this.info.getId());
                this.sessionStore = this.global.getStoragePluginManager().getPlugin(type, version, this.sessionStorageId, sessionProp);
            } else if (this.log.TRACE) {
                this.log.trace(ME, "subscribe persistence for subscribe is switched of with maxEntries=0");
            }
            SubscribeStoreProperty subscribeProp = new SubscribeStoreProperty(this.global, this.global.getStrippedId());
            if (subscribeProp.getMaxEntries() > 0L) {
                String type = subscribeProp.getType();
                String version = subscribeProp.getVersion();
                this.subscribeStorageId = new StorageId("subscribe", this.global.getStrippedId() + "/" + this.info.getId());
                this.subscribeStore = this.global.getStoragePluginManager().getPlugin(type, version, this.subscribeStorageId, subscribeProp);
            } else if (this.log.TRACE) {
                this.log.trace(ME, "subscribe persistence for subscribe is switched of with maxEntries=0");
            }
            this.isOK = true;
            this.global.getRequestBroker().getAuthenticate().addClientListener(this);
            this.global.getRequestBroker().addSubscriptionListener(this);
            HashMap sessionIds = this.recoverSessions();
            this.recoverSubscriptions(sessionIds);
        }
    }

    public String getType() {
        if (this.info != null) {
            return this.info.getType();
        }
        return null;
    }

    public String getVersion() {
        if (this.info != null) {
            return this.info.getVersion();
        }
        return null;
    }

    public void shutdown() throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(ME, "shutdown");
        }
        Object object = this.sync;
        synchronized (object) {
            this.isOK = false;
            this.global.getRequestBroker().getAuthenticate().removeClientListener(this);
            this.global.getRequestBroker().removeSubscriptionListener(this);
            this.sessionStore.shutdown();
            this.subscribeStore.shutdown();
        }
    }

    private void addSession(SessionInfo sessionInfo) throws XmlBlasterException {
        ConnectQosData connectQosData = sessionInfo.getConnectQos().getData();
        if (connectQosData.getPersistentProp() == null || !connectQosData.getPersistentProp().getValue()) {
            return;
        }
        if (sessionInfo.getConnectQos().isFromPersistenceRecovery()) {
            return;
        }
        long uniqueId = new Timestamp().getTimestamp();
        SessionEntry entry = new SessionEntry(connectQosData.toXml(), uniqueId, connectQosData.size());
        if (this.log.TRACE) {
            this.log.trace(ME, "addSession (persistent) for NEW uniqueId: '" + entry.getUniqueId() + "'");
        }
        sessionInfo.setPersistenceUniqueId(uniqueId);
        this.sessionStore.put(entry);
    }

    public void sessionAdded(ClientEvent e) throws XmlBlasterException {
        if (!this.isOK) {
            throw new XmlBlasterException(this.global, ErrorCode.RESOURCE_UNAVAILABLE, "SessionPersistencePlugin.sessionAdded: invoked when plugin already shut down");
        }
        SessionInfo sessionInfo = e.getSessionInfo();
        this.addSession(sessionInfo);
    }

    public void sessionRemoved(ClientEvent e) throws XmlBlasterException {
    }

    public void sessionPreRemoved(ClientEvent e) throws XmlBlasterException {
        SessionEntry entry;
        int num;
        if (this.log.CALL) {
            this.log.call(ME, "sessionRemoved '" + e.getSessionInfo().getId() + "'");
        }
        if (!this.isOK) {
            throw new XmlBlasterException(this.global, ErrorCode.RESOURCE_UNAVAILABLE, "SessionPersistencePlugin.sessionRemoved: invoked when plugin already shut down");
        }
        SessionInfo sessionInfo = e.getSessionInfo();
        ConnectQosData connectQosData = sessionInfo.getConnectQos().getData();
        if (!connectQosData.getPersistentProp().getValue()) {
            return;
        }
        this.removeAssociatedSubscriptions(sessionInfo);
        long uniqueId = sessionInfo.getPersistenceUniqueId();
        if (this.log.TRACE) {
            this.log.trace(ME, "sessionRemoved (persistent) for uniqueId: '" + uniqueId + "'");
        }
        if ((num = this.sessionStore.remove(entry = new SessionEntry(connectQosData.toXml(), uniqueId, 0L))) != 1) {
            this.log.error(ME, "sessionRemoved (persistent) for uniqueId: '" + uniqueId + "' failed, entry not found.");
        }
    }

    public void subscriptionAdd(SubscriptionEvent e) throws XmlBlasterException {
        ClientProperty clientProperty;
        if (this.log.CALL) {
            this.log.call(ME, "subscriptionAdd '" + e.getSubscriptionInfo().getId() + "'");
        }
        if (!this.isOK) {
            throw new XmlBlasterException(this.global, ErrorCode.RESOURCE_UNAVAILABLE, "SessionPersistencePlugin.subscriptionAdded: invoked when plugin already shut down");
        }
        SubscriptionInfo subscriptionInfo = e.getSubscriptionInfo();
        KeyData data = subscriptionInfo.getKeyData();
        if (subscriptionInfo.isCreatedByQuerySubscription()) {
            return;
        }
        QueryQosData subscribeQosData = subscriptionInfo.getQueryQosData();
        if (this.log.DUMP) {
            this.log.dump(ME, "subscriptionAdd: key='" + data.toXml() + "'");
        }
        if (subscribeQosData != null && this.log.DUMP) {
            this.log.dump(ME, "subscriptionAdd: qos='" + subscribeQosData.toXml() + "'");
        }
        if (subscribeQosData == null || subscribeQosData.getPersistentProp() == null || !subscribeQosData.getPersistentProp().getValue()) {
            return;
        }
        SessionInfo sessionInfo = subscriptionInfo.getSessionInfo();
        if (!sessionInfo.getConnectQos().getData().getPersistentProp().getValue()) {
            sessionInfo.getConnectQos().getData().setPersistent(true);
            this.addSession(sessionInfo);
        }
        if ((clientProperty = subscribeQosData.getClientProperty("__persistenceId")) == null) {
            long uniqueId = new Timestamp().getTimestamp();
            subscribeQosData.getClientProperties().put("__persistenceId", new ClientProperty(this.global, "__persistenceId", "long", null, "" + uniqueId));
            QueryKeyData subscribeKeyData = (QueryKeyData)data;
            subscribeQosData.setSubscriptionId(subscriptionInfo.getSubscriptionId());
            SubscribeEntry entry = new SubscribeEntry(subscribeKeyData.toXml(), subscribeQosData.toXml(), sessionInfo.getConnectQos().getSessionName().getAbsoluteName(), uniqueId, 0L);
            if (this.log.TRACE) {
                this.log.trace(ME, "subscriptionAdd: putting to persistence NEW entry '" + entry.getUniqueId() + "' key='" + subscribeKeyData.toXml() + "' qos='" + subscribeQosData.toXml() + "' secretSessionId='" + sessionInfo.getSecretSessionId() + "'");
            }
            subscriptionInfo.setPersistenceId(uniqueId);
            this.subscribeStore.put(entry);
        } else {
            subscribeQosData.getClientProperties().remove("__persistenceId");
            long uniqueId = clientProperty.getLongValue();
            if (this.log.TRACE) {
                this.log.trace(ME, "subscriptionAdd: filling OLD uniqueId into subscriptionInfo '" + uniqueId + "'");
            }
            subscriptionInfo.setPersistenceId(uniqueId);
            ClientProperty prop = subscribeQosData.getClientProperty(ORIGINAL_INITIAL_UPDATES);
            if (prop != null && subscriptionInfo.getSubscribeQosServer() != null) {
                subscriptionInfo.getSubscribeQosServer().inhibitInitalUpdates(true);
                subscribeQosData.getClientProperties().remove(ORIGINAL_INITIAL_UPDATES);
            }
        }
    }

    public void subscriptionRemove(SubscriptionEvent e) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(ME, "subscriptionRemove '" + e.getSubscriptionInfo().getId() + "'");
        }
        if (!this.isOK) {
            throw new XmlBlasterException(this.global, ErrorCode.RESOURCE_UNAVAILABLE, "SessionPersistencePlugin.subscriptionRemove: invoked when plugin already shut down");
        }
        SubscriptionInfo subscriptionInfo = e.getSubscriptionInfo();
        KeyData keyData = subscriptionInfo.getKeyData();
        if (!(keyData instanceof QueryKeyData)) {
            return;
        }
        if (subscriptionInfo.getPersistenceId() < 1L) {
            return;
        }
        QueryQosData qosData = subscriptionInfo.getQueryQosData();
        if (qosData == null || qosData.getPersistentProp() == null || !qosData.getPersistentProp().getValue()) {
            return;
        }
        SubscribeEntry entry = new SubscribeEntry(keyData.toXml(), qosData.toXml(), subscriptionInfo.getSessionInfo().getConnectQos().getSessionName().getAbsoluteName(), subscriptionInfo.getPersistenceId(), 0L);
        if (this.log.TRACE) {
            this.log.trace(ME, "subscriptionRemove: removing from persistence entry '" + entry.getUniqueId() + "' secretSessionId='" + subscriptionInfo.getSessionInfo().getConnectQos().getSessionName().getAbsoluteName());
        }
        this.subscribeStore.remove(entry);
    }

    public void subjectAdded(ClientEvent e) throws XmlBlasterException {
    }

    public void subjectRemoved(ClientEvent e) throws XmlBlasterException {
    }
}

