/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine;

import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import java.util.HashSet;
import java.util.Set;
import org.jutils.log.LogChannel;
import org.xmlBlaster.authentication.SubjectInfo;
import org.xmlBlaster.engine.Global;

public class SubjectEntryShuffler
implements Runnable {
    private static final String ME = "SubjectEntryShuffler";
    private Global global;
    private LogChannel log;
    private Channel channel;
    private Set set;

    SubjectEntryShuffler(Global global) {
        this.global = global;
        this.log = this.global.getLog("core");
        if (this.log.CALL) {
            this.log.call(ME, "constructor");
        }
        this.channel = new LinkedQueue();
        this.set = new HashSet();
        Thread thread = new Thread((Runnable)this, "XmlBlaster.SubjectEntryShuffler");
        thread.setDaemon(true);
        thread.start();
    }

    public void shuffle(SubjectInfo info) {
        if (this.log.CALL) {
            this.log.call(ME, "shuffle SubjectInfo '" + info.getId() + "'");
        }
        try {
            Set set = this.set;
            synchronized (set) {
                if (this.set.contains(info)) {
                    return;
                }
                this.set.add(info);
                this.channel.put((Object)info);
            }
            if (this.log.CALL) {
                this.log.call(ME, "shuffle SubjectInfo '" + info.getId() + "' put has returned");
            }
        }
        catch (InterruptedException ex) {
            this.log.error(ME, "shuffle InterruptedException occured " + ex.getMessage());
            ex.printStackTrace();
        }
        catch (Throwable ex) {
            this.log.error(ME, "shuffle a Throwable occured " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    public void run() {
        this.log.info(ME, "run: shuffling Thread started");
        while (true) {
            try {
                SubjectInfo info = (SubjectInfo)this.channel.take();
                Set set = this.set;
                synchronized (set) {
                    this.set.remove(info);
                }
                if (this.log.TRACE) {
                    this.log.trace(ME, "run: shuffling for subject '" + info.getId() + "' starts");
                }
                info.forwardToSessionQueue();
                if (!this.log.TRACE) continue;
                this.log.trace(ME, "run: shuffling for subject '" + info.getId() + "' completed");
                continue;
            }
            catch (InterruptedException ex) {
                this.log.error(ME, "run InterruptedException occured " + ex.getMessage());
                ex.printStackTrace();
                continue;
            }
            catch (Throwable ex) {
                this.log.error(ME, "run a Throwable occured " + ex.getMessage());
                ex.printStackTrace();
                continue;
            }
            break;
        }
    }
}

