/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine;

import java.util.Vector;
import org.jutils.log.LogChannel;
import org.jutils.time.TimeHelper;
import org.xmlBlaster.authentication.SessionInfo;
import org.xmlBlaster.engine.Global;
import org.xmlBlaster.engine.TopicHandler;
import org.xmlBlaster.engine.admin.I_AdminSubscription;
import org.xmlBlaster.engine.qos.SubscribeQosServer;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.key.KeyData;
import org.xmlBlaster.util.qos.AccessFilterQos;
import org.xmlBlaster.util.qos.QueryQosData;
import org.xmlBlaster.util.queue.I_Queue;

public final class SubscriptionInfo
implements I_AdminSubscription {
    private String ME = "SubscriptionInfo";
    private Global glob;
    private LogChannel log;
    private SessionInfo sessionInfo;
    private KeyData keyData;
    private SubscribeQosServer subscribeQos = null;
    private String uniqueKey = null;
    private TopicHandler topicHandler;
    private SubscriptionInfo querySub = null;
    private Vector childrenVec = null;
    private int subscribeCounter = 0;
    private static long uniqueCounter = 1L;
    private long creationTime = System.currentTimeMillis();
    private long persistenceId = -1L;
    static /* synthetic */ Class class$org$xmlBlaster$engine$SubscriptionInfo;

    public SubscriptionInfo(Global glob, SessionInfo sessionInfo, KeyData keyData, SubscribeQosServer qos) throws XmlBlasterException {
        this.init(glob, sessionInfo, keyData, qos);
    }

    public SubscriptionInfo(Global glob, SessionInfo sessionInfo, SubscriptionInfo querySub, KeyData keyData) throws XmlBlasterException {
        this.querySub = querySub;
        this.init(glob, sessionInfo, keyData, querySub.subscribeQos);
    }

    private void init(Global glob, SessionInfo sessionInfo, KeyData keyData, SubscribeQosServer qos) throws XmlBlasterException {
        this.glob = glob;
        this.log = this.glob.getLog("core");
        this.sessionInfo = sessionInfo;
        this.keyData = keyData;
        this.subscribeQos = qos;
        AccessFilterQos[] filterQos = this.subscribeQos.getAccessFilterArr();
        if (filterQos != null) {
            int ii = 0;
            while (ii < filterQos.length) {
                this.glob.getRequestBroker().getAccessPluginManager().addAccessFilterPlugin(filterQos[ii].getType(), filterQos[ii].getVersion());
                ++ii;
            }
        }
        this.initSubscriptionId();
        this.ME = this.ME + "-" + this.uniqueKey;
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Created SubscriptionInfo '" + this.getSubscriptionId() + "' for client '" + sessionInfo.getLoginName() + "'");
        }
    }

    public void incrSubscribeCounter() {
        ++this.subscribeCounter;
    }

    public void decrSubscribeCounter() {
        --this.subscribeCounter;
    }

    public int getSubscribeCounter() {
        return this.subscribeCounter;
    }

    public SessionInfo getSessionInfo() {
        return this.sessionInfo;
    }

    public I_Queue getMsgQueue() {
        return this.sessionInfo.getSessionQueue();
    }

    public void addSubscription(SubscriptionInfo subs) {
        if (this.childrenVec == null) {
            this.childrenVec = new Vector();
        }
        this.childrenVec.addElement(subs);
    }

    public void removeChildSubscription(SubscriptionInfo subs) {
        if (this.childrenVec == null) {
            return;
        }
        boolean found = this.childrenVec.remove(subs);
        if (!found) {
            this.log.error(this.ME, "Failed to remove XPATH children subscription " + this.uniqueKey);
            Thread.dumpStack();
            return;
        }
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Removed XPATH " + this.uniqueKey + " children subscription ");
        }
    }

    public Vector getChildrenSubscriptions() {
        return this.childrenVec;
    }

    public boolean isQuery() {
        return this.keyData.isQuery();
    }

    public boolean isExact() {
        return !this.isQuery() && !this.isCreatedByQuerySubscription();
    }

    public boolean isCreatedByQuerySubscription() {
        return this.querySub != null;
    }

    protected void finalize() {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "finalize - garbage collect " + this.uniqueKey);
        }
    }

    public AccessFilterQos[] getAccessFilterArr() {
        return this.subscribeQos.getAccessFilterArr();
    }

    private void erase() {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Entering erase()");
        }
        this.subscribeQos = null;
    }

    public void addTopicHandler(TopicHandler topicHandler) {
        if (topicHandler == null) {
            Thread.dumpStack();
            this.log.error(this.ME, "addTopicHandler with topicHandler==null seems to be strange");
        }
        this.topicHandler = topicHandler;
        if (this.topicHandler != null && this.log.TRACE) {
            this.log.trace(this.ME, "Assign to SubscriptionInfo '" + this.uniqueKey + "' for client '" + this.sessionInfo.getId() + "' message '" + this.topicHandler.getUniqueKey() + "'");
        }
    }

    public TopicHandler getTopicHandler() {
        if (this.topicHandler == null) {
            Thread.dumpStack();
            this.log.error(this.ME, "addTopicHandler with topicHandler==null seems to be strange");
        }
        return this.topicHandler;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    void removeSubscribe() {
        if (this.topicHandler == null) {
            if (!this.isQuery()) {
                this.log.warn(this.ME, "The id=" + this.uniqueKey + " has no TopicHandler which takes care of it: " + this.toXml());
                Thread.dumpStack();
            }
            return;
        }
        this.topicHandler.removeSubscriber(this.uniqueKey);
        this.erase();
    }

    public KeyData getKeyData() {
        return this.keyData;
    }

    public String getKeyOid() {
        if (this.keyData != null) {
            return this.keyData.getOid();
        }
        return null;
    }

    public QueryQosData getQueryQosData() {
        if (this.subscribeQos == null) {
            return null;
        }
        return this.subscribeQos.getData();
    }

    public SubscribeQosServer getSubscribeQosServer() {
        return this.subscribeQos;
    }

    public String getSubscriptionId() {
        if (this.uniqueKey == null) {
            throw new IllegalArgumentException(this.ME + ".getSubscriptionId() is not initialized");
        }
        return this.uniqueKey;
    }

    private void initSubscriptionId() throws XmlBlasterException {
        if (this.uniqueKey == null) {
            if (this.querySub != null) {
                StringBuffer buf = new StringBuffer(126);
                Class clazz = class$org$xmlBlaster$engine$SubscriptionInfo == null ? (class$org$xmlBlaster$engine$SubscriptionInfo = SubscriptionInfo.class$("org.xmlBlaster.engine.SubscriptionInfo")) : class$org$xmlBlaster$engine$SubscriptionInfo;
                synchronized (clazz) {
                    buf.append(this.querySub.getSubscriptionId()).append(":").append(++uniqueCounter);
                }
                this.uniqueKey = buf.toString();
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Generated child subscription ID=" + this.uniqueKey);
                }
            } else {
                this.uniqueKey = SubscriptionInfo.generateUniqueKey(this.keyData, this.subscribeQos.getData(), this.glob.useCluster());
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Generated subscription ID=" + this.uniqueKey);
                }
            }
        }
    }

    public String getSubSourceSubscriptionId() throws XmlBlasterException {
        if (this.querySub != null) {
            return this.querySub.getSubscriptionId();
        }
        return this.getSubscriptionId();
    }

    public void shutdown() throws XmlBlasterException {
        if (this.querySub != null) {
            this.querySub.removeChildSubscription(this);
        }
    }

    static boolean isSubscribeId(String id) {
        if (id == null) {
            return false;
        }
        return id.startsWith("__subId:");
    }

    private static String generateUniqueKey(KeyData keyData, QueryQosData xmlQos, boolean clusterWideUnique) throws XmlBlasterException {
        if (xmlQos.getSubscriptionId() != null && xmlQos.getSubscriptionId().length() > 0) {
            return xmlQos.getSubscriptionId();
        }
        StringBuffer buf = new StringBuffer(126);
        Class clazz = class$org$xmlBlaster$engine$SubscriptionInfo == null ? (class$org$xmlBlaster$engine$SubscriptionInfo = SubscriptionInfo.class$("org.xmlBlaster.engine.SubscriptionInfo")) : class$org$xmlBlaster$engine$SubscriptionInfo;
        synchronized (clazz) {
            ++uniqueCounter;
            buf.append("__subId:");
            if (clusterWideUnique) {
                buf.append(keyData.getGlobal().getNodeId().getId()).append("-");
            }
            if (keyData.isQuery()) {
                buf.append(keyData.getQueryType());
            }
            buf.append(uniqueCounter);
        }
        return buf.toString();
    }

    public String toXml() {
        return this.toXml(null);
    }

    public String toXml(String extraOffset) {
        StringBuffer sb = new StringBuffer(2048);
        if (extraOffset == null) {
            extraOffset = "";
        }
        String offset = "\n " + extraOffset;
        sb.append(offset).append("  <subscription id='").append(this.getSubscriptionId()).append("'");
        sb.append(" sessionName='").append(this.getSessionInfo().getSessionName()).append("'");
        if (this.topicHandler != null) {
            sb.append(" oid='").append(this.topicHandler.getUniqueKey()).append("'");
        }
        if (this.querySub != null) {
            sb.append(" parent='").append(this.querySub.getSubscriptionId()).append("'");
        }
        if (this.childrenVec != null) {
            sb.append(" numChilds='").append(this.childrenVec.size()).append("'");
        }
        sb.append(" creationTime='" + TimeHelper.getDateTimeDump(this.creationTime) + "'");
        sb.append(">");
        if (this.keyData != null) {
            sb.append(this.keyData.toXml(extraOffset + " "));
        }
        sb.append(this.subscribeQos.toXml(extraOffset + " "));
        if (this.childrenVec != null) {
            int ii = 0;
            while (ii < this.childrenVec.size()) {
                SubscriptionInfo child = (SubscriptionInfo)this.childrenVec.elementAt(ii);
                sb.append(offset).append(" <child>").append(child.getSubscriptionId()).append("</child>");
                ++ii;
            }
        }
        sb.append(offset).append("</SubscriptionInfo>");
        return sb.toString();
    }

    public String toXmlSmall(String extraOffset) {
        StringBuffer sb = new StringBuffer(256);
        if (extraOffset == null) {
            extraOffset = "";
        }
        String offset = "\n " + extraOffset;
        sb.append(offset).append("  <subscription id='").append(this.getSubscriptionId()).append("'");
        sb.append(" sessionName='").append(this.getSessionInfo().getSessionName()).append("'");
        if (this.topicHandler != null) {
            sb.append(" oid='").append(this.topicHandler.getUniqueKey()).append("'");
        }
        if (this.querySub != null) {
            sb.append(" parent='").append(this.querySub.getSubscriptionId()).append("'");
        }
        if (this.childrenVec != null) {
            sb.append(" numChilds='").append(this.childrenVec.size()).append("'");
        }
        sb.append(" creationTime='" + TimeHelper.getDateTimeDump(this.creationTime) + "'");
        sb.append("/>");
        return sb.toString();
    }

    public final long getPersistenceId() {
        return this.persistenceId;
    }

    public final void setPersistenceId(long persistenceId) {
        this.persistenceId = persistenceId;
    }

    public String getId() {
        return this.getSubscriptionId();
    }

    public String getSessionName() {
        if (this.sessionInfo == null) {
            return "";
        }
        return this.sessionInfo.getId();
    }

    public String getTopicId() {
        if (this.topicHandler == null) {
            return "";
        }
        return this.topicHandler.getId();
    }

    public String getParentSubscription() {
        if (this.querySub == null) {
            return "";
        }
        return this.querySub.getSubscriptionId();
    }

    public String getCreationTimestamp() {
        return TimeHelper.getDateTimeDump(this.creationTime);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

