/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import org.jutils.log.LogChannel;
import org.w3c.dom.Node;
import org.xmlBlaster.authentication.Authenticate;
import org.xmlBlaster.authentication.SessionInfo;
import org.xmlBlaster.authentication.SubjectInfo;
import org.xmlBlaster.client.key.PublishKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.client.qos.PublishReturnQos;
import org.xmlBlaster.engine.Global;
import org.xmlBlaster.engine.I_SubscriptionListener;
import org.xmlBlaster.engine.MsgUnitWrapper;
import org.xmlBlaster.engine.RequestBroker;
import org.xmlBlaster.engine.SubscriptionEvent;
import org.xmlBlaster.engine.SubscriptionInfo;
import org.xmlBlaster.engine.distributor.I_MsgDistributor;
import org.xmlBlaster.engine.mime.I_AccessFilter;
import org.xmlBlaster.engine.msgstore.I_Map;
import org.xmlBlaster.engine.qos.ConnectQosServer;
import org.xmlBlaster.engine.qos.ConnectReturnQosServer;
import org.xmlBlaster.engine.qos.EraseQosServer;
import org.xmlBlaster.engine.qos.PublishQosServer;
import org.xmlBlaster.engine.qos.SubscribeQosServer;
import org.xmlBlaster.engine.queuemsg.MsgQueueHistoryEntry;
import org.xmlBlaster.engine.queuemsg.MsgQueueUpdateEntry;
import org.xmlBlaster.engine.queuemsg.TopicEntry;
import org.xmlBlaster.engine.xml2java.XmlKey;
import org.xmlBlaster.util.I_Timeout;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.SessionName;
import org.xmlBlaster.util.Timeout;
import org.xmlBlaster.util.Timestamp;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.def.MethodName;
import org.xmlBlaster.util.key.MsgKeyData;
import org.xmlBlaster.util.qos.AccessFilterQos;
import org.xmlBlaster.util.qos.MsgQosData;
import org.xmlBlaster.util.qos.QueryQosData;
import org.xmlBlaster.util.qos.StatusQosData;
import org.xmlBlaster.util.qos.TopicProperty;
import org.xmlBlaster.util.qos.address.Destination;
import org.xmlBlaster.util.qos.storage.HistoryQueueProperty;
import org.xmlBlaster.util.qos.storage.MsgUnitStoreProperty;
import org.xmlBlaster.util.queue.I_Entry;
import org.xmlBlaster.util.queue.I_Queue;
import org.xmlBlaster.util.queue.StorageId;
import org.xmlBlaster.util.queuemsg.MsgQueueEntry;

public final class TopicHandler
implements I_Timeout {
    private String ME = "TopicHandler";
    private final Global glob;
    private final LogChannel log;
    private boolean dyingInProgress = false;
    private final String id;
    private final RequestBroker requestBroker;
    private TopicEntry topicEntry;
    private I_MsgDistributor distributor;
    private final Map subscriberMap = new TreeMap();
    private I_Queue historyQueue;
    private SessionName creatorSessionName;
    private TopicProperty topicProperty;
    private I_Map msgUnitCache;
    private XmlKey xmlKey;
    private String uniqueKey;
    private MsgKeyData msgKeyData;
    private boolean handlerIsNewCreated = true;
    private boolean isRegisteredInBigXmlDom = false;
    private Timeout destroyTimer;
    private Timestamp timerKey = null;
    private static final int UNDEF = -1;
    private static final int UNCONFIGURED = 0;
    private static final int ALIVE = 1;
    private static final int UNREFERENCED = 2;
    private static final int SOFT_ERASED = 3;
    private static final int DEAD = 4;
    private int state = -1;
    private final Object ADMIN_MONITOR = new Object();
    private I_SubscriptionListener subscriptionListener;
    private Map msgUnitWrapperUnderConstruction = new HashMap();

    public TopicHandler(RequestBroker requestBroker, String uniqueKey) throws XmlBlasterException {
        this.glob = requestBroker.getGlobal();
        if (uniqueKey == null) {
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, this.ME, "Invalid constructor parameters");
        }
        this.log = this.glob.getLog("core");
        this.id = this.glob.getNodeId() + "/" + "topic" + "/" + uniqueKey;
        this.ME = this.ME + this.glob.getLogPrefixDashed() + "/" + "topic" + "/" + uniqueKey;
        this.requestBroker = requestBroker;
        this.uniqueKey = uniqueKey;
        this.destroyTimer = requestBroker.getGlobal().getTopicTimer();
        this.toUnconfigured();
        TopicHandler t = this.requestBroker.addTopicHandler(this);
        if (t != null) {
            this.log.error(this.ME, "Unexpected duplicated of TopicHandler in RequestBroker");
            Thread.dumpStack();
        }
        if (this.log.CALL) {
            this.log.trace(this.ME, "Creating new TopicHandler because of subscription.");
        }
    }

    public TopicHandler(RequestBroker requestBroker, SessionInfo publisherSessionInfo, String keyOid) throws XmlBlasterException {
        this.glob = requestBroker.getGlobal();
        if (keyOid == null) {
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, this.ME, "Invalid constructor parameters, keyOid=null");
        }
        this.log = this.glob.getLog("core");
        this.requestBroker = requestBroker;
        this.uniqueKey = keyOid;
        this.id = this.glob.getNodeId() + "/" + "topic" + "/" + keyOid;
        this.ME = this.ME + this.glob.getLogPrefixDashed() + "/" + "topic" + "/" + keyOid;
        this.destroyTimer = requestBroker.getGlobal().getTopicTimer();
        this.toUnconfigured();
        TopicHandler t = requestBroker.addTopicHandler(this);
        if (t != null) {
            this.log.error(this.ME, "Unexpected duplicated of TopicHandler in RequestBroker");
            Thread.dumpStack();
        }
        if (this.log.CALL) {
            this.log.trace(this.ME, "Creating new TopicHandler.");
        }
    }

    public String getId() {
        return this.id;
    }

    private synchronized void administrativeInitialize(MsgKeyData msgKeyData, MsgQosData publishQos, PublishQosServer publishQosServer) throws XmlBlasterException {
        long maxEntriesHistory;
        if (!this.isUnconfigured() && !this.isSoftErased()) {
            this.log.error(this.ME, "Sorry we are in state '" + this.getStateStr() + "', reconfiguring TopicHandler is not yet supported, we ignore the request");
            return;
        }
        if (publishQosServer.getTopicEntry() != null) {
            this.topicEntry = publishQosServer.getTopicEntry();
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Reuse TopicEntry persistence handle");
            }
            if (this.log.DUMP) {
                this.log.dump(this.ME, "Reuse TopicEntry persistence handle: " + this.topicEntry.toXml());
            }
        }
        if (this.msgKeyData == null) {
            this.msgKeyData = msgKeyData;
        }
        if (this.log.DUMP) {
            this.log.dump(this.ME, "administrativeInitialize()" + publishQos.toXml());
        }
        this.creatorSessionName = publishQos.getSender();
        this.topicProperty = publishQos.getTopicProperty();
        this.startupMsgstore();
        this.startupHistoryQueue();
        if (this.isUnconfigured()) {
            if (!this.hasCacheEntries() && !this.hasSubscribers()) {
                this.toUnreferenced(true);
            } else {
                this.toAlive();
            }
        }
        String hist = (maxEntriesHistory = this.topicProperty.getHistoryQueueProperty().getMaxEntries()) > 0L ? "history/maxEntries=" + maxEntriesHistory : "message history is switched off with queue/history/maxEntries=0";
        long maxEntriesStore = this.topicProperty.getMsgUnitStoreProperty().getMaxEntries();
        String store = maxEntriesStore > 0L ? "persistence/msgUnitStore/maxEntries=" + maxEntriesStore : "message storage is switched off with persistence/msgUnitStore/maxEntries=0";
        this.log.info(this.ME, "New topic is ready, " + hist + ", " + store);
    }

    private void startupMsgstore() throws XmlBlasterException {
        TopicHandler topicHandler = this;
        synchronized (topicHandler) {
            MsgUnitStoreProperty msgUnitStoreProperty = this.topicProperty.getMsgUnitStoreProperty();
            if (this.msgUnitCache == null) {
                String type = msgUnitStoreProperty.getType();
                String version = msgUnitStoreProperty.getVersion();
                StorageId msgUnitStoreId = new StorageId("msgUnitStore", this.glob.getNodeId() + "/" + this.getUniqueKey());
                this.msgUnitCache = this.glob.getStoragePluginManager().getPlugin(type, version, msgUnitStoreId, msgUnitStoreProperty);
                if (this.msgUnitCache == null) {
                    throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME, "Can't load msgUnitStore persistence plugin [" + type + "][" + version + "]");
                }
            } else {
                this.log.info(this.ME, "Reconfiguring message store.");
                this.msgUnitCache.setProperties(msgUnitStoreProperty);
            }
        }
    }

    private void startupHistoryQueue() throws XmlBlasterException {
        this.historyQueue = this.initQueue(this.historyQueue, "history");
    }

    private I_Queue initQueue(I_Queue queue, String queueName) throws XmlBlasterException {
        TopicHandler topicHandler = this;
        synchronized (topicHandler) {
            HistoryQueueProperty prop = this.topicProperty.getHistoryQueueProperty();
            if (queue == null) {
                if (prop.getMaxEntries() > 0L) {
                    String type = prop.getType();
                    String version = prop.getVersion();
                    StorageId queueId = new StorageId(queueName, this.glob.getNodeId() + "/" + this.getUniqueKey());
                    queue = this.glob.getQueuePluginManager().getPlugin(type, version, queueId, prop);
                    queue.setNotifiedAboutAddOrRemove(true);
                } else if (this.log.TRACE) {
                    this.log.trace(this.ME, queueName + " queuing of this topic is switched off with maxEntries=0");
                }
            } else if (prop.getMaxEntries() > 0L) {
                this.log.info(this.ME, "Reconfiguring " + queueName + " queue.");
                queue.setProperties(prop);
            } else {
                this.log.warn(this.ME, "Destroying " + queueName + " queue with " + queue.getNumOfEntries() + " entries because of new configuration with maxEntries=0");
                queue.clear();
                queue.shutdown();
                queue = null;
            }
        }
        return queue;
    }

    public boolean hasDomTree() {
        if (this.topicProperty == null) {
            return false;
        }
        return this.topicProperty.createDomEntry();
    }

    public void finalize() {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "finalize - garbage collect " + this.getId());
        }
    }

    public RequestBroker getRequestBroker() {
        return this.requestBroker;
    }

    public final boolean hasXmlKey() {
        return this.msgKeyData != null;
    }

    public final XmlKey getXmlKey() throws XmlBlasterException {
        if (this.msgKeyData == null) {
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.getId(), "In state '" + this.getStateStr() + "' no XmlKey object is available");
        }
        if (this.xmlKey == null) {
            TopicHandler topicHandler = this;
            synchronized (topicHandler) {
                if (this.xmlKey == null) {
                    this.xmlKey = new XmlKey(this.glob, this.msgKeyData);
                }
            }
        }
        return this.xmlKey;
    }

    private TopicEntry persistTopicEntry() throws XmlBlasterException {
        if (this.topicEntry == null) {
            boolean isNew = false;
            TopicHandler topicHandler = this;
            synchronized (topicHandler) {
                if (this.topicEntry == null) {
                    if (this.log.TRACE) {
                        this.log.trace(this.ME, "Creating TopicEntry to make topic persistent");
                    }
                    if (this.topicProperty == null || this.msgKeyData == null) {
                        this.log.error(this.ME, "Can't create useful TopicEntry in state=" + this.getStateStr() + " no QoS is available");
                        TopicEntry topicEntry = null;
                        return topicEntry;
                    }
                    MsgQosData msgQosData = new MsgQosData(this.glob, MethodName.PUBLISH);
                    msgQosData.setTopicProperty(this.topicProperty);
                    msgQosData.setAdministrative(true);
                    msgQosData.touchRcvTimestamp();
                    msgQosData.setPersistent(true);
                    msgQosData.setSender(this.creatorSessionName);
                    MsgUnit msgUnit = new MsgUnit(this.msgKeyData, null, msgQosData);
                    this.topicEntry = new TopicEntry(this.glob, msgUnit);
                    isNew = true;
                    if (this.log.TRACE) {
                        this.log.trace(this.ME, "Created persistent topicEntry '" + this.topicEntry.getUniqueId() + "'");
                    }
                }
            }
            if (isNew) {
                this.persistTopic(this.topicEntry);
            }
        }
        return this.topicEntry;
    }

    private boolean persistTopic(TopicEntry entry) {
        try {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Making topicHandler persistent, topicEntry=" + this.topicEntry.getUniqueId());
            }
            int numAdded = this.requestBroker.addPersistentTopicHandler(entry);
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Persisted " + numAdded + " TopicHandler");
            }
            return numAdded > 0;
        }
        catch (XmlBlasterException e) {
            this.log.error(this.ME, "Persisting TopicHandler failed, we continue memory based: " + e.getMessage());
            return false;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PublishReturnQos publish(SessionInfo publisherSessionInfo, MsgUnit msgUnit, PublishQosServer publishQosServer) throws XmlBlasterException {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "publish() publisherSessionInfo '" + publisherSessionInfo.getId() + "', message '" + msgUnit.getLogId() + "' ...");
        }
        publishReturnQos = null;
        msgQosData = null;
        var6_6 = this;
        synchronized (var6_6) {
            qos = new StatusQosData(this.glob, MethodName.PUBLISH);
            qos.setKeyOid(this.uniqueKey);
            qos.setState("OK");
            qos.setRcvTimestamp(publishQosServer.getRcvTimestamp());
            publishReturnQos = new PublishReturnQos((org.xmlBlaster.util.Global)this.glob, (StatusQosData)qos);
            msgKeyData = (MsgKeyData)msgUnit.getKeyData();
            msgQosData = (MsgQosData)msgUnit.getQosData();
            if (msgQosData.isAdministrative()) {
                var9_10 = this.ADMIN_MONITOR;
                synchronized (var9_10) {
                    this.administrativeInitialize(msgKeyData, msgQosData, publishQosServer);
                    if (this.handlerIsNewCreated) {
                        this.handlerIsNewCreated = false;
                        this.glob.getRequestBroker().checkExistingSubscriptions(publisherSessionInfo, this, publishQosServer);
                    }
                    if (msgQosData.isFromPersistenceStore()) {
                        this.log.info(this.ME, "Topic is successfully recovered from persistency to state " + this.getStateStr() + " with " + this.getNumOfHistoryEntries() + " history entries (" + this.getNumOfCacheEntries() + " currently referenced msgUnits are loaded).");
                    } else {
                        this.log.info(this.ME, "Topic is successfully configured by administrative message.");
                    }
                    publishReturnQos.getData().setStateInfo("Administrative configuration request handled");
                    return publishReturnQos;
                }
            }
            if (this.isUnconfigured() || this.isDead() || this.isSoftErased()) {
                var9_11 = this;
                synchronized (var9_11) {
                    if (this.isUnconfigured() || this.isDead() || this.isSoftErased()) {
                        this.administrativeInitialize(msgKeyData, msgQosData, publishQosServer);
                    }
                }
            }
            if (!this.isAlive()) {
                this.toAlive();
            }
            ** if (!this.handlerIsNewCreated) goto lbl40
        }
lbl-1000:
        // 1 sources

        {
            qos = this.ADMIN_MONITOR;
            synchronized (qos) {
                if (this.handlerIsNewCreated) {
                    this.glob.getRequestBroker().checkExistingSubscriptions(publisherSessionInfo, this, publishQosServer);
                    this.handlerIsNewCreated = false;
                }
            }
        }
lbl40:
        // 4 sources

        initialCounter = 1;
        msgUnitWrapper = null;
        try {
            changed = true;
            var10_14 = this;
            synchronized (var10_14) {
                block60: {
                    isInvisiblePtp = publishQosServer.isPtp() != false && publishQosServer.isSubscribable() == false;
                    v0 = addToHistoryQueue = this.historyQueue != null && isInvisiblePtp == false;
                    if (!isInvisiblePtp && this.topicProperty.isReadonly() && this.hasHistoryEntries()) {
                        this.log.warn(this.ME + ".Readonly", "Sorry, published message '" + this.msgKeyData.getOid() + "' rejected, message is readonly.");
                        throw new XmlBlasterException(this.glob, ErrorCode.USER_PUBLISH_READONLY, this.ME, "Sorry, published message '" + this.msgKeyData.getOid() + "' rejected, message is readonly.");
                    }
                    msgUnitWrapper = new MsgUnitWrapper(this.glob, msgUnit, this.msgUnitCache, initialCounter, 0, -1L);
                    var13_18 = this.msgUnitWrapperUnderConstruction;
                    synchronized (var13_18) {
                        this.msgUnitWrapperUnderConstruction.put(new Long(msgUnitWrapper.getUniqueId()), msgUnitWrapper);
                        ** if (!addToHistoryQueue || !msgUnitWrapper.isAlive()) goto lbl72
                    }
lbl-1000:
                    // 1 sources

                    {
                        if (!msgQosData.isForceUpdate() && this.hasHistoryEntries() && (entry = (MsgQueueHistoryEntry)this.historyQueue.peek()) != null && (old = entry.getMsgUnitWrapper()) != null) {
                            changed = old.getMsgUnit().sameContent(msgUnit.getContent()) == false;
                        }
                        try {
                            this.historyQueue.put(new MsgQueueHistoryEntry(this.glob, msgUnitWrapper, this.historyQueue.getStorageId()), false);
                            numHist = this.getNumOfHistoryEntries();
                            if (numHist <= 1L || numHist <= this.historyQueue.getMaxNumOfEntries()) break block60;
                            entryList = this.historyQueue.takeLowest(1, -1L, null, false);
                            if (entryList.size() != 1) {
                                throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME, "Can't remove expected entry, entryList.size()=" + entryList.size() + ": " + this.historyQueue.toXml(""));
                            }
                            entry = (MsgQueueHistoryEntry)entryList.get(0);
                            if (this.log.TRACE && !entry.isInternal()) {
                                this.log.trace(this.ME, "Removed oldest entry in history queue.");
                            }
                        }
                        catch (XmlBlasterException e) {
                            this.log.error(this.ME, "History queue put() problem: " + e.getMessage());
                        }
                    }
                }
                ** if (!publishQosServer.isPtp()) goto lbl108
            }
lbl-1000:
            // 1 sources

            {
                this.forwardToDestinations(publisherSessionInfo, msgUnitWrapper, publishQosServer);
                if (!publishQosServer.isSubscribable()) {
                    publishReturnQos.getData().setStateInfo("PtP request handled");
                    var11_16 = publishReturnQos;
                    var21_25 = null;
                    if (msgUnitWrapper == null) return var11_16;
                    var22_28 = msgUnitWrapper;
                    synchronized (var22_28) {
                        var23_31 = this.msgUnitCache;
                        synchronized (var23_31) {
                            try {
                                if (initialCounter != 0) {
                                    msgUnitWrapper.setReferenceCounter(-1 * initialCounter);
                                }
                                if (!msgUnitWrapper.isDestroyed()) {
                                    this.msgUnitCache.put(msgUnitWrapper);
                                }
                                var25_34 = null;
                                var26_40 = this.msgUnitWrapperUnderConstruction;
                                synchronized (var26_40) {
                                    this.msgUnitWrapperUnderConstruction.remove(new Long(msgUnitWrapper.getUniqueId()));
                                }
                            }
                            catch (Throwable var24_46) {
                                var25_35 = null;
                                var26_41 = this.msgUnitWrapperUnderConstruction;
                                synchronized (var26_41) {
                                    this.msgUnitWrapperUnderConstruction.remove(new Long(msgUnitWrapper.getUniqueId()));
                                    throw var24_46;
                                }
                            }
                            return var11_16;
                        }
                    }
                }
            }
lbl108:
            // 3 sources

            if (this.log.TRACE) {
                this.log.trace(this.ME, "Message " + msgUnit.getLogId() + " handled, now we can send updates to all interested clients.");
            }
            if (changed || msgQosData.isForceUpdate()) {
                this.invokeCallbackAndHandleFailure(publisherSessionInfo, msgUnitWrapper);
            }
            var21_26 = null;
            if (msgUnitWrapper == null) return publishReturnQos;
            var22_29 = msgUnitWrapper;
            synchronized (var22_29) {
                var23_32 = this.msgUnitCache;
                synchronized (var23_32) {
                    try {}
                    catch (Throwable var24_47) {
                        var25_37 = null;
                        var26_43 = this.msgUnitWrapperUnderConstruction;
                        synchronized (var26_43) {
                            this.msgUnitWrapperUnderConstruction.remove(new Long(msgUnitWrapper.getUniqueId()));
                            throw var24_47;
                        }
                    }
                    if (initialCounter != 0) {
                        msgUnitWrapper.setReferenceCounter(-1 * initialCounter);
                    }
                    if (!msgUnitWrapper.isDestroyed()) {
                        this.msgUnitCache.put(msgUnitWrapper);
                    }
                    var25_36 = null;
                    var26_42 = this.msgUnitWrapperUnderConstruction;
                    synchronized (var26_42) {
                        this.msgUnitWrapperUnderConstruction.remove(new Long(msgUnitWrapper.getUniqueId()));
                    }
                    return publishReturnQos;
                }
            }
        }
        catch (Throwable var20_49) {
            var21_27 = null;
            if (msgUnitWrapper == null) throw var20_49;
            var22_30 = msgUnitWrapper;
            synchronized (var22_30) {
                var23_33 = this.msgUnitCache;
                synchronized (var23_33) {
                    try {}
                    catch (Throwable var24_48) {
                        var25_39 = null;
                        var26_45 = this.msgUnitWrapperUnderConstruction;
                        synchronized (var26_45) {
                            this.msgUnitWrapperUnderConstruction.remove(new Long(msgUnitWrapper.getUniqueId()));
                            throw var24_48;
                        }
                    }
                    if (initialCounter != 0) {
                        msgUnitWrapper.setReferenceCounter(-1 * initialCounter);
                    }
                    if (!msgUnitWrapper.isDestroyed()) {
                        this.msgUnitCache.put(msgUnitWrapper);
                    }
                    var25_38 = null;
                    var26_44 = this.msgUnitWrapperUnderConstruction;
                    synchronized (var26_44) {
                        this.msgUnitWrapperUnderConstruction.remove(new Long(msgUnitWrapper.getUniqueId()));
                    }
                    throw var20_49;
                }
            }
        }
    }

    boolean isInMsgStore(MsgUnitWrapper msgUnitWrapper) {
        Map map = this.msgUnitWrapperUnderConstruction;
        synchronized (map) {
            boolean bl = !this.msgUnitWrapperUnderConstruction.containsKey(new Long(msgUnitWrapper.getUniqueId()));
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void forwardToDestinations(SessionInfo publisherSessionInfo, MsgUnitWrapper cacheEntry, PublishQosServer publishQos) throws XmlBlasterException {
        Destination[] destinationArr = publishQos.getDestinationArr();
        Authenticate authenticate = this.requestBroker.getAuthenticate();
        int ii = 0;
        while (true) {
            block27: {
                if (ii >= destinationArr.length) {
                    return;
                }
                Destination destination = destinationArr[ii];
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Working on PtP message for destination [" + destination.getDestination() + "]");
                }
                SessionName destinationSessionName = destination.getDestination();
                boolean destinationIsSession = destinationSessionName.isSession();
                boolean forceQueing = destination.forceQueuing();
                boolean wantsPtP = true;
                SubjectInfo destinationClient = null;
                if (!destinationIsSession) {
                    Object var16_19;
                    destinationClient = authenticate.getSubjectInfoByName(destination.getDestination());
                    if (!forceQueing && destinationClient == null) {
                        String tmp = "Sending PtP message '" + cacheEntry.getLogId() + "' to '" + destination.getDestination() + "' failed, the destination is unkown, the message rejected.";
                        this.log.warn(this.ME, tmp);
                        throw new XmlBlasterException(this.glob, ErrorCode.USER_PTP_UNKNOWNDESTINATION, this.ME, tmp + " Client is not logged in and <destination forceQueuing='true'> is not set");
                    }
                    if (this.log.TRACE) {
                        this.log.trace(this.ME, "Queuing PtP message '" + cacheEntry.getLogId() + "' for subject destination [" + destination.getDestination() + "], forceQueing=" + forceQueing);
                    }
                    boolean returnLocked = true;
                    destinationClient = authenticate.getOrCreateSubjectInfoByName(destination.getDestination(), true, null, null);
                    try {
                        MsgQueueUpdateEntry msgEntrySubject = new MsgQueueUpdateEntry(this.glob, cacheEntry, destinationClient.getSubjectQueue().getStorageId(), destination.getDestination(), "__subId:PtP");
                        destinationClient.queueMessage(msgEntrySubject);
                        var16_19 = null;
                    }
                    catch (Throwable throwable) {
                        var16_19 = null;
                        destinationClient.getLock().release();
                        throw throwable;
                    }
                    destinationClient.getLock().release();
                } else {
                    Object var22_24;
                    SessionInfo receiverSessionInfo = null;
                    try {
                        receiverSessionInfo = authenticate.getSessionInfo(destination.getDestination());
                        if (receiverSessionInfo != null) {
                            receiverSessionInfo.getLock().lock();
                            if (receiverSessionInfo.isAlive()) {
                                if (!receiverSessionInfo.getConnectQos().isPtpAllowed()) {
                                    if (this.log.TRACE) {
                                        this.log.trace(this.ME, "Rejecting PtP message '" + cacheEntry.getLogId() + "' for destination [" + destination.getDestination() + "], isPtpAllowed=false");
                                    }
                                    throw new XmlBlasterException(this.glob, ErrorCode.USER_PTP_DENIED, this.ME, receiverSessionInfo.getId() + " does not accept PtP messages '" + cacheEntry.getLogId() + "' is rejected");
                                }
                            } else {
                                receiverSessionInfo.getLock().release();
                                receiverSessionInfo = null;
                            }
                        }
                        if (receiverSessionInfo == null && !forceQueing) {
                            String tmp = "Sending PtP message '" + cacheEntry.getLogId() + "' to '" + destination.getDestination() + "' failed, the destination is unkown, the message rejected.";
                            this.log.warn(this.ME, tmp);
                            throw new XmlBlasterException(this.glob, ErrorCode.USER_PTP_UNKNOWNDESTINATION, this.ME, tmp + " Client is not logged in and <destination forceQueuing='true'> is not set");
                        }
                        if (receiverSessionInfo == null) {
                            if (this.log.TRACE) {
                                this.log.trace(this.ME, "Working on PtP message '" + cacheEntry.getLogId() + "' for destination [" + destination.getDestination() + "] which does not exist, forceQueuing=true, we create a dummy session");
                            }
                            ConnectQos connectQos = new ConnectQos(this.glob);
                            connectQos.setSessionName(destinationSessionName);
                            connectQos.setUserId(destinationSessionName.getLoginName());
                            ConnectQosServer connectQosServer = new ConnectQosServer((org.xmlBlaster.util.Global)this.glob, connectQos.getData());
                            connectQosServer.bypassCredentialCheck(true);
                            long sessionTimeout = this.glob.getProperty().get("session.ptp.defaultTimeout", -1L);
                            connectQosServer.getSessionQos().setSessionTimeout(sessionTimeout);
                            int i = 0;
                            while (true) {
                                if (i >= 20) {
                                    String tmp = "Sending PtP message '" + cacheEntry.getLogId() + "' to '" + destination.getDestination() + "' failed, the message is rejected.";
                                    String status = "destinationIsSession='" + destinationIsSession + "'" + " forceQueing='" + forceQueing + "' wantsPtP='" + wantsPtP + "'";
                                    throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_NOTIMPLEMENTED, this.ME, tmp + "the combination '" + status + "' is not handled");
                                }
                                if (i > 0) {
                                    try {
                                        Thread.currentThread();
                                        Thread.sleep(1L);
                                    }
                                    catch (InterruptedException ie) {
                                        // empty catch block
                                    }
                                }
                                ConnectReturnQosServer q = authenticate.connect(connectQosServer);
                                receiverSessionInfo = authenticate.getSessionInfo(destination.getDestination());
                                if (receiverSessionInfo != null) {
                                    receiverSessionInfo.getLock().lock();
                                    if (receiverSessionInfo.isAlive()) break;
                                    receiverSessionInfo.getLock().release();
                                    receiverSessionInfo = null;
                                }
                                ++i;
                            }
                        }
                        if (this.log.TRACE) {
                            this.log.trace(this.ME, "Queuing PtP message '" + cacheEntry.getLogId() + "' for destination [" + destination.getDestination() + "]");
                        }
                        MsgQueueUpdateEntry msgEntry = new MsgQueueUpdateEntry(this.glob, cacheEntry, receiverSessionInfo.getSessionQueue().getStorageId(), destination.getDestination(), "__subId:PtP");
                        receiverSessionInfo.queueMessage(msgEntry);
                        var22_24 = null;
                        if (receiverSessionInfo == null) break block27;
                    }
                    catch (Throwable throwable) {
                        var22_24 = null;
                        if (receiverSessionInfo != null) {
                            receiverSessionInfo.getLock().release();
                        }
                        throw throwable;
                    }
                    receiverSessionInfo.getLock().release();
                }
            }
            ++ii;
        }
    }

    public I_Map getMsgUnitCache() {
        return this.msgUnitCache;
    }

    public MsgUnitWrapper getMsgUnitWrapper(long uniqueId) throws XmlBlasterException {
        Map map = this.msgUnitWrapperUnderConstruction;
        synchronized (map) {
            Object obj;
            if (this.msgUnitWrapperUnderConstruction.size() > 0 && (obj = this.msgUnitWrapperUnderConstruction.get(new Long(uniqueId))) != null) {
                MsgUnitWrapper msgUnitWrapper = (MsgUnitWrapper)obj;
                return msgUnitWrapper;
            }
        }
        if (this.msgUnitCache == null) {
            return null;
        }
        return (MsgUnitWrapper)this.msgUnitCache.get(uniqueId);
    }

    public void entryExpired(MsgUnitWrapper msgUnitWrapper) throws XmlBlasterException {
        if (this.historyQueue == null) {
            return;
        }
        MsgUnitWrapper msgUnitWrapper2 = msgUnitWrapper;
        synchronized (msgUnitWrapper2) {
            boolean preDestroyed;
            int numHistory = msgUnitWrapper.getHistoryReferenceCounter();
            if (numHistory > 0 && (preDestroyed = msgUnitWrapper.incrementReferenceCounter(-1 * numHistory, this.historyQueue.getStorageId()))) {
                msgUnitWrapper.toDestroyed();
            }
        }
    }

    public void entryDestroyed(MsgUnitWrapper msgUnitWrapper) {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering entryDestroyed(" + msgUnitWrapper.getLogId() + ")");
        }
        boolean underConstruction = false;
        Map map = this.msgUnitWrapperUnderConstruction;
        synchronized (map) {
            Object obj;
            if (this.msgUnitWrapperUnderConstruction.size() > 0 && (obj = this.msgUnitWrapperUnderConstruction.get(new Long(msgUnitWrapper.getUniqueId()))) != null) {
                underConstruction = true;
            }
        }
        if (!underConstruction) {
            try {
                this.getMsgUnitCache().remove(msgUnitWrapper);
            }
            catch (XmlBlasterException e) {
                this.log.error(this.ME, "Internal problem in entryDestroyed removeRandom of msg store (this can lead to a memory leak of '" + msgUnitWrapper.getLogId() + "'): " + e.getMessage() + ": " + this.toXml());
            }
        }
        TopicHandler topicHandler = this;
        synchronized (topicHandler) {
            if (!this.hasCacheEntries() && !this.hasSubscribers()) {
                try {
                    if (this.isSoftErased()) {
                        this.toDead(this.creatorSessionName, false);
                    } else {
                        this.toUnreferenced(false);
                    }
                }
                catch (XmlBlasterException e) {
                    this.log.error(this.ME, "Internal problem with removeSubscriber: " + e.getMessage() + ": " + this.toXml());
                }
            }
        }
        msgUnitWrapper = null;
    }

    public final Node getRootNode() throws XmlBlasterException {
        return this.getXmlKey().getRootNode();
    }

    public void addSubscriber(SubscriptionInfo sub, boolean calleeIsXPathMatchCheck) throws XmlBlasterException {
        if (sub.getSubscribeCounter() > 1) {
            return;
        }
        Map map = this.subscriberMap;
        synchronized (map) {
            SubscriptionInfo oldOne = this.subscriberMap.put(sub.getSubscriptionId(), sub);
        }
        sub.addTopicHandler(this);
        if (this.subscriptionListener != null) {
            this.subscriptionListener.subscriptionAdd(new SubscriptionEvent(sub));
        }
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Client '" + sub.getSessionInfo().getId() + "' has successfully subscribed");
        }
        if (this.isUnconfigured()) {
            return;
        }
        if (this.isUnreferenced()) {
            this.toAlive();
        }
        if (this.subscriptionListener != null) {
            return;
        }
        SubscribeQosServer subscribeQosServer = sub.getSubscribeQosServer();
        if (subscribeQosServer == null) {
            return;
        }
        if (this.log.TRACE) {
            this.log.trace(this.ME, "addSubscriber(" + sub.getId() + ")");
        }
        if (subscribeQosServer.getWantInitialUpdate() || calleeIsXPathMatchCheck) {
            MsgUnitWrapper[] wrappers = null;
            if (this.hasHistoryEntries()) {
                wrappers = this.getMsgUnitWrapperArr(subscribeQosServer.getData().getHistoryQos().getNumEntries(), subscribeQosServer.getData().getHistoryQos().getNewestFirst());
            }
            if (wrappers != null && wrappers.length > 0) {
                int count = 0;
                int currentCount = 0;
                int i = 0;
                while (i < wrappers.length) {
                    if (this.distributor == null || wrappers[i].isInternal()) {
                        currentCount = this.invokeCallback(null, sub, wrappers[i]);
                    }
                    if (currentCount == -1) break;
                    count += currentCount;
                    ++i;
                }
                if (++count < 1) {
                    HashSet<SubscriptionInfo> removeSet = new HashSet<SubscriptionInfo>();
                    removeSet.add(sub);
                    this.handleCallbackFailed(removeSet);
                }
            }
        }
    }

    public void handleCallbackFailed(Set removeSet) throws XmlBlasterException {
        if (removeSet != null) {
            Iterator iterator = removeSet.iterator();
            while (iterator.hasNext()) {
                SubscriptionInfo sub = (SubscriptionInfo)iterator.next();
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Removed subscriber '" + sub.getSessionInfo().getId() + "' as callback failed.");
                }
                sub.removeSubscribe();
            }
            removeSet.clear();
            removeSet = null;
        }
    }

    SubscriptionInfo removeSubscriber(String subscriptionInfoUniqueKey) {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Before size of subscriberMap = " + this.subscriberMap.size());
        }
        SubscriptionInfo subs = null;
        Map map = this.subscriberMap;
        synchronized (map) {
            subs = (SubscriptionInfo)this.subscriberMap.remove(subscriptionInfoUniqueKey);
        }
        if (subs == null && !this.isDead() && !this.isSoftErased()) {
            this.log.warn(this.ME, ", can't unsubscribe, you where not subscribed to subscription ID=" + subscriptionInfoUniqueKey);
        }
        if (this.log.TRACE) {
            this.log.trace(this.ME, "After size of subscriberMap = " + this.subscriberMap.size());
        }
        if (this.isDead()) {
            if (this.subscriptionListener != null) {
                try {
                    this.subscriptionListener.subscriptionRemove(new SubscriptionEvent(subs));
                }
                catch (XmlBlasterException ex) {
                    this.log.error(this.ME, "removeSubscriber: an exception occured: " + ex.getMessage());
                }
            }
            return subs;
        }
        TopicHandler topicHandler = this;
        synchronized (topicHandler) {
            if (!this.hasCacheEntries() && !this.hasSubscribers()) {
                if (this.isUnconfigured()) {
                    this.toDead(this.creatorSessionName, false);
                } else {
                    try {
                        this.toUnreferenced(false);
                    }
                    catch (XmlBlasterException e) {
                        this.log.error(this.ME, "Internal problem with removeSubscriber: " + e.getMessage() + ": " + this.toXml());
                    }
                }
            }
        }
        if (this.subscriptionListener != null) {
            try {
                this.subscriptionListener.subscriptionRemove(new SubscriptionEvent(subs));
            }
            catch (XmlBlasterException ex) {
                this.log.error(this.ME, "removeSubscriber: an exception occured: " + ex.getMessage());
            }
        }
        return subs;
    }

    public String getUniqueKey() {
        return this.uniqueKey;
    }

    public MsgKeyData getMsgKeyData() {
        return this.msgKeyData;
    }

    public String getContentMime() {
        return this.msgKeyData != null ? this.msgKeyData.getContentMime() : null;
    }

    public String getContentMimeExtended() {
        return this.msgKeyData != null ? this.msgKeyData.getContentMimeExtended() : null;
    }

    private final void invokeCallbackAndHandleFailure(SessionInfo publisherSessionInfo, MsgUnitWrapper msgUnitWrapper) throws XmlBlasterException {
        if (msgUnitWrapper == null) {
            Thread.dumpStack();
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, this.ME, "MsgUnitWrapper is null");
        }
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Going to update dependent clients for " + msgUnitWrapper.getKeyOid() + ", subscriberMap.size() = " + this.subscriberMap.size());
        }
        if (this.distributor != null && !msgUnitWrapper.isInternal()) {
            this.distributor.distribute(msgUnitWrapper);
            return;
        }
        SubscriptionInfo[] subInfoArr = this.getSubscriptionInfoArr();
        HashSet<SubscriptionInfo> removeSet = null;
        int ii = 0;
        while (ii < subInfoArr.length) {
            SubscriptionInfo sub = subInfoArr[ii];
            if (this.subscriberMayReceiveIt(sub, msgUnitWrapper) && this.invokeCallback(publisherSessionInfo, sub, msgUnitWrapper) < 1) {
                if (removeSet == null) {
                    removeSet = new HashSet<SubscriptionInfo>();
                }
                removeSet.add(sub);
            }
            ++ii;
        }
        if (removeSet != null) {
            this.handleCallbackFailed(removeSet);
        }
    }

    public boolean checkIfAllowedToSend(SessionInfo publisherSessionInfo, SubscriptionInfo sub) {
        if (!sub.getSessionInfo().hasCallback()) {
            this.log.error(this.ME, "Internal problem: A client which subcribes should have a callback server: " + (publisherSessionInfo != null ? publisherSessionInfo.toXml("") : ""));
            Thread.dumpStack();
            return false;
        }
        if (this.isUnconfigured()) {
            this.log.warn(this.ME, "invokeCallback() not supported, this MsgUnit was created by a subscribe() and not a publish()");
            return false;
        }
        if (this.isUnreferenced()) {
            this.log.error(this.ME, "PANIC: invoke callback is strange in state 'UNREFERENCED'");
            Thread.dumpStack();
            return false;
        }
        return true;
    }

    public final boolean checkFilter(SessionInfo publisherSessionInfo, SubscriptionInfo sub, MsgUnitWrapper msgUnitWrapper, boolean handleException) throws XmlBlasterException {
        AccessFilterQos[] filterQos = sub.getAccessFilterArr();
        if (filterQos != null) {
            int ii = 0;
            while (ii < filterQos.length) {
                try {
                    I_AccessFilter filter = this.requestBroker.getAccessPluginManager().getAccessFilter(filterQos[ii].getType(), filterQos[ii].getVersion(), this.getContentMime(), this.getContentMimeExtended());
                    if (filter != null && !filter.match(sub.getSessionInfo(), msgUnitWrapper.getMsgUnit(), filterQos[ii].getQuery())) {
                        return false;
                    }
                }
                catch (Throwable e) {
                    SessionName publisherName = publisherSessionInfo != null ? publisherSessionInfo.getSessionName() : msgUnitWrapper.getMsgQosData().getSender();
                    String reason = "Mime access filter '" + filterQos[ii].getType() + "' for message '" + msgUnitWrapper.getLogId() + "' from sender '" + publisherName + "' to subscriber '" + sub.getSessionInfo().getSessionName() + "' threw an exception, we don't deliver " + "the message to the subscriber: " + e.toString();
                    if (this.log.TRACE) {
                        this.log.trace(this.ME, reason);
                    }
                    if (handleException) {
                        MsgQueueEntry[] entries = new MsgQueueEntry[]{new MsgQueueUpdateEntry(this.glob, msgUnitWrapper, sub.getMsgQueue().getStorageId(), sub.getSessionInfo().getSessionName(), sub.getSubSourceSubscriptionId())};
                        this.requestBroker.deadMessage(entries, null, reason);
                    }
                    throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME, "checkFilter: " + reason);
                }
                ++ii;
            }
        }
        return true;
    }

    public boolean isDirtyRead(SubscriptionInfo sub, MsgUnitWrapper msgUnitWrapper) throws XmlBlasterException {
        MsgQosData msgQosData = msgUnitWrapper.getMsgQosData();
        if (sub.getSessionInfo().getSubjectInfo().isCluster()) {
            if (this.log.DUMP) {
                this.log.dump(this.ME, "Slave node '" + sub.getSessionInfo() + "' has dirty read message '" + msgUnitWrapper.toXml());
            }
            if (msgQosData.dirtyRead(sub.getSessionInfo().getSubjectInfo().getNodeId())) {
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Slave node '" + sub.getSessionInfo() + "' has dirty read message '" + sub.getSubscriptionId() + "', '" + sub.getKeyData().getOid() + "' we don't need to send it back");
                }
                return true;
            }
        }
        return false;
    }

    public final MsgQueueUpdateEntry createEntryFromWrapper(MsgUnitWrapper msgUnitWrapper, SubscriptionInfo sub) throws XmlBlasterException {
        return new MsgQueueUpdateEntry(this.glob, msgUnitWrapper, sub.getMsgQueue().getStorageId(), sub.getSessionInfo().getSessionName(), sub.getSubSourceSubscriptionId());
    }

    public final int invokeCallback(SessionInfo publisherSessionInfo, SubscriptionInfo sub, MsgUnitWrapper msgUnitWrapper) {
        if (!this.checkIfAllowedToSend(publisherSessionInfo, sub)) {
            return -1;
        }
        if (msgUnitWrapper == null) {
            this.log.error(this.ME, "invokeCallback() MsgUnitWrapper is null: " + (publisherSessionInfo != null ? publisherSessionInfo.toXml() + "\n" : "") + (sub != null ? sub.toXml() + "\n" : "") + (this.historyQueue != null ? this.historyQueue.toXml("") : ""));
            Thread.dumpStack();
            return 0;
        }
        try {
            if (this.isDirtyRead(sub, msgUnitWrapper)) {
                return 1;
            }
            try {
                if (!this.checkFilter(publisherSessionInfo, sub, msgUnitWrapper, true)) {
                    return 1;
                }
            }
            catch (XmlBlasterException ex) {
                return 0;
            }
            if (this.log.CALL) {
                this.log.call(this.ME, "pushing update() message '" + sub.getKeyData().getOid() + "' " + msgUnitWrapper.getStateStr() + "' into '" + sub.getSessionInfo().getId() + "' callback queue");
            }
            MsgQueueUpdateEntry entry = this.createEntryFromWrapper(msgUnitWrapper, sub);
            sub.getMsgQueue().put(entry, false);
            return 1;
        }
        catch (Throwable e) {
            SessionName publisherName;
            SessionName sessionName = publisherName = publisherSessionInfo != null ? publisherSessionInfo.getSessionName() : msgUnitWrapper.getMsgQosData().getSender();
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Sending of message from " + publisherName + " to " + sub.getSessionInfo().getId() + " failed: " + e.toString());
            }
            try {
                MsgQueueEntry[] entries = new MsgQueueEntry[]{new MsgQueueUpdateEntry(this.glob, msgUnitWrapper, sub.getMsgQueue().getStorageId(), sub.getSessionInfo().getSessionName(), sub.getSubSourceSubscriptionId())};
                String reason = e.toString();
                if (e instanceof XmlBlasterException) {
                    reason = ((XmlBlasterException)e).getMessage();
                }
                this.requestBroker.deadMessage(entries, null, reason);
            }
            catch (XmlBlasterException e2) {
                this.log.error(this.ME, "PANIC: Sending of message '" + msgUnitWrapper.getLogId() + "' from " + publisherName + " to " + sub.getSessionInfo().getId() + " failed, message is lost: " + e2.getMessage() + " original exception is: " + e.toString());
            }
            return 1;
        }
    }

    public final int numSubscribers() {
        return this.subscriberMap.size();
    }

    public final boolean hasSubscribers() {
        return this.subscriberMap.size() != 0;
    }

    public final SubscriptionInfo[] getSubscriptionInfoArr() {
        Map map = this.subscriberMap;
        synchronized (map) {
            SubscriptionInfo[] subscriptionInfoArray = this.subscriberMap.values().toArray(new SubscriptionInfo[this.subscriberMap.size()]);
            return subscriptionInfoArray;
        }
    }

    public final boolean hasExactSubscribers() {
        Map map = this.subscriberMap;
        synchronized (map) {
            Iterator iterator = this.subscriberMap.values().iterator();
            while (iterator.hasNext()) {
                SubscriptionInfo sub = (SubscriptionInfo)iterator.next();
                if (sub.isCreatedByQuerySubscription()) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public final Vector findSubscriber(SessionInfo sessionInfo) {
        Vector<SubscriptionInfo> vec = null;
        Map map = this.subscriberMap;
        synchronized (map) {
            Iterator iterator = this.subscriberMap.values().iterator();
            while (iterator.hasNext()) {
                SubscriptionInfo sub = (SubscriptionInfo)iterator.next();
                if (!sub.getSessionInfo().isSameSession(sessionInfo)) continue;
                if (vec == null) {
                    vec = new Vector<SubscriptionInfo>();
                }
                vec.addElement(sub);
            }
        }
        return vec;
    }

    private void clearSubscribers() {
        SubscriptionInfo[] subscriptionInfoArr = this.getSubscriptionInfoArr();
        int i = 0;
        while (i < subscriptionInfoArr.length) {
            try {
                this.glob.getRequestBroker().fireUnSubscribeEvent(subscriptionInfoArr[i]);
            }
            catch (XmlBlasterException e) {
                this.log.error(this.ME, "Problems in clearSubscriber: " + e.getMessage());
            }
            ++i;
        }
        Map map = this.subscriberMap;
        synchronized (map) {
            this.subscriberMap.clear();
        }
    }

    public boolean hasHistoryEntries() {
        return this.getNumOfHistoryEntries() > 0L;
    }

    public long getNumOfHistoryEntries() {
        if (this.historyQueue == null) {
            return 0L;
        }
        long num = this.historyQueue.getNumOfEntries();
        if (!(num <= 0L || this.dyingInProgress || this.isAlive() || this.isUnconfigured())) {
            this.log.error(this.ME, "Internal problem: we have messages but are not alive: " + this.toXml());
            Thread.dumpStack();
        }
        return num;
    }

    public boolean hasCacheEntries() {
        return this.getNumOfCacheEntries() > 0L;
    }

    public long getNumOfCacheEntries() {
        if (this.msgUnitCache == null) {
            return 0L;
        }
        return this.msgUnitCache.getNumOfEntries();
    }

    public MsgUnitWrapper[] getMsgUnitWrapperArr(int num, boolean newestFirst) throws XmlBlasterException {
        if (this.historyQueue == null) {
            return new MsgUnitWrapper[0];
        }
        ArrayList historyList = this.historyQueue.peek(num, -1L);
        if (this.log.TRACE) {
            this.log.trace(this.ME, "getMsgUnitWrapperArr(" + num + "," + newestFirst + "), found " + historyList.size() + " historyList entries");
        }
        ArrayList<MsgUnitWrapper> aliveMsgUnitWrapperList = new ArrayList<MsgUnitWrapper>();
        ArrayList<MsgQueueHistoryEntry> historyDestroyList = null;
        int n = historyList.size();
        int i = 0;
        while (i < n) {
            MsgQueueHistoryEntry entry = (MsgQueueHistoryEntry)historyList.get(i);
            if (entry != null) {
                MsgUnitWrapper wr = entry.getMsgUnitWrapper();
                if (wr != null) {
                    if (wr.isAlive()) {
                        aliveMsgUnitWrapperList.add(wr);
                    } else {
                        if (historyDestroyList == null) {
                            historyDestroyList = new ArrayList<MsgQueueHistoryEntry>();
                        }
                        historyDestroyList.add(entry);
                    }
                } else {
                    if (entry.isExpired()) {
                        if (this.log.TRACE) {
                            this.log.trace(this.ME, "getMsgUnitWrapperArr(): MsgUnitWrapper weak reference from history queue is null, it is expired: " + entry.toXml());
                        }
                    } else {
                        this.log.error(this.ME, "getMsgUnitWrapperArr(): MsgUnitWrapper weak reference from history queue is null, this could be a serious bug, please report it to xmlBlaster@xmlBlaster.org mailing list: " + entry.toXml() + "\n" + (this.msgUnitCache != null ? this.msgUnitCache.toXml("") + "\n" : "") + (this.historyQueue != null ? this.historyQueue.toXml("") : ""));
                        Thread.dumpStack();
                    }
                    if (historyDestroyList == null) {
                        historyDestroyList = new ArrayList();
                    }
                    historyDestroyList.add(entry);
                }
            }
            ++i;
        }
        if (historyDestroyList != null && historyDestroyList.size() > 0) {
            this.historyQueue.removeRandom(historyDestroyList.toArray(new I_Entry[historyDestroyList.size()]));
        }
        if (newestFirst) {
            return aliveMsgUnitWrapperList.toArray(new MsgUnitWrapper[aliveMsgUnitWrapperList.size()]);
        }
        MsgUnitWrapper[] arr = new MsgUnitWrapper[aliveMsgUnitWrapperList.size()];
        int size = aliveMsgUnitWrapperList.size();
        int i2 = 0;
        while (i2 < size) {
            arr[i2] = (MsgUnitWrapper)aliveMsgUnitWrapperList.get(size - i2 - 1);
            ++i2;
        }
        return arr;
    }

    public MsgUnit[] getHistoryMsgUnitArr(int num, boolean newestFirst) throws XmlBlasterException {
        MsgUnitWrapper[] msgUnitWrapper = this.getMsgUnitWrapperArr(num, newestFirst);
        MsgUnit[] msgUnitArr = new MsgUnit[msgUnitWrapper.length];
        int i = 0;
        while (i < msgUnitWrapper.length) {
            msgUnitArr[i] = msgUnitWrapper[i].getMsgUnit();
            ++i;
        }
        return msgUnitArr;
    }

    public boolean isUndef() {
        return this.state == -1;
    }

    public boolean isUnconfigured() {
        return this.state == 0;
    }

    public boolean isAlive() {
        return this.state == 1;
    }

    public boolean isUnreferenced() {
        return this.state == 2;
    }

    public boolean isSoftErased() {
        return this.state == 3;
    }

    public boolean isDead() {
        return this.state == 4;
    }

    private void toUnconfigured() {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering toUnconfigured(oldState=" + this.getStateStr() + ")");
        }
        TopicHandler topicHandler = this;
        synchronized (topicHandler) {
            if (this.isUnconfigured()) {
                return;
            }
            this.state = 0;
            if (this.timerKey != null) {
                this.destroyTimer.removeTimeoutListener(this.timerKey);
                this.timerKey = null;
            }
        }
    }

    private void toAlive() throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering toAlive(oldState=" + this.getStateStr() + ")");
        }
        TopicHandler topicHandler = this;
        synchronized (topicHandler) {
            if (this.isAlive()) {
                return;
            }
            if (this.timerKey != null) {
                this.destroyTimer.removeTimeoutListener(this.timerKey);
                this.timerKey = null;
            }
            if (!this.isRegisteredInBigXmlDom) {
                try {
                    this.addToBigDom();
                }
                catch (XmlBlasterException e) {
                    if (this.isUnreferenced()) {
                        this.toDead(this.creatorSessionName, false);
                    } else if (this.isUnconfigured()) {
                        // empty if block
                    }
                    throw e;
                }
            }
            this.persistTopicEntry();
            this.initMsgDistributorPlugin();
            this.state = 1;
        }
    }

    private void removeTopicPersistence() {
        if (this.requestBroker.getTopicStore() == null) {
            return;
        }
        try {
            if (this.topicEntry != null) {
                int num = this.requestBroker.removePersistentTopicHandler(this.topicEntry);
                this.topicEntry = null;
                if (num == 0) {
                    this.log.warn(this.ME, "" + num + " TopicHandler removed from persistency");
                } else if (this.log.TRACE) {
                    this.log.trace(this.ME, "" + num + " TopicHandler removed from persistency");
                }
                return;
            }
        }
        catch (XmlBlasterException e) {
            this.log.error(this.ME, "Persisting TopicHandler failed, we continue memory based: " + e.getMessage());
        }
    }

    private void toUnreferenced(boolean onAdministrativeCreate) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering toUnreferenced(oldState=" + this.getStateStr() + ", onAdministrativeCreate=" + onAdministrativeCreate + ")");
        }
        TopicHandler topicHandler = this;
        synchronized (topicHandler) {
            if (this.isUnreferenced() || this.isDead()) {
                return;
            }
            int oldState = this.state;
            if (this.hasHistoryEntries()) {
                if (this.log.TRACE) {
                    this.log.trace(this.ME, this.getStateStr() + "->" + "UNREFERENCED: Clearing " + this.getNumOfHistoryEntries() + " history entries");
                }
                this.historyQueue.clear();
            }
            if (this.hasCacheEntries()) {
                if (this.log.TRACE) {
                    this.log.trace(this.ME, this.getStateStr() + "->" + "UNREFERENCED: Clearing " + this.msgUnitCache.getNumOfEntries() + " msgUnitStore cache entries");
                }
                this.msgUnitCache.clear();
            }
            this.state = 2;
            if (!onAdministrativeCreate) {
                if (this.topicProperty == null) {
                    this.toDead(this.creatorSessionName, true);
                    return;
                }
                if (this.topicProperty.getDestroyDelay() > 0L) {
                    if (this.timerKey == null) {
                        this.timerKey = this.destroyTimer.addTimeoutListener(this, this.topicProperty.getDestroyDelay(), null);
                    }
                } else if (this.topicProperty.getDestroyDelay() == 0L) {
                    this.timeout(null);
                    return;
                }
            }
            if (!this.isRegisteredInBigXmlDom) {
                this.addToBigDom();
            }
            if (oldState == -1 || oldState == 0) {
                this.persistTopicEntry();
            }
        }
    }

    private void toSoftErased(SessionInfo sessionInfo) {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering toSoftErased(oldState=" + this.getStateStr() + ")");
        }
        TopicHandler topicHandler = this;
        synchronized (topicHandler) {
            if (this.isSoftErased()) {
                return;
            }
            if (this.hasHistoryEntries()) {
                if (this.log.TRACE) {
                    this.log.trace(this.ME, this.getStateStr() + "->" + "SOFTERASED: Clearing " + this.getNumOfHistoryEntries() + " history entries");
                }
                this.historyQueue.clear();
            }
            if (this.hasSubscribers()) {
                if (this.log.TRACE) {
                    this.log.trace(this.ME, this.getStateStr() + "->" + "SOFTERASED: Clearing " + this.numSubscribers() + " subscriber entries");
                }
                this.notifySubscribersAboutErase(sessionInfo.getSessionName());
                this.clearSubscribers();
            }
            this.state = 3;
            this.removeFromBigDom();
            this.handlerIsNewCreated = true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void toDead(SessionName sessionName, boolean forceDestroy) {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering toDead(oldState=" + this.getStateStr() + ")");
        }
        long numHistory = 0L;
        TopicHandler topicHandler = this;
        synchronized (topicHandler) {
            block34: {
                if (this.dyingInProgress || this.isDead()) {
                    return;
                }
                this.dyingInProgress = true;
                try {
                    try {
                        this.shutdownMsgDistributorPlugin();
                        if (this.topicEntry != null) {
                            this.removeTopicPersistence();
                        } else if (!this.isUnconfigured()) {
                            this.log.error(this.ME, "In " + this.getStateStr() + " -> DEAD: this.topicEntry == null");
                            Thread.dumpStack();
                            Object var9_5 = null;
                            this.state = 4;
                            this.dyingInProgress = false;
                            return;
                        }
                        if (this.isAlive() && (this.numSubscribers() > 0 || this.hasCacheEntries() || this.hasHistoryEntries())) {
                            this.log.info(this.ME, "Forced state transition ALIVE -> DEAD with " + this.numSubscribers() + " subscribers, " + this.getNumOfCacheEntries() + " cache messages and " + this.getNumOfHistoryEntries() + " history messages.");
                        }
                        if (!forceDestroy && !this.isSoftErased()) {
                            this.notifySubscribersAboutErase(sessionName);
                        }
                        if (this.hasHistoryEntries()) {
                            try {
                                numHistory = this.historyQueue.clear();
                                if (this.log.TRACE) {
                                    this.log.trace(this.ME, this.getStateStr() + "->" + "DEAD: Cleared " + numHistory + " history entries");
                                }
                            }
                            catch (Throwable e) {
                                this.log.error(this.ME, this.getStateStr() + "->" + "DEAD: Ignoring problems during clearing the history queue: " + e.getMessage());
                            }
                        }
                        if (this.historyQueue != null) {
                            this.historyQueue.shutdown();
                        }
                        if (this.hasCacheEntries()) {
                            try {
                                long num = this.msgUnitCache.clear();
                                if (this.log.TRACE) {
                                    this.log.trace(this.ME, this.getStateStr() + "->" + "DEAD: Cleared " + num + " message storage entries");
                                }
                            }
                            catch (XmlBlasterException e) {
                                this.log.error(this.ME, this.getStateStr() + "->" + "DEAD: Ignoring problems during clearing the message store: " + e.getMessage());
                            }
                        }
                        if (this.msgUnitCache != null) {
                            this.msgUnitCache.shutdown();
                        }
                        if (this.topicEntry != null) {
                            this.removeTopicPersistence();
                        }
                    }
                    catch (Throwable e) {
                        this.log.error(this.ME, this.getStateStr() + "->" + "DEAD: Ignoring problems during clearing the message store: " + e.getMessage());
                        Object var9_7 = null;
                        this.state = 4;
                        this.dyingInProgress = false;
                        break block34;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_8 = null;
                    this.state = 4;
                    this.dyingInProgress = false;
                    throw throwable;
                }
                Object var9_6 = null;
                this.state = 4;
                this.dyingInProgress = false;
            }
            try {
                this.removeFromBigSubscriptionSet();
            }
            catch (Throwable e) {
                this.log.error(this.ME, this.getStateStr() + "->" + "DEAD: Ignoring problems during clearing the subscriptions: " + e.getMessage());
            }
            try {
                this.removeFromBigDom();
            }
            catch (Throwable e) {
                this.log.error(this.ME, this.getStateStr() + "->" + "DEAD: Ignoring problems during clearing the big DOM: " + e.getMessage());
            }
            try {
                this.clearSubscribers();
            }
            catch (Throwable e) {
                this.log.error(this.ME, this.getStateStr() + "->" + "DEAD: Ignoring problems during clearing the subscribers: " + e.getMessage());
            }
            try {
                this.removeFromBigMessageMap();
            }
            catch (Throwable e) {
                this.log.error(this.ME, this.getStateStr() + "->" + "DEAD: Ignoring problems during clearing the big message map: " + e.getMessage());
            }
            if (this.timerKey != null) {
                this.destroyTimer.removeTimeoutListener(this.timerKey);
                this.timerKey = null;
            }
            this.handlerIsNewCreated = true;
        }
        this.log.info(this.ME, "Topic reached state " + this.getStateStr() + ". " + numHistory + " history entries are destroyed.");
    }

    private void addToBigDom() throws XmlBlasterException {
        if (this.isRegisteredInBigXmlDom) {
            return;
        }
        if (!this.topicProperty.createDomEntry()) {
            return;
        }
        this.getXmlKey().mergeRootNode(this.requestBroker.getBigXmlKeyDOM());
        this.isRegisteredInBigXmlDom = true;
    }

    private void removeFromBigDom() {
        if (!this.isRegisteredInBigXmlDom) {
            return;
        }
        try {
            this.requestBroker.getBigXmlKeyDOM().messageErase(this);
            this.isRegisteredInBigXmlDom = false;
        }
        catch (XmlBlasterException e) {
            this.log.error(this.ME, "Received exception on BigDom erase, we ignore it: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void notifySubscribersAboutErase(SessionName sessionName) {
        if (this.log.CALL) {
            this.log.call(this.ME, "Sending client notification about message erase() event");
        }
        if (this.hasSubscribers()) {
            try {
                SessionInfo publisherSessionInfo = this.glob.getRequestBroker().getInternalSessionInfo();
                PublishKey pk = new PublishKey(this.glob, this.getUniqueKey(), "text/plain", "1.0");
                PublishQos pq = new PublishQos(this.glob);
                pq.setState("ERASED");
                pq.setVolatile(true);
                pq.setSender(sessionName);
                MsgUnit msgUnit = new MsgUnit(pk, this.getId(), pq);
                PublishQosServer ps = new PublishQosServer(this.glob, pq.getData());
                this.publish(publisherSessionInfo, msgUnit, ps);
            }
            catch (XmlBlasterException e) {
                this.log.error(this.ME, "Received exception for message erase event (callback to client), we ignore it: " + e.getMessage());
            }
        }
    }

    private void removeFromBigSubscriptionSet() {
        try {
            this.requestBroker.getClientSubscriptions().messageErase(this);
        }
        catch (XmlBlasterException e) {
            this.log.error(this.ME, "Received exception on message erase, we ignore it: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void removeFromBigMessageMap() {
        try {
            this.requestBroker.messageErase(this);
        }
        catch (XmlBlasterException e) {
            this.log.error(this.ME, "Received exception on message erase, we ignore it: " + e.getMessage());
            e.printStackTrace();
        }
    }

    final void fireMessageEraseEvent(SessionInfo sessionInfo, EraseQosServer eraseQos) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering fireMessageEraseEvent forceDestroy=" + eraseQos.getForceDestroy());
        }
        eraseQos = eraseQos == null ? new EraseQosServer((org.xmlBlaster.util.Global)this.glob, new QueryQosData(this.glob, MethodName.ERASE)) : eraseQos;
        TopicHandler topicHandler = this;
        synchronized (topicHandler) {
            if (this.isAlive() || this.isUnconfigured()) {
                if (eraseQos.getForceDestroy()) {
                    this.toDead(sessionInfo.getSessionName(), eraseQos.getForceDestroy());
                    return;
                }
                this.toSoftErased(sessionInfo);
                long numMsgUnitStore = this.msgUnitCache.getNumOfEntries();
                if (numMsgUnitStore < 1L) {
                    this.toDead(sessionInfo.getSessionName(), eraseQos.getForceDestroy());
                    return;
                }
                this.log.info(this.ME, "Erase not possible, we are still referenced by " + numMsgUnitStore + " callback queue entries, transition to topic state " + this.getStateStr() + ", all subscribers are removed.");
            }
            if (this.isUnreferenced()) {
                this.toDead(sessionInfo.getSessionName(), eraseQos.getForceDestroy());
                return;
            }
        }
    }

    public final void timeout(Object userData) {
        if (this.log.CALL) {
            this.log.call(this.ME, "Timeout after destroy delay occurred - destroying topic now ...");
        }
        this.timerKey = null;
        if (this.isDead()) {
            return;
        }
        TopicHandler topicHandler = this;
        synchronized (topicHandler) {
            if (this.isAlive()) {
                return;
            }
            this.toDead(this.creatorSessionName, false);
        }
    }

    public String getStateStr() {
        if (this.isAlive()) {
            return "ALIVE";
        }
        if (this.isUnconfigured()) {
            return "UNCONFIGURED";
        }
        if (this.isUnreferenced()) {
            return "UNREFERENCED";
        }
        if (this.isDead()) {
            return "DEAD";
        }
        if (this.isSoftErased()) {
            return "SOFTERASED";
        }
        if (this.state == -1) {
            return "UNDEF";
        }
        this.log.error(this.ME, "PANIC: Unknown internal state=" + this.state);
        return "ERROR";
    }

    public final String toXml() {
        return this.toXml(null);
    }

    public final String toXml(String extraOffset) {
        StringBuffer sb = new StringBuffer(4000);
        if (extraOffset == null) {
            extraOffset = "";
        }
        String offset = "\n " + extraOffset;
        sb.append(offset).append("<TopicHandler id='").append(this.getId()).append("' state='").append(this.getStateStr()).append("'>");
        sb.append(offset).append(" <uniqueKey>").append(this.getUniqueKey()).append("</uniqueKey>");
        if (this.topicEntry != null) {
            sb.append(offset).append(" <topicEntry>").append(this.topicEntry.getLogId()).append("</topicEntry>");
        }
        if (this.topicProperty != null) {
            sb.append(this.topicProperty.toXml(extraOffset + " "));
        }
        if (this.msgUnitCache != null) {
            sb.append(this.msgUnitCache.toXml(extraOffset + " "));
        }
        if (this.historyQueue != null) {
            sb.append(this.historyQueue.toXml(extraOffset + " "));
        }
        try {
            MsgUnitWrapper[] msgUnitWrapperArr = this.getMsgUnitWrapperArr(-1, false);
            int ii = 0;
            while (ii < msgUnitWrapperArr.length) {
                MsgUnitWrapper msgUnitWrapper = msgUnitWrapperArr[ii];
                if (msgUnitWrapper != null) {
                    sb.append(msgUnitWrapper.toXml(extraOffset + " "));
                }
                ++ii;
            }
        }
        catch (XmlBlasterException e) {
            this.log.error(this.ME, e.getMessage());
        }
        if (this.hasSubscribers()) {
            SubscriptionInfo[] subscriptionInfoArr = this.getSubscriptionInfoArr();
            int i = 0;
            while (i < subscriptionInfoArr.length) {
                sb.append(offset).append(" <SubscriptionInfo id='").append(subscriptionInfoArr[i].getSubscriptionId()).append("'/>");
                ++i;
            }
        } else {
            sb.append(offset + " <SubscriptionInfo>NO SUBSCRIPTIONS</SubscriptionInfo>");
        }
        sb.append(offset).append(" <newCreated>").append(this.handlerIsNewCreated).append("</newCreated>");
        sb.append(offset).append("</TopicHandler>\n");
        return sb.toString();
    }

    public I_Queue getHistoryQueue() {
        return this.historyQueue;
    }

    private void initMsgDistributorPlugin() throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "initMsgDistributorPlugin");
        }
        if (this.distributor != null) {
            return;
        }
        String typeVersion = this.topicProperty.getMsgDistributor();
        this.distributor = this.glob.getMsgDistributorPluginManager().getPlugin(typeVersion, this);
        this.subscriptionListener = this.distributor;
        if (this.subscriptionListener != null) {
            SubscriptionInfo[] subs = this.getSubscriptionInfoArr();
            int i = 0;
            while (i < subs.length) {
                this.subscriptionListener.subscriptionAdd(new SubscriptionEvent(subs[i]));
                ++i;
            }
        }
    }

    private void shutdownMsgDistributorPlugin() {
        if (this.log.CALL) {
            this.log.call(this.ME, "shutdownMsgDistributorPlugin");
        }
        if (this.distributor == null) {
            return;
        }
        TopicHandler topicHandler = this;
        synchronized (topicHandler) {
            try {
                try {
                    this.distributor.shutdown();
                }
                catch (XmlBlasterException ex) {
                    this.log.error(this.ME, "shutdownMsgDistributorPlugin " + ex.getMessage());
                    Object var4_3 = null;
                    this.distributor = null;
                    this.subscriptionListener = null;
                }
                Object var4_2 = null;
                this.distributor = null;
                this.subscriptionListener = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.distributor = null;
                this.subscriptionListener = null;
                throw throwable;
            }
        }
    }

    public final boolean subscriberMayReceiveIt(SubscriptionInfo sub, MsgUnitWrapper msgUnitWrapper) {
        if (sub == null) {
            return false;
        }
        if (sub.getSessionInfo() == null) {
            return false;
        }
        QueryQosData qos = sub.getQueryQosData();
        if (qos == null) {
            return false;
        }
        if (!qos.getWantLocal() && sub.getSessionInfo().getSessionName().equalsAbsolute(msgUnitWrapper.getMsgQosData().getSender())) {
            return false;
        }
        return qos.getWantNotify() || !msgUnitWrapper.getMsgQosData().isErased();
    }

    public final I_MsgDistributor getMsgDistributorPlugin() {
        return this.distributor;
    }
}

