/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine;

import org.jutils.log.LogChannel;
import org.xmlBlaster.authentication.Authenticate;
import org.xmlBlaster.authentication.SessionInfo;
import org.xmlBlaster.authentication.plugins.I_Session;
import org.xmlBlaster.authentication.plugins.I_Subject;
import org.xmlBlaster.engine.AvailabilityChecker;
import org.xmlBlaster.engine.Global;
import org.xmlBlaster.engine.RequestBroker;
import org.xmlBlaster.engine.qos.EraseQosServer;
import org.xmlBlaster.engine.qos.GetQosServer;
import org.xmlBlaster.engine.qos.SubscribeQosServer;
import org.xmlBlaster.engine.qos.UnSubscribeQosServer;
import org.xmlBlaster.protocol.I_XmlBlaster;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.MsgUnitRaw;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.def.MethodName;
import org.xmlBlaster.util.key.QueryKeyData;
import org.xmlBlaster.util.qos.QosData;
import org.xmlBlaster.util.qos.QueryQosData;

public class XmlBlasterImpl
implements I_XmlBlaster {
    private final String ME;
    private final RequestBroker requestBroker;
    private final Authenticate authenticate;
    private final AvailabilityChecker availabilityChecker;
    private final Global glob;
    private final LogChannel log;
    private static final byte[] EMPTY_BYTES = "".getBytes();

    public XmlBlasterImpl(Authenticate authenticate) throws XmlBlasterException {
        this.authenticate = authenticate;
        this.glob = authenticate.getGlobal();
        this.ME = "XmlBlasterImpl" + this.glob.getLogPrefixDashed();
        this.log = this.glob.getLog("core");
        this.requestBroker = new RequestBroker(authenticate);
        this.availabilityChecker = new AvailabilityChecker(this.glob);
    }

    public final String subscribe(String sessionId, String xmlKey_literal, String qos_literal) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering subscribe(" + sessionId + ", key, qos)");
        }
        try {
            SessionInfo sessionInfo = this.authenticate.check(sessionId);
            MsgUnit msgUnit = this.importAndAuthorize(sessionInfo, new MsgUnitRaw(xmlKey_literal, null, qos_literal), MethodName.SUBSCRIBE);
            SubscribeQosServer subscribeQos = new SubscribeQosServer((org.xmlBlaster.util.Global)this.glob, (QueryQosData)msgUnit.getQosData());
            String ret = this.requestBroker.subscribe(sessionInfo, (QueryKeyData)msgUnit.getKeyData(), subscribeQos);
            return sessionInfo.getSecuritySession().exportMessage(ret);
        }
        catch (Throwable e) {
            throw this.availabilityChecker.checkException(MethodName.SUBSCRIBE, e);
        }
    }

    public final String[] unSubscribe(String sessionId, String xmlKey_literal, String qos_literal) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering unSubscribe(" + sessionId + ", key, qos)");
        }
        try {
            SessionInfo sessionInfo = this.authenticate.check(sessionId);
            MsgUnit msgUnit = this.importAndAuthorize(sessionInfo, new MsgUnitRaw(xmlKey_literal, null, qos_literal), MethodName.UNSUBSCRIBE);
            UnSubscribeQosServer unSubscribeQosServer = new UnSubscribeQosServer((org.xmlBlaster.util.Global)this.glob, (QueryQosData)msgUnit.getQosData());
            String[] retArr = this.requestBroker.unSubscribe(sessionInfo, (QueryKeyData)msgUnit.getKeyData(), unSubscribeQosServer);
            I_Session sec = sessionInfo.getSecuritySession();
            int ii = 0;
            while (ii < retArr.length) {
                retArr[ii] = sec.exportMessage(retArr[ii]);
                ++ii;
            }
            return retArr;
        }
        catch (Throwable e) {
            throw this.availabilityChecker.checkException(MethodName.UNSUBSCRIBE, e);
        }
    }

    public final String publish(String sessionId, MsgUnitRaw msgUnitRaw) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering publish()");
        }
        try {
            SessionInfo sessionInfo = this.authenticate.check(sessionId);
            MsgUnit msgUnit = this.importAndAuthorize(sessionInfo, msgUnitRaw, MethodName.PUBLISH);
            String ret = this.requestBroker.publish(sessionInfo, msgUnit);
            return sessionInfo.getSecuritySession().exportMessage(ret);
        }
        catch (Throwable e) {
            throw this.availabilityChecker.checkException(MethodName.PUBLISH, e);
        }
    }

    public final String[] publishArr(String sessionId, MsgUnitRaw[] msgUnitArr) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering publishArr()");
        }
        try {
            SessionInfo sessionInfo = this.authenticate.check(sessionId);
            I_Session sec = sessionInfo.getSecuritySession();
            String[] returnArr = new String[msgUnitArr.length];
            int ii = 0;
            while (ii < msgUnitArr.length) {
                MsgUnit msgUnit = this.importAndAuthorize(sessionInfo, msgUnitArr[ii], MethodName.PUBLISH);
                String ret = this.requestBroker.publish(sessionInfo, msgUnit);
                returnArr[ii] = sec.exportMessage(ret);
                ++ii;
            }
            return returnArr;
        }
        catch (Throwable e) {
            throw this.availabilityChecker.checkException(MethodName.PUBLISH_ARR, e);
        }
    }

    public final void publishOneway(String sessionId, MsgUnitRaw[] msgUnitArr) {
        try {
            this.publishArr(sessionId, msgUnitArr);
        }
        catch (Throwable e) {
            this.log.error(this.ME, "Caught exception on publish which can't be delivered to client because of 'oneway' mode: " + e.getMessage());
        }
    }

    public final String[] erase(String sessionId, String xmlKey_literal, String qos_literal) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering erase()");
        }
        try {
            SessionInfo sessionInfo = this.authenticate.check(sessionId);
            MsgUnit msgUnit = this.importAndAuthorize(sessionInfo, new MsgUnitRaw(xmlKey_literal, null, qos_literal), MethodName.ERASE);
            EraseQosServer eraseQosServer = new EraseQosServer((org.xmlBlaster.util.Global)this.glob, (QueryQosData)msgUnit.getQosData());
            String[] retArr = this.requestBroker.erase(sessionInfo, (QueryKeyData)msgUnit.getKeyData(), eraseQosServer);
            I_Session sec = sessionInfo.getSecuritySession();
            int ii = 0;
            while (ii < retArr.length) {
                retArr[ii] = sec.exportMessage(retArr[ii]);
                ++ii;
            }
            return retArr;
        }
        catch (Throwable e) {
            throw this.availabilityChecker.checkException(MethodName.ERASE, e);
        }
    }

    public final MsgUnitRaw[] get(String sessionId, String xmlKey_literal, String qos_literal) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering get()");
        }
        try {
            SessionInfo sessionInfo = this.authenticate.check(sessionId);
            MsgUnit msgUnit = this.importAndAuthorize(sessionInfo, new MsgUnitRaw(xmlKey_literal, null, qos_literal), MethodName.GET);
            GetQosServer getQosServer = new GetQosServer((org.xmlBlaster.util.Global)this.glob, (QueryQosData)msgUnit.getQosData());
            MsgUnit[] msgUnitArr = this.requestBroker.get(sessionInfo, (QueryKeyData)msgUnit.getKeyData(), getQosServer);
            MsgUnitRaw[] msgUnitRawArr = new MsgUnitRaw[msgUnitArr.length];
            I_Session sec = sessionInfo.getSecuritySession();
            int ii = 0;
            while (ii < msgUnitArr.length) {
                msgUnitRawArr[ii] = sec.exportMessage(msgUnitArr[ii].getMsgUnitRaw(), MethodName.GET);
                ++ii;
            }
            return msgUnitRawArr;
        }
        catch (Throwable e) {
            throw this.availabilityChecker.checkException(MethodName.GET, e);
        }
    }

    public final String toXml() throws XmlBlasterException {
        return this.requestBroker.toXml();
    }

    public final String toXml(String extraOffset) throws XmlBlasterException {
        return this.requestBroker.toXml(extraOffset);
    }

    private MsgUnit importAndAuthorize(SessionInfo sessionInfo, MsgUnitRaw msgUnitRaw, MethodName action) throws XmlBlasterException {
        I_Subject subjSecCtx;
        I_Session sessionSecCtx = sessionInfo.getSecuritySession();
        if (sessionSecCtx == null) {
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME + ".accessDenied", "unknown session - internal error.");
        }
        MsgUnit msgUnit = new MsgUnit(this.glob, (msgUnitRaw = sessionSecCtx.importMessage(msgUnitRaw, action)).getKey(), msgUnitRaw.getContent(), msgUnitRaw.getQos(), action);
        QosData qosData = msgUnit.getQosData();
        if (qosData.getClientProperty("__persistenceId") != null) {
            qosData.isFromPersistenceRecovery(true);
        }
        this.availabilityChecker.checkServerIsReady(sessionInfo.getSessionName(), msgUnit, action);
        if (sessionInfo.getConnectQos().isClusterNode()) {
            if (qosData.getSender() == null) {
                qosData.setSender(sessionInfo.getSessionName());
            }
        } else if (qosData.getSender() == null) {
            qosData.setSender(sessionInfo.getSessionName());
        } else if (!sessionInfo.getSessionName().equalsAbsolute(qosData.getSender())) {
            this.log.warn(this.ME, sessionInfo.getId() + " sends message '" + msgUnit.getKeyOid() + "' with invalid sender name '" + qosData.getSender() + "', we fix this");
            qosData.setSender(sessionInfo.getSessionName());
        }
        if (!(subjSecCtx = sessionSecCtx.getSubject()).isAuthorized(action, msgUnitRaw.getKey())) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_SECURITY_AUTHORIZATION_NOTAUTHORIZED, this.ME, "Subject '" + subjSecCtx.getName() + "' is not permitted to perform action '" + action + "' on key '" + msgUnit.getKey() + "'");
        }
        return msgUnit;
    }

    public final String ping(String qos) {
        String ret = "<qos><state id='" + this.availabilityChecker.getStatus(qos) + "'/></qos>";
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering ping(" + qos + "), returning " + ret + " ...");
        }
        return ret;
    }

    public final void shutdown() {
        this.availabilityChecker.shutdown();
    }
}

