/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.admin;

import java.util.Map;
import java.util.TreeMap;
import org.jutils.log.LogChannel;
import org.xmlBlaster.authentication.SessionInfo;
import org.xmlBlaster.engine.Global;
import org.xmlBlaster.engine.admin.CommandWrapper;
import org.xmlBlaster.engine.admin.I_CommandHandler;
import org.xmlBlaster.engine.admin.I_ExternGateway;
import org.xmlBlaster.engine.admin.SetReturn;
import org.xmlBlaster.engine.admin.extern.MomClientGateway;
import org.xmlBlaster.engine.admin.extern.SnmpGateway;
import org.xmlBlaster.engine.admin.extern.TelnetGateway;
import org.xmlBlaster.engine.admin.intern.CoreHandler;
import org.xmlBlaster.engine.admin.intern.MsgHandler;
import org.xmlBlaster.engine.admin.intern.PropertyHandler;
import org.xmlBlaster.engine.runlevel.I_RunlevelListener;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.key.QueryKeyData;
import org.xmlBlaster.util.qos.QueryQosData;

public final class CommandManager
implements I_RunlevelListener {
    private final String ME;
    private final Global glob;
    private final LogChannel log;
    private final SessionInfo sessionInfo;
    private final Map handlerMap = new TreeMap();
    private final Map externMap = new TreeMap();

    public CommandManager(Global glob, SessionInfo sessionInfo) {
        this.glob = glob;
        this.log = this.glob.getLog("admin");
        this.ME = "CommandManager" + this.glob.getLogPrefixDashed();
        this.sessionInfo = sessionInfo;
        glob.getRunlevelManager().addRunlevelListener(this);
    }

    private void initializeInternal() {
        PropertyHandler propertyHandler = new PropertyHandler();
        propertyHandler.initialize(this.glob, this);
        CoreHandler coreHandler = new CoreHandler();
        coreHandler.initialize(this.glob, this);
        MsgHandler msgHandler = new MsgHandler();
        msgHandler.initialize(this.glob, this);
    }

    private void initializeExternal() {
        try {
            TelnetGateway telnetGateway = new TelnetGateway();
            if (telnetGateway.initialize(this.glob, this)) {
                this.externMap.put(telnetGateway.getName(), telnetGateway);
            }
        }
        catch (XmlBlasterException e) {
            this.log.error(this.ME, e.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.log.error(this.ME, e.toString());
        }
        try {
            SnmpGateway snmpGateway = new SnmpGateway();
            if (snmpGateway.initialize(this.glob, this)) {
                this.externMap.put(snmpGateway.getName(), snmpGateway);
            }
        }
        catch (XmlBlasterException e) {
            this.log.error(this.ME, e.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.log.error(this.ME, e.toString());
        }
        try {
            MomClientGateway momClientGateway = new MomClientGateway();
            if (momClientGateway.initialize(this.glob, this)) {
                this.externMap.put(momClientGateway.getName(), momClientGateway);
                this.glob.registerMomClientGateway(momClientGateway);
            }
        }
        catch (XmlBlasterException e) {
            this.log.error(this.ME, e.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.log.error(this.ME, e.toString());
        }
    }

    public final synchronized void register(String key, I_CommandHandler handler) {
        if (key == null || handler == null) {
            Thread.dumpStack();
            throw new IllegalArgumentException(this.ME + ": Please pass a valid key and handler");
        }
        this.handlerMap.put(key, handler);
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Registered '" + key + "' for handler=" + handler.getClass());
        }
    }

    public final synchronized MsgUnit[] get(String sessionId, QueryKeyData keyData, QueryQosData qosData) throws XmlBlasterException {
        String oid = keyData.getOid();
        if (this.log.CALL) {
            this.log.call(this.ME, "get(" + oid + ")");
        }
        if (oid == null || oid.length() < 8) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME, "Please pass a command which is not null or too short");
        }
        try {
            Object obj;
            CommandWrapper w = new CommandWrapper(this.glob, keyData, qosData);
            String key = w.getThirdLevel();
            if (w.getThirdLevel().startsWith("?")) {
                key = "DEFAULT";
            }
            if ((obj = this.handlerMap.get(key)) == null) {
                throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME, "Sorry can't process your command '" + oid + "', '" + w.getThirdLevel() + "' has no registered handler (key=" + key + ")");
            }
            I_CommandHandler handler = (I_CommandHandler)obj;
            MsgUnit[] ret = handler.get(sessionId, w);
            if (ret == null) {
                ret = new MsgUnit[]{};
            }
            return ret;
        }
        catch (XmlBlasterException e) {
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw XmlBlasterException.convert(this.glob, this.ME, "get(" + oid + ")", e);
        }
    }

    public final synchronized SetReturn set(String sessionId, String cmd) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "set(" + cmd + ")");
        }
        if (cmd == null || cmd.length() < 1) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME, "Please pass a command which is not null");
        }
        try {
            Object obj;
            CommandWrapper w = new CommandWrapper(this.glob, cmd, null);
            String key = w.getThirdLevel();
            if (w.getThirdLevel().startsWith("?")) {
                key = "DEFAULT";
            }
            if ((obj = this.handlerMap.get(key)) == null) {
                throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME, "Sorry can't process your command '" + cmd + "', the third level '" + w.getThirdLevel() + "' has no registered handler (key=" + key + ")");
            }
            I_CommandHandler handler = (I_CommandHandler)obj;
            return new SetReturn(w, handler.set(sessionId, w));
        }
        catch (XmlBlasterException e) {
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw XmlBlasterException.convert(this.glob, this.ME, "set(" + cmd + ")", e);
        }
    }

    public String help() {
        return "  XmlBlaster administration, see http://www.xmlblaster.org/xmlBlaster/doc/requirements/admin.commands.html";
    }

    public String help(String cmd) {
        return this.help();
    }

    public void shutdown() {
        int ii;
        Object[] arr;
        if (this.externMap != null && this.externMap.size() > 0) {
            arr = this.externMap.values().toArray(new I_ExternGateway[this.externMap.size()]);
            ii = 0;
            while (ii < arr.length) {
                arr[ii].shutdown();
                ++ii;
            }
            this.externMap.clear();
        }
        if (this.handlerMap != null && this.handlerMap.size() > 0) {
            arr = this.handlerMap.values().toArray(new I_CommandHandler[this.handlerMap.size()]);
            ii = 0;
            while (ii < arr.length) {
                arr[ii].shutdown();
                ++ii;
            }
            this.handlerMap.clear();
        }
    }

    public String getName() {
        return this.ME;
    }

    public void runlevelChange(int from, int to, boolean force) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Changing from run level=" + from + " to level=" + to + " with force=" + force);
        }
        if (to == from) {
            return;
        }
        if (to > from && to == 3) {
            this.initializeInternal();
            this.initializeExternal();
            this.log.info(this.ME, "Administration manager is ready");
        }
        if (to < from && to == 0) {
            this.shutdown();
        }
    }

    public final String toXml() {
        return this.toXml(null);
    }

    public final synchronized String toXml(String extraOffset) {
        StringBuffer sb = new StringBuffer(1024);
        String offset = "\n   ";
        if (extraOffset == null) {
            extraOffset = "";
        }
        offset = offset + extraOffset;
        sb.append(offset).append("<commandManager>");
        sb.append(offset).append("</commandManager>");
        return sb.toString();
    }
}

