/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.admin;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.jutils.log.LogChannel;
import org.jutils.text.StringHelper;
import org.xmlBlaster.engine.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.def.MethodName;
import org.xmlBlaster.util.key.QueryKeyData;
import org.xmlBlaster.util.qos.QueryQosData;
import org.xmlBlaster.util.qos.QueryQosSaxFactory;

public final class CommandWrapper {
    private final String ME;
    private final Global glob;
    private final LogChannel log;
    private static final String PROP_SEPARATOR = "&";
    private static final String XMLBLASTER_PREFIX = "xmlBlaster.";
    private final String cmd;
    private final String myStrippedClusterNodeId;
    String root = null;
    String clusterNodeId = null;
    String third = null;
    String fourth = null;
    String fifth = null;
    String sixth = null;
    String tail = null;
    String key = null;
    String value = null;
    QueryQosData qosData;
    QueryKeyData keyData;
    Map props = new HashMap();

    public CommandWrapper(Global glob, QueryKeyData keyData, QueryQosData qosData) throws XmlBlasterException {
        this(glob, CommandWrapper.stripCommand(glob, keyData.getOid()), qosData);
        this.keyData = keyData;
        if (this.qosData == null) {
            this.fillKeyAndQos();
        }
    }

    public CommandWrapper(Global glob, String cmd, QueryQosData qosData) throws XmlBlasterException {
        this.glob = glob;
        this.log = this.glob.getLog("admin");
        this.ME = "CommandWrapper-" + this.glob.getId();
        this.myStrippedClusterNodeId = this.getStrippedClusterNodeId();
        if (cmd == null) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME, "Your command is null, aborted request");
        }
        this.cmd = !cmd.startsWith("/") ? "/node/" + this.myStrippedClusterNodeId + "/" + cmd : cmd;
        this.qosData = qosData;
        this.parse();
    }

    private void parse() throws XmlBlasterException {
        String prefix = this.cmd;
        int questionIndex = this.cmd.indexOf("?");
        int equalsIndex = this.cmd.indexOf("=");
        if (questionIndex >= 0 && equalsIndex >= 0 && questionIndex < equalsIndex) {
            this.parseKeyValue();
            prefix = this.cmd.substring(0, equalsIndex);
            if (this.log.TRACE) {
                this.log.trace(this.ME, "prefix=" + prefix + " key=" + this.key + " value=" + this.value);
            }
        }
        StringTokenizer st = new StringTokenizer(prefix, "/");
        int ii = 1;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Parsing '" + prefix + "' ii=" + ii + " token=" + token);
            }
            if (ii == 1) {
                this.root = token;
            } else if (ii == 2) {
                this.clusterNodeId = token;
            } else if (ii == 3) {
                this.third = token;
            } else if (ii == 4) {
                this.fourth = token;
            } else if (ii == 5) {
                this.fifth = token;
            } else {
                if (ii != 6) break;
                this.sixth = token;
            }
            ++ii;
        }
        if (this.root == null || this.clusterNodeId == null || this.third == null) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME + ".parse", "Your command is invalid, missing levels: '" + this.cmd + "'");
        }
        if (!"node".equals(this.root)) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME + ".parse", "Your root node is invalid, only <node> is supported, sorry '" + this.cmd + "' rejected");
        }
        if (!this.glob.getId().equals(this.clusterNodeId) && !this.myStrippedClusterNodeId.equals(this.clusterNodeId)) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME + ".parse", "Query of foreign cluster node '" + this.clusterNodeId + "' is not implemented, sorry '" + this.cmd + "' rejected");
        }
        int offset = this.root.length() + this.clusterNodeId.length() + this.third.length() + 4;
        if (this.cmd.length() > offset) {
            this.tail = this.cmd.substring(offset);
        }
    }

    public final String getStrippedClusterNodeId() {
        return StringHelper.replaceAll(this.glob.getId(), "/", "");
    }

    public final String getRoot() {
        return this.root;
    }

    public final String getClusterNodeId() {
        return this.clusterNodeId;
    }

    public final String getThirdLevel() {
        return this.third;
    }

    public final String getUserNameLevel() {
        return this.fourth;
    }

    public final String getSessionIdLevel() {
        return this.getFifthLevel();
    }

    public final String getFifthLevel() {
        return this.fifth;
    }

    public final String getSessionAttrLevel() {
        return this.sixth;
    }

    public final String getTail() {
        return this.tail;
    }

    public final String getValue() throws XmlBlasterException {
        if (this.key == null && this.value == null) {
            this.parseKeyValue();
        }
        return this.value;
    }

    public final String getKey() throws XmlBlasterException {
        if (this.key == null && this.value == null) {
            this.parseKeyValue();
        }
        return this.key;
    }

    private void parseKeyValue() throws XmlBlasterException {
        int qIndex = this.cmd.indexOf("?");
        if (qIndex < 1 || this.cmd.length() <= qIndex + 1) {
            this.log.warn(this.ME, "parseKeyValue(): Invalid command '" + this.cmd + "', can't find '?'");
            throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME + ".parseKeyValue", "Invalid command '" + this.cmd + "', can't find '?'");
        }
        String propString = this.cmd.substring(qIndex + 1);
        StringTokenizer tokenizer = new StringTokenizer(propString.trim(), PROP_SEPARATOR);
        boolean keyAlreadyAssigned = false;
        while (tokenizer.hasMoreTokens()) {
            String pair = tokenizer.nextToken().trim();
            if (pair.length() < 1) continue;
            int equalsIndex = pair.indexOf("=");
            String tmpKey = null;
            String tmpValue = null;
            if (equalsIndex < 1 || pair.length() <= equalsIndex + 1) {
                tmpKey = pair.trim();
                tmpValue = null;
            } else {
                tmpKey = pair.substring(0, equalsIndex).trim();
                tmpValue = pair.substring(equalsIndex + 1);
            }
            if (tmpKey.indexOf(XMLBLASTER_PREFIX) < 0) {
                if (keyAlreadyAssigned) {
                    throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, "only one key which does not start with 'xmlBlaster.' can be assigned");
                }
                this.key = tmpKey;
                this.value = tmpValue;
                continue;
            }
            this.props.put(tmpKey, tmpValue);
        }
    }

    public final String getCommand() {
        return this.cmd;
    }

    public final String getCommandStripAssign() throws XmlBlasterException {
        int equalsIndex = this.cmd.lastIndexOf("=");
        if (equalsIndex < 1 || this.cmd.length() <= equalsIndex + 1) {
            this.log.warn(this.ME, "getCommandStripAssign(): Invalid command '" + this.cmd + "', can't find assignment '='");
            throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME + ".getCommandStripAssign", "Invalid command '" + this.cmd + "', can't find assignment '='");
        }
        return this.cmd.substring(0, equalsIndex).trim();
    }

    public final String toXml() {
        return this.toXml(null);
    }

    public final synchronized String toXml(String extraOffset) {
        StringBuffer sb = new StringBuffer(1024);
        String offset = "\n   ";
        if (extraOffset == null) {
            extraOffset = "";
        }
        offset = offset + extraOffset;
        sb.append(offset).append("<commandWrapper>");
        sb.append(offset).append("  <cmd>").append(this.cmd).append("</cmd>");
        sb.append(offset).append("  <root>").append(this.root).append("</root>");
        sb.append(offset).append("  <nodeId>").append(this.clusterNodeId).append("</nodeId");
        sb.append(offset).append("  <third>").append(this.third).append("</third");
        sb.append(offset).append("  <tail>").append(this.third).append("</tail");
        sb.append(offset).append("</commandWrapper>");
        return sb.toString();
    }

    public QueryQosData getQueryQosData() {
        return this.qosData;
    }

    public QueryKeyData getQueryKeyData() {
        return this.keyData;
    }

    public static String stripCommand(Global glob, String command) throws XmlBlasterException {
        if (command == null) {
            throw new XmlBlasterException(glob, ErrorCode.USER_ILLEGALARGUMENT, "CommandWrapper.stripCommand", "Ignoring your empty command.");
        }
        if (!(command = command.trim()).startsWith("__cmd:") || command.length() < "__cmd:".length() + 1) {
            throw new XmlBlasterException(glob, ErrorCode.USER_ILLEGALARGUMENT, "CommandWrapper.stripCommand", "Ignoring your empty command '" + command + "'.");
        }
        int dotIndex = command.indexOf(":");
        return command.substring(dotIndex + 1).trim();
    }

    private void fillKeyAndQos() throws XmlBlasterException {
        if (this.qosData != null) {
            return;
        }
        int qosPos = this.cmd.indexOf("&xmlBlaster.qos=");
        String qosLitteral = null;
        if (qosPos > -1) {
            qosLitteral = this.cmd.substring(qosPos + "&xmlBlaster.qos=".length());
        }
        if (qosLitteral == null) {
            this.qosData = new QueryQosData(this.glob, MethodName.GET);
        } else {
            QueryQosSaxFactory factory = new QueryQosSaxFactory(this.glob);
            this.qosData = factory.readObject(qosLitteral);
        }
        if (this.sixth == null) {
            this.keyData.setOid("__cmd:" + this.cmd);
        } else {
            int pos = this.sixth.indexOf(38);
            if (pos > -1) {
                this.sixth = this.sixth.substring(0, pos);
            }
            pos = this.cmd.indexOf(38);
            String tmpCmd = "";
            if (pos > -1) {
                tmpCmd = this.cmd.substring(0, pos);
            }
            this.keyData.setOid("__cmd:" + tmpCmd);
        }
    }
}

