/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.admin.extern;

import org.jutils.log.LogChannel;
import org.xmlBlaster.authentication.SessionInfo;
import org.xmlBlaster.engine.Global;
import org.xmlBlaster.engine.admin.CommandManager;
import org.xmlBlaster.engine.admin.I_ExternGateway;
import org.xmlBlaster.engine.admin.SetReturn;
import org.xmlBlaster.engine.qos.PublishQosServer;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.key.KeyData;
import org.xmlBlaster.util.key.QueryKeyData;
import org.xmlBlaster.util.qos.QueryQosData;

public final class MomClientGateway
implements I_ExternGateway {
    private String ME;
    private Global glob;
    private LogChannel log;
    private CommandManager commandManager;
    private static int instanceCounter = 0;

    public boolean initialize(Global glob, CommandManager commandManager) throws XmlBlasterException {
        this.glob = glob;
        this.log = this.glob.getLog("admin");
        boolean useMessages = glob.getProperty().get("admin.messages", true);
        useMessages = glob.getProperty().get("admin.messages[" + glob.getId() + "]", useMessages);
        if (!useMessages) {
            return false;
        }
        this.ME = "MomClientGateway" + ++instanceCounter + this.glob.getLogPrefixDashed();
        this.commandManager = commandManager;
        return true;
    }

    public MsgUnit[] getCommand(SessionInfo sessionInfo, QueryKeyData keyData, QueryQosData qosData) throws XmlBlasterException {
        String cmdType = "get";
        if (this.log.CALL) {
            this.log.call(this.ME, "Invoking getCommand(" + keyData.getOid() + ")");
        }
        MsgUnit[] msgs = this.commandManager.get(sessionInfo.getSecretSessionId(), keyData, qosData);
        return msgs;
    }

    public String setCommand(SessionInfo sessionInfo, KeyData xmlKey, MsgUnit msgUnit, PublishQosServer publishQos, boolean isClusterUpdate) throws XmlBlasterException {
        SetReturn ret;
        String cmdType = "set";
        String command = xmlKey.getOid();
        if (command == null) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME + ".setCommand", "Ignoring your empty command.");
        }
        command = command.trim();
        if (this.log.CALL) {
            this.log.call(this.ME, "Invoking setCommand(" + command + ")");
        }
        if (!command.startsWith("__cmd:") || command.length() < "__cmd:".length() + 1) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME + ".setCommand", "Ignoring your empty command '" + command + "'.");
        }
        int dotIndex = command.indexOf(":");
        String query = command.substring(dotIndex + 1).trim();
        if (query.indexOf("=") == -1) {
            query = query + "=" + msgUnit.getContentStr();
        }
        if ((ret = this.commandManager.set(sessionInfo.getSecretSessionId(), query)) == null) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME + ".setCommand", "Your command '" + ret.commandWrapper.getCommand() + "' failed, reason is unknown");
        }
        String info = ret.commandWrapper.getCommandStripAssign() + "=" + ret.returnString;
        StringBuffer buf = new StringBuffer(160);
        buf.append("<qos><state id='").append("OK").append("'");
        if (info.indexOf("'") == -1) {
            buf.append(" info='").append(info).append("'");
        }
        buf.append("/><key oid='").append(xmlKey.getOid()).append("'/></qos>");
        return buf.toString();
    }

    private final String getErrorText(String error) {
        String text = "ERROR-XmlBlaster momClient server: " + error;
        text = text + " Try a oid='__cmd:...'";
        this.log.info(this.ME, error);
        return text;
    }

    public String getName() {
        return "MomClientGateway";
    }

    public void shutdown() {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Shutdown.");
        }
    }

    public final String toXml() {
        return this.toXml(null);
    }

    public final synchronized String toXml(String extraOffset) {
        StringBuffer sb = new StringBuffer(1024);
        String offset = "\n   ";
        if (extraOffset == null) {
            extraOffset = "";
        }
        offset = offset + extraOffset;
        sb.append(offset).append("<momClientGateway>");
        sb.append(offset).append("</momClientGateway>");
        return sb.toString();
    }
}

