/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.admin.extern;

import jax.AgentXConnection;
import jax.AgentXOID;
import jax.AgentXRegistration;
import jax.AgentXSession;
import org.jutils.log.LogChannel;
import org.xmlBlaster.engine.Global;
import org.xmlBlaster.engine.admin.CommandManager;
import org.xmlBlaster.engine.admin.I_ExternGateway;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.Constants;
import org.xmlBlaster.util.key.QueryKeyData;

public final class SnmpGateway
implements I_ExternGateway {
    private String ME;
    private Global glob;
    private LogChannel log;
    private CommandManager manager;
    private String sessionId = null;
    private int port = 705;
    private String hostname;
    private AgentXConnection connection;
    private AgentXSession session;
    private AgentXRegistration registration;

    public boolean initialize(Global glob, CommandManager commandManager) throws XmlBlasterException {
        this.glob = glob;
        this.log = this.glob.getLog("admin");
        this.ME = "SnmpGateway" + this.glob.getLogPrefixDashed();
        this.manager = commandManager;
        boolean useSnmp = glob.getProperty().get("admin.snmp", false);
        useSnmp = glob.getProperty().get("admin.snmp[" + glob.getId() + "]", useSnmp);
        if (!useSnmp) {
            return false;
        }
        boolean ret = this.initSubagent();
        this.log.trace(this.ME, "Started SNMP gateway for administration, try 'snmpget -v 1 -c public " + glob.getLocalIP() + " 1.3.6.1.4.1.11662.1.2.1.3' to access it.");
        return ret;
    }

    private boolean initSubagent() throws XmlBlasterException {
        this.port = this.glob.getProperty().get("admin.snmp.port", this.port);
        this.port = this.glob.getProperty().get("admin.snmp.port[" + this.glob.getId() + "]", this.port);
        this.hostname = this.glob.getProperty().get("admin.snmp.hostname", this.glob.getBootstrapAddress().getBootstrapHostname());
        this.hostname = this.glob.getProperty().get("admin.snmp.hostname[" + this.glob.getId() + "]", this.hostname);
        boolean debug = this.glob.getProperty().get("admin.snmp.debug", false);
        debug = this.glob.getProperty().get("admin.snmp.debug[" + this.glob.getId() + "]", debug);
        System.setProperty("jax.debug", "" + debug);
        if (this.port < 1) {
            this.log.warn(this.ME, "SNMP subagent is switched off, please provide admin.snmp.port > 0 to switch it on");
            return false;
        }
        try {
            this.log.info(this.ME, "Subagent connection over AGENTX to SNMP-agent on " + this.hostname + ":" + this.port);
            this.connection = new AgentXConnection(this.hostname, this.port);
            this.log.info(this.ME, "Subagent connection over AGENTX to SNMP-agent on " + this.hostname + ":" + this.port + " established");
            this.session = new AgentXSession();
            this.connection.openSession(this.session);
            this.registration = new AgentXRegistration(new AgentXOID(Constants.XMLBLASTER_OID_ROOT));
            this.session.register(this.registration);
            this.log.info(this.ME, "Subagent registered");
        }
        catch (Exception e) {
            String text = "Subagent connection over AGENTX to SNMP-agent on " + this.hostname + ":" + this.port + " failed:" + e.toString();
            this.log.error(this.ME, text);
            throw new XmlBlasterException(this.ME, text);
        }
        this.initMib();
        return true;
    }

    private void initMib() {
    }

    public String getCommand(String cmd) {
        try {
            MsgUnit[] msgs;
            if (cmd == null || cmd.length() < 1) {
                return this.getErrorText("Ignoring your empty command.");
            }
            if ((cmd = cmd.trim()).length() < 1) {
                return this.getErrorText("Ignoring your empty command.");
            }
            QueryKeyData query = new QueryKeyData(this.glob);
            query.setOid("__cmd:" + cmd);
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Invoking SNMP cmd=" + cmd + " as query=" + query.toXml());
            }
            if ((msgs = this.manager.get(this.sessionId, query, null)).length == 0) {
                return "NOT FOUND";
            }
            String retValue = "";
            int ii = 0;
            while (ii < msgs.length) {
                MsgUnit msg = msgs[ii];
                if (msg.getQos().startsWith("text/plain")) {
                    retValue = msg.getContentStr() + ", ";
                }
                ++ii;
            }
            return retValue;
        }
        catch (XmlBlasterException e) {
            if (this.log.TRACE) {
                this.log.trace(this.ME + ".SNMP", e.toString());
            }
            return e.toString();
        }
    }

    private final String getErrorText(String error) {
        String text = "ERROR-XmlBlaster SNMP server: " + error + "Try a 'snmpget ...'.";
        this.log.info(this.ME, error);
        return text;
    }

    public String help() {
        return "XmlBlaster SNMP administration, see http://www.xmlblaster.org/xmlBlaster/doc/requirements/admin.snmp.html";
    }

    public String help(String cmd) {
        return this.help();
    }

    public String getName() {
        return "SnmpGateway";
    }

    public void shutdown() {
        if (this.session != null) {
            try {
                this.session.unregister(this.registration);
                this.session.close((short)5);
                this.session = null;
            }
            catch (Exception e) {
                this.log.warn(this.ME, "Problems on shutdown: " + e.toString());
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
                this.connection = null;
            }
            catch (Exception e) {
                this.log.warn(this.ME, "Problems on disconnect: " + e.toString());
            }
        }
        this.log.info(this.ME, "Subagent connection over AGENTX to SNMP-agent on " + this.hostname + ":" + this.port + " is shutdown");
    }

    public final String toXml() {
        return this.toXml(null);
    }

    public final synchronized String toXml(String extraOffset) {
        StringBuffer sb = new StringBuffer(1024);
        String offset = "\n   ";
        if (extraOffset == null) {
            extraOffset = "";
        }
        offset = offset + extraOffset;
        sb.append(offset).append("<SnmpGateway>");
        sb.append(offset).append("</SnmpGateway>");
        return sb.toString();
    }
}

