/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.admin.extern;

import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.StringTokenizer;
import org.jutils.log.LogChannel;
import org.jutils.time.TimeHelper;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.engine.Global;
import org.xmlBlaster.engine.admin.CommandManager;
import org.xmlBlaster.engine.admin.I_ExternGateway;
import org.xmlBlaster.engine.admin.SetReturn;
import org.xmlBlaster.engine.qos.ConnectQosServer;
import org.xmlBlaster.engine.qos.ConnectReturnQosServer;
import org.xmlBlaster.util.I_Timeout;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.Timestamp;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.key.QueryKeyData;
import remotecons.RemoteServer;
import remotecons.ifc.CommandHandlerIfc;
import remotecons.wttools.ConnectionServer;

public final class TelnetGateway
implements CommandHandlerIfc,
I_ExternGateway,
I_Timeout {
    private String ME;
    private Global glob;
    private LogChannel log;
    private CommandManager commandManager;
    private int port;
    private RemoteServer rs = null;
    private final String CRLF = "\r\n";
    private static int instanceCounter = 0;
    private boolean isShutdown = true;
    private boolean isLogin = false;
    private ConnectReturnQosServer connectRetQos = null;
    private String loginName = "";
    private String sessionId = null;
    private Set telnetInstancesSet;
    private Timestamp timerKey;
    private long sessionTimeout = 3600000L;
    private ConnectionServer connectionServer = null;
    private String lastCommand = "";
    public static final int TELNET_PORT = 2702;

    public TelnetGateway() {
        ++instanceCounter;
    }

    public boolean initialize(Global glob, CommandManager commandManager) throws XmlBlasterException {
        this.initializeVariables(glob, commandManager, true);
        return this.initListener();
    }

    private boolean initializeVariables(Global glob, CommandManager commandManager, boolean isBootstrap) {
        this.glob = glob;
        this.log = this.glob.getLog("admin");
        this.ME = "TelnetGateway" + instanceCounter + this.glob.getLogPrefixDashed();
        this.telnetInstancesSet = new HashSet();
        this.commandManager = commandManager;
        this.sessionTimeout = glob.getProperty().get("admin.remoteconsole.sessionTimeout", this.sessionTimeout);
        this.sessionTimeout = glob.getProperty().get("admin.remoteconsole.sessionTimeout[" + glob.getId() + "]", this.sessionTimeout);
        this.port = glob.getProperty().get("admin.remoteconsole.port", 2702);
        this.port = glob.getProperty().get("admin.remoteconsole.port[" + glob.getId() + "]", this.port);
        if (this.port <= 1000) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "No telnet gateway configured, port=" + this.port + " try '-admin.remoteconsole.port " + 2702 + "' if you want one");
            }
            return false;
        }
        if (!isBootstrap) {
            if (this.sessionTimeout > 0L) {
                this.log.info(this.ME, "New connection from telnet client accepted, session timeout is " + TimeHelper.millisToNice(this.sessionTimeout));
                this.timerKey = glob.getTelnetSessionTimer().addTimeoutListener(this, this.sessionTimeout, null);
            } else {
                this.log.info(this.ME, "Session for " + this.loginName + " lasts forever, requested expiry timer was 0");
            }
        }
        return true;
    }

    public void register(ConnectionServer server) {
        this.connectionServer = server;
    }

    private void stopTimer() {
        if (this.timerKey != null && this.glob.hasTelnetSessionTimer()) {
            this.glob.getTelnetSessionTimer().removeTimeoutListener(this.timerKey);
            this.timerKey = null;
        }
    }

    protected void finalize() {
        this.stopTimer();
        this.disconnect();
    }

    public final void timeout(Object userData) {
        TelnetGateway telnetGateway = this;
        synchronized (telnetGateway) {
            this.timerKey = null;
            if (this.isLogin) {
                this.log.warn(this.ME, "Session timeout " + TimeHelper.millisToNice(this.sessionTimeout) + " for telnet client " + this.loginName + " occurred, autologout.");
            } else {
                this.log.warn(this.ME, "Session timeout " + TimeHelper.millisToNice(this.sessionTimeout) + " for not authorized telnet client occurred, autologout.");
            }
        }
        this.connectRetQos = null;
        if (this.connectionServer != null) {
            this.connectionServer.shutdown();
        }
    }

    private synchronized void disconnect() {
        if (this.isLogin) {
            if (this.connectRetQos != null) {
                try {
                    this.glob.getAuthenticate().disconnect(this.connectRetQos.getSecretSessionId(), null);
                }
                catch (XmlBlasterException e) {
                    this.log.warn(this.ME, e.getMessage());
                }
                this.log.info(this.ME, "Logout of '" + this.loginName + "', telnet connection destroyed");
                this.connectRetQos = null;
            } else {
                this.log.info(this.ME, "Connection from not authorized telnet client destroyed");
            }
        }
        this.isLogin = false;
    }

    private boolean initListener() throws XmlBlasterException {
        if (this.port > 1000) {
            this.createRemoteConsole(this.port);
            this.log.info(this.ME, "Started remote console server for administration, try 'telnet " + this.glob.getLocalIP() + " " + this.port + "' to access it and type 'help'.");
            return true;
        }
        if (this.log.TRACE) {
            this.log.trace(this.ME, "No telnet gateway configured, port=" + this.port + " try '-admin.remoteconsole.port " + 2702 + "' if you want one");
        }
        return false;
    }

    private void createRemoteConsole(int port) throws XmlBlasterException {
        if (port > 1000) {
            this.rs = new RemoteServer();
            this.rs.setServer_port(port);
            this.rs.setAs_daemon(true);
            LinkedList<TelnetGateway> ll = new LinkedList<TelnetGateway>();
            ll.add(this);
            try {
                this.rs.initialize(ll);
            }
            catch (IOException e) {
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Initializing of remote console on port=" + port + " failed:" + e.toString());
                }
                throw new XmlBlasterException(this.ME, "Initializing of remote telnet console on port=" + port + " failed:" + e.toString());
            }
        }
    }

    public String handleCommand(String cmd) {
        try {
            if (cmd == null || cmd.length() < 1) {
                this.lastCommand = "";
                return this.getErrorText("Ignoring your empty command.");
            }
            if ((cmd = cmd.trim()).length() < 1) {
                this.lastCommand = "";
                return this.getErrorText("Ignoring your empty command.");
            }
            if (cmd.trim().equalsIgnoreCase("quit")) {
                this.lastCommand = "";
                this.stopTimer();
                this.disconnect();
                return null;
            }
            if (cmd.trim().equalsIgnoreCase("time")) {
                this.lastCommand = cmd;
                return "" + new Date() + "\r\n";
            }
            if (cmd.trim().toUpperCase().startsWith("MEM")) {
                this.lastCommand = cmd;
                Runtime rt = Runtime.getRuntime();
                return "" + rt.totalMemory() + "/" + rt.freeMemory() + "\r\n";
            }
            StringTokenizer st = new StringTokenizer(cmd, " ");
            if (!st.hasMoreTokens()) {
                this.lastCommand = cmd;
                return this.getErrorText("Ignoring your empty command.");
            }
            String cmdType = st.nextToken();
            if (!st.hasMoreTokens()) {
                if (cmdType.trim().equalsIgnoreCase("GET") || cmdType.trim().equalsIgnoreCase("SET") || cmdType.trim().equalsIgnoreCase("CONNECT")) {
                    this.lastCommand = cmd;
                    return this.getErrorText("Ignoring your empty command '" + cmd + "'");
                }
                if (cmdType.trim().equalsIgnoreCase("echo")) {
                    this.lastCommand = cmd;
                    return null;
                }
            }
            String query = cmd.substring(cmdType.length()).trim();
            if (cmdType.trim().equalsIgnoreCase("CONNECT")) {
                if (!st.hasMoreTokens()) {
                    this.lastCommand = cmd;
                    return this.getErrorText("Please give me a login name and password to connect: '" + cmd + " <name> <passwd>'");
                }
                String loginName = st.nextToken();
                if (!st.hasMoreTokens()) {
                    this.lastCommand = cmd;
                    return this.getErrorText("Please give me a password to connect: '" + cmd + " <passwd>'");
                }
                String passwd = st.nextToken();
                this.connect(loginName, passwd);
                this.log.info(this.ME, "Successful login for telnet client '" + loginName + "', session timeout is " + TimeHelper.millisToNice(this.sessionTimeout));
                this.lastCommand = cmd;
                return "Successful login for user " + loginName + ", session timeout is " + TimeHelper.millisToNice(this.sessionTimeout) + "\r\n";
            }
            if (!this.isLogin) {
                this.lastCommand = cmd;
                return this.getErrorText("Please login first with 'connect <loginName> <password>'");
            }
            if (cmd.trim().equalsIgnoreCase("gc")) {
                this.lastCommand = cmd;
                System.gc();
                return "OK\r\n";
            }
            if (cmd.trim().toUpperCase().startsWith("EXIT")) {
                this.lastCommand = cmd;
                return "\r\nYou are going to shutdown remote JVM!\r\nAre you sure to do this and stop xmlBlaster? (yes/no): ";
            }
            if (cmd.trim().equalsIgnoreCase("yes") && this.lastCommand.trim().startsWith("exit")) {
                System.exit(0);
            }
            if (cmd.trim().equalsIgnoreCase("no") && this.lastCommand.trim().toUpperCase().startsWith("EXIT")) {
                this.lastCommand = "";
                return "\r\n";
            }
            this.lastCommand = "";
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Invoking cmdType=" + cmdType + " query=" + query + " from '" + cmd + "'");
            }
            if (cmdType.trim().equalsIgnoreCase("GET")) {
                QueryKeyData keyData = new QueryKeyData(this.glob);
                keyData.setOid("__cmd:" + query);
                MsgUnit[] msgs = this.commandManager.get(this.sessionId, keyData, null);
                if (msgs.length == 0) {
                    return "NO ENTRY FOUND: " + cmd + "\r\n";
                }
                StringBuffer sb = new StringBuffer(msgs.length * 40);
                int ii = 0;
                while (ii < msgs.length) {
                    MsgUnit msg = msgs[ii];
                    if (msg.getQos().startsWith("text/plain")) {
                        sb.append(msg.getKey()).append("=").append(msg.getContentStr()).append("\r\n");
                    } else {
                        sb.append(msg.toXml());
                    }
                    ++ii;
                }
                return sb.toString() + "\r\n";
            }
            if (cmdType.trim().equalsIgnoreCase("SET")) {
                SetReturn ret = this.commandManager.set(this.sessionId, query);
                if (ret == null) {
                    return "NO ENTRY SET: " + ret.commandWrapper.getCommand() + "\r\n";
                }
                return ret.commandWrapper.getCommandStripAssign() + "=" + ret.returnString + "\r\n";
            }
            return null;
        }
        catch (XmlBlasterException e) {
            if (this.log.TRACE) {
                this.log.trace(this.ME + ".telnet", e.toString());
            }
            return "\r\n" + e.toString() + "\r\n" + "\r\n";
        }
    }

    private final String getErrorText(String error) {
        String text = "ERROR-XmlBlaster telnet server: " + error + "\r\n";
        text = this.isLogin ? text + "Try a 'get sysprop/?user.home' or 'set sysprop/?trace[core]=true' or just 'help'\r\n\r\n" : text + "Try 'help'\r\n\r\n";
        this.log.info(this.ME, error);
        return text;
    }

    public String help() {
        return "\r\n  XmlBlaster telnet administration\r\n   connect [name] [passwd]  Login with your login name and password\r\n   get [query]              Get property or xmlBlaster state\r\n   set [query]              Set a property or change xmlBlaster setting\r\n   time                     Display current time on server\r\n   gc                       Run System.gc() command on remote system\r\n   mem [total|free]         Display amount of memory on remote system\r\n   exit                     Call System.exit(0) on remote system\r\n  For query syntax see\r\n  http://www.xmlblaster.org/xmlBlaster/doc/requirements/admin.telnet.html\r\n  http://www.xmlblaster.org/xmlBlaster/doc/requirements/admin.commands.html\r\n\r\n";
    }

    public String help(String cmd) {
        return "";
    }

    public CommandHandlerIfc getInstance() {
        if (this.isShutdown) {
            return this;
        }
        if (this.port <= 1000) {
            return null;
        }
        TelnetGateway telnetGateway = new TelnetGateway();
        telnetGateway.initializeVariables(this.glob, this.commandManager, false);
        this.telnetInstancesSet.add(telnetGateway);
        return telnetGateway;
    }

    public String getName() {
        return "TelnetGateway";
    }

    public void connect(String loginName, String passwd) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering login(loginName=" + loginName + ")");
        }
        if (loginName == null || passwd == null) {
            this.log.error(this.ME + "InvalidArguments", "login failed: please use no null arguments for login()");
            throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME + ".connect", "login failed: please use 'connect loginName password'");
        }
        ConnectQos clientConnectQos = new ConnectQos(this.glob, loginName, passwd);
        clientConnectQos.setSessionTimeout(this.sessionTimeout);
        ConnectQosServer connectQos = new ConnectQosServer((org.xmlBlaster.util.Global)this.glob, clientConnectQos.getData());
        this.connectRetQos = this.glob.getAuthenticate().connect(connectQos);
        this.loginName = loginName;
        this.sessionId = this.connectRetQos.getSecretSessionId();
        this.isLogin = true;
        if (connectQos.getSessionTimeout() > 0L) {
            this.stopTimer();
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Setting expiry timer for " + loginName + " to " + connectQos.getSessionTimeout() + " msec");
            }
            this.timerKey = this.glob.getTelnetSessionTimer().addTimeoutListener(this, connectQos.getSessionTimeout(), null);
        } else {
            this.log.info(this.ME, "Session for " + loginName + " lasts forever, requested expiry timer was 0");
        }
    }

    public void shutdown() {
        if (this.log.CALL) {
            this.log.call(this.ME, "Invoking shutdown()");
        }
        this.isLogin = false;
        if (this.glob.hasTelnetSessionTimer()) {
            this.stopTimer();
            this.glob.removeTelnetSessionTimer();
        }
        this.disconnect();
        if (this.telnetInstancesSet != null) {
            Iterator it = this.telnetInstancesSet.iterator();
            while (it.hasNext()) {
                TelnetGateway gw = (TelnetGateway)it.next();
                gw.shutdown();
            }
            this.telnetInstancesSet.clear();
        }
        if (this.rs != null) {
            this.rs.disable();
            this.rs = null;
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Shutdown done, telnet disabled.");
            }
        }
        this.isShutdown = true;
    }

    public final String toXml() {
        return this.toXml(null);
    }

    public final synchronized String toXml(String extraOffset) {
        StringBuffer sb = new StringBuffer(1024);
        String offset = "\n ";
        if (extraOffset == null) {
            extraOffset = "";
        }
        offset = offset + extraOffset;
        sb.append(offset).append("<telnetGateway");
        sb.append(" port='").append(this.port).append("'");
        sb.append(" loginName='").append(this.loginName).append("'");
        sb.append(" numInstances='").append(this.telnetInstancesSet != null ? this.telnetInstancesSet.size() : 0).append("'");
        sb.append(">");
        if (this.glob.hasTelnetSessionTimer()) {
            sb.append(offset).append(" <hasTimer/>");
        }
        sb.append(offset).append("</telnetGateway>");
        return sb.toString();
    }
}

