/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.admin.extern.snmp;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import jax.AgentXGroup;
import jax.AgentXNotification;
import jax.AgentXSession;
import org.xmlBlaster.engine.admin.extern.snmp.ClientEntryImpl;
import org.xmlBlaster.engine.admin.extern.snmp.ClientQueueThresholdOverflow;
import org.xmlBlaster.engine.admin.extern.snmp.ClientTable;
import org.xmlBlaster.engine.admin.extern.snmp.ClientTableSubject;
import org.xmlBlaster.engine.admin.extern.snmp.Observer;
import org.xmlBlaster.engine.admin.extern.snmp.SessionTableThresholdOverflow;
import org.xmlBlaster.engine.admin.extern.snmp.Subject;

public class ClientTableObserver
implements Observer {
    private ClientTableSubject clientTableSubject;
    private AgentXSession session;
    private ClientEntryImpl clientEntryImpl;
    private ClientTable clientTable;
    private Hashtable clientHashtable;
    private BitSet indexSet;
    private Hashtable refCounts;
    private static final int MAXINDX = 100;

    public ClientTableObserver(ClientTableSubject clientTableSubject, AgentXSession session) {
        this.clientTableSubject = clientTableSubject;
        this.session = session;
        clientTableSubject.addObserver(this);
        this.clientTable = new ClientTable();
        session.addGroup((AgentXGroup)this.clientTable);
        this.clientHashtable = new Hashtable();
        this.refCounts = new Hashtable();
        this.indexSet = new BitSet();
        int i = 1;
        while (i <= 100) {
            this.indexSet.set(i);
            ++i;
        }
    }

    public int increment(Integer clientIndex) {
        Enumeration e = this.clientHashtable.keys();
        String clientName = (String)e.nextElement();
        while (this.clientHashtable.get(clientName) != clientIndex && e.hasMoreElements()) {
            clientName = (String)e.nextElement();
        }
        if (this.clientHashtable.get(clientName) != clientIndex) {
            return -1;
        }
        Integer rc = (Integer)this.refCounts.get(clientName);
        if (rc != null) {
            this.refCounts.put(clientName, new Integer(rc + 1));
            System.out.println("increment, " + clientName + ", " + (Integer)this.refCounts.get(clientName));
            return rc + 1;
        }
        this.refCounts.put(clientName, new Integer(1));
        System.out.println("increment, " + clientName + ", 1");
        return 1;
    }

    public int decrement(Integer clientIndex) {
        Enumeration e = this.clientHashtable.keys();
        String clientName = (String)e.nextElement();
        while (this.clientHashtable.get(clientName) != clientIndex && e.hasMoreElements()) {
            clientName = (String)e.nextElement();
        }
        if (this.clientHashtable.get(clientName) != clientIndex) {
            return -1;
        }
        Integer rc = (Integer)this.refCounts.get(clientName);
        if (rc == null) {
            return -1;
        }
        if (rc > 1) {
            this.refCounts.put(clientName, new Integer(rc - 1));
            return rc - 1;
        }
        this.refCounts.remove(clientName);
        return 0;
    }

    public void sendTrap(AgentXSession session) {
        Enumeration ct = this.clientTable.elements();
        while (ct.hasMoreElements()) {
            this.clientEntryImpl = (ClientEntryImpl)((Object)ct.nextElement());
            long clientQueueNumEntries = this.clientEntryImpl.get_clientQueueNumEntries();
            long clientQueueMaxEntries = this.clientEntryImpl.get_clientQueueMaxEntries();
            long clientQueueThreshold = this.clientEntryImpl.get_clientQueueThreshold();
            System.out.println("clientQueueMaxEntries: " + clientQueueMaxEntries + ", clientQueueThreshold: " + clientQueueThreshold + ", clientQueueNumEntries: " + clientQueueNumEntries);
            if (clientQueueMaxEntries * clientQueueThreshold < clientQueueNumEntries) {
                try {
                    ClientQueueThresholdOverflow clientQueueNotify = new ClientQueueThresholdOverflow(this.clientEntryImpl, this.clientEntryImpl, this.clientEntryImpl, this.clientEntryImpl);
                    session.notify((AgentXNotification)clientQueueNotify);
                }
                catch (Exception e) {
                    System.err.println(e);
                }
            }
            long numSessions = this.clientEntryImpl.get_numSessions();
            long maxSessions = this.clientEntryImpl.get_maxSessions();
            long sessionThreshold = this.clientEntryImpl.get_sessionThreshold();
            System.out.println("maxSessions: " + maxSessions + ", sessionThreshold: " + sessionThreshold + ", numSessions: " + numSessions);
            if (maxSessions * sessionThreshold >= numSessions) continue;
            try {
                SessionTableThresholdOverflow sessionTableNotify = new SessionTableThresholdOverflow(this.clientEntryImpl, this.clientEntryImpl, this.clientEntryImpl, this.clientEntryImpl);
                session.notify((AgentXNotification)sessionTableNotify);
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
    }

    public Integer getIndex(String key) {
        return (Integer)this.clientHashtable.get(key);
    }

    public void update(Subject o) {
        block0 : switch (this.clientTableSubject.opCode) {
            case 0: {
                if (o != this.clientTableSubject) break;
                String clientName = this.clientTableSubject.clientEntryImplPeer.get_clientName();
                String nodeName = this.clientTableSubject.nodeName;
                if (this.clientHashtable.containsKey(nodeName + clientName)) {
                    System.out.println("A node/client  " + nodeName + clientName + " already exists.");
                    break;
                }
                System.out.println("Insert node/client " + nodeName + clientName);
                int clientIndex = 1;
                while (clientIndex <= 100 && !this.indexSet.get(clientIndex)) {
                    ++clientIndex;
                }
                if (clientIndex > 100) {
                    System.out.println("Error: clientIndex > 100");
                    break;
                }
                this.indexSet.clear(clientIndex);
                this.clientHashtable.put(nodeName + clientName, new Integer(clientIndex));
                this.clientEntryImpl = new ClientEntryImpl(this.clientTableSubject.nodeIndex.intValue(), clientIndex, this.clientTableSubject.clientEntryImplPeer);
                this.clientTable.addEntry(this.clientEntryImpl);
                this.clientTableSubject.nodeTableObserver.increment(this.clientTableSubject.nodeIndex);
                break;
            }
            case 1: {
                if (o != this.clientTableSubject) break;
                System.out.println("Remove a client table entry.");
                String clientName = this.clientTableSubject.clientEntryImplPeer.get_clientName();
                String nodeName = this.clientTableSubject.nodeName;
                if (!this.clientHashtable.containsKey(nodeName + clientName)) {
                    System.out.println("A node/client " + nodeName + clientName + " does not exist.");
                    break;
                }
                System.out.println("Remove node/client " + nodeName + clientName);
                if (this.refCounts.get(nodeName + clientName) != null) {
                    System.out.println("node/client " + nodeName + clientName + " is referenced by ...");
                    break;
                }
                int remInd = (Integer)this.clientHashtable.get(nodeName + clientName);
                this.clientHashtable.remove(nodeName + clientName);
                Enumeration ct = this.clientTable.elements();
                while (ct.hasMoreElements()) {
                    this.clientEntryImpl = (ClientEntryImpl)((Object)ct.nextElement());
                    long nodeIndex = this.clientEntryImpl.nodeIndex;
                    long clientIndex = this.clientEntryImpl.clientIndex;
                    if (clientIndex != (long)remInd || nodeIndex != (long)this.clientTableSubject.nodeIndex.intValue()) continue;
                    this.clientTable.removeEntry(this.clientEntryImpl);
                    this.clientTableSubject.nodeTableObserver.decrement(this.clientTableSubject.nodeIndex);
                    break block0;
                }
                break;
            }
            default: {
                System.out.println("Unknown table operation code: " + this.clientTableSubject.opCode);
            }
        }
    }
}

