/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.admin.extern.snmp;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.xmlBlaster.engine.admin.extern.snmp.ClientEntryImplPeer;
import org.xmlBlaster.engine.admin.extern.snmp.NodeTableObserver;
import org.xmlBlaster.engine.admin.extern.snmp.Observer;
import org.xmlBlaster.engine.admin.extern.snmp.Subject;

public class ClientTableSubject
implements Subject {
    public ClientEntryImplPeer clientEntryImplPeer;
    public NodeTableObserver nodeTableObserver;
    public ArrayList observers = new ArrayList();
    public Integer nodeIndex;
    public String nodeName;
    public int opCode;
    public static final int INSERT = 0;
    public static final int REMOVE = 1;

    public ClientTableSubject(NodeTableObserver nodeTableObserver) {
        this.nodeTableObserver = nodeTableObserver;
    }

    public void addEntry(String nodeName, ClientEntryImplPeer clientEntryImplPeer) {
        this.clientEntryImplPeer = clientEntryImplPeer;
        this.nodeIndex = this.nodeTableObserver.getIndex(nodeName);
        this.nodeName = nodeName;
        if (this.nodeIndex != null) {
            this.opCode = 0;
            this.notifyObservers();
        } else {
            System.out.println("Cannot add client entry. Node entry " + nodeName + " does not exist.");
        }
    }

    public void removeEntry(String nodeName, ClientEntryImplPeer clientEntryImplPeer) {
        this.clientEntryImplPeer = clientEntryImplPeer;
        this.nodeIndex = this.nodeTableObserver.getIndex(nodeName);
        this.nodeName = nodeName;
        if (this.nodeIndex != null) {
            this.opCode = 1;
            this.notifyObservers();
        } else {
            System.out.println("Cannot remove client entry. Node entry " + nodeName + " does not exist.");
        }
    }

    public void addObserver(Observer o) {
        this.observers.add(o);
    }

    public void removeObserver(Observer o) {
        ((AbstractCollection)this.observers).remove(o);
    }

    private void notifyObservers() {
        Iterator i = ((AbstractList)this.observers).iterator();
        while (i.hasNext()) {
            Observer o = (Observer)i.next();
            o.update(this);
        }
    }
}

