/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.admin.extern.snmp;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import jax.AgentXGroup;
import jax.AgentXSession;
import org.xmlBlaster.engine.admin.extern.snmp.ConnectionEntryImpl;
import org.xmlBlaster.engine.admin.extern.snmp.ConnectionTable;
import org.xmlBlaster.engine.admin.extern.snmp.ConnectionTableSubject;
import org.xmlBlaster.engine.admin.extern.snmp.Observer;
import org.xmlBlaster.engine.admin.extern.snmp.Subject;

public class ConnectionTableObserver
implements Observer {
    private ConnectionTableSubject connectionTableSubject;
    private AgentXSession session;
    private ConnectionEntryImpl connectionEntryImpl;
    private ConnectionTable connectionTable;
    private Hashtable connectionHashtable;
    private BitSet indexSet;
    private static final int MAXINDX = 100;

    public ConnectionTableObserver(ConnectionTableSubject connectionTableSubject, AgentXSession session) {
        this.connectionTableSubject = connectionTableSubject;
        this.session = session;
        connectionTableSubject.addObserver(this);
        this.connectionTable = new ConnectionTable();
        session.addGroup((AgentXGroup)this.connectionTable);
        this.connectionHashtable = new Hashtable();
        this.indexSet = new BitSet();
        int i = 1;
        while (i <= 100) {
            this.indexSet.set(i);
            ++i;
        }
    }

    public void update(Subject o) {
        block0 : switch (this.connectionTableSubject.opCode) {
            case 0: {
                if (o != this.connectionTableSubject) break;
                String connectionHost = this.connectionTableSubject.connectionEntryImplPeer.get_connectionHost();
                long connectionPort = this.connectionTableSubject.connectionEntryImplPeer.get_connectionPort();
                if (this.connectionHashtable.containsKey(connectionHost + connectionPort)) {
                    System.out.println("A connection to " + connectionHost + connectionPort + " already exists.");
                    break;
                }
                System.out.println("Insert connection = " + connectionHost + connectionPort);
                int connectionIndex = 1;
                while (connectionIndex <= 100 && !this.indexSet.get(connectionIndex)) {
                    ++connectionIndex;
                }
                if (connectionIndex > 100) {
                    System.out.println("Error: connectionIndex > 100");
                    break;
                }
                this.indexSet.clear(connectionIndex);
                this.connectionHashtable.put(connectionHost + connectionPort, new Integer(connectionIndex));
                this.connectionEntryImpl = new ConnectionEntryImpl(this.connectionTableSubject.nodeIndex.intValue(), connectionIndex, this.connectionTableSubject.connectionEntryImplPeer);
                this.connectionTable.addEntry(this.connectionEntryImpl);
                this.connectionTableSubject.nodeTableObserver.increment(this.connectionTableSubject.nodeIndex);
                break;
            }
            case 1: {
                if (o != this.connectionTableSubject) break;
                System.out.println("Remove a connection table entry.");
                String connectionHost = this.connectionTableSubject.connectionEntryImplPeer.get_connectionHost();
                long connectionPort = this.connectionTableSubject.connectionEntryImplPeer.get_connectionPort();
                if (!this.connectionHashtable.containsKey(connectionHost + connectionPort)) {
                    System.out.println("A connection to " + connectionHost + connectionPort + " does not exist.");
                    break;
                }
                System.out.println("Remove connection = " + connectionHost + connectionPort);
                int remConInd = (Integer)this.connectionHashtable.get(connectionHost + connectionPort);
                this.connectionHashtable.remove(connectionHost + connectionPort);
                Enumeration ct = this.connectionTable.elements();
                while (ct.hasMoreElements()) {
                    this.connectionEntryImpl = (ConnectionEntryImpl)((Object)ct.nextElement());
                    long nodeIndex = this.connectionEntryImpl.nodeIndex;
                    long connectionIndex = this.connectionEntryImpl.connectionIndex;
                    if (connectionIndex != (long)remConInd || nodeIndex != (long)this.connectionTableSubject.nodeIndex.intValue()) continue;
                    this.connectionTable.removeEntry(this.connectionEntryImpl);
                    this.connectionTableSubject.nodeTableObserver.decrement(this.connectionTableSubject.nodeIndex);
                    break block0;
                }
                break;
            }
            default: {
                System.out.println("Unknown table operation code: " + this.connectionTableSubject.opCode);
            }
        }
    }
}

