/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.admin.extern.snmp;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import jax.AgentXGroup;
import jax.AgentXNotification;
import jax.AgentXSession;
import org.xmlBlaster.engine.admin.extern.snmp.ClientTableThresholdOverflow;
import org.xmlBlaster.engine.admin.extern.snmp.NodeEntryImpl;
import org.xmlBlaster.engine.admin.extern.snmp.NodeTable;
import org.xmlBlaster.engine.admin.extern.snmp.NodeTableSubject;
import org.xmlBlaster.engine.admin.extern.snmp.Observer;
import org.xmlBlaster.engine.admin.extern.snmp.Subject;

public class NodeTableObserver
implements Observer {
    private NodeTableSubject nodeTableSubject;
    private AgentXSession session;
    private NodeEntryImpl nodeEntryImpl;
    private NodeTable nodeTable;
    private Hashtable nodeHashtable;
    private BitSet indexSet;
    private Hashtable refCounts;
    private static final int MAXINDX = 100;

    public NodeTableObserver(NodeTableSubject nodeTableSubject, AgentXSession session) {
        this.nodeTableSubject = nodeTableSubject;
        this.session = session;
        nodeTableSubject.addObserver(this);
        this.nodeTable = new NodeTable();
        session.addGroup((AgentXGroup)this.nodeTable);
        this.nodeHashtable = new Hashtable();
        this.refCounts = new Hashtable();
        this.indexSet = new BitSet();
        int i = 1;
        while (i <= 100) {
            this.indexSet.set(i);
            ++i;
        }
    }

    public int increment(Integer nodeIndex) {
        Enumeration e = this.nodeHashtable.keys();
        String nodeName = (String)e.nextElement();
        while (this.nodeHashtable.get(nodeName) != nodeIndex && e.hasMoreElements()) {
            nodeName = (String)e.nextElement();
        }
        if (this.nodeHashtable.get(nodeName) != nodeIndex) {
            return -1;
        }
        Integer rc = (Integer)this.refCounts.get(nodeName);
        if (rc != null) {
            this.refCounts.put(nodeName, new Integer(rc + 1));
            System.out.println("increment, " + nodeName + ", " + (Integer)this.refCounts.get(nodeName));
            return rc + 1;
        }
        this.refCounts.put(nodeName, new Integer(1));
        System.out.println("increment, " + nodeName + ", 1");
        return 1;
    }

    public int decrement(Integer nodeIndex) {
        Enumeration e = this.nodeHashtable.keys();
        String nodeName = (String)e.nextElement();
        while (this.nodeHashtable.get(nodeName) != nodeIndex && e.hasMoreElements()) {
            nodeName = (String)e.nextElement();
        }
        if (this.nodeHashtable.get(nodeName) != nodeIndex) {
            return -1;
        }
        Integer rc = (Integer)this.refCounts.get(nodeName);
        if (rc == null) {
            return -1;
        }
        if (rc > 1) {
            this.refCounts.put(nodeName, new Integer(rc - 1));
            return rc - 1;
        }
        this.refCounts.remove(nodeName);
        return 0;
    }

    public void sendTrap(AgentXSession session) {
        Enumeration nt = this.nodeTable.elements();
        while (nt.hasMoreElements()) {
            this.nodeEntryImpl = (NodeEntryImpl)((Object)nt.nextElement());
            long numClients = this.nodeEntryImpl.get_numClients();
            long maxClients = this.nodeEntryImpl.get_maxClients();
            long clientThreshold = this.nodeEntryImpl.get_clientThreshold();
            System.out.println("maxClients: " + maxClients + ", clientThreshold: " + clientThreshold + ", numClients: " + numClients);
            if (maxClients * clientThreshold >= numClients) continue;
            try {
                ClientTableThresholdOverflow clientTableNotify = new ClientTableThresholdOverflow(this.nodeEntryImpl, this.nodeEntryImpl, this.nodeEntryImpl, this.nodeEntryImpl);
                session.notify((AgentXNotification)clientTableNotify);
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
    }

    public Integer getIndex(String key) {
        return (Integer)this.nodeHashtable.get(key);
    }

    public void update(Subject o) {
        switch (this.nodeTableSubject.opCode) {
            case 0: {
                if (o != this.nodeTableSubject) break;
                String nodeName = this.nodeTableSubject.nodeEntryImplPeer.get_nodeName();
                System.out.println("Insert a node with nodename = " + nodeName);
                if (this.nodeHashtable.containsKey(nodeName)) {
                    System.out.println("A node with nodename = " + nodeName + " already exists.");
                    break;
                }
                System.out.println("Insert node = " + nodeName);
                int insInd = 1;
                while (insInd <= 100 && !this.indexSet.get(insInd)) {
                    ++insInd;
                }
                if (insInd > 100) {
                    System.out.println("Error: insInd > 100");
                    break;
                }
                this.indexSet.clear(insInd);
                this.nodeHashtable.put(nodeName, new Integer(insInd));
                this.nodeEntryImpl = new NodeEntryImpl(insInd, this.nodeTableSubject.nodeEntryImplPeer);
                this.nodeTable.addEntry(this.nodeEntryImpl);
                break;
            }
            case 1: {
                if (o != this.nodeTableSubject) break;
                String nodeName = this.nodeTableSubject.nodeEntryImplPeer.get_nodeName();
                System.out.println("Remove a node with nodename = " + nodeName);
                if (!this.nodeHashtable.containsKey(nodeName)) {
                    System.out.println("A node with nodename = " + nodeName + " does not exists.");
                    break;
                }
                System.out.println("Remove node = " + nodeName);
                if (this.refCounts.get(nodeName) != null) {
                    System.out.println("node " + nodeName + " is referenced by ...");
                    break;
                }
                int remInd = (Integer)this.nodeHashtable.get(nodeName);
                this.nodeHashtable.remove(nodeName);
                Enumeration nt = this.nodeTable.elements();
                while (nt.hasMoreElements()) {
                    this.nodeEntryImpl = (NodeEntryImpl)((Object)nt.nextElement());
                    long ind = this.nodeEntryImpl.nodeIndex;
                    if (ind != (long)remInd) continue;
                    this.nodeTable.removeEntry(this.nodeEntryImpl);
                    break;
                }
                this.indexSet.set(remInd);
                break;
            }
            default: {
                System.out.println("Unknown table operation code: " + this.nodeTableSubject.opCode);
            }
        }
    }
}

