/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.admin.extern.snmp;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import jax.AgentXGroup;
import jax.AgentXNotification;
import jax.AgentXSession;
import org.xmlBlaster.engine.admin.extern.snmp.CbQueueThresholdOverflow;
import org.xmlBlaster.engine.admin.extern.snmp.Observer;
import org.xmlBlaster.engine.admin.extern.snmp.SessionEntryImpl;
import org.xmlBlaster.engine.admin.extern.snmp.SessionTable;
import org.xmlBlaster.engine.admin.extern.snmp.SessionTableSubject;
import org.xmlBlaster.engine.admin.extern.snmp.Subject;

public class SessionTableObserver
implements Observer {
    private SessionTableSubject sessionTableSubject;
    private AgentXSession session;
    private SessionEntryImpl sessionEntryImpl;
    private SessionTable sessionTable;
    private Hashtable sessionHashtable;
    private BitSet indexSet;
    private static final int MAXINDX = 100;

    public SessionTableObserver(SessionTableSubject sessionTableSubject, AgentXSession session) {
        this.sessionTableSubject = sessionTableSubject;
        this.session = session;
        sessionTableSubject.addObserver(this);
        this.sessionTable = new SessionTable();
        session.addGroup((AgentXGroup)this.sessionTable);
        this.sessionHashtable = new Hashtable();
        this.indexSet = new BitSet();
        int i = 1;
        while (i <= 100) {
            this.indexSet.set(i);
            ++i;
        }
    }

    public void sendTrap(AgentXSession session) {
        Enumeration st = this.sessionTable.elements();
        while (st.hasMoreElements()) {
            this.sessionEntryImpl = (SessionEntryImpl)((Object)st.nextElement());
            long cbQueueNumEntries = this.sessionEntryImpl.get_cbQueueNumEntries();
            long cbQueueMaxEntries = this.sessionEntryImpl.get_cbQueueMaxEntries();
            long cbQueueThreshold = this.sessionEntryImpl.get_cbQueueThreshold();
            System.out.println("cbQueueMaxEntries: " + cbQueueMaxEntries + ", cbQueueThreshold: " + cbQueueThreshold + ", cbQueueNumEntries: " + cbQueueNumEntries);
            if (cbQueueMaxEntries * cbQueueThreshold >= cbQueueNumEntries) continue;
            try {
                CbQueueThresholdOverflow cbQueueNotify = new CbQueueThresholdOverflow(this.sessionEntryImpl, this.sessionEntryImpl, this.sessionEntryImpl, this.sessionEntryImpl);
                session.notify((AgentXNotification)cbQueueNotify);
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
    }

    public void update(Subject o) {
        block0 : switch (this.sessionTableSubject.opCode) {
            case 0: {
                if (o != this.sessionTableSubject) break;
                String sessionName = this.sessionTableSubject.sessionEntryImplPeer.get_sessionName();
                String nodeName = this.sessionTableSubject.nodeName;
                String clientName = this.sessionTableSubject.clientName;
                if (this.sessionHashtable.containsKey(nodeName + clientName + sessionName)) {
                    System.out.println("A session to " + nodeName + clientName + sessionName + " already exists.");
                    break;
                }
                System.out.println("Insert session = " + nodeName + clientName + sessionName);
                int sessionIndex = 1;
                while (sessionIndex <= 100 && !this.indexSet.get(sessionIndex)) {
                    ++sessionIndex;
                }
                if (sessionIndex > 100) {
                    System.out.println("Error: sessionIndex > 100");
                    break;
                }
                this.indexSet.clear(sessionIndex);
                this.sessionHashtable.put(nodeName + clientName + sessionName, new Integer(sessionIndex));
                this.sessionEntryImpl = new SessionEntryImpl(this.sessionTableSubject.nodeIndex.intValue(), this.sessionTableSubject.clientIndex.intValue(), sessionIndex, this.sessionTableSubject.sessionEntryImplPeer);
                this.sessionTable.addEntry(this.sessionEntryImpl);
                this.sessionTableSubject.clientTableObserver.increment(this.sessionTableSubject.clientIndex);
                break;
            }
            case 1: {
                if (o != this.sessionTableSubject) break;
                System.out.println("Remove a session table entry.");
                String sessionName = this.sessionTableSubject.sessionEntryImplPeer.get_sessionName();
                String nodeName = this.sessionTableSubject.nodeName;
                String clientName = this.sessionTableSubject.clientName;
                if (!this.sessionHashtable.containsKey(nodeName + clientName + sessionName)) {
                    System.out.println("A session to " + nodeName + clientName + sessionName + " does not exist.");
                    break;
                }
                System.out.println("Remove session = " + nodeName + clientName + sessionName);
                int remInd = (Integer)this.sessionHashtable.get(nodeName + clientName + sessionName);
                this.sessionHashtable.remove(nodeName + clientName + sessionName);
                Enumeration st = this.sessionTable.elements();
                while (st.hasMoreElements()) {
                    this.sessionEntryImpl = (SessionEntryImpl)((Object)st.nextElement());
                    long nodeIndex = this.sessionEntryImpl.nodeIndex;
                    long clientIndex = this.sessionEntryImpl.clientIndex;
                    long sessionIndex = this.sessionEntryImpl.sessionIndex;
                    if (sessionIndex != (long)remInd || clientIndex != (long)this.sessionTableSubject.nodeIndex.intValue() || nodeIndex != (long)this.sessionTableSubject.nodeIndex.intValue()) continue;
                    this.sessionTable.removeEntry(this.sessionEntryImpl);
                    this.sessionTableSubject.clientTableObserver.decrement(this.sessionTableSubject.clientIndex);
                    break block0;
                }
                break;
            }
            default: {
                System.out.println("Unknown table operation code: " + this.sessionTableSubject.opCode);
            }
        }
    }
}

