/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.admin.extern.snmp;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.xmlBlaster.engine.admin.extern.snmp.ClientTableObserver;
import org.xmlBlaster.engine.admin.extern.snmp.NodeTableObserver;
import org.xmlBlaster.engine.admin.extern.snmp.Observer;
import org.xmlBlaster.engine.admin.extern.snmp.SessionEntryImplPeer;
import org.xmlBlaster.engine.admin.extern.snmp.Subject;

public class SessionTableSubject
implements Subject {
    public SessionEntryImplPeer sessionEntryImplPeer;
    public NodeTableObserver nodeTableObserver;
    public ClientTableObserver clientTableObserver;
    public ArrayList observers = new ArrayList();
    public Integer nodeIndex;
    public Integer clientIndex;
    public String nodeName;
    public String clientName;
    public int opCode;
    public static final int INSERT = 0;
    public static final int REMOVE = 1;

    public SessionTableSubject(NodeTableObserver nodeTableObserver, ClientTableObserver clientTableObserver) {
        this.nodeTableObserver = nodeTableObserver;
        this.clientTableObserver = clientTableObserver;
    }

    public void addEntry(String nodeName, String clientName, SessionEntryImplPeer sessionEntryImplPeer) {
        this.sessionEntryImplPeer = sessionEntryImplPeer;
        this.nodeIndex = this.nodeTableObserver.getIndex(nodeName);
        this.clientIndex = this.clientTableObserver.getIndex(nodeName + clientName);
        this.nodeName = nodeName;
        this.clientName = clientName;
        if (this.nodeIndex != null && this.clientIndex != null) {
            this.opCode = 0;
            this.notifyObservers();
        } else {
            System.out.println("Cannot add session entry. Node " + nodeName + " or client " + clientName + " does not exist.");
        }
    }

    public void removeEntry(String nodeName, String clientName, SessionEntryImplPeer sessionEntryImplPeer) {
        this.sessionEntryImplPeer = sessionEntryImplPeer;
        this.nodeIndex = this.nodeTableObserver.getIndex(nodeName);
        this.clientIndex = this.clientTableObserver.getIndex(nodeName + clientName);
        this.nodeName = nodeName;
        this.clientName = clientName;
        if (this.nodeIndex != null && this.clientIndex != null) {
            this.opCode = 1;
            this.notifyObservers();
        } else {
            System.out.println("Cannot remove session entry. Node " + nodeName + " or client " + clientName + " does not exist.");
        }
    }

    public void addObserver(Observer o) {
        this.observers.add(o);
    }

    public void removeObserver(Observer o) {
        ((AbstractCollection)this.observers).remove(o);
    }

    private void notifyObservers() {
        Iterator i = ((AbstractList)this.observers).iterator();
        while (i.hasNext()) {
            Observer o = (Observer)i.next();
            o.update(this);
        }
    }
}

