/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.admin.extern.snmp;

import jax.AgentXConnection;
import jax.AgentXGroup;
import jax.AgentXOID;
import jax.AgentXRegistration;
import jax.AgentXSession;
import org.xmlBlaster.engine.admin.extern.snmp.ClientEntryImplPeer;
import org.xmlBlaster.engine.admin.extern.snmp.ClientTableObserver;
import org.xmlBlaster.engine.admin.extern.snmp.ClientTableSubject;
import org.xmlBlaster.engine.admin.extern.snmp.ConnectionEntryImplPeer;
import org.xmlBlaster.engine.admin.extern.snmp.ConnectionTableObserver;
import org.xmlBlaster.engine.admin.extern.snmp.ConnectionTableSubject;
import org.xmlBlaster.engine.admin.extern.snmp.NodeEntryImplPeer;
import org.xmlBlaster.engine.admin.extern.snmp.NodeScalarImpl;
import org.xmlBlaster.engine.admin.extern.snmp.NodeTableObserver;
import org.xmlBlaster.engine.admin.extern.snmp.NodeTableSubject;
import org.xmlBlaster.engine.admin.extern.snmp.SessionEntryImplPeer;
import org.xmlBlaster.engine.admin.extern.snmp.SessionTableObserver;
import org.xmlBlaster.engine.admin.extern.snmp.SessionTableSubject;

public class SubagentTest {
    AgentXSession session;
    NodeTableSubject nodeTableSubject;
    NodeTableObserver nodeTableObserver;
    ConnectionTableSubject connectionTableSubject;
    ConnectionTableObserver connectionTableObserver;
    ClientTableSubject clientTableSubject;
    ClientTableObserver clientTableObserver;
    SessionTableSubject sessionTableSubject;
    SessionTableObserver sessionTableObserver;

    public SubagentTest(String[] argv) {
        AgentXRegistration registration;
        AgentXConnection connection;
        int testCase = 0;
        long[] value = new long[]{1L, 3L, 6L, 1L, 4L, 1L, 11662L};
        boolean sleep = true;
        if (argv.length >= 1) {
            testCase = Integer.parseInt(argv[0]);
        }
        String host = argv.length >= 2 ? argv[1] : "localhost";
        int port = argv.length >= 3 ? Integer.parseInt(argv[2]) : 0;
        if (argv.length >= 4) {
            sleep = false;
        }
        try {
            System.out.print("connection to ");
            if (port != 0) {
                System.out.print(host + ", " + port);
                connection = new AgentXConnection(host, port);
            } else {
                connection = new AgentXConnection(host);
            }
            System.out.println(" ... established");
            this.session = new AgentXSession();
            connection.openSession(this.session);
            registration = new AgentXRegistration(new AgentXOID(value));
            this.session.register(registration);
        }
        catch (Exception e) {
            System.out.println(" ... not established");
            System.err.println(e);
            return;
        }
        NodeScalarImpl nodeScalarImpl = new NodeScalarImpl();
        this.session.addGroup((AgentXGroup)nodeScalarImpl);
        this.nodeTableSubject = new NodeTableSubject();
        this.nodeTableObserver = new NodeTableObserver(this.nodeTableSubject, this.session);
        this.connectionTableSubject = new ConnectionTableSubject(this.nodeTableObserver);
        this.connectionTableObserver = new ConnectionTableObserver(this.connectionTableSubject, this.session);
        this.clientTableSubject = new ClientTableSubject(this.nodeTableObserver);
        this.clientTableObserver = new ClientTableObserver(this.clientTableSubject, this.session);
        this.sessionTableSubject = new SessionTableSubject(this.nodeTableObserver, this.clientTableObserver);
        this.sessionTableObserver = new SessionTableObserver(this.sessionTableSubject, this.session);
        switch (testCase) {
            case 0: {
                this.testProc0();
                break;
            }
            case 1: {
                this.testProc1();
                break;
            }
            case 2: {
                this.testProc2();
                break;
            }
            case 3: {
                this.testProc3();
                break;
            }
            case 4: {
                this.testProc4();
                break;
            }
            case 5: {
                this.testProc5();
                break;
            }
            case 6: {
                this.testProc1();
                break;
            }
            default: {
                System.out.println("No testcase argument");
            }
        }
        if (sleep) {
            try {
                Thread.sleep(90000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        try {
            this.session.unregister(registration);
            this.session.close((short)5);
            connection.close();
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public void testProc0() {
        System.out.println("+++ testProc 0 +++");
        System.setProperty("jax.debug", "true");
        NodeEntryImplPeer nodeEntryImplPeer1 = new NodeEntryImplPeer("node1", "host1", 111L, 1111L, 11L, "err1.log", 1);
        this.nodeTableSubject.addEntry(nodeEntryImplPeer1);
        this.nodeTableObserver.sendTrap(this.session);
        ClientEntryImplPeer clientEntryImplPeer1 = new ClientEntryImplPeer("client1", 1, 1, 1111L, 11L, 1, 111L, 11L);
        this.clientTableSubject.addEntry(nodeEntryImplPeer1.get_nodeName(), clientEntryImplPeer1);
        this.clientTableObserver.sendTrap(this.session);
        SessionEntryImplPeer sessionEntryImplPeer1 = new SessionEntryImplPeer("session1", 111L, 11L, 1, 1);
        this.sessionTableSubject.addEntry(nodeEntryImplPeer1.get_nodeName(), clientEntryImplPeer1.get_clientName(), sessionEntryImplPeer1);
        this.sessionTableObserver.sendTrap(this.session);
    }

    public void testProc1() {
        System.out.println("+++ testProc 1 +++");
        NodeEntryImplPeer nodeEntryImplPeer1 = new NodeEntryImplPeer("node1", "host1", 111L, 1111L, 11L, "err1.log", 1);
        ConnectionEntryImplPeer connectionEntryImplPeer1 = new ConnectionEntryImplPeer("host1", 1111L, "1.1.1.1", 1);
        ClientEntryImplPeer clientEntryImplPeer1 = new ClientEntryImplPeer("client1", 1, 1, 1111L, 11L, 1, 111L, 11L);
        SessionEntryImplPeer sessionEntryImplPeer1 = new SessionEntryImplPeer("session1", 111L, 11L, 1, 1);
        this.nodeTableSubject.addEntry(nodeEntryImplPeer1);
        this.connectionTableSubject.addEntry(nodeEntryImplPeer1.get_nodeName(), connectionEntryImplPeer1);
        this.clientTableSubject.addEntry(nodeEntryImplPeer1.get_nodeName(), clientEntryImplPeer1);
        this.sessionTableSubject.addEntry(nodeEntryImplPeer1.get_nodeName(), clientEntryImplPeer1.get_clientName(), sessionEntryImplPeer1);
    }

    public void testProc2() {
        System.out.println("+++ testProc 2 +++");
        NodeEntryImplPeer nodeEntryImplPeer1 = new NodeEntryImplPeer("node1", "host1", 111L, 1111L, 11L, "err1.log", 1);
        NodeEntryImplPeer nodeEntryImplPeer2 = new NodeEntryImplPeer("node2", "host2", 222L, 2222L, 22L, "err2.log", 2);
        ConnectionEntryImplPeer connectionEntryImplPeer1 = new ConnectionEntryImplPeer("host1", 1111L, "1.1.1.1", 1);
        ClientEntryImplPeer clientEntryImplPeer1 = new ClientEntryImplPeer("client1", 1, 1, 1111L, 11L, 1, 111L, 11L);
        ClientEntryImplPeer clientEntryImplPeer2 = new ClientEntryImplPeer("client2", 2, 2, 2222L, 22L, 2, 222L, 22L);
        SessionEntryImplPeer sessionEntryImplPeer1 = new SessionEntryImplPeer("session1", 111L, 11L, 1, 1);
        SessionEntryImplPeer sessionEntryImplPeer2 = new SessionEntryImplPeer("session2", 222L, 22L, 2, 2);
        this.nodeTableSubject.addEntry(nodeEntryImplPeer1);
        this.nodeTableSubject.addEntry(nodeEntryImplPeer2);
        this.connectionTableSubject.addEntry(nodeEntryImplPeer1.get_nodeName(), connectionEntryImplPeer1);
        this.connectionTableSubject.addEntry(nodeEntryImplPeer2.get_nodeName(), connectionEntryImplPeer1);
        this.clientTableSubject.addEntry(nodeEntryImplPeer1.get_nodeName(), clientEntryImplPeer1);
        this.clientTableSubject.addEntry(nodeEntryImplPeer1.get_nodeName(), clientEntryImplPeer2);
        this.sessionTableSubject.addEntry(nodeEntryImplPeer1.get_nodeName(), clientEntryImplPeer1.get_clientName(), sessionEntryImplPeer1);
        this.sessionTableSubject.addEntry(nodeEntryImplPeer1.get_nodeName(), clientEntryImplPeer1.get_clientName(), sessionEntryImplPeer2);
        this.sessionTableSubject.addEntry(nodeEntryImplPeer1.get_nodeName(), clientEntryImplPeer2.get_clientName(), sessionEntryImplPeer1);
    }

    public void testProc3() {
        System.out.println("+++ testProc 3 +++");
        NodeEntryImplPeer nodeEntryImplPeer1 = new NodeEntryImplPeer("node1", "host1", 111L, 1111L, 11L, "err1.log", 1);
        NodeEntryImplPeer nodeEntryImplPeer2 = new NodeEntryImplPeer("node2", "host2", 222L, 2222L, 22L, "err2.log", 2);
        ConnectionEntryImplPeer connectionEntryImplPeer1 = new ConnectionEntryImplPeer("host1", 1111L, "1.1.1.1", 1);
        ClientEntryImplPeer clientEntryImplPeer1 = new ClientEntryImplPeer("client1", 1, 1, 1111L, 11L, 1, 111L, 11L);
        ClientEntryImplPeer clientEntryImplPeer2 = new ClientEntryImplPeer("client2", 2, 2, 2222L, 22L, 2, 222L, 22L);
        SessionEntryImplPeer sessionEntryImplPeer1 = new SessionEntryImplPeer("session1", 111L, 11L, 1, 1);
        this.nodeTableSubject.addEntry(nodeEntryImplPeer1);
        this.connectionTableSubject.addEntry(nodeEntryImplPeer2.get_nodeName(), connectionEntryImplPeer1);
        this.clientTableSubject.addEntry(nodeEntryImplPeer1.get_nodeName(), clientEntryImplPeer1);
        this.clientTableSubject.addEntry(nodeEntryImplPeer2.get_nodeName(), clientEntryImplPeer1);
        this.sessionTableSubject.addEntry(nodeEntryImplPeer1.get_nodeName(), clientEntryImplPeer2.get_clientName(), sessionEntryImplPeer1);
        this.sessionTableSubject.addEntry(nodeEntryImplPeer2.get_nodeName(), clientEntryImplPeer1.get_clientName(), sessionEntryImplPeer1);
    }

    public void testProc4() {
        System.out.println("+++ testProc 4 +++");
        NodeEntryImplPeer nodeEntryImplPeer1 = new NodeEntryImplPeer("node1", "host1", 111L, 1111L, 11L, "err1.log", 1);
        ConnectionEntryImplPeer connectionEntryImplPeer1 = new ConnectionEntryImplPeer("host1", 1111L, "1.1.1.1", 1);
        ClientEntryImplPeer clientEntryImplPeer1 = new ClientEntryImplPeer("client1", 1, 1, 1111L, 11L, 1, 111L, 11L);
        SessionEntryImplPeer sessionEntryImplPeer1 = new SessionEntryImplPeer("session1", 111L, 11L, 1, 1);
        this.nodeTableSubject.addEntry(nodeEntryImplPeer1);
        this.connectionTableSubject.addEntry(nodeEntryImplPeer1.get_nodeName(), connectionEntryImplPeer1);
        this.clientTableSubject.addEntry(nodeEntryImplPeer1.get_nodeName(), clientEntryImplPeer1);
        this.sessionTableSubject.addEntry(nodeEntryImplPeer1.get_nodeName(), clientEntryImplPeer1.get_clientName(), sessionEntryImplPeer1);
        this.clientTableSubject.removeEntry(nodeEntryImplPeer1.get_nodeName(), clientEntryImplPeer1);
        this.nodeTableSubject.removeEntry(nodeEntryImplPeer1);
    }

    public void testProc5() {
        System.out.println("+++ testProc 5 +++");
        NodeEntryImplPeer nodeEntryImplPeer1 = new NodeEntryImplPeer("node1", "host1", 111L, 1111L, 11L, "err1.log", 1);
        ConnectionEntryImplPeer connectionEntryImplPeer1 = new ConnectionEntryImplPeer("host1", 1111L, "1.1.1.1", 1);
        ClientEntryImplPeer clientEntryImplPeer1 = new ClientEntryImplPeer("client1", 1, 1, 1111L, 11L, 1, 111L, 11L);
        SessionEntryImplPeer sessionEntryImplPeer1 = new SessionEntryImplPeer("session1", 111L, 11L, 1, 1);
        this.nodeTableSubject.addEntry(nodeEntryImplPeer1);
        this.connectionTableSubject.addEntry(nodeEntryImplPeer1.get_nodeName(), connectionEntryImplPeer1);
        this.clientTableSubject.addEntry(nodeEntryImplPeer1.get_nodeName(), clientEntryImplPeer1);
        this.sessionTableSubject.addEntry(nodeEntryImplPeer1.get_nodeName(), clientEntryImplPeer1.get_clientName(), sessionEntryImplPeer1);
        this.connectionTableSubject.removeEntry(nodeEntryImplPeer1.get_nodeName(), connectionEntryImplPeer1);
        this.sessionTableSubject.removeEntry(nodeEntryImplPeer1.get_nodeName(), clientEntryImplPeer1.get_clientName(), sessionEntryImplPeer1);
        this.clientTableSubject.removeEntry(nodeEntryImplPeer1.get_nodeName(), clientEntryImplPeer1);
        this.nodeTableSubject.removeEntry(nodeEntryImplPeer1);
    }

    public void testProc6() {
        System.out.println("+++ testProc 6 +++");
    }

    public static void main(String[] argv) {
        new SubagentTest(argv);
    }
}

