/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.admin.extern.snmp;

import jax.AgentXConnection;
import jax.AgentXGroup;
import jax.AgentXOID;
import jax.AgentXRegistration;
import jax.AgentXSession;
import org.xmlBlaster.engine.admin.extern.snmp.ClientEntryImplPeer;
import org.xmlBlaster.engine.admin.extern.snmp.ClientTableObserver;
import org.xmlBlaster.engine.admin.extern.snmp.ClientTableSubject;
import org.xmlBlaster.engine.admin.extern.snmp.ConnectionEntryImplPeer;
import org.xmlBlaster.engine.admin.extern.snmp.ConnectionTableObserver;
import org.xmlBlaster.engine.admin.extern.snmp.ConnectionTableSubject;
import org.xmlBlaster.engine.admin.extern.snmp.NodeEntryImplPeer;
import org.xmlBlaster.engine.admin.extern.snmp.NodeScalarImpl;
import org.xmlBlaster.engine.admin.extern.snmp.NodeTableObserver;
import org.xmlBlaster.engine.admin.extern.snmp.NodeTableSubject;
import org.xmlBlaster.engine.admin.extern.snmp.SessionEntryImplPeer;
import org.xmlBlaster.engine.admin.extern.snmp.SessionTableObserver;
import org.xmlBlaster.engine.admin.extern.snmp.SessionTableSubject;

public class XmlBlasterTest {
    public XmlBlasterTest(String[] argv) {
        AgentXRegistration registration;
        AgentXSession session;
        AgentXConnection connection;
        long[] value = new long[]{1L, 3L, 6L, 1L, 4L, 1L, 11662L};
        boolean sleep = true;
        String host = argv.length >= 1 ? argv[0] : "localhost";
        int port = argv.length >= 2 ? Integer.parseInt(argv[1]) : 0;
        if (argv.length >= 3) {
            sleep = false;
        }
        try {
            System.out.print("connection to ");
            if (port != 0) {
                System.out.print(host + ", " + port);
                connection = new AgentXConnection(host, port);
            } else {
                connection = new AgentXConnection(host);
            }
            System.out.println(" ... established");
            session = new AgentXSession();
            connection.openSession(session);
            registration = new AgentXRegistration(new AgentXOID(value));
            session.register(registration);
        }
        catch (Exception e) {
            System.out.println(" ... not established");
            System.err.println(e);
            return;
        }
        NodeScalarImpl nodeScalarImpl = new NodeScalarImpl();
        session.addGroup((AgentXGroup)nodeScalarImpl);
        NodeTableSubject nodeTableSubject = new NodeTableSubject();
        NodeTableObserver nodeTableObserver = new NodeTableObserver(nodeTableSubject, session);
        ConnectionTableSubject connectionTableSubject = new ConnectionTableSubject(nodeTableObserver);
        ConnectionTableObserver connectionTableObserver = new ConnectionTableObserver(connectionTableSubject, session);
        ClientTableSubject clientTableSubject = new ClientTableSubject(nodeTableObserver);
        ClientTableObserver clientTableObserver = new ClientTableObserver(clientTableSubject, session);
        SessionTableSubject sessionTableSubject = new SessionTableSubject(nodeTableObserver, clientTableObserver);
        SessionTableObserver sessionTableObserver = new SessionTableObserver(sessionTableSubject, session);
        NodeEntryImplPeer nodeEntryImplPeer1 = new NodeEntryImplPeer("node11", "host11", 111L, 1161L, 80L, "err1.log", 1);
        NodeEntryImplPeer nodeEntryImplPeer2 = new NodeEntryImplPeer("node22", "host22", 222L, 1162L, 20L, "err2.log", 2);
        NodeEntryImplPeer nodeEntryImplPeer3 = new NodeEntryImplPeer("node33", "host33", 333L, 3333L, 33L, "err3.log", 3);
        NodeEntryImplPeer nodeEntryImplPeer4 = new NodeEntryImplPeer("node44", "host44", 444L, 4444L, 44L, "err4.log", 4);
        ConnectionEntryImplPeer connectionEntryImplPeer1 = new ConnectionEntryImplPeer("hostAAA", 4711L, "192.47.11", 5);
        ConnectionEntryImplPeer connectionEntryImplPeer2 = new ConnectionEntryImplPeer("hostBBB", 2222L, "3.3.3.3.3", 335);
        ClientEntryImplPeer clientEntryImplPeer1 = new ClientEntryImplPeer("client111", 1, 1, 1111L, 11L, 1, 111L, 11L);
        ClientEntryImplPeer clientEntryImplPeer2 = new ClientEntryImplPeer("client222", 2, 2, 2222L, 22L, 2, 222L, 22L);
        SessionEntryImplPeer sessionEntryImplPeer1 = new SessionEntryImplPeer("session1", 111L, 50L, 1, 1);
        SessionEntryImplPeer sessionEntryImplPeer2 = new SessionEntryImplPeer("session2", 222L, 60L, 2, 2);
        nodeTableSubject.addEntry(nodeEntryImplPeer1);
        nodeTableSubject.addEntry(nodeEntryImplPeer2);
        nodeTableSubject.addEntry(nodeEntryImplPeer3);
        nodeTableSubject.addEntry(nodeEntryImplPeer4);
        connectionTableSubject.addEntry(nodeEntryImplPeer1.get_nodeName(), connectionEntryImplPeer1);
        connectionTableSubject.addEntry(nodeEntryImplPeer2.get_nodeName(), connectionEntryImplPeer2);
        clientTableSubject.addEntry(nodeEntryImplPeer3.get_nodeName(), clientEntryImplPeer1);
        clientTableSubject.addEntry(nodeEntryImplPeer2.get_nodeName(), clientEntryImplPeer1);
        clientTableSubject.addEntry(nodeEntryImplPeer2.get_nodeName(), clientEntryImplPeer2);
        sessionTableSubject.addEntry(nodeEntryImplPeer2.get_nodeName(), clientEntryImplPeer1.get_clientName(), sessionEntryImplPeer1);
        sessionTableSubject.addEntry(nodeEntryImplPeer2.get_nodeName(), clientEntryImplPeer1.get_clientName(), sessionEntryImplPeer2);
        nodeTableSubject.removeEntry(nodeEntryImplPeer3);
        nodeTableSubject.removeEntry(nodeEntryImplPeer1);
        connectionTableSubject.removeEntry(nodeEntryImplPeer1.get_nodeName(), connectionEntryImplPeer1);
        if (sleep) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        nodeTableObserver.sendTrap(session);
        if (sleep) {
            try {
                Thread.sleep(90000L);
            }
            catch (InterruptedException e) {}
        } else {
            return;
        }
        try {
            session.unregister(registration);
            session.close((short)5);
            connection.close();
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public static void main(String[] argv) {
        new XmlBlasterTest(argv);
    }
}

