/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.admin.intern;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.jutils.log.LogChannel;
import org.xmlBlaster.engine.Global;
import org.xmlBlaster.engine.SubscriptionInfo;
import org.xmlBlaster.engine.admin.CommandManager;
import org.xmlBlaster.engine.admin.CommandWrapper;
import org.xmlBlaster.engine.admin.I_AdminSession;
import org.xmlBlaster.engine.admin.I_AdminSubject;
import org.xmlBlaster.engine.admin.I_CommandHandler;
import org.xmlBlaster.engine.admin.intern.Invoker;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.SessionName;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.key.QueryKeyData;
import org.xmlBlaster.util.plugin.I_Plugin;
import org.xmlBlaster.util.plugin.PluginInfo;
import org.xmlBlaster.util.qos.QueryQosData;

public final class CoreHandler
implements I_CommandHandler,
I_Plugin {
    private String ME = "CoreHandler";
    private Global glob = null;
    private LogChannel log = null;
    private CommandManager commandManager = null;
    static /* synthetic */ Class class$org$xmlBlaster$engine$admin$I_AdminNode;
    static /* synthetic */ Class class$org$xmlBlaster$engine$admin$I_AdminSubject;
    static /* synthetic */ Class class$org$xmlBlaster$engine$admin$I_AdminSession;
    static /* synthetic */ Class class$org$xmlBlaster$engine$admin$I_AdminSubscription;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    public void initialize(Global glob, CommandManager commandManager) {
        this.glob = glob;
        this.log = this.glob.getLog("admin");
        this.commandManager = commandManager;
        this.ME = "CoreHandler" + this.glob.getLogPrefixDashed();
        this.commandManager.register("DEFAULT", this);
        this.commandManager.register("client", this);
        this.commandManager.register("subscription", this);
        this.log.info(this.ME, "Core administration plugin is initialized");
    }

    public void init(org.xmlBlaster.util.Global glob, PluginInfo pluginInfo) {
    }

    public String getType() {
        return "CoreHandler";
    }

    public String getVersion() {
        return "1.0";
    }

    public String getName() {
        return "CoreHandler";
    }

    private MsgUnit[] doGetInvoke(CommandWrapper cmd, String property, Object impl, Class clazz) throws XmlBlasterException {
        Object tmp = this.getInvoke(property, impl, clazz, cmd.getQueryKeyData(), cmd.getQueryQosData());
        String ret = "" + tmp;
        this.log.info(this.ME, "Retrieved " + cmd.getCommand());
        if (this.log.DUMP) {
            this.log.dump(this.ME, "Retrieved " + cmd.getCommand() + "=" + ret);
        }
        MsgUnit[] msgs = null;
        msgs = tmp instanceof MsgUnit[] ? (MsgUnit[])tmp : new MsgUnit[]{new MsgUnit(cmd.getQueryKeyData(), ret.getBytes(), cmd.getQueryQosData())};
        return msgs;
    }

    public synchronized MsgUnit[] get(String sessionId, CommandWrapper cmd) throws XmlBlasterException {
        if (cmd == null) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME, "Please pass a command which is not null");
        }
        String registerKey = cmd.getThirdLevel();
        if (registerKey == null || registerKey.length() < 2) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME, "Please pass a command which has a valid property added, '" + cmd.getCommand() + "' is invalid, aborted request.");
        }
        if (registerKey.startsWith("?")) {
            return this.doGetInvoke(cmd, registerKey.substring(1), this.glob.getRequestBroker(), class$org$xmlBlaster$engine$admin$I_AdminNode == null ? (class$org$xmlBlaster$engine$admin$I_AdminNode = CoreHandler.class$("org.xmlBlaster.engine.admin.I_AdminNode")) : class$org$xmlBlaster$engine$admin$I_AdminNode);
        }
        if (registerKey.equals("client") || registerKey.equals("DEFAULT")) {
            String loginName = cmd.getUserNameLevel();
            if (loginName == null || loginName.length() < 1 || loginName.startsWith("?")) {
                throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME, "Please pass a command which has a valid client name in '" + cmd.getCommand() + "' with '" + loginName + "' is invalid");
            }
            I_AdminSubject subjectInfo = this.glob.getAuthenticate().getSubjectInfoByName(new SessionName(this.glob, loginName));
            if (subjectInfo == null) {
                throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME, "Please pass a command which has a valid client name in '" + cmd.getCommand() + "' client '" + loginName + "' is unknown");
            }
            String pubSessionId = cmd.getSessionIdLevel();
            if (pubSessionId == null || pubSessionId.length() < 1) {
                throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME, "Please pass a command which has a valid public session ID in '" + cmd.getCommand() + "'.");
            }
            if (pubSessionId.startsWith("?")) {
                return this.doGetInvoke(cmd, pubSessionId.substring(1), subjectInfo, class$org$xmlBlaster$engine$admin$I_AdminSubject == null ? (class$org$xmlBlaster$engine$admin$I_AdminSubject = CoreHandler.class$("org.xmlBlaster.engine.admin.I_AdminSubject")) : class$org$xmlBlaster$engine$admin$I_AdminSubject);
            }
            String sessionAttr = cmd.getSessionAttrLevel();
            if (sessionAttr == null || sessionAttr.length() < 1 || !sessionAttr.startsWith("?")) {
                throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME, "Please pass a command which has a valid session attribute in '" + cmd.getCommand() + "'.");
            }
            if (sessionAttr.startsWith("?")) {
                I_AdminSession sessionInfo = subjectInfo.getSessionByPubSessionId(Long.parseLong(pubSessionId));
                if (sessionInfo == null) {
                    throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME, "The public session ID '" + pubSessionId + "' in '" + cmd.getCommand() + "' is unknown.");
                }
                return this.doGetInvoke(cmd, sessionAttr.substring(1), sessionInfo, class$org$xmlBlaster$engine$admin$I_AdminSession == null ? (class$org$xmlBlaster$engine$admin$I_AdminSession = CoreHandler.class$("org.xmlBlaster.engine.admin.I_AdminSession")) : class$org$xmlBlaster$engine$admin$I_AdminSession);
            }
        } else if (registerKey.equals("subscription")) {
            String subscriptionId = cmd.getUserNameLevel();
            if (subscriptionId == null || subscriptionId.length() < 1 || subscriptionId.startsWith("?")) {
                throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME, "Please pass a command which has a valid subscriptionId in '" + cmd.getCommand() + "' with '" + subscriptionId + "' is invalid");
            }
            SubscriptionInfo subscriptionInfo = this.glob.getRequestBroker().getClientSubscriptions().getSubscription(subscriptionId);
            if (subscriptionInfo == null) {
                throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME, "Please pass a command which has a valid subscriptionId in '" + cmd.getCommand() + "' subscriptionId '" + subscriptionId + "' is unknown");
            }
            String methodName = cmd.getFifthLevel();
            if (methodName == null || methodName.length() < 1) {
                throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME, "Please pass a command which has a valid method name in '" + cmd.getCommand() + "'.");
            }
            if (methodName.startsWith("?")) {
                return this.doGetInvoke(cmd, methodName.substring(1), subscriptionInfo, class$org$xmlBlaster$engine$admin$I_AdminSubscription == null ? (class$org$xmlBlaster$engine$admin$I_AdminSubscription = CoreHandler.class$("org.xmlBlaster.engine.admin.I_AdminSubscription")) : class$org$xmlBlaster$engine$admin$I_AdminSubscription);
            }
        }
        this.log.info(this.ME, cmd.getCommand() + " not implemented");
        return new MsgUnit[0];
    }

    public String set(String sessionId, CommandWrapper cmd) throws XmlBlasterException {
        if (cmd == null) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME, "Please pass a command which is not null");
        }
        String client = cmd.getThirdLevel();
        if (client == null || client.length() < 1) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME, "Please pass a command which has a valid property added, '" + cmd.getCommand() + "' is invalid, aborted request.");
        }
        if (client.startsWith("?")) {
            String ret = "" + this.setInvoke(cmd.getKey(), (Object)this.glob.getRequestBroker(), class$org$xmlBlaster$engine$admin$I_AdminNode == null ? (class$org$xmlBlaster$engine$admin$I_AdminNode = CoreHandler.class$("org.xmlBlaster.engine.admin.I_AdminNode")) : class$org$xmlBlaster$engine$admin$I_AdminNode, cmd.getValue());
            this.log.info(this.ME, "Set " + cmd.getCommandStripAssign() + "=" + cmd.getValue());
            return cmd.getValue();
        }
        String loginName = cmd.getUserNameLevel();
        if (loginName == null || loginName.length() < 1 || loginName.startsWith("?")) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME, "Please pass a command which has a valid client name in '" + cmd.getCommand() + "' with '" + loginName + "' is invalid");
        }
        I_AdminSubject subjectInfo = this.glob.getAuthenticate().getSubjectInfoByName(new SessionName(this.glob, loginName));
        if (subjectInfo == null) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME, "Please pass a command which has a valid client name in '" + cmd.getCommand() + "' client '" + loginName + "' is unknown");
        }
        String pubSessionId = cmd.getSessionIdLevel();
        if (pubSessionId == null || pubSessionId.length() < 1) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME, "Please pass a command which has a valid public session ID in '" + cmd.getCommand() + "'.");
        }
        if (pubSessionId.startsWith("?")) {
            String ret = "" + this.setInvoke(cmd.getKey(), (Object)subjectInfo, class$org$xmlBlaster$engine$admin$I_AdminSubject == null ? (class$org$xmlBlaster$engine$admin$I_AdminSubject = CoreHandler.class$("org.xmlBlaster.engine.admin.I_AdminSubject")) : class$org$xmlBlaster$engine$admin$I_AdminSubject, cmd.getValue());
            this.log.info(this.ME, "Set " + cmd.getCommandStripAssign() + "=" + cmd.getValue());
            return cmd.getValue();
        }
        String sessionAttr = cmd.getSessionAttrLevel();
        if (sessionAttr == null || sessionAttr.length() < 1 || !sessionAttr.startsWith("?")) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME, "Please pass a command which has a valid session attribute in '" + cmd.getCommand() + "'.");
        }
        if (sessionAttr.startsWith("?")) {
            I_AdminSession sessionInfo = subjectInfo.getSessionByPubSessionId(Long.parseLong(pubSessionId));
            if (sessionInfo == null) {
                throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME, "The public session ID '" + pubSessionId + "' in '" + cmd.getCommand() + "' is unknown.");
            }
            String ret = "" + this.setInvoke(cmd.getKey(), (Object)sessionInfo, class$org$xmlBlaster$engine$admin$I_AdminSession == null ? (class$org$xmlBlaster$engine$admin$I_AdminSession = CoreHandler.class$("org.xmlBlaster.engine.admin.I_AdminSession")) : class$org$xmlBlaster$engine$admin$I_AdminSession, cmd.getValue());
            this.log.info(this.ME, "Set " + cmd.getCommandStripAssign() + "=" + cmd.getValue());
            return cmd.getValue();
        }
        this.log.info(this.ME, cmd.getCommand() + " not implemented");
        return null;
    }

    private Object getInvoke(String property, Object impl, Class aInterface, QueryKeyData keyData, QueryQosData qosData) throws XmlBlasterException {
        String methodName = null;
        if (property == null || property.length() < 2) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME, "Please pass a vaild command, aborted request.");
        }
        try {
            Invoker invoker = new Invoker(this.glob, impl, aInterface);
            methodName = "get" + property.substring(0, 1).toUpperCase() + property.substring(1);
            Object obj = invoker.execute(methodName, qosData, keyData);
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Return for '" + methodName + "' is '" + obj + "'");
            }
            return obj;
        }
        catch (Exception e) {
            this.log.error(this.ME, "Invoke for get method '" + methodName + "' on class=" + aInterface + " on object=" + impl.getClass() + " failed: " + e.toString());
            throw XmlBlasterException.convert(this.glob, this.ME, "Invoke for get method '" + property + "' on class=" + aInterface + " on object=" + impl.getClass() + " failed", e);
        }
    }

    private Object[] convertMethodArguments(Class[] classes, String[] args) throws XmlBlasterException {
        if (classes.length != args.length) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME + ".convertMethodArguments", "wrong number of arguments: '" + args.length + "' but should be '" + classes.length + "'");
        }
        Object[] ret = new Object[classes.length];
        int i = 0;
        while (i < classes.length) {
            if (classes[i] == (class$java$lang$String == null ? CoreHandler.class$("java.lang.String") : class$java$lang$String)) {
                ret[i] = args[i];
            } else {
                if (classes[i] == Boolean.TYPE || classes[i] == (class$java$lang$Boolean == null ? CoreHandler.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                    try {
                        ret[i] = Boolean.valueOf(args[i]);
                    }
                    catch (Throwable ex) {
                        throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME + ".convertMethodArguments", "wrong type of argument nr. '" + (i + 1) + "' should be of type '" + classes[i].getName() + "' but its value is '" + args[i] + "'");
                    }
                }
                if (classes[i] == Short.TYPE || classes[i] == (class$java$lang$Short == null ? CoreHandler.class$("java.lang.Short") : class$java$lang$Short)) {
                    try {
                        ret[i] = Short.valueOf(args[i]);
                    }
                    catch (Throwable ex) {
                        throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME + ".convertMethodArguments", "wrong type of argument nr. '" + (i + 1) + "' should be of type '" + classes[i].getName() + "' but its value is '" + args[i] + "'");
                    }
                }
                if (classes[i] == Integer.TYPE || classes[i] == (class$java$lang$Integer == null ? CoreHandler.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    try {
                        ret[i] = Integer.valueOf(args[i]);
                    }
                    catch (Throwable ex) {
                        throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME + ".convertMethodArguments", "wrong type of argument nr. '" + (i + 1) + "' should be of type '" + classes[i].getName() + "' but its value is '" + args[i] + "'");
                    }
                }
                if (classes[i] == Long.TYPE || classes[i] == (class$java$lang$Long == null ? CoreHandler.class$("java.lang.Long") : class$java$lang$Long)) {
                    try {
                        ret[i] = Long.valueOf(args[i]);
                    }
                    catch (Throwable ex) {
                        throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME + ".convertMethodArguments", "wrong type of argument nr. '" + (i + 1) + "' should be of type '" + classes[i].getName() + "' but its value is '" + args[i] + "'");
                    }
                }
                if (classes[i] == Float.TYPE || classes[i] == (class$java$lang$Float == null ? CoreHandler.class$("java.lang.Float") : class$java$lang$Float)) {
                    try {
                        ret[i] = Float.valueOf(args[i]);
                    }
                    catch (Throwable ex) {
                        throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME + ".convertMethodArguments", "wrong type of argument nr. '" + (i + 1) + "' should be of type '" + classes[i].getName() + "' but its value is '" + args[i] + "'");
                    }
                }
                if (classes[i] == Double.TYPE || classes[i] == (class$java$lang$Double == null ? CoreHandler.class$("java.lang.Double") : class$java$lang$Double)) {
                    try {
                        ret[i] = Double.valueOf(args[i]);
                    }
                    catch (Throwable ex) {
                        throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME + ".convertMethodArguments", "wrong type of argument nr. '" + (i + 1) + "' should be of type '" + classes[i].getName() + "' but its value is '" + args[i] + "'");
                    }
                }
            }
            ++i;
        }
        return ret;
    }

    private Object setInvoke(String property, Object impl, Class aClass, String[] argValuesAsStrings) throws XmlBlasterException {
        try {
            PropertyDescriptor desc = new PropertyDescriptor(property, aClass);
            Method method = desc.getWriteMethod();
            Object[] argValues = this.convertMethodArguments(method.getParameterTypes(), argValuesAsStrings);
            Object obj = method.invoke(impl, argValues);
            this.log.info(this.ME, "Successful invoked set method '" + property + "'");
            if (obj != null) {
                this.log.warn(this.ME, "Ignoring returned value of set method '" + property + "'");
            }
            return obj;
        }
        catch (Exception e) {
            if (e instanceof XmlBlasterException) {
                throw (XmlBlasterException)e;
            }
            if (argValuesAsStrings.length > 0) {
                this.log.error(this.ME, "Invoke for property '" + property + "' with " + argValuesAsStrings.length + " arguments of type " + argValuesAsStrings[0].getClass().toString() + " on interface " + aClass.toString() + " failed: " + e.toString());
            } else {
                this.log.error(this.ME, "Invoke for property '" + property + "' on interface " + aClass.toString() + " failed: " + e.toString());
            }
            throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME, "Invoke for property '" + property + "' on class=" + aClass + " on object=" + impl.getClass() + " failed: " + e.toString());
        }
    }

    private Object setInvoke(String property, Object impl, Class aClass, String value) throws XmlBlasterException {
        String[] argValuesAsStrings = new String[]{value};
        return this.setInvoke(property, impl, aClass, argValuesAsStrings);
    }

    public String help() {
        return "Administration of properties from system, xmlBlaster.properties and command line";
    }

    public String help(String cmd) {
        return this.help();
    }

    public void shutdown() {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Shutdown ignored, nothing to do");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

