/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.admin.intern;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.xmlBlaster.engine.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.key.QueryKeyData;
import org.xmlBlaster.util.qos.QueryQosData;

class Invoker {
    private Global glob;
    private Object invokeTarget;
    private Class targetClass;
    boolean debug = true;

    public Invoker(Global glob, Object target, Class targetClass) {
        this.glob = glob;
        this.invokeTarget = target;
        this.targetClass = targetClass;
    }

    public Object execute(String methodName, QueryQosData qosData, QueryKeyData keyData) throws XmlBlasterException {
        Class[] argClasses = new Class[]{};
        Method method = null;
        boolean hasArgs = false;
        try {
            method = this.targetClass.getMethod(methodName, argClasses);
        }
        catch (NoSuchMethodException nsm_e) {
            hasArgs = true;
            try {
                argClasses = new Class[]{keyData.getClass(), qosData.getClass()};
                method = this.targetClass.getMethod(methodName, argClasses);
            }
            catch (NoSuchMethodException nsm_e1) {
                throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, "CoreHandler", "Please check your command, aborted request.", nsm_e);
            }
        }
        catch (SecurityException s_e) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_SECURITY_AUTHENTICATION_ACCESSDENIED, "CoreHandler", "Aborted request.", s_e);
        }
        Object[] argValues = null;
        argValues = hasArgs ? new Object[]{keyData, qosData} : new Object[]{};
        try {
            if (method.getDeclaringClass() == Class.forName("java.lang.Object")) {
                throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, "CoreHandler", "Invoker can't call methods defined in java.lang.Object");
            }
        }
        catch (ClassNotFoundException e) {
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, "CoreHandler", "Invoker can't call methods defined in java.lang.Object", e);
        }
        Object returnValue = null;
        try {
            returnValue = method.invoke(this.invokeTarget, argValues);
        }
        catch (IllegalAccessException iacc_e) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, "CoreHandler", "Aborted request.", iacc_e);
        }
        catch (IllegalArgumentException iarg_e) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, "CoreHandler", "Aborted request.", iarg_e);
        }
        catch (InvocationTargetException it_e) {
            if (this.debug) {
                it_e.getTargetException().printStackTrace();
            }
            Throwable t = it_e.getTargetException();
            throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, "CoreHandler", "Aborted request.", t);
        }
        return returnValue;
    }
}

