/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.engine.admin.intern;

import org.jutils.log.LogChannel;
import org.xmlBlaster.engine.Global;
import org.xmlBlaster.engine.admin.CommandManager;
import org.xmlBlaster.engine.admin.CommandWrapper;
import org.xmlBlaster.engine.admin.I_CommandHandler;
import org.xmlBlaster.protocol.I_XmlBlaster;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.MsgUnitRaw;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.def.MethodName;
import org.xmlBlaster.util.plugin.I_Plugin;
import org.xmlBlaster.util.plugin.PluginInfo;

public final class MsgHandler
implements I_CommandHandler,
I_Plugin {
    private String ME = "MsgHandler";
    private Global glob = null;
    private LogChannel log = null;
    private CommandManager commandManager = null;

    public void initialize(Global glob, CommandManager commandManager) {
        this.glob = glob;
        this.log = this.glob.getLog("admin");
        this.commandManager = commandManager;
        this.ME = "MsgHandler" + this.glob.getLogPrefixDashed();
        this.commandManager.register("topic", this);
        this.log.info(this.ME, "Message administration plugin is initialized");
    }

    public void init(org.xmlBlaster.util.Global glob, PluginInfo pluginInfo) {
    }

    public String getType() {
        return "MsgHandler";
    }

    public String getVersion() {
        return "1.0";
    }

    public String getName() {
        return "MsgHandler";
    }

    public synchronized MsgUnit[] get(String sessionId, CommandWrapper cmd) throws XmlBlasterException {
        if (cmd == null) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME + ".get", "Please pass a command which is not null");
        }
        String client = cmd.getThirdLevel();
        if (client == null || client.length() < 1) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME + ".get", "Please pass a command which has a valid message oid added, '" + cmd.getCommand() + "' is too short, aborted request.");
        }
        if (client.startsWith("?")) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME + ".get", "Please pass a command which has a valid message oid added, '" + cmd.getCommand() + "' is too short, aborted request.");
        }
        I_XmlBlaster xmlBlaster = this.glob.getAuthenticate().getXmlBlaster();
        String oidTmp = cmd.getUserNameLevel();
        if (oidTmp == null || oidTmp.length() < 1) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME + ".get", "Please pass a command which has a valid message oid added, '" + cmd.getCommand() + "' is too short, aborted request.");
        }
        String oid = oidTmp;
        if (oidTmp.startsWith("?")) {
            oid = oidTmp.substring(1);
        }
        String xmlKey = "<key oid='" + oid + "'/>";
        MsgUnitRaw[] msgUnitArrRaw = xmlBlaster.get(sessionId, xmlKey, cmd.getQueryQosData().toXml());
        MsgUnit[] msgUnits = new MsgUnit[msgUnitArrRaw.length];
        MethodName method = cmd.getQueryQosData().getMethod();
        int i = 0;
        while (i < msgUnits.length) {
            msgUnits[i] = new MsgUnit(this.glob, msgUnitArrRaw[i], method);
            ++i;
        }
        this.log.info(this.ME, cmd.getCommand() + " returned " + msgUnitArrRaw.length + " messages");
        if (this.log.DUMP) {
            int ii = 0;
            while (ii < msgUnitArrRaw.length) {
                this.log.dump(this.ME, msgUnitArrRaw[ii].toXml());
                ++ii;
            }
        }
        return msgUnits;
    }

    public String set(String sessionId, CommandWrapper cmd) throws XmlBlasterException {
        String qos;
        if (cmd == null) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME + ".set", "Please pass a command which is not null");
        }
        String client = cmd.getThirdLevel();
        if (client == null || client.length() < 1) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME + ".set", "Please pass a command which has a valid message oid added, '" + cmd.getCommand() + "' is too short, aborted request.");
        }
        if (client.startsWith("?")) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME + ".set", "Please pass a command which has a valid message oid added, '" + cmd.getCommand() + "' is too short, aborted request.");
        }
        I_XmlBlaster xmlBlaster = this.glob.getAuthenticate().getXmlBlaster();
        String oidTmp = cmd.getUserNameLevel();
        if (oidTmp == null || oidTmp.length() < 1) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME + ".set", "Please pass a command which has a valid message oid added, '" + cmd.getCommand() + "' is too short, aborted request.");
        }
        String oid = oidTmp;
        if (oidTmp.startsWith("?")) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_ILLEGALARGUMENT, this.ME + ".set", "Please pass a command which has a valid message oid added, '" + cmd.getCommand() + "' is too short, aborted request.");
        }
        String xmlKey = "<key oid='" + oid + "'/>";
        MsgUnitRaw[] msgUnitArrRaw = xmlBlaster.get(sessionId, xmlKey, qos = "<qos/>");
        if (msgUnitArrRaw.length < 1) {
            this.log.info(this.ME, cmd.getCommand() + " Message oid=" + oid + " not found");
            return null;
        }
        String key = cmd.getKey();
        String value = cmd.getValue();
        if (!key.equalsIgnoreCase("content")) {
            throw new XmlBlasterException(this.glob, ErrorCode.USER_ADMIN_INVALID, this.ME, "Only the 'content' can currently be changed on messages, try something like '?content=Hello world'");
        }
        String[] retArr = xmlBlaster.publishArr(sessionId, msgUnitArrRaw);
        this.log.info(this.ME, cmd.getCommand() + " published " + msgUnitArrRaw.length + " messages");
        StringBuffer sb = new StringBuffer(retArr.length * 60);
        int ii = 0;
        while (ii < retArr.length) {
            sb.append(retArr[ii]);
            ++ii;
        }
        return sb.toString();
    }

    public String help() {
        return "Administration of xmlBlaster messages.";
    }

    public String help(String cmd) {
        return this.help();
    }

    public void shutdown() {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Shutdown ignored, nothing to do");
        }
    }
}

